/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import tsg.TSNodeLabel;
import tsg.corpora.Wsj;
import util.FileUtil;
import viewer.ConstTreePanel;
import viewer.TreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstTreeViewer
extends TreeViewer<TSNodeLabel> {
    private static TSNodeLabel initialSentence = ConstTreeViewer.initialSentence();

    public static TSNodeLabel initialSentence() {
        try {
            return new TSNodeLabel("(S (V-H load) (NP (D a) (N-H corpus)))");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setInitialSentence() {
        ArrayList<TSNodeLabel> treebank = new ArrayList<TSNodeLabel>();
        treebank.add(initialSentence);
        this.loadTreebank(treebank);
    }

    protected void loadTreebank(File treebankFile) {
        this.corpusFile = treebankFile;
        ArrayList<TSNodeLabel> treebank = null;
        try {
            treebank = Wsj.getTreebank(treebankFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadTreebank(treebank);
    }

    @Override
    protected void setCheckBoxOptions() {
        this.optionCheckBoxs = new JCheckBox[]{new JCheckBox("Skewed Lines", false), new JCheckBox("Show Heads", false)};
    }

    @Override
    protected void initializeTreePanel() {
        ConstTreePanel constTreePanel = new ConstTreePanel();
        constTreePanel.skewedLinesCheckBox = this.optionCheckBoxs[0];
        constTreePanel.showHeads = this.optionCheckBoxs[1];
        this.treePanel = constTreePanel;
        this.treePanel.setBackground(Color.white);
        this.treePanel.setFocusable(false);
    }

    public static void doBeforeClosing() {
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Constituency Tree Viewer");
        frame.setDefaultCloseOperation(3);
        final ConstTreeViewer treeViewer = new ConstTreeViewer();
        Dimension area = treeViewer.treePanel.area;
        frame.setMinimumSize(new Dimension(area.width + 5, area.height + 5));
        treeViewer.setOpaque(true);
        frame.setContentPane(treeViewer);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConstTreeViewer.doBeforeClosing();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem openTreebank = new JMenuItem("Open Treebank");
        JMenuItem exportEps = new JMenuItem("Export to EPS");
        JMenuItem exportPdf = new JMenuItem("Export to PDF");
        JMenuItem exportAllToPdf = new JMenuItem("Export All to PDF");
        JMenuItem quit = new JMenuItem("Quit");
        final JFileChooser fc = new JFileChooser();
        openTreebank.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        exportEps.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        exportPdf.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        exportAllToPdf.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        quit.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        openTreebank.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(treeViewer);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    treeViewer.loadTreebank(selectedFile);
                }
            }
        });
        exportEps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    selectedFile = FileUtil.changeExtention(selectedFile, "eps");
                    treeViewer.treePanel.exportToEPS(selectedFile);
                }
            }
        });
        exportPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    selectedFile = FileUtil.changeExtention(selectedFile, "pdf");
                    treeViewer.treePanel.exportToPDF(selectedFile);
                }
            }
        });
        exportAllToPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    selectedFile = FileUtil.changeExtention(selectedFile, "pdf");
                    treeViewer.treePanel.exportAllToPdf(selectedFile);
                }
            }
        });
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ConstTreeViewer.doBeforeClosing();
                System.exit(0);
            }
        });
        file.add(openTreebank);
        file.add(exportEps);
        file.add(exportPdf);
        file.add(exportAllToPdf);
        file.add(quit);
        openTreebank.setMnemonic('O');
        exportPdf.setMnemonic('P');
        exportAllToPdf.setMnemonic('A');
        quit.setMnemonic('Q');
        menuBar.add(file);
        frame.setJMenuBar(menuBar);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConstTreeViewer.createAndShowGUI();
            }
        });
    }
}

