/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import javax.swing.JCheckBox;
import tsg.TSNodeLabel;
import viewer.TreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstTreePanel
extends TreePanel<TSNodeLabel> {
    int sentenceLength;
    int nodesCount;
    IdentityHashMap<TSNodeLabel, Integer> indexTable;
    TSNodeLabel[] nodesArray;
    TSNodeLabel[] lexicalsArray;
    String[] labelArray;
    int[] XLeftArray;
    int[] YArray;
    int[] XMiddleArray;
    int[] wordLengthsArray;
    ArrayList<TSNodeLabel> wrongNodes;
    public JCheckBox skewedLinesCheckBox;
    public JCheckBox showHeads;
    public static int wrongNodesBorder = 2;

    public ConstTreePanel() {
    }

    public ConstTreePanel(ArrayList<TSNodeLabel> treebank) {
        this.loadTreebank(treebank);
    }

    @Override
    public void loadTreebank(ArrayList<TSNodeLabel> treebank) {
        this.treebank = treebank;
        this.lastIndex = treebank.size() - 1;
        this.sentenceNumber = 0;
    }

    public void setWrongNodes(ArrayList<TSNodeLabel> wrongNodes) {
        this.wrongNodes = wrongNodes;
    }

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke());
        TSNodeLabel[] tSNodeLabelArray = this.nodesArray;
        int n = this.nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel p;
            TSNodeLabel n3 = tSNodeLabelArray[n2];
            boolean isHead = this.showHeads.isSelected() && n3.isHeadMarked();
            int i = this.indexTable.get(n3);
            if (isHead) {
                g2.setColor(Color.RED);
            }
            g2.drawString(this.labelArray[i], this.XLeftArray[i], this.YArray[i]);
            if (isHead) {
                g2.setColor(Color.black);
            }
            if ((p = n3.parent) != null) {
                int pIndex = this.indexTable.get(p);
                this.drawLine(this.XMiddleArray[i], this.YArray[i] - this.fontSize - this.textTopMargin, this.XMiddleArray[pIndex], this.YArray[pIndex] + this.textTopMargin, g2);
            }
            ++n2;
        }
        if (this.wrongNodes != null) {
            this.markWrongNodes(g2);
        }
    }

    public void renderText(Graphics2D g2, String text) {
        g2.setFont(this.font);
        g2.setColor(Color.black);
        g2.drawString(text, 0, 0);
    }

    private void markWrongNodes(Graphics2D g2) {
        TSNodeLabel[] tSNodeLabelArray = this.nodesArray;
        int n = this.nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel n3 = tSNodeLabelArray[n2];
            int i = this.indexTable.get(n3);
            if (this.wrongNodes.contains(n3)) {
                g2.setColor(Color.red);
                g2.drawRect(this.XLeftArray[i] - wrongNodesBorder, this.YArray[i] - this.fontHight + wrongNodesBorder, this.wordLengthsArray[i] + 2 * wrongNodesBorder, this.fontHight + wrongNodesBorder);
                g2.setColor(Color.black);
            }
            ++n2;
        }
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D g2) {
        if (!this.skewedLinesCheckBox.isSelected()) {
            int yM = y1 + (y2 - y1) / 2;
            g2.drawLine(x1, y1, x1, yM);
            g2.drawLine(x1, yM, x2, yM);
            g2.drawLine(x2, yM, x2, y2);
        } else {
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.render(g2);
    }

    @Override
    public void loadSentence() {
        TSNodeLabel t = (TSNodeLabel)this.treebank.get(this.sentenceNumber);
        this.indexTable = new IdentityHashMap();
        this.nodesCount = t.countAllNodes();
        this.sentenceLength = t.countLexicalNodes();
        this.lexicalsArray = t.collectLexicalItems().toArray(new TSNodeLabel[this.sentenceLength]);
        this.nodesArray = t.collectAllNodes().toArray(new TSNodeLabel[this.nodesCount]);
        int maxDepth = t.maxDepth();
        int i = 0;
        while (i < this.nodesCount) {
            TSNodeLabel n = this.nodesArray[i];
            this.indexTable.put(n, i);
            ++i;
        }
        this.labelArray = new String[this.nodesCount];
        this.XLeftArray = new int[this.nodesCount];
        this.XMiddleArray = new int[this.nodesCount];
        this.wordLengthsArray = new int[this.nodesCount];
        Arrays.fill(this.XLeftArray, -1);
        this.YArray = new int[this.nodesCount];
        int treeWidth = 0;
        int previousWordLength = 0;
        int previousXLeft = this.leftMargin;
        int j = 0;
        while (j < this.sentenceLength) {
            int wordLengthColumn;
            TSNodeLabel n = this.lexicalsArray[j];
            int i2 = this.indexTable.get(n);
            this.labelArray[i2] = n.label();
            int wordLength = this.metrics.stringWidth(this.labelArray[i2]);
            this.wordLengthsArray[i2] = wordLengthColumn = this.getWordLengthColumn(n, wordLength);
            this.XMiddleArray[i2] = wordLengthColumn / 2 + previousXLeft + previousWordLength + this.wordSpace;
            this.XLeftArray[i2] = this.XMiddleArray[i2] - wordLength / 2;
            this.YArray[i2] = this.topMargin + this.fontHight + n.hight() * this.levelSize;
            previousWordLength = wordLengthColumn;
            previousXLeft = this.XLeftArray[i2];
            if (j == this.sentenceLength - 1) {
                treeWidth = previousXLeft + previousWordLength + this.wordSpace;
            }
            ++j;
        }
        TSNodeLabel[] tSNodeLabelArray = this.nodesArray;
        int n = this.nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel n3 = tSNodeLabelArray[n2];
            if (!n3.isLexical) {
                int i3 = this.indexTable.get(n3);
                this.updateValues(n3, i3);
            }
            ++n2;
        }
        int treeHeight = this.topMargin + this.fontHight + maxDepth * this.levelSize + this.bottomMargin;
        this.area.width = treeWidth += this.rightMargin;
        this.area.height = treeHeight;
    }

    private int getWordLengthColumn(TSNodeLabel n, int wordLength) {
        while (n.parent != null && n.isUniqueDaughter()) {
            n = n.parent;
            int length = this.metrics.stringWidth(n.label());
            if (length <= wordLength) continue;
            wordLength = length;
        }
        return wordLength;
    }

    private void updateValues(TSNodeLabel n, int i) {
        int wordLength;
        if (this.XLeftArray[i] != -1) {
            return;
        }
        this.labelArray[i] = n.label();
        this.YArray[i] = this.topMargin + this.fontHight + n.hight() * this.levelSize;
        this.wordLengthsArray[i] = wordLength = this.metrics.stringWidth(this.labelArray[i]);
        TSNodeLabel[] daughters = n.daughters;
        TSNodeLabel firstDaughter = n.daughters[0];
        int iDF = this.indexTable.get(firstDaughter);
        if (!firstDaughter.isLexical) {
            this.updateValues(firstDaughter, iDF);
        }
        if (daughters.length == 1) {
            this.XMiddleArray[i] = this.XMiddleArray[iDF];
            this.XLeftArray[i] = this.XMiddleArray[i] - wordLength / 2;
        } else {
            TSNodeLabel lastDaughter = n.daughters[n.prole() - 1];
            int iDL = this.indexTable.get(lastDaughter);
            if (!lastDaughter.isLexical) {
                this.updateValues(lastDaughter, iDL);
            }
            this.XMiddleArray[i] = this.XLeftArray[iDF] + (this.XLeftArray[iDL] + this.wordLengthsArray[iDL] - this.XLeftArray[iDF]) / 2;
            this.XLeftArray[i] = this.XMiddleArray[i] - wordLength / 2;
        }
    }

    public TSNodeLabel getSentence(int n) {
        return (TSNodeLabel)this.treebank.get(n);
    }

    public void exportAllToPdf(File outputFile, File corpusFile) {
        Color bgColor = new Color(255, 222, 173);
        Document document = new Document();
        Font font = new Font(2, 15.0f, 0);
        try {
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(outputFile));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Chunk introPhrase = new Chunk("Structures in file " + corpusFile.getName(), font);
            document.add(introPhrase);
            this.sentenceNumber = 0;
            while (this.sentenceNumber < this.treebank.size()) {
                this.loadSentence();
                Chunk sentenceLabel = new Chunk("Sentence # " + (this.sentenceNumber + 1), font);
                sentenceLabel.setBackground(bgColor);
                Rectangle r = new Rectangle((int)this.area.getWidth(), (int)this.area.getHeight());
                document.setPageSize(r);
                document.newPage();
                document.add(sentenceLabel);
                Graphics2D g2 = cb.createGraphics((int)this.area.getWidth(), (int)this.area.getHeight());
                this.render(g2);
                g2.dispose();
                ++this.sentenceNumber;
            }
            document.close();
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }
}

