/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiHashTableCompact {
    int intCounter = 1;
    Hashtable<String, Integer> stringIntegerTable;
    Vector<String> stringVector;
    static Integer dummyIndex = 0;
    Hashtable<Integer, Object> mainStructure = new Hashtable();
    int levels;

    public MultiHashTableCompact() {
        this.stringIntegerTable = new Hashtable();
        this.stringVector = new Vector();
    }

    public Integer addNewString(String s) {
        Integer newInt = this.intCounter;
        ++this.intCounter;
        this.stringIntegerTable.put(s, newInt);
        this.stringVector.add(s);
        return newInt;
    }

    public void addOne(String multiString) {
        String[] multiStringSplit;
        Hashtable structure = this.mainStructure;
        String[] stringArray = multiStringSplit = multiString.split("_");
        int n = multiStringSplit.length;
        int n2 = 0;
        while (n2 < n) {
            Hashtable newStructure;
            String s = stringArray[n2];
            Integer stringIndex = this.stringIntegerTable.get(s);
            if (stringIndex == null) {
                stringIndex = this.addNewString(s);
            }
            if ((newStructure = (Hashtable)structure.get(stringIndex)) == null) {
                newStructure = new Hashtable();
                structure.put(stringIndex, newStructure);
            }
            structure = newStructure;
            ++n2;
        }
        MultiHashTableCompact.increaseOneInTable(structure);
    }

    public static void increaseOneInTable(Hashtable<Integer, Object> table) {
        int[] freq = (int[])table.get(dummyIndex);
        if (freq == null) {
            freq = new int[]{1};
            table.put(dummyIndex, freq);
        } else {
            freq[0] = freq[0] + 1;
        }
    }

    public int get(String multiString) {
        String[] multiStringSplit;
        Hashtable structure = this.mainStructure;
        String[] stringArray = multiStringSplit = multiString.split("_");
        int n = multiStringSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Integer stringIndex = this.stringIntegerTable.get(s);
            if (stringIndex == null) {
                return 0;
            }
            if ((structure = (Hashtable)structure.get(stringIndex)) == null) {
                return 0;
            }
            ++n2;
        }
        return ((int[])structure.get(dummyIndex))[0];
    }

    private static void printToFileRecursive(Hashtable<Integer, Object> structure, String prefix, PrintWriter pw, Vector stringVector) {
        Object freq = structure.get(dummyIndex);
        if (freq != null) {
            pw.println(freq + "\t" + prefix);
            return;
        }
        for (Integer key : structure.keySet()) {
            Hashtable subTable = (Hashtable)structure.get(key);
            prefix = String.valueOf(prefix) + "_" + stringVector.get(key);
            MultiHashTableCompact.printToFileRecursive(subTable, prefix, pw, stringVector);
        }
    }

    public void printToFile(File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        MultiHashTableCompact.printToFileRecursive(this.mainStructure, "", pw, this.stringVector);
        pw.close();
    }
}

