/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.TreeSet;
import settings.Parameters;
import tsg.DistributeTreeBankInDepthFiles;
import tsg.TSNodeLabel;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.ObjectInteger;
import util.PrintProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieveCorrectFreq {
    public static void retriveCorrectFreq(ArrayList<TSNodeLabel> treebank, File fragmentsFile, File outputFile, boolean partialTrees) throws Exception {
        ObjectInteger<TSNodeLabel> fragmentFreq;
        int count;
        Scanner scan = FileUtil.getScanner(fragmentsFile);
        ArrayList fragmentList = new ArrayList();
        int lines = 0;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            ++lines;
            String[] stringArray = line.split("\t");
            Iterator fragment = new TSNodeLabel(stringArray[0], false);
            fragmentList.add(fragment);
        }
        scan.close();
        TreeSet<ObjectInteger<TSNodeLabel>> finalList = new TreeSet<ObjectInteger<TSNodeLabel>>();
        System.out.println("Total Fragments: " + lines);
        PrintProgress.start("Counting Fragments");
        if (partialTrees) {
            for (TSNodeLabel tSNodeLabel : fragmentList) {
                PrintProgress.next();
                count = TSNodeLabel.countPartialFragmentInTreebank(treebank, tSNodeLabel);
                fragmentFreq = new ObjectInteger<TSNodeLabel>(tSNodeLabel, count);
                finalList.add(fragmentFreq);
            }
        } else {
            for (TSNodeLabel tSNodeLabel : fragmentList) {
                PrintProgress.next();
                count = TSNodeLabel.countFragmentInTreebank(treebank, tSNodeLabel);
                fragmentFreq = new ObjectInteger<TSNodeLabel>(tSNodeLabel, count);
                finalList.add(fragmentFreq);
            }
        }
        PrintProgress.end();
        PrintWriter printWriter = FileUtil.getPrintWriter(outputFile);
        Iterator i = finalList.descendingIterator();
        while (i.hasNext()) {
            ObjectInteger next = (ObjectInteger)i.next();
            printWriter.println(String.valueOf(((TSNodeLabel)next.getObject()).toString(false, true)) + "\t" + next.getInteger());
        }
        printWriter.close();
    }

    public static void main1(String[] args) throws Exception {
        String[] wordList = new String[]{"of_first1000", "make", "good", "give", "believe", "be_first1000"};
        String dirBase = "/scratch/fsangati/RESULTS/TSG/TSGkernels/Wsj/KenelFragments/SemTagOn/";
        String dirBaseFrag = String.valueOf(dirBase) + "subTree/20/correct/";
        String dirBasePartialFrag = String.valueOf(dirBase) + "subBranch/20/correct/";
        File corpusFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21.mrg");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(corpusFile);
        int i = 1;
        while (i < 2) {
            String[] stringArray = wordList;
            int n = wordList.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                String inputFileString = i == 0 ? String.valueOf(dirBaseFrag) + "fragments_MUB_freq_20_sorted_" : String.valueOf(dirBasePartialFrag) + "fragments_subBranch_MUB_freq_20_sorted_";
                File inputFile = new File(String.valueOf(inputFileString) + word + ".txt");
                File outputFile = new File(String.valueOf(inputFileString) + word + "_correctCount.txt");
                RetrieveCorrectFreq.retriveCorrectFreq(treebank, inputFile, outputFile, i == 1);
                ++n2;
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        String[] wordList = new String[]{"gave"};
        String dirBase = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/KenelFragments/SemTagOn/";
        String dirBasePartialFrag = String.valueOf(dirBase) + "subBranch/20/correct/";
        File corpusFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21.mrg");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(corpusFile);
        String[] stringArray = wordList;
        int n = wordList.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            String inputFileString = String.valueOf(dirBasePartialFrag) + "fragments_subBranch_MUB_freq_20_sorted_";
            File inputFile = new File(String.valueOf(inputFileString) + word + ".txt");
            File outputFile = new File(String.valueOf(inputFileString) + word + "_correctCount.txt");
            RetrieveCorrectFreq.retriveCorrectFreq(treebank, inputFile, outputFile, true);
            ++n2;
        }
    }

    public static void main3(String[] args) throws Exception {
        File corpusFile = new File(String.valueOf(Wsj.WsjOriginalCleanedTop) + "wsj-02-21.mrg");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(corpusFile);
        TSNodeLabel.removeSemanticTagsInTreebank(treebank);
        String workingDir = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/KenelFragments/SemTagOff_Top/all/";
        System.out.println("Working Dir: " + workingDir);
        File fragmentFile = new File(String.valueOf(workingDir) + "fragments_MUB_freq_all.txt");
        File fragmentFileCorrect = new File(String.valueOf(workingDir) + "fragments_MUB_freq_all_correctCount.txt");
        RetrieveCorrectFreq.retriveCorrectFreq(treebank, fragmentFile, fragmentFileCorrect, false);
        DistributeTreeBankInDepthFiles.distribute(fragmentFileCorrect);
    }
}

