/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.util.ArrayList;
import kernels.NodeSetCollector;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonSubtrees {
    ArrayList<TSNodeLabelStructure> treebank;

    public CommonSubtrees(ArrayList<TSNodeLabelStructure> treebank) {
        this.treebank = treebank;
    }

    protected static NodeSetCollector[][] getCST(TSNodeLabelStructure t1, TSNodeLabelStructure t2, NodeSetCollector collector) {
        NodeSetCollector[][] CST = new NodeSetCollector[t1.length()][t2.length()];
        int currentLength = t1.length();
        TSNodeLabelIndex[] tSNodeLabelIndexArray = t1.structure();
        int n = tSNodeLabelIndexArray.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex nodeA = tSNodeLabelIndexArray[n2];
            TSNodeLabelIndex[] tSNodeLabelIndexArray2 = t2.structure();
            int n3 = tSNodeLabelIndexArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TSNodeLabelIndex nodeB = tSNodeLabelIndexArray2[n4];
                CommonSubtrees.getCST(nodeA, nodeB, CST, collector, currentLength);
                ++n4;
            }
            ++n2;
        }
        return CST;
    }

    private static NodeSetCollector getCST(TSNodeLabelIndex nodeA, TSNodeLabelIndex nodeB, NodeSetCollector[][] CST, NodeSetCollector collector, int currentLength) {
        NodeSetCollector stored = CST[nodeA.index][nodeB.index];
        if (stored != null) {
            return stored;
        }
        NodeSetCollector nodeCollector = (NodeSetCollector)collector.clone();
        nodeCollector.setMaxLength(currentLength);
        if (nodeA.isLexical == nodeB.isLexical && nodeA.sameLabel(nodeB)) {
            nodeCollector.addDefaultBitSet(nodeA.index);
            if (!nodeA.isLexical && nodeA.sameDaughtersLabel(nodeB)) {
                TSNodeLabel[] daughtersA = nodeA.daughters;
                TSNodeLabel[] daughtersB = nodeB.daughters;
                int prole = nodeA.daughters.length;
                NodeSetCollector[] nodeCollDaughters = new NodeSetCollector[prole];
                int[] nodeSetDaughtersLength = new int[prole];
                int i = 0;
                while (i < prole) {
                    NodeSetCollector collD;
                    TSNodeLabelIndex nodeADaughter = (TSNodeLabelIndex)daughtersA[i];
                    TSNodeLabelIndex nodeBDaughter = (TSNodeLabelIndex)daughtersB[i];
                    nodeCollDaughters[i] = collD = CommonSubtrees.getCST(nodeADaughter, nodeBDaughter, CST, collector, currentLength);
                    nodeSetDaughtersLength[i] = collD.size();
                    ++i;
                }
                nodeCollector.addAllCombinations(nodeCollDaughters, nodeSetDaughtersLength, nodeA.index);
            }
        }
        NodeSetCollector nodeSetCollector = nodeCollector;
        CST[nodeA.index][nodeB.index] = nodeSetCollector;
        return nodeSetCollector;
    }
}

