/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import settings.Parameters;
import tsg.Constituency;
import tsg.IndexConstituency;
import tsg.Yield;
import tsg.YieldConstituency;
import tsg.corpora.ConstCorpus;
import util.Pair;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSNode
implements Serializable {
    public String label;
    public TSNode parent;
    public boolean headMarked;
    public boolean isLexical;
    public TSNode[] daughters;
    private static final long serialVersionUID = 0L;

    public TSNode() {
    }

    public TSNode(String label, TSNode[] daughters) {
        this.label = label;
        this.daughters = daughters;
        TSNode[] tSNodeArray = daughters;
        int n = daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode d = tSNodeArray[n2];
            d.parent = this;
            ++n2;
        }
    }

    public static TSNode TSNodeLexical(String label) {
        TSNode TSN = new TSNode();
        TSN.label = label;
        TSN.isLexical = true;
        return TSN;
    }

    public TSNode(String bracketing) {
        this(bracketing, null, true);
    }

    public TSNode(String bracketing, boolean allTerminalsAreLeaves) {
        this(bracketing, null, allTerminalsAreLeaves);
    }

    private TSNode(String bracketing, TSNode parent, boolean allTerminalsAreLexical) {
        this.parent = parent;
        if (bracketing.indexOf(40) == -1) {
            this.acquireHeads(bracketing);
            if (allTerminalsAreLexical) {
                this.isLexical = true;
            } else {
                this.acquireLexicalMark();
            }
            return;
        }
        String[] subBrackets = TSNode.subBrackets(bracketing);
        if (!this.isLexical) {
            this.acquireHeads(subBrackets[0]);
        }
        this.daughters = new TSNode[subBrackets.length - 1];
        int i = 1;
        while (i < subBrackets.length) {
            this.daughters[i - 1] = new TSNode(subBrackets[i], this, allTerminalsAreLexical);
            ++i;
        }
    }

    private static String[] subBrackets(String bracketing) {
        LinkedList<String> subBrackets = new LinkedList<String>();
        bracketing = bracketing.substring(1, bracketing.length() - 1);
        bracketing = bracketing.replaceAll("\\)\\(", ") (");
        int parenthesis = 0;
        String currentSubBracket = "";
        int i = 0;
        while (i < bracketing.length()) {
            char c = bracketing.charAt(i);
            if (c != ' ' || !currentSubBracket.equals("")) {
                currentSubBracket = String.valueOf(currentSubBracket) + c;
                if (c == '(') {
                    ++parenthesis;
                } else if (c == ')') {
                    --parenthesis;
                }
                if ((c == ' ' || i == bracketing.length() - 1) && parenthesis == 0) {
                    subBrackets.add(currentSubBracket.trim());
                    currentSubBracket = "";
                }
            }
            ++i;
        }
        return subBrackets.toArray(new String[0]);
    }

    private void acquireHeads(String label) {
        if (label.endsWith("-H")) {
            this.headMarked = true;
            label = label.substring(0, label.length() - 2);
        } else {
            this.headMarked = false;
        }
        this.label = label;
    }

    private void acquireLexicalMark() {
        if (this.label.indexOf("\"") == -1) {
            return;
        }
        this.label = this.label.replaceAll("\"", "");
        this.isLexical = true;
    }

    public String label() {
        return this.label;
    }

    public String label(boolean removeSematicTags) {
        return removeSematicTags ? TSNode.removeSemanticTag(this.label) : this.label;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isTop() {
        return this.isRoot() && this.label.equals(ConstCorpus.topTag);
    }

    public void removeTop() {
        if (!this.isTop()) {
            return;
        }
        this.label = this.daughters[0].label;
        this.daughters = this.daughters[0].daughters;
        if (this.daughters != null) {
            TSNode[] tSNodeArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNode d = tSNodeArray[n2];
                d.parent = this;
                ++n2;
            }
        }
    }

    public boolean isHeadMarked() {
        return this.headMarked;
    }

    public boolean isArgumentMarked() {
        return this.label.endsWith("-A");
    }

    public TSNode root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    public int prole() {
        return this.daughters.length;
    }

    public void updateLabel(String newlabel) {
        this.label = newlabel;
    }

    public TSNode firstDaughter() {
        return this.daughters[0];
    }

    public TSNode lastDaughter() {
        return this.daughters[this.daughters.length - 1];
    }

    public TSNode(TSNode original) {
        this.label = original.label;
        this.headMarked = original.headMarked;
        this.isLexical = original.isLexical;
        if (original.daughters == null) {
            return;
        }
        this.daughters = new TSNode[original.daughters.length];
        int d = 0;
        while (d < original.daughters.length) {
            this.daughters[d] = new TSNode(original.daughters[d]);
            this.daughters[d].parent = this;
            ++d;
        }
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public boolean isUniqueDaughter() {
        TSNode parent = this.parent;
        if (parent == null) {
            return false;
        }
        return this.parent.daughters.length == 1;
    }

    public boolean isTerminal() {
        return this.daughters == null;
    }

    public boolean isPreterminal() {
        return this.daughters.length == 1 && this.daughters[0].isTerminal();
    }

    public boolean isPrelexical() {
        return this.daughters.length == 1 && this.daughters[0].isLexical;
    }

    public boolean containsSubstringInDaughter(String substring) {
        if (this.daughters == null) {
            return false;
        }
        int i = 0;
        while (i < this.daughters.length) {
            if (this.daughters[i].label.contains(substring)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsMultipleHeadInDaughters() {
        if (this.daughters == null) {
            return false;
        }
        int prole = this.daughters.length;
        int countHead = 0;
        int d = 0;
        while (d < prole) {
            if (this.daughters[d].headMarked) {
                ++countHead;
            }
            ++d;
        }
        return countHead > 1;
    }

    public int maxDepth(boolean tilde) {
        if (this.daughters == null) {
            return 0;
        }
        int maxDepth = 0;
        int i = 0;
        while (i < this.daughters.length) {
            int depth;
            int increase = 1;
            if (!tilde && this.isTildeNode()) {
                increase = 0;
            }
            if ((depth = increase + this.daughters[i].maxDepth(tilde)) > maxDepth) {
                maxDepth = depth;
            }
            ++i;
        }
        return maxDepth;
    }

    public int maxDepth() {
        if (this.daughters == null) {
            return 0;
        }
        int maxDepth = 0;
        int i = 0;
        while (i < this.daughters.length) {
            int increase = 1;
            int depth = increase + this.daughters[i].maxDepth();
            if (depth > maxDepth) {
                maxDepth = depth;
            }
            ++i;
        }
        return maxDepth;
    }

    public int maxOfMinDepth() {
        if (this.daughters == null) {
            return 0;
        }
        int maxOfMinDepth = this.minDepth();
        int i = 0;
        while (i < this.daughters.length) {
            int minDepth = this.daughters[i].minDepth();
            if (minDepth > maxOfMinDepth) {
                maxOfMinDepth = minDepth;
            }
            ++i;
        }
        return maxOfMinDepth;
    }

    public int minDepth() {
        if (this.daughters.length == 1) {
            if (this.daughters[0].daughters == null) {
                return 0;
            }
            return this.daughters[0].minDepth();
        }
        int minDepth = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.daughters.length) {
            int depth = this.daughters[i].minDepth();
            if (this.daughters[i].daughters.length > 1) {
                ++depth;
            }
            if (depth < minDepth) {
                minDepth = depth;
            }
            ++i;
        }
        return minDepth;
    }

    public long lexDerivations() {
        long result = this.prole();
        if (this.isPrelexical()) {
            return result;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode D = tSNodeArray[n2];
            result *= D.lexDerivations();
            ++n2;
        }
        return result;
    }

    public int hight() {
        int hight = 0;
        TSNode TN = this;
        while (TN.parent != null) {
            TN = TN.parent;
            ++hight;
        }
        return hight;
    }

    public TSNode markedDaughter() {
        if (this.daughters == null) {
            return null;
        }
        int i = 0;
        while (i < this.daughters.length) {
            if (this.daughters[i].headMarked) {
                return this.daughters[i];
            }
            ++i;
        }
        return null;
    }

    public boolean hasMoreThanNBranching(int n) {
        if (this.isTerminal()) {
            return false;
        }
        if (this.prole() > n) {
            return true;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n2 = this.daughters.length;
        int n3 = 0;
        while (n3 < n2) {
            TSNode TN = tSNodeArray[n3];
            if (TN.hasMoreThanNBranching(n)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int[] maxSerialUnaryProduction() {
        int prole = this.daughters.length;
        if (prole == 1 && this.daughters[0].daughters == null) {
            return new int[2];
        }
        int[] max = new int[2];
        int i = 0;
        while (i < prole) {
            max[1] = Math.max(max[1], this.daughters[i].maxSerialUnaryProduction()[1]);
            max[0] = Math.max(max[0], this.daughters[i].maxSerialUnaryProduction()[0]);
            ++i;
        }
        if (prole == 1 && this.parent != null) {
            max[0] = max[0] + 1;
            max[1] = Math.max(max[1], max[0]);
        } else {
            max[0] = 0;
        }
        return max;
    }

    public void makePosTagsLexicon() {
        List<TSNode> words = this.collectTerminals();
        for (TSNode w : words) {
            w.label = w.parent.label;
        }
    }

    public void unMakePosTagsLexicon(TSNode original) {
        List<TSNode> posTags = this.collectLexicalItems();
        List<TSNode> lexicon = original.collectLexicalItems();
        ListIterator<TSNode> p = posTags.listIterator();
        ListIterator<TSNode> l = lexicon.listIterator();
        while (p.hasNext() && l.hasNext()) {
            p.next().label = l.next().label;
        }
    }

    public void replaceNumbers(String numberTag) {
        List<TSNode> words = this.collectLexicalItems();
        for (TSNode w : words) {
            if (w.label.length() > 1 && w.label.matches("[\\d.,\\\\/]+")) {
                w.label = numberTag;
                continue;
            }
            if (!w.label.matches("\\d")) continue;
            w.label = numberTag;
        }
    }

    public int indexOfDaughter(TSNode daughter) {
        if (this.daughters == null) {
            return -1;
        }
        int i = 0;
        while (i < this.daughters.length) {
            if (this.daughters[i] == daughter) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void pruneDaughter(TSNode daughter) {
        this.pruneDaughter(this.indexOfDaughter(daughter));
    }

    public void insertNewDaughter(TSNode daughter, int newPosition) {
        TSNode[] newDaughters = new TSNode[this.daughters.length + 1];
        int i = 0;
        int j = 0;
        while (j < newDaughters.length) {
            if (j == newPosition) {
                newDaughters[j] = daughter;
            } else {
                newDaughters[j] = this.daughters[i];
                ++i;
            }
            ++j;
        }
        daughter.parent = this;
        this.daughters = newDaughters;
    }

    public void pruneDaughter(int index) {
        TSNode[] newDaughters = new TSNode[this.daughters.length - 1];
        int i = 0;
        int j = 0;
        while (j < this.daughters.length) {
            if (j != index) {
                newDaughters[i] = this.daughters[j];
                ++i;
            }
            ++j;
        }
        this.daughters = newDaughters;
    }

    public void removeSemanticTags() {
        if (this.isLexical) {
            return;
        }
        this.label = TSNode.removeSemanticTag(this.label);
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode D = tSNodeArray[n2];
            D.removeSemanticTags();
            ++n2;
        }
    }

    public void removeSemanticTags(String tag) {
        if (this.isLexical) {
            return;
        }
        this.label = TSNode.removeSemanticTag(this.label, tag);
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode D = tSNodeArray[n2];
            D.removeSemanticTags(tag);
            ++n2;
        }
    }

    public static boolean hasSemanticTag(String label) {
        return label.indexOf(45) > 0;
    }

    public static String removeSemanticTag(String label) {
        int dash_index = label.indexOf(45);
        if (dash_index > 0) {
            label = label.substring(0, dash_index);
        }
        return label;
    }

    public static String removeSemanticTag(String label, String tag) {
        int dash_index = label.indexOf(String.valueOf('-') + tag);
        if (dash_index > 0) {
            label = label.substring(0, dash_index);
        }
        return label;
    }

    public void updateUnknown(int limit, Hashtable<String, Integer> lexFreq, String unknownTag, String exception) {
        List<TSNode> lexicon = this.collectLexicalItems();
        for (TSNode w : lexicon) {
            Integer freq;
            if (w.label.equals(exception) || (freq = lexFreq.get(w.label)) != null && freq > limit) continue;
            w.label = unknownTag;
        }
    }

    public TSNode pruneSubTrees(String tag) {
        if (this.toString().indexOf(tag) == -1) {
            return null;
        }
        if (this.label.equals(tag)) {
            return this;
        }
        if (this.isTerminal()) {
            return null;
        }
        LinkedList<TSNode> nonTraces = new LinkedList<TSNode>();
        int i = 0;
        while (i < this.daughters.length) {
            TSNode D = this.daughters[i];
            if (D.pruneSubTrees(tag) == null) {
                nonTraces.add(D);
            }
            ++i;
        }
        if (nonTraces.size() == this.daughters.length) {
            return null;
        }
        if (nonTraces.isEmpty()) {
            return this;
        }
        this.daughters = nonTraces.toArray(new TSNode[0]);
        return null;
    }

    public void replaceLabels(String oldLabel, String newLabel) {
        if (this.label.equals(oldLabel)) {
            this.label = newLabel;
        }
        if (this.daughters == null) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode d = tSNodeArray[n2];
            d.replaceLabels(oldLabel, newLabel);
            ++n2;
        }
    }

    public TSNode pruneSubTrees(String[] removeLabels) {
        if (Arrays.binarySearch(removeLabels, this.label) >= 0) {
            return this;
        }
        if (this.isTerminal()) {
            return null;
        }
        LinkedList<TSNode> nonTraces = new LinkedList<TSNode>();
        int i = 0;
        while (i < this.daughters.length) {
            TSNode D = this.daughters[i];
            if (D.pruneSubTrees(removeLabels) == null) {
                nonTraces.add(D);
            }
            ++i;
        }
        if (nonTraces.size() == this.daughters.length) {
            return null;
        }
        if (nonTraces.isEmpty()) {
            return this;
        }
        this.daughters = nonTraces.toArray(new TSNode[0]);
        return null;
    }

    public void removeRedundantRules() {
        if (this.isPrelexical()) {
            return;
        }
        if (this.prole() == 1 && this.label.equals(this.daughters[0].label)) {
            TSNode[] tSNodeArray = this.daughters = this.daughters[0].daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNode D = tSNodeArray[n2];
                D.parent = this;
                ++n2;
            }
            this.removeRedundantRules();
        } else {
            TSNode[] tSNodeArray = this.daughters;
            int n = this.daughters.length;
            int n3 = 0;
            while (n3 < n) {
                TSNode D = tSNodeArray[n3];
                D.removeRedundantRules();
                ++n3;
            }
        }
    }

    public boolean hasRedundentRules() {
        List<TSNode> nodes = this.collectNonLexicalNodes();
        for (TSNode TN : nodes) {
            if (TN.isPrelexical() || TN.prole() != 1 || !TN.label.equals(TN.daughters[0].label)) continue;
            return true;
        }
        return false;
    }

    public void prunePunctuationBeginning() {
        TSNode pruningRoot;
        TSNode[] terminals = this.collectTerminals().toArray(new TSNode[0]);
        int i = 0;
        while (i < terminals.length && Utility.isPunctuation(terminals[i].parent.label)) {
            ++i;
        }
        int lastIndex = i - 1;
        if (lastIndex == -1) {
            return;
        }
        TSNode tSNode = pruningRoot = lastIndex == 0 ? terminals[0] : this.lowestCommonParent(terminals[0], terminals[lastIndex]);
        if (lastIndex != 0) {
            System.out.print("Multiple punctuation: " + this);
        }
        while (pruningRoot.isUniqueDaughter()) {
            pruningRoot = pruningRoot.parent;
        }
        pruningRoot.parent.pruneDaughter(pruningRoot);
    }

    public void prunePunctuationEnd() {
        TSNode pruningRoot;
        TSNode[] terminals = this.collectTerminals().toArray(new TSNode[0]);
        int i = terminals.length - 1;
        while (i > -1 && Utility.isPunctuation(terminals[i].parent.label)) {
            --i;
        }
        int firstIndex = i + 1;
        if (firstIndex == terminals.length) {
            return;
        }
        TSNode tSNode = pruningRoot = firstIndex == terminals.length - 1 ? terminals[terminals.length - 1] : this.lowestCommonParent(terminals[terminals.length - 1], terminals[firstIndex]);
        if (firstIndex != terminals.length - 1) {
            System.out.print("Multiple punctuation: " + this);
        }
        while (pruningRoot.isUniqueDaughter()) {
            pruningRoot = pruningRoot.parent;
        }
        pruningRoot.parent.pruneDaughter(pruningRoot);
    }

    public void raisePunctuation() {
        List<TSNode> terminals = this.collectTerminals();
        for (TSNode leaf : terminals) {
            int newPosition;
            TSNode postag = leaf.parent;
            if (!Utility.isPunctuation(postag.label)) continue;
            if (postag.isUniqueDaughter()) {
                System.out.println("Nodes that only dominate punctuation preterminals: " + this);
                continue;
            }
            TSNode parentNode = postag.parent;
            if (parentNode.firstDaughter() == postag) {
                parentNode.pruneDaughter(0);
                while (parentNode == parentNode.parent.firstDaughter()) {
                    parentNode = parentNode.parent;
                }
                newPosition = parentNode.parent.indexOfDaughter(parentNode);
                parentNode.parent.insertNewDaughter(postag, newPosition);
                continue;
            }
            if (parentNode.lastDaughter() != postag) continue;
            parentNode.pruneDaughter(parentNode.daughters.length - 1);
            while (parentNode == parentNode.parent.lastDaughter()) {
                parentNode = parentNode.parent;
            }
            newPosition = parentNode.parent.indexOfDaughter(parentNode) + 1;
            parentNode.parent.insertNewDaughter(postag, newPosition);
        }
    }

    public void removeNumberInLabels() {
        if (this.isTerminal()) {
            return;
        }
        this.label = this.label.replaceAll("-\\d+", "");
        this.label = this.label.replaceAll("=\\d+", "");
        int i = 0;
        while (i < this.daughters.length) {
            this.daughters[i].removeNumberInLabels();
            ++i;
        }
    }

    public int countCorrectPOS(TSNode TNgold, String[] exludePOS) {
        List<TSNode> thisLex = this.collectLexicalItems();
        List<TSNode> goldLex = TNgold.collectLexicalItems();
        int result = 0;
        int i = 0;
        while (i < thisLex.size()) {
            String thisPOS = thisLex.get((int)i).parent.label;
            String goldPOS = goldLex.get((int)i).parent.label;
            if (Arrays.binarySearch(exludePOS, goldPOS) < 0 && thisPOS.equals(goldPOS)) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public int countInternalNodes() {
        int result = 0;
        if (this.isTerminal()) {
            return result;
        }
        if (this.parent != null) {
            ++result;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result += TN.countInternalNodes();
            ++n2;
        }
        return result;
    }

    public int countNodes(boolean top, boolean terminals, boolean preterminals) {
        int result = 0;
        if (this.isTerminal()) {
            return terminals ? 1 : 0;
        }
        boolean isRoot = this.isRoot();
        boolean isPreterminal = this.isPreterminal();
        if (isRoot && top) {
            ++result;
        }
        if (isPreterminal && preterminals) {
            ++result;
        }
        if (!isRoot && !isPreterminal) {
            ++result;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result += TN.countNodes(top, terminals, preterminals);
            ++n2;
        }
        return result;
    }

    public int countAllNodes() {
        int result = 1;
        if (this.isTerminal()) {
            return result;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result += TN.countAllNodes();
            ++n2;
        }
        return result;
    }

    public int countLexicalNodes() {
        int result = 0;
        if (this.isLexical) {
            return 1;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result += TN.countLexicalNodes();
            ++n2;
        }
        return result;
    }

    public int countLexicalNodesExcludingLexLabels(String[] excludeLexLabels) {
        int result = 0;
        if (this.isLexical) {
            return Arrays.binarySearch(excludeLexLabels, this.label) < 0 ? 1 : 0;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result += TN.countLexicalNodesExcludingLexLabels(excludeLexLabels);
            ++n2;
        }
        return result;
    }

    public int countLexicalNodesExcludingCatLabels(String[] excludeCatLabels) {
        int result = 0;
        if (this.isLexical) {
            return 1;
        }
        if (Arrays.binarySearch(excludeCatLabels, this.label) >= 0) {
            return 0;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result += TN.countLexicalNodesExcludingCatLabels(excludeCatLabels);
            ++n2;
        }
        return result;
    }

    public String label(boolean headDependencies, boolean lexquot) {
        return this.label(headDependencies, lexquot, true);
    }

    public String label(boolean headDependencies, boolean lexquot, boolean semTag) {
        String result;
        String string = result = semTag ? this.label : TSNode.removeSemanticTag(this.label);
        if (headDependencies && this.headMarked) {
            result = String.valueOf(result) + "-H";
        }
        if (lexquot && this.isLexical) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean headDependencies, boolean lexquot) {
        String result = this.label(headDependencies, lexquot);
        if (this.isTerminal()) {
            return result;
        }
        result = "(" + result;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result = String.valueOf(result) + " " + TN.toString(headDependencies, lexquot);
            ++n2;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String toCFG(boolean lexquot) {
        String result = this.label;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result = String.valueOf(result) + " " + TN.label(false, lexquot);
            ++n2;
        }
        return result;
    }

    public String toCFGCompl(boolean semTag, int[] exluded) {
        String result = this.label(false, false, semTag);
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            if (TN.label.endsWith("-A")) {
                result = String.valueOf(result) + " " + TN.label(false, false, semTag);
            } else {
                exluded[0] = exluded[0] + 1;
            }
            ++n2;
        }
        return result;
    }

    public String toFlat() {
        String flat = "";
        List<TSNode> terminals = this.collectTerminals();
        for (TSNode TN : terminals) {
            flat = String.valueOf(flat) + TN.label + " ";
        }
        flat = flat.trim();
        return flat;
    }

    public String toExtractWord() {
        String result = "";
        List<TSNode> terminals = this.collectTerminals();
        for (TSNode TN : terminals) {
            result = String.valueOf(result) + TN.label + "\n";
        }
        return result;
    }

    public boolean containsConstructor(TSNode constructor) {
        return this.containsConstructor(constructor, true, null);
    }

    public TSNode whereIsConstructor(TSNode constructor) {
        TSNode[] result = new TSNode[1];
        this.containsConstructor(constructor, true, result);
        return result[0];
    }

    public boolean containsSpine(TSNode constructor) {
        TSNode lex = constructor.getAnchor();
        List<TSNode> anchors = this.collectLexicalItems();
        for (TSNode a : anchors) {
            if (!a.label.equals(lex.label)) continue;
            boolean equals = true;
            TSNode ancestor = lex;
            while (ancestor.parent != null) {
                ancestor = ancestor.parent;
                a = a.parent;
                if (ancestor.label.equals(a.label)) continue;
                equals = false;
                break;
            }
            if (!equals) continue;
            return true;
        }
        return false;
    }

    private boolean containsConstructor(TSNode constructor, boolean recursive, TSNode[] pointer) {
        if (this.daughters == null) {
            return constructor.daughters == null && (this.label.equals(constructor.label) || constructor.label.equals("*"));
        }
        if (this.label.equals(constructor.label) || constructor.label.equals("*")) {
            boolean sameDaughters = true;
            if (constructor.daughters != null) {
                if (this.daughters.length == constructor.daughters.length) {
                    int i = 0;
                    while (i < this.daughters.length) {
                        if (!this.daughters[i].containsConstructor(constructor.daughters[i], false, pointer)) {
                            sameDaughters = false;
                            break;
                        }
                        ++i;
                    }
                } else {
                    sameDaughters = false;
                }
            }
            if (sameDaughters) {
                if (pointer != null && constructor.parent == null) {
                    pointer[0] = this;
                }
                return true;
            }
        }
        if (recursive) {
            int i = 0;
            while (i < this.daughters.length) {
                if (this.daughters[i].containsConstructor(constructor, true, pointer)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public TSNode getLeftmostLexicon() {
        if (!this.isLexical) {
            return this.firstDaughter().getLeftmostLexicon();
        }
        return this;
    }

    public TSNode getRightmostLexicon() {
        if (!this.isLexical) {
            return this.lastDaughter().getRightmostLexicon();
        }
        return this;
    }

    public List<TSNode> collectTerminals() {
        ArrayList<TSNode> result = new ArrayList<TSNode>();
        this.collectTerminals(result);
        return result;
    }

    public String getYield() {
        List<TSNode> terminals = this.collectTerminals();
        String result = "";
        for (TSNode TN : terminals) {
            result = String.valueOf(result) + TN.label + " ";
        }
        result = result.trim();
        return result;
    }

    private void collectTerminals(List<TSNode> terminals) {
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            if (TN.isTerminal()) {
                terminals.add(TN);
            } else {
                TN.collectTerminals(terminals);
            }
            ++n2;
        }
    }

    public List<Constituency> collectConsituencies(boolean labeled, String[] excludeLabels, boolean yield) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        List<String> lexicalLabels = null;
        List<TSNode> lexicalNodes = this.collectLexicalItems();
        if (!yield) {
            lexicalLabels = this.collectTerminalStrings();
            int i = 0;
            while (i < lexicalNodes.size()) {
                TSNode LN = lexicalNodes.get(i);
                LN.label = "" + i;
                ++i;
            }
        }
        List<TSNode> nonTerminals = this.collectNodes(true, false, false, true);
        for (TSNode NT : nonTerminals) {
            String NTlabel;
            if (Arrays.binarySearch(excludeLabels, NT.label) >= 0) continue;
            String string = NTlabel = labeled ? NT.label : "";
            if (yield) {
                result.add(new YieldConstituency(NTlabel, new Yield(NT.getYield())));
                continue;
            }
            int start = Integer.parseInt(NT.getLeftmostLexicon().label);
            int end = Integer.parseInt(NT.getRightmostLexicon().label);
            result.add(new IndexConstituency(NTlabel, start, end));
        }
        if (!yield) {
            int i = 0;
            while (i < lexicalNodes.size()) {
                TSNode LN = lexicalNodes.get(i);
                LN.label = lexicalLabels.get(i);
                ++i;
            }
        }
        return result;
    }

    public List<TSNode> collectLexicalItems() {
        ArrayList<TSNode> result = new ArrayList<TSNode>();
        this.collectLexicalItems(result);
        return result;
    }

    private void collectLexicalItems(List<TSNode> terminals) {
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            if (TN.isLexical) {
                terminals.add(TN);
            } else {
                TN.collectLexicalItems(terminals);
            }
            ++n2;
        }
    }

    public List<String> collectTerminalStrings() {
        List<TSNode> terminals = this.collectTerminals();
        ArrayList<String> result = new ArrayList<String>(terminals.size());
        for (TSNode TN : terminals) {
            result.add(TN.toString(false, false));
        }
        return result;
    }

    public List<TSNode> collectSubstitutionSites() {
        ArrayList<TSNode> result = new ArrayList<TSNode>();
        this.collectSubstitutionSites(result);
        return result;
    }

    private void collectSubstitutionSites(List<TSNode> list) {
        if (this.isPrelexical()) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode D = tSNodeArray[n2];
            if (!D.headMarked) {
                list.add(D);
            } else {
                D.collectSubstitutionSites(list);
            }
            ++n2;
        }
    }

    public List<TSNode> collectNodes(boolean top, boolean prelexical, boolean lexical, boolean unary) {
        ArrayList<TSNode> nodes = new ArrayList<TSNode>();
        this.collectNodes(top, prelexical, lexical, unary, nodes);
        return nodes;
    }

    private void collectNodes(boolean top, boolean prelexical, boolean lexical, boolean unary, List<TSNode> list) {
        if (!(!top && this.parent == null || !lexical && this.isLexical || !prelexical && this.isPrelexical() || !unary && this.prole() == 1)) {
            list.add(this);
        }
        if (this.isLexical) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.collectNodes(top, prelexical, lexical, unary, list);
            ++n2;
        }
    }

    public List<TSNode> collectNonLexicalNodes() {
        ArrayList<TSNode> list = new ArrayList<TSNode>();
        this.collectNonLexicalNodes(list);
        return list;
    }

    private void collectNonLexicalNodes(List<TSNode> list) {
        if (this.isLexical) {
            return;
        }
        list.add(this);
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.collectNonLexicalNodes(list);
            ++n2;
        }
    }

    public List<TSNode> collectNonTerminalNodes() {
        ArrayList<TSNode> list = new ArrayList<TSNode>();
        this.collectNonTerminalNodes(list);
        return list;
    }

    private void collectNonTerminalNodes(List<TSNode> list) {
        if (this.isTerminal()) {
            return;
        }
        list.add(this);
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.collectNonTerminalNodes(list);
            ++n2;
        }
    }

    public List<TSNode> collectAncestorNodes() {
        ArrayList<TSNode> list = new ArrayList<TSNode>();
        TSNode node = this.parent;
        while (node != null) {
            list.add(node);
            node = node.parent;
        }
        return list;
    }

    public List<TSNode> collectAllNodes() {
        ArrayList<TSNode> list = new ArrayList<TSNode>();
        this.collectAllNodes(list);
        return list;
    }

    private void collectAllNodes(List<TSNode> list) {
        list.add(this);
        if (this.daughters == null) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.collectAllNodes(list);
            ++n2;
        }
    }

    public String[] splitUniqueLexProduction() {
        String[] result = new String[2];
        TSNode TN = this.getAnchor();
        TN = TN.parent;
        result[0] = TN.toString(false, true);
        TN.daughters = null;
        result[1] = this.toString(false, true);
        return result;
    }

    public ArrayList<ArrayList<TSNode>> getNodesInDepthLevels() {
        int levels = this.maxDepth(true) + 1;
        ArrayList<ArrayList<TSNode>> result = new ArrayList<ArrayList<TSNode>>(levels);
        ArrayList<TSNode> currentLevel = new ArrayList<TSNode>();
        currentLevel.add(this);
        int i = 0;
        while (i < levels) {
            result.add(0, currentLevel);
            ArrayList<TSNode> newLevel = new ArrayList<TSNode>();
            for (TSNode TN : currentLevel) {
                if (TN.isTerminal()) continue;
                TSNode[] tSNodeArray = TN.daughters;
                int n = TN.daughters.length;
                int n2 = 0;
                while (n2 < n) {
                    TSNode TNdaughter = tSNodeArray[n2];
                    newLevel.add(TNdaughter);
                    ++n2;
                }
            }
            currentLevel = newLevel;
            ++i;
        }
        return result;
    }

    public TSNode getAnchor() {
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            if (TN.isLexical) {
                return TN;
            }
            if (!TN.isTerminal()) {
                return TN.getAnchor();
            }
            ++n2;
        }
        return null;
    }

    public TSNode getAnchorThroughPercolation() {
        TSNode node = this;
        while (!node.isPrelexical()) {
            node = node.getHeadDaughter();
        }
        return node.firstDaughter();
    }

    public TSNode getHeadDaughter() {
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            if (TN.headMarked) {
                return TN;
            }
            ++n2;
        }
        return null;
    }

    public List<String> getLexicalProduction(boolean quotation) {
        ArrayList<String> result = new ArrayList<String>();
        this.getLexicalProduction(quotation, result);
        return result;
    }

    private void getLexicalProduction(boolean quotation, List<String> result) {
        if (this.isPrelexical()) {
            result.add(this.toString(false, quotation));
        } else {
            TSNode[] tSNodeArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNode TN = tSNodeArray[n2];
                if (!TN.isTerminal()) {
                    TN.getLexicalProduction(quotation, result);
                }
                ++n2;
            }
        }
    }

    public void toLowerCase() {
        List<TSNode> terminals = this.collectTerminals();
        for (TSNode TN : terminals) {
            TN.label = TN.label.toLowerCase();
        }
    }

    public void toUpperCase() {
        List<TSNode> terminals = this.collectTerminals();
        for (TSNode TN : terminals) {
            TN.label = TN.label.toUpperCase();
        }
    }

    public void removeLexicon() {
        if (this.isPrelexical()) {
            this.daughters = null;
        } else {
            TSNode[] tSNodeArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNode TN = tSNodeArray[n2];
                TN.removeLexicon();
                ++n2;
            }
        }
    }

    public boolean dominatesNodeLabel(String lab) {
        if (this.isPrelexical()) {
            return false;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode D = tSNodeArray[n2];
            if (D.label.equals(lab) || D.dominatesNodeLabel(lab)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void transformNodebasal(String tag, String basalTag) {
        if (this.isPrelexical()) {
            return;
        }
        if (this.label.equals(tag) && !this.dominatesNodeLabel(tag)) {
            this.label = basalTag;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode D = tSNodeArray[n2];
            D.transformNodebasal(tag, basalTag);
            ++n2;
        }
    }

    public void transformSubjectlessSentences(String SubjectLessTag) {
        System.err.println("transformSubjectlessSentences() not yet implemented");
    }

    public void convertTag(String oldTag, String newTag) {
        if (this.label.equals(oldTag)) {
            this.label = newTag;
        }
        if (this.isTerminal()) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode D = tSNodeArray[n2];
            D.convertTag(oldTag, newTag);
            ++n2;
        }
    }

    public int toUniqueInternalLabels(boolean top, int index, boolean followHeads) {
        if (this.daughters == null) {
            return index;
        }
        if ((top || this.parent != null) && (!followHeads || this.headMarked || this.isTildeNode())) {
            this.label = String.valueOf(this.label) + "@" + index++;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            index = TN.toUniqueInternalLabels(top, index, followHeads);
            ++n2;
        }
        return index;
    }

    public void removeUniqueInternalLabels(boolean markHeads) {
        if (markHeads && this.label.indexOf(64) != -1) {
            this.headMarked = true;
        }
        this.label = this.label.replaceAll("@\\d+", "");
        if (this.daughters == null) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.removeUniqueInternalLabels(markHeads);
            ++n2;
        }
    }

    public LinkedList<String> goodman(boolean lexQuotes) {
        LinkedList<String> result = new LinkedList<String>();
        this.goodman(lexQuotes, result);
        return result;
    }

    public long goodman(boolean lexQuotes, LinkedList<String> CFGRules) {
        long result = 1L;
        if (this.isLexical) {
            return result;
        }
        String Aj = this.label;
        String A = this.label.replaceAll("@\\d+", "");
        boolean AisTildeNode = this.isTildeNode();
        if (this.isPrelexical()) {
            String lex = this.daughters[0].label;
            if (lexQuotes) {
                lex = "\"" + lex + "\"";
            }
            CFGRules.add(String.valueOf(Aj) + " " + lex + " " + "1");
            CFGRules.add(String.valueOf(A) + " " + lex + " " + "1");
            return result;
        }
        String Bk = this.daughters[0].label;
        String B = this.daughters[0].label.replaceAll("@\\d+", "");
        long b_k = this.daughters[0].goodman(lexQuotes, CFGRules);
        result = b_k + 1L;
        if (this.daughters.length == 1) {
            if (!A.equals(ConstCorpus.topTag)) {
                CFGRules.add(String.valueOf(Aj) + " " + B + " 1");
                CFGRules.add(String.valueOf(Aj) + " " + Bk + " " + b_k);
            }
            CFGRules.add(String.valueOf(A) + " " + B + " 1");
            CFGRules.add(String.valueOf(A) + " " + Bk + " " + b_k);
            return result;
        }
        String Cl = this.daughters[1].label;
        String C = this.daughters[1].label.replaceAll("@\\d+", "");
        boolean CisTildeNode = this.daughters[1].isTildeNode();
        long c_l = this.daughters[1].goodman(lexQuotes, CFGRules);
        if (!CisTildeNode) {
            result *= c_l + 1L;
            CFGRules.add(String.valueOf(Aj) + " " + B + " " + C + " 1");
            CFGRules.add(String.valueOf(Aj) + " " + Bk + " " + C + " " + b_k);
        } else {
            result *= c_l;
        }
        CFGRules.add(String.valueOf(Aj) + " " + B + " " + Cl + " " + c_l);
        CFGRules.add(String.valueOf(Aj) + " " + Bk + " " + Cl + " " + b_k * c_l);
        if (!AisTildeNode) {
            if (C.indexOf(126) == -1) {
                CFGRules.add(String.valueOf(A) + " " + B + " " + C + " 1");
                CFGRules.add(String.valueOf(A) + " " + Bk + " " + C + " " + b_k);
            }
            CFGRules.add(String.valueOf(A) + " " + B + " " + Cl + " " + c_l);
            CFGRules.add(String.valueOf(A) + " " + Bk + " " + Cl + " " + b_k * c_l);
        }
        return result;
    }

    public void percolatePosTags() {
        ArrayList<ArrayList<TSNode>> nodesInLevels = this.getNodesInDepthLevels();
        boolean first = true;
        for (ArrayList<TSNode> levelList : nodesInLevels) {
            if (first) {
                first = false;
                continue;
            }
            for (TSNode TN : levelList) {
                if (TN.isLexical || TN.isPrelexical() || TN.label.equals(ConstCorpus.topTag)) continue;
                TSNode daughter = TN.getHeadDaughter();
                TN.label = daughter.label;
            }
        }
    }

    public void applyAllConversions() {
        if (Parameters.spineConversion) {
            this.convertToSpine();
            if (Parameters.removeRedundencyInSpine) {
                this.removeRedundantRules();
            }
        }
        if (Parameters.posTagConversion) {
            this.makePosTagsLexicon();
        } else if (Parameters.jollyConversion) {
            this.convertToJolly();
        }
    }

    public void convertToSpine() {
        if (this.isTerminal()) {
            return;
        }
        if (this.daughters.length != 1) {
            TSNode[] newDaughter = new TSNode[1];
            TSNode[] tSNodeArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNode D = tSNodeArray[n2];
                if (!D.isTerminal()) {
                    newDaughter[0] = D;
                    break;
                }
                ++n2;
            }
            this.daughters = newDaughter;
        }
        this.daughters[0].convertToSpine();
    }

    public void convertToJolly() {
        if (this.isPrelexical()) {
            return;
        }
        LinkedList<TSNode> newDaughters = new LinkedList<TSNode>();
        TSNode headDaughter = null;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode d = tSNodeArray[n2];
            if (!d.isTerminal()) {
                headDaughter = d;
                newDaughters.add(d);
            } else {
                boolean present;
                boolean bl = present = Arrays.binarySearch(Parameters.jollyLabels, d.label) >= 0;
                if (Parameters.jollyInclusion && present) {
                    newDaughters.add(d);
                } else if (!Parameters.jollyInclusion && !present) {
                    newDaughters.add(d);
                }
            }
            ++n2;
        }
        if (this.prole() != newDaughters.size()) {
            this.daughters = newDaughters.toArray(new TSNode[newDaughters.size()]);
        }
        headDaughter.convertToJolly();
    }

    public List<String> allSubTrees(int maxDepth) {
        Pair<ArrayList<String>> duet = this.allSubTreesB(maxDepth);
        List result = duet.getFirst();
        result.addAll((Collection)duet.getSecond());
        return result;
    }

    private Pair<ArrayList<String>> allSubTreesB(int maxDepth) {
        Pair<ArrayList<String>> subTrees = new Pair<ArrayList<String>>(new ArrayList(), new ArrayList());
        if (this.isTerminal()) {
            return subTrees;
        }
        int prole = this.daughters.length;
        ArrayList<ArrayList<String>> daughterSubTrees = new ArrayList<ArrayList<String>>(prole);
        int[] daughterSubTreesSize = new int[prole];
        int index = 0;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            Pair<ArrayList<String>> daugherSubTreesNewOld = TN.allSubTreesB(maxDepth);
            subTrees.getSecond().addAll((Collection<String>)daugherSubTreesNewOld.getFirst());
            subTrees.getSecond().addAll((Collection<String>)daugherSubTreesNewOld.getSecond());
            ArrayList<String> TNlist = daugherSubTreesNewOld.getFirst();
            TNlist.add(TN.label(false, true));
            daughterSubTrees.add(TNlist);
            ListIterator<String> l = TNlist.listIterator();
            while (l.hasNext()) {
                String sT = l.next();
                TSNode TNsT = new TSNode(sT, false);
                if (TNsT.maxDepth(true) != maxDepth) continue;
                l.remove();
            }
            daughterSubTreesSize[index] = TNlist.size();
            ++index;
            ++n2;
        }
        int[][] combinations = Utility.combinations(daughterSubTreesSize);
        int i = 0;
        while (i < combinations.length) {
            String rule = "(" + this.label(false, false) + " ";
            int j = 0;
            while (j < prole) {
                String sT = (String)((ArrayList)daughterSubTrees.get(j)).get(combinations[i][j]);
                rule = String.valueOf(rule) + sT;
                rule = String.valueOf(rule) + (j == prole - 1 ? ")" : " ");
                ++j;
            }
            if (rule != null) {
                subTrees.getFirst().add(rule);
            }
            ++i;
        }
        return subTrees;
    }

    public long countSubTrees(boolean includeTilde) {
        if (this.daughters == null) {
            return 0L;
        }
        long result = this.daughters[0].countSubTrees(includeTilde) + 1L;
        if (this.daughters.length == 1) {
            return result;
        }
        int i = 1;
        while (i < this.daughters.length) {
            long count = this.daughters[i].countSubTrees(includeTilde);
            if (includeTilde || this.daughters[i].label.indexOf(126) == -1) {
                ++count;
            }
            result *= count;
            ++i;
        }
        return result;
    }

    public boolean isTildeNode() {
        return this.label.indexOf("~") != -1;
    }

    public void toNormalForm() {
        String newLabel;
        int level;
        if (this.isTerminal()) {
            return;
        }
        if (this.daughters.length <= 2) {
            TSNode[] tSNodeArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNode TN = tSNodeArray[n2];
                TN.toNormalForm();
                ++n2;
            }
            return;
        }
        this.daughters[0].toNormalForm();
        int index = this.label.indexOf(126);
        int n = level = index == -1 ? 1 : Integer.parseInt(this.label.substring(index + 1)) + 1;
        if (index == -1) {
            newLabel = new String(this.label);
            TSNode[] tSNodeArray = this.daughters;
            int n3 = this.daughters.length;
            int n4 = 0;
            while (n4 < n3) {
                TSNode TN = tSNodeArray[n4];
                newLabel = String.valueOf(newLabel) + "_" + TN.label;
                ++n4;
            }
        } else {
            newLabel = this.label.substring(0, index);
        }
        TSNode tildeDaughter = new TSNode();
        tildeDaughter.label = String.valueOf(newLabel) + "~" + level;
        tildeDaughter.parent = this;
        tildeDaughter.daughters = new TSNode[this.daughters.length - 1];
        tildeDaughter.headMarked = false;
        int i = 1;
        while (i < this.daughters.length) {
            tildeDaughter.daughters[i - 1] = this.daughters[i];
            tildeDaughter.daughters[i - 1].parent = tildeDaughter;
            tildeDaughter.daughters[i - 1].toNormalForm();
            if (tildeDaughter.daughters[i - 1].headMarked) {
                tildeDaughter.headMarked = true;
            }
            ++i;
        }
        this.daughters = new TSNode[]{this.daughters[0], tildeDaughter};
        tildeDaughter.toNormalForm();
    }

    public void fromNormalForm() {
        if (this.daughters == null) {
            return;
        }
        int last = this.daughters.length - 1;
        if (this.daughters[last].isTildeNode()) {
            int new_dim = this.daughters.length + 1;
            TSNode[] newDaughters = new TSNode[new_dim];
            int i = 0;
            while (i < last) {
                newDaughters[i] = this.daughters[i];
                ++i;
            }
            newDaughters[last] = this.daughters[last].daughters[0];
            newDaughters[last].parent = this;
            newDaughters[last + 1] = this.daughters[last].daughters[1];
            newDaughters[last + 1].parent = this;
            this.daughters = newDaughters;
            this.fromNormalForm();
            return;
        }
        int i = 0;
        while (i < this.daughters.length) {
            this.daughters[i].fromNormalForm();
            ++i;
        }
    }

    public int lexicalizedHeadDerivations() {
        if (this.daughters == null) {
            return 1;
        }
        int result = this.daughters.length;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            result *= TN.lexicalizedHeadDerivations();
            ++n2;
        }
        return result;
    }

    public void toLexicalizeFrame() {
        if (this.isTerminal()) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            if (!TN.headMarked) {
                TN.daughters = null;
            } else {
                TN.toLexicalizeFrame();
            }
            ++n2;
        }
    }

    public TSNode[] cutRecursiveNew() {
        if (!this.label.equals("TOP")) {
            return null;
        }
        TSNode recursiveNode = null;
        int i = 0;
        while (i < this.daughters.length) {
            if (this.daughters[i].daughters != null) {
                recursiveNode = this.daughters[i];
                break;
            }
            ++i;
        }
        i = 0;
        while (i < recursiveNode.daughters.length) {
            TSNode D = recursiveNode.daughters[i];
            if (D.daughters != null) {
                if (!D.label.equals(recursiveNode.label)) {
                    return null;
                }
                TSNode[] splitting = new TSNode[2];
                TSNode[] daughters = D.daughters;
                D.daughters = null;
                splitting[0] = new TSNode(this);
                D.daughters = daughters;
                D.parent = null;
                splitting[1] = D;
                return splitting;
            }
            ++i;
        }
        return null;
    }

    public TSNode[] cutRecursiveOld() {
        if (this.label.equals("TOP") && this.daughters[0].label.equals("S")) {
            TSNode TN_S = this.daughters[0];
            int j = 0;
            while (j < TN_S.daughters.length) {
                TSNode D = TN_S.daughters[j];
                if (D.daughters != null && D.label.equals("S")) {
                    TSNode[] splitting = new TSNode[2];
                    TSNode[] daughters = D.daughters;
                    D.daughters = null;
                    splitting[0] = new TSNode(this);
                    D.daughters = daughters;
                    splitting[1] = D;
                    return splitting;
                }
                ++j;
            }
        }
        return null;
    }

    public TSNode[] cutRecursive() {
        if (this.label.equals("TOP")) {
            int j = 0;
            while (j < this.daughters.length) {
                TSNode D = this.daughters[j];
                if (!D.isTerminal()) {
                    TSNode[] splitting = new TSNode[2];
                    TSNode[] daughters = D.daughters;
                    D.daughters = null;
                    splitting[0] = new TSNode(this);
                    D.daughters = daughters;
                    splitting[1] = D;
                    return splitting;
                }
                ++j;
            }
        }
        return null;
    }

    public void removeHeadAnnotations() {
        this.headMarked = false;
        if (this.daughters == null) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.removeHeadAnnotations();
            ++n2;
        }
    }

    public void removeArgumentInHeads() {
        if (this.label.endsWith("-H-A")) {
            this.headMarked = true;
            this.label = this.label.substring(0, this.label.length() - 4);
        }
        if (this.daughters == null) {
            return;
        }
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.removeArgumentInHeads();
            ++n2;
        }
    }

    public void assignFirstLeftHeads() {
        int prole = this.daughters.length;
        if (prole == 1 && this.daughters[0].daughters == null) {
            return;
        }
        this.daughters[0].headMarked = true;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.assignFirstLeftHeads();
            ++n2;
        }
    }

    public void assignFirstRightHeads() {
        int prole = this.daughters.length;
        if (prole == 1 && this.daughters[0].daughters == null) {
            return;
        }
        this.daughters[prole - 1].headMarked = true;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.assignFirstRightHeads();
            ++n2;
        }
    }

    public void assignRandomHeads() {
        int prole = this.daughters.length;
        if (prole == 1 && this.daughters[0].daughters == null) {
            return;
        }
        int randomDaughter = Utility.randomInteger(prole);
        this.daughters[randomDaughter].headMarked = true;
        TSNode[] tSNodeArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNode TN = tSNodeArray[n2];
            TN.assignRandomHeads();
            ++n2;
        }
    }

    public TSNode lowestCommonParent(TSNode[] set) {
        if (set.length > 2) {
            TSNode[] newSet = new TSNode[set.length - 1];
            newSet[0] = this.lowestCommonParent(set[0], set[1]);
            int i = 2;
            while (i < set.length) {
                newSet[i - 1] = set[i];
                ++i;
            }
            return this.lowestCommonParent(newSet);
        }
        return this.lowestCommonParent(set[0], set[1]);
    }

    /*
     * Unable to fully structure code
     */
    public TSNode lowestCommonParent(TSNode terminal1, TSNode terminal2) {
        block3: {
            hightDifference = terminal1.hight() - terminal2.hight();
            if (hightDifference == 0) break block3;
            if (hightDifference >= 0) ** GOTO lbl11
            while (hightDifference != 0) {
                terminal2 = terminal2.parent;
                ++hightDifference;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                terminal1 = terminal1.parent;
                --hightDifference;
lbl11:
                // 2 sources

                ** while (hightDifference != 0)
            }
        }
        while (terminal1 != terminal2) {
            terminal1 = terminal1.parent;
            terminal2 = terminal2.parent;
        }
        return terminal1;
    }

    public void copyHeadAnnotation(TSNode fromTree) {
        this.headMarked = fromTree.headMarked;
        if (this.isTerminal()) {
            return;
        }
        int d = 0;
        while (d < this.daughters.length) {
            this.daughters[d].copyHeadAnnotation(fromTree.daughters[d]);
            ++d;
        }
    }

    public boolean hasSameHeadAnnotation(TSNode otherTree) {
        if (this.headMarked != otherTree.headMarked) {
            return false;
        }
        if (this.isTerminal()) {
            return true;
        }
        int i = 0;
        while (i < this.prole()) {
            if (!this.daughters[i].hasSameHeadAnnotation(otherTree.daughters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] checkHeadConsistency(boolean correct) {
        int[] result = new int[2];
        this.checkHeadConsistency(correct, result);
        return result;
    }

    public boolean hasWrongHeadAssignment() {
        int[] correction = new int[2];
        this.checkHeadConsistency(false, correction);
        return correction[0] > 0;
    }

    private void checkHeadConsistency(boolean correct, int[] result) {
        if (this.daughters == null) {
            return;
        }
        int prole = this.daughters.length;
        if (this.isPreterminal()) {
            return;
        }
        int countHead = 0;
        int d = 0;
        while (d < prole) {
            if (this.daughters[d].headMarked) {
                ++countHead;
            }
            this.daughters[d].checkHeadConsistency(correct, result);
            ++d;
        }
        if (countHead != 1) {
            if (correct) {
                if (countHead > 1) {
                    TSNode[] tSNodeArray = this.daughters;
                    int n = this.daughters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TSNode d2 = tSNodeArray[n2];
                        d2.headMarked = false;
                        ++n2;
                    }
                }
                this.daughters[0].headMarked = true;
            }
            result[0] = result[0] + 1;
            if (prole == 1) {
                result[1] = result[1] + 1;
            }
        }
    }

    public void fixUnaryHeadConsistency() {
        if (this.daughters == null) {
            return;
        }
        int prole = this.daughters.length;
        if (prole == 1 && this.daughters[0].daughters != null) {
            this.daughters[0].headMarked = true;
        }
        int d = 0;
        while (d < prole) {
            this.daughters[d].fixUnaryHeadConsistency();
            ++d;
        }
    }

    public List<TSNode> lexicalizedTreesFromHeadAnnotation() {
        ArrayList<TSNode> result = new ArrayList<TSNode>();
        List<TSNode> lexicon = this.collectLexicalItems();
        for (TSNode TN : lexicon) {
            TSNode up = TN.parent;
            while (up.headMarked && up.parent != null) {
                up = up.parent;
            }
            result.add(up.lexicalizedTreeCopy());
        }
        return result;
    }

    public TSNode lexicalizedTreeCopy() {
        TSNode lexicalTree = new TSNode(this);
        lexicalTree.toLexicalizeFrame();
        return lexicalTree;
    }

    public TSNode lexicalizedTreeToAnchor(TSNode leaf) {
        this.markHeadPathToAnchor(leaf);
        TSNode lexTree = new TSNode(this);
        lexTree.toLexicalizeFrame();
        this.unmarkHeadPathToAnchor(leaf);
        return lexTree;
    }

    public void markHeadPathToAnchor(TSNode leaf) {
        TSNode up = leaf.parent;
        while (up != this) {
            up.headMarked = true;
            up = up.parent;
        }
    }

    public void unmarkHeadPathToAnchor(TSNode leaf) {
        TSNode up = leaf.parent;
        while (up != this) {
            up.headMarked = false;
            up = up.parent;
        }
    }

    public void markHeadPathToTop() {
        TSNode up = this.parent;
        while (up != null) {
            up.headMarked = true;
            up = up.parent;
        }
    }

    public void removeSubstitutionSitesInLexTree(String[] removeCat) {
        TSNode daughter = this.getAnchor();
        TSNode parent = daughter.parent;
        while (parent != null) {
            LinkedList<TSNode> newDaughters = new LinkedList<TSNode>();
            TSNode[] tSNodeArray = parent.daughters;
            int n = parent.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNode d = tSNodeArray[n2];
                if (d == daughter || Arrays.binarySearch(removeCat, d.label) < 0) {
                    newDaughters.add(d);
                }
                ++n2;
            }
            if (newDaughters.size() != parent.daughters.length) {
                parent.daughters = newDaughters.toArray(new TSNode[0]);
            }
            daughter = parent;
            parent = daughter.parent;
        }
    }

    public void addMarkersInTree(IdentityHashMap<TSNode, TreeSet<Integer>> markTable) {
        TreeSet<Integer> markRecord = markTable.get(this);
        if (markRecord == null) {
            this.label = "*_" + this.label;
        } else {
            for (Integer mark : markRecord) {
                this.label = String.valueOf(this.label) + "_" + mark;
            }
        }
        if (this.daughters == null) {
            return;
        }
        int i = 0;
        while (i < this.daughters.length) {
            this.daughters[i].addMarkersInTree(markTable);
            ++i;
        }
    }

    public static String get_unique_lexicon(String eTree) {
        int quoteChar = eTree.indexOf(34);
        if (quoteChar == -1) {
            return null;
        }
        String lexicon = eTree.substring(quoteChar + 1, eTree.indexOf(34, quoteChar + 1));
        return lexicon;
    }

    public static String get_unique_root(String eTree) {
        return eTree.substring(1, eTree.indexOf(32));
    }

    public boolean isPunctuation() {
        return Utility.isPunctuation(this.label);
    }

    public boolean hasOnlyPuncLeaves() {
        List<TSNode> terminals = this.collectTerminals();
        for (TSNode l : terminals) {
            if (l.isPunctuation()) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllPunctuationLabels(List<TSNode> nodes) {
        for (TSNode l : nodes) {
            if (l.isPunctuation()) continue;
            return false;
        }
        return true;
    }

    public String printLatex(int level) {
        String result = "";
        if (level == 0) {
            result = String.valueOf(result) + "\\begin{parsetree}\n";
        }
        result = String.valueOf(result) + Utility.fillTab(level) + "( ." + this.label + ".";
        int i = 0;
        while (i < this.daughters.length) {
            TSNode TN = this.daughters[i];
            if (TN.daughters == null) {
                String lexicalLabel = TN.label;
                if (lexicalLabel.equals("")) {
                    lexicalLabel = "$\\varnothing$";
                }
                result = String.valueOf(result) + " ~ `" + lexicalLabel + "')";
            } else {
                result = String.valueOf(result) + "\n" + TN.printLatex(level + 1);
                if (i == this.daughters.length - 1) {
                    result = String.valueOf(result) + "\n" + Utility.fillTab(level) + ")";
                }
            }
            ++i;
        }
        if (level == 0) {
            result = String.valueOf(result) + "\n\\end{parsetree}\n\n";
        }
        return result;
    }

    public String printLatex2() {
        String result = "\\Tree " + this.toString();
        result = result.replaceAll("\\(", "[.");
        result = result.replaceAll("\\)", " ]");
        return result;
    }

    public BitSet getHeadsBitSet() {
        List<TSNode> allNodes = this.collectAllNodes();
        BitSet result = new BitSet(allNodes.size());
        int index = 0;
        for (TSNode t : allNodes) {
            if (t.isHeadMarked()) {
                result.set(index);
            }
            ++index;
        }
        return result;
    }

    public void assignHeadFromBitSet(BitSet bs) {
        List<TSNode> allNodes = this.collectAllNodes();
        int index = bs.nextSetBit(0);
        while (index != -1) {
            allNodes.get((int)index).headMarked = true;
            index = bs.nextSetBit(index + 1);
        }
    }

    public void hasNonMinimalHeads(boolean countPunctuation, int sentenceNumber) {
        List<TSNode> allNodes = this.collectNonTerminalNodes();
        List<TSNode> allTerminals = this.collectTerminals();
        IdentityHashMap<TSNode, Integer> hights = new IdentityHashMap<TSNode, Integer>();
        for (TSNode t : allTerminals) {
            hights.put(t, t.hight());
        }
        for (TSNode n : allNodes) {
            TSNode terminalHead = n.getAnchorThroughPercolation();
            int terminalHeadHight = (Integer)hights.get(terminalHead);
            List<TSNode> terminals = n.collectTerminals();
            TSNode minimalHead = terminalHead;
            int minimalHight = terminalHeadHight;
            for (TSNode t : terminals) {
                int tHight;
                if (t == terminalHead || !countPunctuation && t.isPunctuation() || (tHight = ((Integer)hights.get(t)).intValue()) >= minimalHight) continue;
                minimalHight = tHight;
                minimalHead = t;
            }
            if (minimalHead == terminalHead) continue;
            System.out.println(String.valueOf(sentenceNumber) + ":\t" + this.toString() + "\n" + "\tParent: " + n.label + "  Current Head: " + terminalHead.label + "  Min Head: " + minimalHead.label);
        }
    }

    public static void main(String[] args) {
    }
}

