/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import backoff.BackoffModel_Eisner;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Scanner;
import settings.Parameters;
import symbols.Symbol;
import symbols.SymbolList;
import symbols.SymbolString;
import tesniere.EvalTDS;
import tsg.TSNodeLabel;
import tsg.corpora.Wsj;
import tsg.parseEval.EvalF;
import util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCFG_reranker {
    public static BackoffModel_Eisner rulesModel = null;

    public static ArrayList<TSNodeLabel> nextNBest(int nBest, Scanner s) throws Exception {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>(nBest);
        int count = 0;
        while (s.hasNextLine() && count < nBest) {
            String line = s.nextLine();
            if (line.equals("")) {
                return result;
            }
            result.add(new TSNodeLabel(line));
            ++count;
        }
        while (s.hasNextLine() && !s.nextLine().equals("")) {
        }
        return result;
    }

    public static void trainFromCorpus(File trainingCorpus) throws Exception {
        ArrayList<TSNodeLabel> corpus = TSNodeLabel.getTreebank(trainingCorpus);
        for (TSNodeLabel t : corpus) {
            t.pruneSubTrees(TSNodeLabel.nullTag);
            t.addTop();
            ArrayList<TSNodeLabel> nodes = t.collectAllNodes();
            for (TSNodeLabel n : nodes) {
                if (n.isLexical) continue;
                SymbolList rule = n.cfgRuleSymbol();
                SymbolString lhs = new SymbolString(n.label());
                Symbol[][] event = new Symbol[][]{{rule, lhs}};
                rulesModel.increaseInTables((Symbol[][])event);
            }
        }
    }

    public static double getProb(TSNodeLabel t) {
        ArrayList<TSNodeLabel> nodes = t.collectAllNodes();
        double totalProb = 1.0;
        for (TSNodeLabel n : nodes) {
            if (n.isLexical) continue;
            SymbolList rule = n.cfgRuleSymbol();
            SymbolString lhs = new SymbolString(n.label());
            Symbol[][] event = new Symbol[][]{{rule, lhs}};
            totalProb *= rulesModel.getCondProb((Symbol[][])event);
        }
        return totalProb;
    }

    public static void rerank(int nBest) throws Exception {
        rulesModel = new BackoffModel_Eisner(2, 0.005, 0.5, 0.0);
        File trainingCorpus = new File(String.valueOf(Wsj.WsjConstBase) + "ORIGINAL_READABLE_CIRCUMSTANTIALS_SEMTAGSOFF/" + "wsj-02-21.mrg");
        PCFG_reranker.trainFromCorpus(trainingCorpus);
        String baseDir = String.valueOf(Parameters.resultsPath) + "TSG/PCFG_Reranker/";
        File nBestFile = new File(String.valueOf(baseDir) + "wsj-22_chiarniak_parsed1000_clean_ADV.mrg");
        File PCFGfile = new File(String.valueOf(baseDir) + "pcfg.txt");
        Scanner nBestScanner = FileUtil.getScanner(nBestFile);
        rulesModel.printTablesToFile(PCFGfile, 0);
        File goldFile = new File(String.valueOf(baseDir) + "wsj-22_gold_ADV.mrg");
        ArrayList<TSNodeLabel> goldTreebank = TSNodeLabel.getTreebank(goldFile);
        File rerankedFile = new File(String.valueOf(baseDir) + "wsj-22_reranked_" + nBest + "best.mrg");
        File rerankedFileEvalF = new File(String.valueOf(baseDir) + "wsj-22_reranked_" + nBest + "best.evalF");
        PrintWriter pw = FileUtil.getPrintWriter(rerankedFile);
        int size = goldTreebank.size();
        int activelyReranked = 0;
        int i = 0;
        while (i < size) {
            ArrayList<TSNodeLabel> nBestTrees = PCFG_reranker.nextNBest(nBest, nBestScanner);
            Iterator<TSNodeLabel> iter = nBestTrees.iterator();
            TSNodeLabel bestReranked = iter.next();
            double maxProb = PCFG_reranker.getProb(bestReranked);
            boolean reranked = false;
            while (iter.hasNext()) {
                TSNodeLabel t = iter.next();
                double p = PCFG_reranker.getProb(t);
                if (!(p > maxProb)) continue;
                maxProb = p;
                bestReranked = t;
                reranked = true;
            }
            if (reranked) {
                ++activelyReranked;
            }
            pw.println(bestReranked.toString());
            ++i;
        }
        pw.close();
        float[] rerankedFScore = EvalF.staticEvalF(goldFile, rerankedFile, rerankedFileEvalF, true);
        System.out.println("Actively Reranked: " + activelyReranked);
        System.out.println("Reranked Recall Precision FScore: " + Arrays.toString(rerankedFScore));
        new EvalTDS(rerankedFile, goldFile).compareStructures();
    }

    public static void main(String[] args) throws Exception {
        int[] nBest;
        int[] nArray = nBest = new int[]{1, 5, 10, 100, 500, 1000};
        int n = nBest.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            PCFG_reranker.rerank(n3);
            ++n2;
        }
    }
}

