/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.TreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeViewer<T>
extends JPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected TreePanel<T> treePanel;
    protected File corpusFile;
    protected JPanel controlPanel;
    protected JSpinner controlSentenceNumber;
    protected JButton plus;
    protected JButton minus;
    protected JLabel sizeReport;
    protected JLabel statusBar;
    protected JCheckBox[] optionCheckBoxs;

    public TreeViewer() {
        super(new BorderLayout());
        this.setCheckBoxOptions();
        this.buildComponents();
        JScrollPane scroller = new JScrollPane(this.treePanel);
        scroller.setPreferredSize(new Dimension(800, 600));
        this.statusBar = new JLabel("");
        this.add((Component)this.controlPanel, "North");
        this.add((Component)scroller, "Center");
        this.add((Component)this.statusBar, "South");
        this.setInitialSentence();
    }

    protected abstract void setCheckBoxOptions();

    protected abstract void setInitialSentence();

    protected abstract void initializeTreePanel();

    protected void loadTreebank(ArrayList<T> treebank) {
        int size = treebank.size();
        this.treePanel.loadTreebank(treebank);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, size, 1);
        this.controlSentenceNumber.setModel(spinnerModel);
        this.sizeReport.setText("of: " + size);
        this.treePanel.init();
        this.statusBar.setText(this.treePanel.flatSentence);
    }

    protected void buildComponents() {
        this.controlSentenceNumber = new JSpinner();
        this.controlSentenceNumber.setPreferredSize(new Dimension(100, 30));
        this.controlSentenceNumber.addChangeListener(this);
        this.controlSentenceNumber.setFocusable(true);
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setFocusable(false);
        JPanel leftControlPanel = new JPanel();
        JPanel centerControlPanel = new JPanel();
        JPanel rightControlPanel = new JPanel();
        this.controlPanel.add((Component)leftControlPanel, "West");
        this.controlPanel.add((Component)centerControlPanel, "Center");
        this.controlPanel.add((Component)rightControlPanel, "East");
        if (this.optionCheckBoxs != null) {
            JCheckBox[] jCheckBoxArray = this.optionCheckBoxs;
            int n = this.optionCheckBoxs.length;
            int n2 = 0;
            while (n2 < n) {
                JCheckBox cb = jCheckBoxArray[n2];
                cb.addActionListener(this);
                cb.setFocusable(false);
                leftControlPanel.add(cb);
                ++n2;
            }
        }
        this.plus = new JButton("+");
        this.minus = new JButton("-");
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        this.plus.setFocusable(false);
        this.minus.setFocusable(false);
        centerControlPanel.add(new JLabel("Zoom: "));
        centerControlPanel.add(this.plus);
        centerControlPanel.add(this.minus);
        rightControlPanel.add(this.controlSentenceNumber);
        this.sizeReport = new JLabel();
        this.sizeReport.setFocusable(false);
        rightControlPanel.add(this.sizeReport);
        this.initializeTreePanel();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Integer s = (Integer)this.controlSentenceNumber.getValue();
        int index = s - 1;
        this.treePanel.goToSentence(index);
        this.treePanel.init();
        this.statusBar.setText(this.treePanel.flatSentence);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.optionCheckBoxs != null) {
            JCheckBox[] jCheckBoxArray = this.optionCheckBoxs;
            int n = this.optionCheckBoxs.length;
            int n2 = 0;
            while (n2 < n) {
                JCheckBox cb = jCheckBoxArray[n2];
                if (source == cb) {
                    this.treePanel.init();
                    this.controlSentenceNumber.requestFocus();
                    return;
                }
                ++n2;
            }
        }
        int fs = source == this.plus ? this.treePanel.increaseFontSize() : this.treePanel.decreaseFontSize();
        System.out.println("Font size: " + fs);
        this.treePanel.init();
        this.controlSentenceNumber.requestFocus();
    }
}

