/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import tdg.TDNode;
import tdg.corpora.DepCorpus;
import tdg.corpora.WsjD;
import viewer.DepTreePanelOld;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepTreeViewerOld
extends JPanel
implements MouseListener,
KeyListener {
    private DepTreePanelOld treePanel;

    public DepTreeViewerOld(ArrayList<TDNode> treebank) {
        super(new BorderLayout());
        this.treePanel = new DepTreePanelOld(treebank);
        this.treePanel.setBackground(Color.white);
        this.treePanel.setFocusable(true);
        this.treePanel.addMouseListener(this);
        this.treePanel.addKeyListener(this);
        JScrollPane scroller = new JScrollPane(this.treePanel);
        scroller.setPreferredSize(new Dimension(800, 600));
        this.add((Component)scroller, "Center");
        this.treePanel.init();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int s = this.treePanel.nextSentence();
            System.out.println("Next sentence: " + s);
        } else {
            int s = this.treePanel.previousSentence();
            System.out.println("Previous sentence: " + s);
        }
        this.treePanel.init();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        int id = e.getID();
        if (id == 400) {
            char c = e.getKeyChar();
            switch (c) {
                case '+': {
                    int s = this.treePanel.increaseFontSize();
                    System.out.println("Font size: " + s);
                    this.treePanel.init();
                    break;
                }
                case '-': {
                    int s = this.treePanel.decreaseFontSize();
                    System.out.println("Font size: " + s);
                    this.treePanel.init();
                    break;
                }
                case 'N': 
                case 'n': {
                    int s = this.treePanel.nextSentence();
                    System.out.println("Next sentence: " + s);
                    this.treePanel.init();
                    break;
                }
                case 'P': 
                case 'p': {
                    int s = this.treePanel.previousSentence();
                    System.out.println("Previous sentence: " + s);
                    this.treePanel.init();
                    break;
                }
                case 'S': 
                case 's': {
                    File outputFile = new File("tmp/image1.eps");
                    this.treePanel.exportToEPS(outputFile);
                }
            }
        } else {
            int n = e.getKeyCode();
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Dependency Tree Viewer");
        frame.setDefaultCloseOperation(3);
        File trainCorpus = new File(String.valueOf(WsjD.WsjCOLLINS99Arg_ulab) + "wsj-00.ulab");
        ArrayList treebank = DepCorpus.readTreebankFromFileMST((File)trainCorpus, (int)100, (boolean)false, (boolean)false);
        DepTreeViewerOld newContentPane = new DepTreeViewerOld(treebank);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DepTreeViewerOld.createAndShowGUI();
            }
        });
    }
}

