/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tdg.TDNode;
import tdg.corpora.DepCorpus;
import tsg.TSNode;
import tsg.corpora.ConstCorpus;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.Utility;

public class DepConstConverter {
    public static void assignHeadsFromDependencyPair(TSNode TSN, int indexHead, int indexDependent) {
        List<TSNode> terminals = TSN.collectTerminals();
        TSNode head = terminals.get(indexHead);
        TSNode dependent = terminals.get(indexDependent);
        TSNode lowestCommonParent = TSN.lowestCommonParent(head, dependent);
        head = head.parent;
        while (head != lowestCommonParent) {
            head.headMarked = true;
            head = head.parent;
        }
    }

    public static boolean assignHeadsFromDependencyTable(TSNode TSN, int[][] wordBoundary, int[][] dependency, String[] output) {
        int i;
        if (dependency == null) {
            TSN.fixUnaryHeadConsistency();
            return TSN.hasWrongHeadAssignment();
        }
        Object[] wordBoundaryNodes = new TSNode[wordBoundary.length];
        int[] lastBlock = wordBoundary[wordBoundary.length - 1];
        int lastIndex = lastBlock[lastBlock.length - 1];
        TSNode[] terminals = TSN.collectTerminals().toArray(new TSNode[0]);
        if (lastIndex != terminals.length - 2 && !terminals[terminals.length - 1].label.equals("''")) {
            i = 0;
            ++i;
        }
        i = 0;
        while (i < wordBoundary.length) {
            if (wordBoundary[i].length == 1) {
                wordBoundaryNodes[i] = terminals[wordBoundary[i][0]].parent;
            } else {
                TSNode[] terminalBlock = new TSNode[wordBoundary[i].length];
                int j = 0;
                while (j < wordBoundary[i].length) {
                    terminalBlock[j] = terminals[wordBoundary[i][j]];
                    ++j;
                }
                wordBoundaryNodes[i] = TSN.lowestCommonParent(terminalBlock);
            }
            output[0] = String.valueOf(output[0]) + wordBoundaryNodes[i].collectTerminals().toString() + " ";
            ++i;
        }
        output[0] = String.valueOf(output[0]) + "\n";
        int d = 0;
        while (d < dependency.length) {
            block13: {
                TSNode lowestCommonParent;
                TSNode head;
                block14: {
                    int[] dep;
                    if (dependency[d][1] == dependency[d][0]) break block13;
                    head = wordBoundaryNodes[dependency[d][1]];
                    TSNode dependent = wordBoundaryNodes[dependency[d][0]];
                    output[0] = String.valueOf(output[0]) + head.collectTerminals().toString() + " --> " + dependent.collectTerminals().toString() + "\n";
                    lowestCommonParent = TSN.lowestCommonParent(head, dependent);
                    TSNode markedDaughter = lowestCommonParent.markedDaughter();
                    if (markedDaughter == null) break block14;
                    TSNode competitor = markedDaughter;
                    int wordBoundaryNodeIndexCompetitor = Utility.indexOf(competitor, wordBoundaryNodes);
                    while (wordBoundaryNodeIndexCompetitor == -1) {
                        competitor = competitor.markedDaughter();
                        wordBoundaryNodeIndexCompetitor = Utility.indexOf(competitor, wordBoundaryNodes);
                    }
                    if (wordBoundaryNodeIndexCompetitor == dependency[d][1] || Utility.indexOf(dep = new int[]{dependency[d][1], wordBoundaryNodeIndexCompetitor}, dependency) != -1) break block13;
                    markedDaughter.headMarked = false;
                }
                while (head != lowestCommonParent) {
                    head.headMarked = true;
                    head = head.parent;
                }
            }
            ++d;
        }
        TSN.fixUnaryHeadConsistency();
        return !TSN.hasWrongHeadAssignment();
    }

    public static boolean assignHeadsFromDependencyTable(TSNode TSN, int[][] dependency, String[] output) {
        if (dependency == null) {
            TSN.fixUnaryHeadConsistency();
            return !TSN.hasWrongHeadAssignment();
        }
        TSNode[] terminals = TSN.collectTerminals().toArray(new TSNode[0]);
        int d = 0;
        while (d < dependency.length) {
            if (dependency[d][0] != dependency[d][1] && dependency[d][0] <= terminals.length - 1 && dependency[d][1] <= terminals.length - 1 && dependency[d][0] >= 0 && dependency[d][1] >= 0) {
                TSNode head = terminals[dependency[d][0]];
                TSNode dependent = terminals[dependency[d][1]];
                output[0] = String.valueOf(output[0]) + head.toString() + " (" + dependency[d][0] + ") --> " + dependent.toString() + " (" + dependency[d][1] + ")\n";
                TSNode lowestCommonParent = TSN.lowestCommonParent(head, dependent);
                head = head.parent;
                while (head != lowestCommonParent) {
                    head.headMarked = true;
                    head = head.parent;
                }
            }
            ++d;
        }
        TSN.fixUnaryHeadConsistency();
        return !TSN.hasWrongHeadAssignment();
    }

    public static void dep2const(TSNode TSN, TDNode TDN, int index, PrintWriter log) {
        TSNode[] terminals;
        TDNode[] structure = TDN.getStructureArray();
        if (structure.length != (terminals = TSN.collectLexicalItems().toArray(new TSNode[0])).length) {
            String errorMessage = "Error in dep2const: length unmatched at sentence" + index;
            if (log != null) {
                log.println(errorMessage);
            } else {
                System.err.println(errorMessage);
            }
            return;
        }
        if (structure.length == 1) {
            TSN.fixUnaryHeadConsistency();
            return;
        }
        TDNode[] tDNodeArray = structure;
        int n = structure.length;
        int n2 = 0;
        while (n2 < n) {
            TDNode tdn = tDNodeArray[n2];
            TDNode parent = tdn.parent;
            if (parent != null) {
                TSNode head = terminals[parent.index];
                TSNode dependent = terminals[tdn.index];
                TSNode lowestCommonParent = TSN.lowestCommonParent(head, dependent);
                head = head.parent;
                while (head != lowestCommonParent) {
                    head.headMarked = true;
                    head = head.parent;
                }
            }
            ++n2;
        }
        TSN.fixUnaryHeadConsistency();
        if (TSN.hasWrongHeadAssignment()) {
            String errorMessage = "Error in dep2const: wrong head assignment at sentence " + index;
            if (log != null) {
                log.println(errorMessage);
            } else {
                System.err.println(errorMessage);
            }
            return;
        }
    }

    public static void convertConll07() {
        File DepConll07Dir = new File("/scratch/fsangati/CORPUS/WSJ/DEPENDENCY/CONLL07/");
        File ConstConll07Dir = new File(Wsj.WsjOriginalNPBraketingCleanedConll07);
        File ConstCleanedDir = new File(Wsj.WsjOriginalNPBraketingCleaned);
        ConstConll07Dir.mkdirs();
        Object[] fileDepList = DepConll07Dir.listFiles();
        Object[] fileConstList = ConstCleanedDir.listFiles();
        Arrays.sort(fileDepList);
        Arrays.sort(fileConstList);
        int i = 0;
        while (i < fileDepList.length) {
            Object inputDepFile = fileDepList[i];
            Object inputConstFile = fileConstList[i];
            File outputConstFile = new File(ConstConll07Dir + "/" + ((File)inputConstFile).getName());
            File outputConstFileLog = new File(ConstConll07Dir + "/" + ((File)inputConstFile).getName() + ".log");
            PrintWriter output = FileUtil.getPrintWriter(outputConstFile);
            PrintWriter logOutput = FileUtil.getPrintWriter(outputConstFileLog);
            ArrayList depCorpus = DepCorpus.readTreebankFromFileConll07((File)inputDepFile, (int)1000);
            ArrayList<TSNode> constCorpusCleaned = new ConstCorpus((File)inputConstFile, (String)"OrigNPBracketing", (boolean)false).treeBank;
            System.out.println(((File)inputConstFile).getName());
            int j = 0;
            while (j < depCorpus.size()) {
                System.out.println(j);
                TDNode tdn = (TDNode)depCorpus.get(j);
                TSNode tsn = (TSNode)constCorpusCleaned.get(j);
                DepConstConverter.dep2const(tsn, tdn, j, logOutput);
                output.println(tsn.toString(true, false));
                ++j;
            }
            output.close();
            logOutput.close();
            ++i;
        }
    }

    public static void convertYM() {
        File DepYMDir = new File("/scratch/fsangati/CORPUS/WSJ/DEPENDENCY/YM/");
        File ConstYMDir = new File("/scratch/fsangati/CORPUS/WSJ/CONSTITUENCY/YM/");
        File ConstCleanedDir = new File(Wsj.WsjOriginalCleaned);
        ConstYMDir.mkdirs();
        Object[] fileDepList = DepYMDir.listFiles();
        Object[] fileConstList = ConstCleanedDir.listFiles();
        Arrays.sort(fileDepList);
        Arrays.sort(fileConstList);
        int i = 0;
        while (i < fileDepList.length) {
            Object inputDepFile = fileDepList[i];
            Object inputConstFile = fileConstList[i];
            File outputConstFile = new File(ConstYMDir + "/" + ((File)inputConstFile).getName());
            File outputConstFileLog = new File(ConstYMDir + "/" + ((File)inputConstFile).getName() + ".log");
            PrintWriter output = FileUtil.getPrintWriter(outputConstFile);
            PrintWriter logOutput = FileUtil.getPrintWriter(outputConstFileLog);
            ArrayList depCorpus = DepCorpus.readTreebankFromFileYM((File)inputDepFile, (int)1000);
            ArrayList<TSNode> constCorpusCleaned = new ConstCorpus((File)inputConstFile, (String)"OrigNPBracketing", (boolean)false).treeBank;
            System.out.println(((File)inputConstFile).getName());
            int j = 0;
            while (j < depCorpus.size()) {
                System.out.println(j);
                TDNode tdn = (TDNode)depCorpus.get(j);
                TSNode tsn = (TSNode)constCorpusCleaned.get(j);
                DepConstConverter.dep2const(tsn, tdn, j, logOutput);
                output.println(tsn.toString(true, false));
                ++j;
            }
            output.close();
            logOutput.close();
            ++i;
        }
    }

    public static void convertMalt() {
        File DepYMDir = new File("/scratch/fsangati/CORPUS/WSJ/DEPENDENCY/PENN2MALT");
        File ConstYMDir = new File("/scratch/fsangati/CORPUS/WSJ/CONSTITUENCY/PENN2MALT/");
        File ConstCleanedDir = new File(Wsj.WsjOriginalCleaned);
        ConstYMDir.mkdirs();
        Object[] fileDepList = DepYMDir.listFiles();
        Object[] fileConstList = ConstCleanedDir.listFiles();
        Arrays.sort(fileDepList);
        Arrays.sort(fileConstList);
        int i = 0;
        while (i < fileDepList.length) {
            Object inputDepFile = fileDepList[i];
            Object inputConstFile = fileConstList[i];
            File outputConstFile = new File(ConstYMDir + "/" + ((File)inputConstFile).getName());
            File outputConstFileLog = new File(ConstYMDir + "/" + ((File)inputConstFile).getName() + ".log");
            PrintWriter output = FileUtil.getPrintWriter(outputConstFile);
            PrintWriter logOutput = FileUtil.getPrintWriter(outputConstFileLog);
            ArrayList depCorpus = DepCorpus.readTreebankFromFileMALT((File)inputDepFile, (int)1000);
            ArrayList<TSNode> constCorpusCleaned = new ConstCorpus((File)inputConstFile, (String)"OrigNPBracketing", (boolean)false).treeBank;
            System.out.println(((File)inputConstFile).getName());
            int j = 0;
            while (j < depCorpus.size()) {
                System.out.println(j);
                TDNode tdn = (TDNode)depCorpus.get(j);
                TSNode tsn = (TSNode)constCorpusCleaned.get(j);
                DepConstConverter.dep2const(tsn, tdn, j, logOutput);
                output.println(tsn.toString(true, false));
                ++j;
            }
            output.close();
            logOutput.close();
            ++i;
        }
    }

    public static void main(String[] args) {
        File DepConll07_15 = new File("/scratch/fsangati/CORPUS/WSJ/DEPENDENCY/CONLL07/wsj-00_15.tab");
        ArrayList depCorpus = DepCorpus.readTreebankFromFileConll07((File)DepConll07_15, (int)1000);
        TSNode TSN = new TSNode("(S (PP-LOC (IN-H Among) (NP (NP-H (CD 33) (NNS-H men)) (SBAR (WHNP (WP-H who)) (S-H (VP-H (VBD-H worked) (ADVP-MNR (RB-H closely)) (PP-CLR (IN-H with) (NP (DT the) (NN-H substance)))))))) (, ,) (NP-SBJ-H (NP-H (CD-H 28))) (VP-H (VBP-H have) (VP (VBN-H died) (: --) (NP (QP (JJ more) (IN than) (CD three) (NNS-H times)) (DT the) (VBN expected) (NN-H number)))) (. .))");
        TDNode TDN = (TDNode)depCorpus.get(0);
        DepConstConverter.dep2const(TSN, TDN, 0, null);
    }
}

