/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import settings.Parameters;
import tsg.ConvertFragmentsToCFGRules;
import tsg.TSNodeLabel;
import tsg.corpora.ConstCorpus;
import tsg.parseEval.EvalF;
import tsg.parser.ConvertGrammarInBitParFormat;
import util.FileUtil;
import util.PrintProgress;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseWSJprobNew {
    public static String lexPosSeparationString = "^";
    public static char lexPosSeparationChar = lexPosSeparationString.charAt(0);
    static PrintWriter pwLog;
    static int nBest;
    static String bitparArgs;
    static String viterbProbPrefix;
    static int viterbProbPrefixLength;

    static {
        nBest = 1000;
        bitparArgs = "-vp -b " + nBest + " -o -s TOP ";
        viterbProbPrefix = "vitprob=";
        viterbProbPrefixLength = viterbProbPrefix.length();
    }

    private static void reportLine(String line) {
        System.out.println(line);
        if (pwLog != null) {
            pwLog.println(line);
        }
    }

    public static void extractCFGrules(File inputFile, File outputFile) throws Exception {
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(inputFile);
        Hashtable<String, int[]> rulesTableFreq = new Hashtable<String, int[]>();
        for (TSNodeLabel t : treebank) {
            ArrayList<String> fragments = t.allSubTrees(1, Integer.MAX_VALUE);
            for (String s : fragments) {
                Utility.increaseStringIntArray(rulesTableFreq, s);
            }
        }
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        for (Map.Entry e : rulesTableFreq.entrySet()) {
            String fragmentString = (String)e.getKey();
            int freq = ((int[])e.getValue())[0];
            TSNodeLabel fragmentTree = new TSNodeLabel(fragmentString, false);
            pw.println(String.valueOf(fragmentTree.toString(false, true)) + "\t" + freq);
        }
        pw.close();
    }

    public static void extractFragmentsFileDepths(File inputFile, String outputDir, int maxDepth, int maxProle) throws Exception {
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(inputFile);
        Hashtable[] fragmentsTablesDepths = new Hashtable[maxDepth];
        int i = 0;
        while (i < maxDepth) {
            fragmentsTablesDepths[i] = new Hashtable();
            ++i;
        }
        PrintProgress.start("Extractrig fragments up to depth " + maxDepth + " max braching " + maxProle + ": ");
        for (TSNodeLabel t : treebank) {
            PrintProgress.next();
            ArrayList<String> fragments = t.allSubTrees(maxDepth, maxProle);
            for (String s : fragments) {
                TSNodeLabel treeFragm = new TSNodeLabel(s, false);
                int depth = treeFragm.maxDepth();
                Utility.increaseStringIntArray(fragmentsTablesDepths[depth - 1], s);
            }
        }
        PrintProgress.end();
        i = 0;
        while (i < maxDepth) {
            int depth = i + 1;
            File outputFile = new File(String.valueOf(outputDir) + "fragments_Depth_" + depth + "_maxProle_" + maxProle + "_freq_all.txt");
            PrintWriter pw = FileUtil.getPrintWriter(outputFile);
            for (Map.Entry e : fragmentsTablesDepths[i].entrySet()) {
                String fragmentString = (String)e.getKey();
                int freq = ((int[])e.getValue())[0];
                TSNodeLabel fragmentTree = new TSNodeLabel(fragmentString, false);
                pw.println(String.valueOf(freq) + "\t" + fragmentTree.toString(false, true));
            }
            pw.close();
            ++i;
        }
    }

    public static void prepareKernelFragments() throws Exception {
    }

    private static void makeFragmentsUniqueFile(File fragmentsFile, File fragmentsUniqueFile) {
        Hashtable<String, int[]> fragFreq = new Hashtable<String, int[]>();
        Scanner scan = FileUtil.getScanner(fragmentsFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            String[] freqTree = line.split("\t");
            int freq = Integer.parseInt(freqTree[0]);
            String tree = freqTree[1];
            int[] storedFreq = (int[])fragFreq.get(tree);
            if (storedFreq == null) {
                storedFreq = new int[]{freq};
                fragFreq.put(tree, storedFreq);
                continue;
            }
            if (storedFreq[0] >= freq) continue;
            storedFreq[0] = freq;
        }
        PrintWriter pw = FileUtil.getPrintWriter(fragmentsUniqueFile);
        for (Map.Entry e : fragFreq.entrySet()) {
            pw.println(String.valueOf(((int[])e.getValue())[0]) + "\t" + (String)e.getKey());
        }
        pw.println();
        pw.close();
    }

    private static ArrayList<String[]> getTestSentencesPosWord(File testFile) throws Exception {
        ArrayList<String[]> result = new ArrayList<String[]>();
        ArrayList<TSNodeLabel> testTreebank = TSNodeLabel.getTreebank(testFile);
        for (TSNodeLabel t : testTreebank) {
            ArrayList<String> sentencePosWords = new ArrayList<String>();
            ArrayList<TSNodeLabel> lexItems = t.collectLexicalItems();
            for (TSNodeLabel l : lexItems) {
                String word = l.label();
                String pos = l.parent.label();
                sentencePosWords.add(String.valueOf(pos) + lexPosSeparationString + word);
            }
            String[] sentencePosWordArray = sentencePosWords.toArray(new String[sentencePosWords.size()]);
            result.add(sentencePosWordArray);
        }
        return result;
    }

    private static void createTestSentenceFile(String[] flatWordArrayPosTerminal, File testSentencesPreprocessed) {
        PrintWriter flatPW = FileUtil.getPrintWriter(testSentencesPreprocessed);
        flatPW.println(String.valueOf(Utility.joinStringArrayToString(flatWordArrayPosTerminal, "\n")) + "\n");
        flatPW.close();
    }

    public static File buildAndParse(String workingDir, File testFile, File fragmentsFile) throws Exception {
        File fragmentsUniqueFile = new File(fragmentsFile + "_UNIQUE");
        File probGrammarFile = new File(String.valueOf(workingDir) + "CFG_FREQ_GRAMMAR.txt");
        File cfgRuleFragmentMappingFile = new File(String.valueOf(workingDir) + "CFG_RULE_FRAGMENT_MAPPING.txt");
        File ouputBitParPosProcessedBestFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED_BEST.txt");
        File ouputBitParPosProcessedFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED.txt");
        File parseLog = new File(String.valueOf(workingDir) + "parse.log");
        pwLog = FileUtil.getPrintWriter(parseLog);
        ParseWSJprobNew.makeFragmentsUniqueFile(fragmentsFile, fragmentsUniqueFile);
        File ambiguousFragmentsLogFile = new File(String.valueOf(workingDir) + "log_ambiguousFragmetnsCFG.txt");
        ConvertFragmentsToCFGRules converter = new ConvertFragmentsToCFGRules(fragmentsUniqueFile, ambiguousFragmentsLogFile);
        converter.printGrammarFile(probGrammarFile);
        converter.printRuleBestFragmentMappingFile(cfgRuleFragmentMappingFile);
        Hashtable<String, TSNodeLabel> ruleFragmentTable = converter.getRuleBestFragmentMappingTable();
        ArrayList<String[]> testSentencesPosWord = ParseWSJprobNew.getTestSentencesPosWord(testFile);
        String bitParOuputPath = String.valueOf(workingDir) + "bitparOutput/";
        new File(bitParOuputPath).mkdir();
        int sentenceIndex = 0;
        int maxCounterLength = Integer.toString(testSentencesPosWord.size()).length();
        PrintWriter pwBest = FileUtil.getPrintWriter(ouputBitParPosProcessedBestFile);
        PrintWriter pwComplete = FileUtil.getPrintWriter(ouputBitParPosProcessedFile);
        for (String[] sentencePosWord : testSentencesPosWord) {
            if (++sentenceIndex < 1011) continue;
            ParseWSJprobNew.reportLine("Preparing grammar for sentence: " + sentenceIndex);
            long startTime = System.currentTimeMillis();
            String sentenceIndexPad = Utility.padZero(maxCounterLength, sentenceIndex);
            String sentenceFolder = String.valueOf(bitParOuputPath) + "Sentence" + sentenceIndexPad + "/";
            new File(sentenceFolder).mkdir();
            File testSenteceBitParFormat = new File(String.valueOf(sentenceFolder) + "sentence_" + sentenceIndexPad + "_words.txt");
            ParseWSJprobNew.createTestSentenceFile(sentencePosWord, testSenteceBitParFormat);
            File sentenceGrammarFile = new File(String.valueOf(sentenceFolder) + "GRAMMAR.txt");
            File sentenceLexiconFile = new File(String.valueOf(sentenceFolder) + "LEXICON.txt");
            ConvertGrammarInBitParFormat.probGrammarForOneSentenceNew(probGrammarFile, sentencePosWord, sentenceGrammarFile, sentenceLexiconFile, lexPosSeparationChar);
            float tookSec = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            ParseWSJprobNew.reportLine("Took " + tookSec);
            startTime = System.currentTimeMillis();
            ParseWSJprobNew.reportLine("Parsing sentence...");
            File outputBitParSentenceFile = new File(String.valueOf(sentenceFolder) + "sentence_" + sentenceIndexPad + "_bitParOut.txt");
            File outputBitParSentencePostProcessedFile = new File(String.valueOf(sentenceFolder) + "sentence_" + sentenceIndexPad + "_bitParOut_postprocessed.txt");
            ParseWSJprobNew.runBitPar(sentenceGrammarFile, sentenceLexiconFile, testSenteceBitParFormat, outputBitParSentenceFile, sentenceFolder);
            ParseWSJprobNew.posprocessNbest(outputBitParSentenceFile, outputBitParSentencePostProcessedFile, ruleFragmentTable, pwBest);
            FileUtil.append(outputBitParSentencePostProcessedFile, pwComplete);
            pwComplete.println();
            tookSec = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            ParseWSJprobNew.reportLine("Finished parsing. Took " + tookSec + " sec.");
            ParseWSJprobNew.reportLine("");
        }
        pwBest.close();
        pwLog.close();
        pwComplete.close();
        return ouputBitParPosProcessedBestFile;
    }

    private static HashSet<String> getTestSentencesPosWordSet(File testCorpus) throws Exception {
        HashSet<String> result = new HashSet<String>();
        ArrayList<TSNodeLabel> corpus = TSNodeLabel.getTreebank(testCorpus);
        for (TSNodeLabel t : corpus) {
            ArrayList<TSNodeLabel> lex = t.collectLexicalItems();
            for (TSNodeLabel l : lex) {
                String word = l.label();
                String pos = l.parent.label();
                result.add(String.valueOf(pos) + lexPosSeparationString + word);
            }
        }
        return result;
    }

    public static File buildAndParseUniqueGrammar(String workingDir, File testFile, File fragmentsFile, int nBest) throws Exception {
        File fragmentsUniqueFile = new File(String.valueOf(workingDir) + "ALL_FRAGMENTS_UNIQUE.txt");
        File probGrammarFile = new File(String.valueOf(workingDir) + "CFG_FREQ_GRAMMAR.txt");
        File cfgRuleFragmentMappingFile = new File(String.valueOf(workingDir) + "CFG_RULE_FRAGMENT_MAPPING.txt");
        File testSentencesBitParFormat = new File(String.valueOf(workingDir) + "Test_BitPar_Format.txt");
        File ouputBitParFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT.txt");
        File ouputBitParPosProcessedFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED.txt");
        File ouputBitParPosProcessedBestFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED_BEST.txt");
        File grammarFile = new File(String.valueOf(workingDir) + "GRAMMAR.txt");
        File lexiconFile = new File(String.valueOf(workingDir) + "LEXICON.txt");
        File parseLog = new File(String.valueOf(workingDir) + "parse.log");
        pwLog = FileUtil.getPrintWriter(parseLog);
        ParseWSJprobNew.makeFragmentsUniqueFile(fragmentsFile, fragmentsUniqueFile);
        File ambiguousFragmentsLogFile = new File(String.valueOf(workingDir) + "log_ambiguousFragmetnsCFG.txt");
        ConvertFragmentsToCFGRules converter = new ConvertFragmentsToCFGRules(fragmentsUniqueFile, ambiguousFragmentsLogFile);
        converter.printGrammarFile(probGrammarFile);
        converter.printRuleBestFragmentMappingFile(cfgRuleFragmentMappingFile);
        Hashtable<String, TSNodeLabel> ruleFragmentTable = converter.getRuleBestFragmentMappingTable();
        HashSet<String> testSentencesPosWordSet = ParseWSJprobNew.getTestSentencesPosWordSet(testFile);
        ParseWSJprobNew.reportLine("Preparing unique grammar for all sentences.");
        long startTime = System.currentTimeMillis();
        ConvertGrammarInBitParFormat.probGrammarForAllSentences(probGrammarFile, testSentencesPosWordSet, grammarFile, lexiconFile, lexPosSeparationChar);
        float tookSec = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        ParseWSJprobNew.reportLine("Took " + tookSec);
        String bitParOuputPath = String.valueOf(workingDir) + "bitparOutput/";
        new File(bitParOuputPath).mkdir();
        ArrayList<String[]> testSentencesPosWord = ParseWSJprobNew.getTestSentencesPosWord(testFile);
        PrintWriter pwTestBP = FileUtil.getPrintWriter(testSentencesBitParFormat);
        int sentenceIndex = 0;
        for (String[] sentencePosWord : testSentencesPosWord) {
            pwTestBP.println(String.valueOf(Utility.joinStringArrayToString(sentencePosWord, "\n")) + "\n");
            ++sentenceIndex;
        }
        pwTestBP.close();
        PrintWriter pwBestFinal = FileUtil.getPrintWriter(ouputBitParPosProcessedBestFile);
        ParseWSJprobNew.runBitPar(grammarFile, lexiconFile, testSentencesBitParFormat, ouputBitParFile, workingDir);
        ParseWSJprobNew.posprocessNbest(ouputBitParFile, ouputBitParPosProcessedFile, ruleFragmentTable, pwBestFinal);
        pwBestFinal.close();
        pwLog.close();
        return ouputBitParPosProcessedBestFile;
    }

    private static void runBitPar(File grammarFile, File lexiconFile, File testSentencesWordsFile, File outputBitParSentenceFile, String workingDir) throws Exception {
        String line;
        Process p = Runtime.getRuntime().exec(String.valueOf(Parameters.bitparApp) + " " + bitparArgs + " " + grammarFile + " " + lexiconFile + " " + testSentencesWordsFile + " " + outputBitParSentenceFile, null, new File(workingDir));
        p.waitFor();
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = input.readLine()) != null) {
            ParseWSJprobNew.reportLine(line);
        }
        input.close();
        input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            ParseWSJprobNew.reportLine(line);
        }
        input.close();
        p.getOutputStream().close();
        p.getInputStream().close();
        p.getErrorStream().close();
        p.destroy();
    }

    private static void posprocessNbest(File outputBitParSentenceFile, File outputBitParSentencePosProcessedFile, Hashtable<String, TSNodeLabel> ruleFragmentTable, PrintWriter pwFinal) throws Exception {
        Scanner scan = FileUtil.getScanner(outputBitParSentenceFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputBitParSentencePosProcessedFile);
        double prob = -1.0;
        Hashtable<String, double[]> parseProbTable = new Hashtable<String, double[]>();
        if (!scan.hasNextLine()) {
            ParseWSJprobNew.reportLine("EMPTY FILE!!!!");
        }
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) {
                if (parseProbTable.isEmpty()) continue;
                pwFinal.println(Utility.getMaxKey(parseProbTable));
                parseProbTable.clear();
                pw.println();
                continue;
            }
            if (line.startsWith(viterbProbPrefix)) {
                prob = Double.parseDouble(line.substring(viterbProbPrefixLength));
                pw.println(line);
                continue;
            }
            line = line.replaceAll("\\\\", "");
            TSNodeLabel tree = null;
            String fragmentConvertedString = null;
            if (line.startsWith("No parse for: ")) {
                tree = new TSNodeLabel("(FIX FIX)");
                ParseWSJprobNew.reportLine("NO PARSE SENTENCE!!");
                fragmentConvertedString = tree.toString();
            } else {
                tree = new TSNodeLabel(line);
                ParseWSJprobNew.fixLexiconInTree(tree);
                fragmentConvertedString = tree.replaceRulesWithFragments(ruleFragmentTable).toString();
            }
            pw.println(fragmentConvertedString);
            Utility.increaseStringDoubleArray(parseProbTable, fragmentConvertedString, prob);
        }
        pw.close();
        scan.close();
    }

    private static void posprocessNbest(File outputBitParSentenceFile, File outputBest) throws Exception {
        Scanner scan = FileUtil.getScanner(outputBitParSentenceFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputBest);
        double prob = -1.0;
        Hashtable<String, double[]> parseProbTable = new Hashtable<String, double[]>();
        if (!scan.hasNextLine()) {
            ParseWSJprobNew.reportLine("EMPTY FILE!!!!");
        }
        int sentenceIndex = 0;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) {
                if (parseProbTable.isEmpty()) continue;
                System.out.println(++sentenceIndex);
                pw.println(Utility.getMaxKey(parseProbTable));
                parseProbTable.clear();
                continue;
            }
            if (line.startsWith(viterbProbPrefix)) {
                prob = Double.parseDouble(line.substring(viterbProbPrefixLength));
                continue;
            }
            line = line.replaceAll("\\\\", "");
            TSNodeLabel tree = new TSNodeLabel(line);
            Utility.increaseStringDoubleArray(parseProbTable, tree.toString(), prob);
        }
        pw.close();
        scan.close();
    }

    private static void fixLexiconInTree(TSNodeLabel tree) {
        ArrayList<TSNodeLabel> lexicon = tree.collectLexicalItems();
        for (TSNodeLabel l : lexicon) {
            if (l.label().equals(l.parent.label())) {
                l.parent.daughters = null;
                l.parent.isLexical = true;
                continue;
            }
            String label = l.label();
            String newLabel = label.substring(label.indexOf(lexPosSeparationChar) + 1);
            l.relabel(newLabel);
        }
    }

    private static void addOneInKernelFragmentFileAndSwapColumns(File inputFile, File outputFile) {
        Scanner scan = FileUtil.getScanner(inputFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            String[] freqTree = line.split("\t");
            String tree = freqTree[0];
            int newFreq = Integer.parseInt(freqTree[1]) + 1;
            pw.println(String.valueOf(newFreq) + "\t" + tree);
        }
        pw.println();
        scan.close();
        pw.close();
    }

    private static void concatFilesAndSwapColumns(File[] fileList, File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Scanner scan = FileUtil.getScanner(f);
            while (scan.hasNextLine()) {
                String line = scan.nextLine();
                if (line.equals("")) continue;
                String[] treeFreq = line.split("\t");
                pw.println(String.valueOf(treeFreq[1]) + "\t" + treeFreq[0]);
            }
            scan.close();
            ++n2;
        }
        pw.println();
        pw.close();
    }

    public static void preProcessTreebank(File inputFile, File outputFile) throws Exception {
        Scanner scan = FileUtil.getScanner(inputFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            line = ConstCorpus.addTop(line);
            TSNodeLabel t = new TSNodeLabel(line);
            t.removeSemanticTags();
            pw.println(t.toString());
        }
        scan.close();
        pw.close();
    }

    public static void toyGrammarParsing() throws Exception {
        File trainigFile = new File("tmp/toyGrammar.txt");
        String fragmentDir = "tmp/";
        ParseWSJprobNew.extractFragmentsFileDepths(trainigFile, fragmentDir, 10, 100);
    }

    public static void smallParsing() throws Exception {
        String workingDir = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/parsing/SmallGrammar1000L1/";
        File testFile = new File(String.valueOf(workingDir) + "wsj-22_TOP.mrg");
        File allFragmentFile = new File(String.valueOf(workingDir) + "ALL_FRAGMENTS");
        File parsedFile = ParseWSJprobNew.buildAndParse(workingDir, testFile, allFragmentFile);
        File evalF = new File(String.valueOf(workingDir) + "evalF.txt");
        File evalFLog = new File(String.valueOf(workingDir) + "evalF.log");
        EvalF.staticEvalF(testFile, parsedFile, evalF, evalFLog, true);
    }

    public static void bigParsing() throws Exception {
        String workingDir = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/parsing/BigGrammar1000L1_SemTagOff/";
        File testFileClean = new File(String.valueOf(workingDir) + "wsj-22_clean.mrg");
        File trainigFile = new File(String.valueOf(workingDir) + "wsj-02-21_TOP_semTagOff.mrg");
        File kernelFragmentFile = new File(String.valueOf(workingDir) + "fragments_MUB_freq_all_semTagOff.txt");
        File cfgRulesFile = new File(String.valueOf(workingDir) + "cfgRules_semTagOff.txt");
        File kernelCfgFile = new File(String.valueOf(workingDir) + "fragments_CFG_all.txt");
        File parsedFile = ParseWSJprobNew.buildAndParse(workingDir, testFileClean, kernelCfgFile);
        File evalF = new File(String.valueOf(workingDir) + "1Best_evalF_semTag.txt");
        EvalF.REMOVE_SEMANTIC_TAGS = false;
        EvalF.staticEvalF(testFileClean, parsedFile, evalF, true);
    }

    public static void cfgParsing() throws Exception {
        int nBest = 1000;
        String workingDir = String.valueOf(Parameters.resultsPath) + "TSG/CFG/Nbest/";
        File trainigFile = new File(String.valueOf(workingDir) + "wsj-02-21_TOP.mrg");
        ArrayList<TSNodeLabel> corpus = TSNodeLabel.getTreebank(trainigFile);
        File testFile = new File(String.valueOf(workingDir) + "wsj-22.mrg");
        File cfgRulesFile = new File(String.valueOf(workingDir) + "wsj-02-21_TOP_CFG_RULES.txt");
        File parsedFile = ParseWSJprobNew.buildAndParseUniqueGrammar(workingDir, testFile, cfgRulesFile, nBest);
        File evalF = new File(String.valueOf(workingDir) + "evalF.txt");
        File evalFLog = new File(String.valueOf(workingDir) + "evalF.log");
        EvalF.staticEvalF(testFile, parsedFile, evalF, evalFLog, true);
    }

    public static void cleanSlashInFile(File inputFile, File outputFile) {
        Scanner scan = FileUtil.getScanner(inputFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            pw.println(line.replaceAll("\\\\", ""));
        }
        scan.close();
        pw.close();
    }

    public static void makeBestOnly() throws Exception {
        String workingDir = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/parsing/BigGrammar1000L1_SemTagOff/";
        File goldFileClean = new File(String.valueOf(workingDir) + "wsj-22_clean.mrg");
        File parsedFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED.txt");
        File bestFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED_BEST.txt");
        ParseWSJprobNew.posprocessNbest(parsedFile, bestFile);
        File evalF = new File(String.valueOf(workingDir) + "Best_evalF_semTagOff.txt");
        EvalF.staticEvalF(goldFileClean, bestFile, evalF, true);
    }

    public static void postProcessOnly() throws Exception {
        String workingDir = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/parsing/BigGrammar1000L1_SemTagOff/";
        File output = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED.txt");
        PrintWriter pw = FileUtil.getPrintWriter(output);
        workingDir = String.valueOf(workingDir) + "bitparOutput/";
        int i = 1;
        while (i <= 1700) {
            String numberPad = Utility.padZero(4, i);
            String dir = "Sentence" + numberPad + "/";
            File inputFile = new File(String.valueOf(workingDir) + dir + "sentence_" + numberPad + "_bitParOut_postprocessed.txt");
            Scanner scan = FileUtil.getScanner(inputFile);
            while (scan.hasNextLine()) {
                pw.println(scan.nextLine());
            }
            ++i;
        }
        pw.close();
    }

    public static void main(String[] args) throws Exception {
        ParseWSJprobNew.makeBestOnly();
    }
}

