/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.util.ArrayList;
import tsg.corpora.ConstCorpus;
import tsg.parser.CacheManager;
import tsg.parser.Cell;
import tsg.parser.DerivationForest;
import tsg.parser.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CKYChart {
    static Grammar grammar;
    static CacheManager cache;
    Cell[][] chart;
    ArrayList<Integer> sentenceIndexes;
    int length;

    public CKYChart(ArrayList<Integer> sentenceIndexes) {
        this.sentenceIndexes = sentenceIndexes;
        this.length = sentenceIndexes.size();
        this.chart = new Cell[this.sentenceIndexes.size()][this.sentenceIndexes.size()];
        this.buildChart();
    }

    private void buildChart() {
        int w = 0;
        while (w < this.length) {
            this.chart[w][w] = new Cell(this.sentenceIndexes.get(w));
            this.chart[w][w].updateUnaryOld();
            ++w;
        }
        int span = 2;
        while (span <= this.length) {
            int start = 0;
            while (start <= this.length - span) {
                int end = start + span;
                ArrayList<Integer> subString = new ArrayList<Integer>(this.sentenceIndexes.subList(start, end));
                int cacheInquire = cache.inquire(subString);
                if (cacheInquire < 1) {
                    Cell newCell = new Cell(subString);
                    int split = start;
                    while (split < end - 1) {
                        newCell.updateBinary(this.chart[start][split], this.chart[split + 1][end - 1], split - start);
                        ++split;
                    }
                    newCell.updateUnaryOld();
                    this.chart[start][end - 1] = newCell;
                    if (cacheInquire == -1) {
                        cache.writeToCache(newCell);
                    }
                } else {
                    this.chart[start][end - 1] = cache.readFromCache(subString);
                }
                ++start;
            }
            ++span;
        }
    }

    private String getDerivation(int yIndex, int xIndex, int root, int rootDerivationIndex, double[] checkProb) {
        Cell cell = this.chart[yIndex][xIndex];
        DerivationForest rootForest = cell.DerivationForestSet.get(root);
        int[] derivationIndexes = rootForest.derivations[rootDerivationIndex];
        if (derivationIndexes[1] == -1) {
            checkProb[0] = checkProb[0] + grammar.getLexLogProb(root, cell.yield.get(0));
            return "(" + CKYChart.grammar.catArray[root] + " " + CKYChart.grammar.lexArray[cell.yield.get(0)] + ")";
        }
        int split = derivationIndexes[0];
        int leftCellIndexY = yIndex;
        int leftCellIndexX = split + yIndex;
        int upCellIndexX = xIndex;
        int upCellIndexY = yIndex + split + 1;
        if (split == -1) {
            checkProb[0] = checkProb[0] + grammar.getUnaryLogProb(root, derivationIndexes[1]);
            return "(" + CKYChart.grammar.catArray[root] + " " + this.getDerivation(yIndex, xIndex, derivationIndexes[1], derivationIndexes[2], checkProb) + ")";
        }
        checkProb[0] = checkProb[0] + grammar.getBinaryLogProb(root, derivationIndexes[1], derivationIndexes[3]);
        return "(" + CKYChart.grammar.catArray[root] + " " + this.getDerivation(leftCellIndexY, leftCellIndexX, derivationIndexes[1], derivationIndexes[2], checkProb) + this.getDerivation(upCellIndexY, upCellIndexX, derivationIndexes[3], derivationIndexes[4], checkProb) + ")";
    }

    public String outputBestNDerivation() {
        String result = "";
        Cell cornerCell = this.chart[0][this.chart.length - 1];
        Integer topIndex = CKYChart.grammar.catIndex.get(ConstCorpus.topTag);
        DerivationForest topForest = cornerCell.DerivationForestSet.get(topIndex);
        if (topForest == null) {
            return "No parse for: \"" + cornerCell.getYieldInWord() + "\"\n\n";
        }
        result = String.valueOf(result) + "InsideProb: " + Math.exp(topForest.logInsideProb) + "\n";
        int i = 0;
        while (i < topForest.derivations.length) {
            result = String.valueOf(result) + "vitprob=" + Math.exp(topForest.derivationLogProb[i]) + "\n";
            double[] checkProb = new double[]{0.0};
            result = String.valueOf(result) + this.getDerivation(0, this.chart.length - 1, topIndex, i, checkProb) + "\n";
            double error = Math.abs(checkProb[0] - topForest.derivationLogProb[i]);
            if (error > 1.0E-7) {
                System.out.println("Prob error! " + error);
            }
            ++i;
        }
        result = String.valueOf(result) + "\n";
        return result;
    }
}

