/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.util.ArrayList;
import tsg.TSNodeLabel;
import util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllOrderedNodeExactSubsequence {
    Cell[][] cellMatrix;
    TSNodeLabel[] a1;
    TSNodeLabel[] a2;
    int xMax;
    int yMax;
    int xLength;
    int yLength;
    int lengthToMatch;
    int totalMatched;

    public AllOrderedNodeExactSubsequence(TSNodeLabel[] a1, TSNodeLabel[] a2) {
        this.a1 = a1;
        this.a2 = a2;
        this.xLength = a1.length + 1;
        this.yLength = a2.length + 1;
        this.lengthToMatch = a2.length;
        this.xMax = a1.length;
        this.yMax = a2.length;
        this.cellMatrix = new Cell[this.xLength][this.yLength];
        int x = 0;
        while (x < this.xLength) {
            this.cellMatrix[x][0] = new Cell(x - 1, -1, false);
            ++x;
        }
        int y = 0;
        while (y < this.yLength) {
            this.cellMatrix[0][y] = new Cell(-1, y - 1, false);
            ++y;
        }
        x = 1;
        while (x < this.xLength) {
            int y2 = 1;
            while (y2 < this.yLength) {
                this.cellMatrix[x][y2] = new Cell(x - 1, y2 - 1, AllOrderedNodeExactSubsequence.areEqual(a1[x - 1], a2[y2 - 1]));
                ++y2;
            }
            ++x;
        }
    }

    public static boolean areEqual(TSNodeLabel a, TSNodeLabel b) {
        return a.sameLabel(b);
    }

    public static ArrayList<ArrayList<Pair<TSNodeLabel>>> getallExactSubsequences(TSNodeLabel[] t1, TSNodeLabel[] t2) {
        if (t1.length < t2.length) {
            return null;
        }
        AllOrderedNodeExactSubsequence O = new AllOrderedNodeExactSubsequence(t1, t2);
        return O.getExactSubsequences();
    }

    public ArrayList<ArrayList<Pair<TSNodeLabel>>> getExactSubsequences() {
        Cell c;
        if (this.totalMatched < this.lengthToMatch) {
            return null;
        }
        int firstindexXmatchFirstY = -1;
        int lastIndexXmatchLastY = -1;
        int x = 1;
        while (x < this.xLength) {
            if (this.cellMatrix[x][1].match) {
                firstindexXmatchFirstY = x;
                break;
            }
            ++x;
        }
        x = this.xMax;
        while (x >= this.yMax) {
            if (this.cellMatrix[x][this.yMax].match) {
                lastIndexXmatchLastY = x;
                break;
            }
            --x;
        }
        if (lastIndexXmatchLastY - firstindexXmatchFirstY + 1 < this.lengthToMatch) {
            return null;
        }
        boolean previousReachable = false;
        int x2 = 1;
        while (x2 < this.xLength) {
            Cell c2 = this.cellMatrix[x2][1];
            if (c2.match) {
                c2.maxSequenceLength = 1;
                previousReachable = true;
            } else if (previousReachable) {
                c2.leftReachable = true;
                c2.maxSequenceLength = 1;
                previousReachable = true;
            }
            ++x2;
        }
        int y = 2;
        while (y < this.yLength) {
            int x3 = 1;
            while (x3 < this.xLength) {
                int maxSL;
                c = this.cellMatrix[x3][y];
                Cell cl = this.cellMatrix[x3 - 1][y];
                int maxSequenceLenghtFromL = cl.maxSequenceLength;
                int maxSequenceLenghtFromD = 0;
                if (c.match) {
                    Cell cd = this.cellMatrix[x3 - 1][y - 1];
                    maxSequenceLenghtFromD = cd.maxSequenceLength + 1;
                }
                if ((maxSL = Math.max(maxSequenceLenghtFromL, maxSequenceLenghtFromD)) != 0) {
                    c.maxSequenceLength = maxSL;
                    if (maxSequenceLenghtFromL == maxSL) {
                        c.leftReachable = true;
                    }
                    if (maxSequenceLenghtFromD == maxSL) {
                        c.diagonalReachable = true;
                    }
                }
                ++x3;
            }
            ++y;
        }
        ArrayList<ArrayList<Pair<TSNodeLabel>>> result = new ArrayList<ArrayList<Pair<TSNodeLabel>>>();
        int x4 = 1;
        while (x4 < this.xLength) {
            c = this.cellMatrix[x4][this.yMax];
            if (c.match && c.maxSequenceLength == this.lengthToMatch) {
                c.leftReachable = false;
                c.addAllSubSequences(new ArrayList<Pair<TSNodeLabel>>(), result);
            }
            ++x4;
        }
        return result;
    }

    public static void main(String[] args) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Cell {
        int x;
        int y;
        boolean match;
        boolean leftReachable;
        boolean diagonalReachable;
        int maxSequenceLength;

        protected Cell(int x, int y, boolean match) {
            this.x = x;
            this.y = y;
            if (match) {
                this.match = true;
                ++AllOrderedNodeExactSubsequence.this.totalMatched;
            }
        }

        public void addAllSubSequences(ArrayList<Pair<TSNodeLabel>> currentThread, ArrayList<ArrayList<Pair<TSNodeLabel>>> result) {
            if (this.leftReachable) {
                if (this.diagonalReachable) {
                    ArrayList<Pair<TSNodeLabel>> newThread = new ArrayList<Pair<TSNodeLabel>>(currentThread);
                    AllOrderedNodeExactSubsequence.this.cellMatrix[this.x][this.y + 1].addAllSubSequences(newThread, result);
                } else {
                    AllOrderedNodeExactSubsequence.this.cellMatrix[this.x][this.y + 1].addAllSubSequences(currentThread, result);
                }
            }
            if (this.match) {
                currentThread.add(0, new Pair<TSNodeLabel>(AllOrderedNodeExactSubsequence.this.a1[this.x], AllOrderedNodeExactSubsequence.this.a2[this.y]));
                if (this.y == 0) {
                    result.add(currentThread);
                    return;
                }
            }
            if (this.diagonalReachable) {
                AllOrderedNodeExactSubsequence.this.cellMatrix[this.x][this.y].addAllSubSequences(currentThread, result);
            }
        }
    }
}

