/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Scanner;
import tsg.TSNodeLabelIndex;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.PrintProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSNodeLabelStructure {
    public TSNodeLabelIndex[] structure;
    int length;

    public TSNodeLabelStructure(String s) throws Exception {
        this.structure = new TSNodeLabelIndex(s).collectAllNodesInArray();
        this.length = this.structure.length;
    }

    public TSNodeLabelStructure(TSNodeLabelIndex t) {
        this.structure = t.collectAllNodesInArray();
        this.length = this.structure.length;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        int i = 0;
        while (i < this.length) {
            result.append(this.structure[i].label());
            if (i != this.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public int length() {
        return this.length;
    }

    private int lexiconLength() {
        int result = 0;
        TSNodeLabelIndex[] tSNodeLabelIndexArray = this.structure;
        int n = this.structure.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex n3 = tSNodeLabelIndexArray[n2];
            if (n3.isLexical) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public TSNodeLabelIndex[] structure() {
        return this.structure;
    }

    public int hashCode() {
        return this.structure[0].hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TSNodeLabelStructure) {
            TSNodeLabelStructure anOtherNodeStructure = (TSNodeLabelStructure)o;
            if (this.structure.length != anOtherNodeStructure.structure.length) {
                return false;
            }
            return this.structure[0].equals(anOtherNodeStructure.structure[0]);
        }
        return false;
    }

    public static ArrayList<TSNodeLabelStructure> readTreebank(File inputFile) throws Exception {
        return TSNodeLabelStructure.readTreebank(inputFile, FileUtil.defaultEncoding, Integer.MAX_VALUE);
    }

    public static ArrayList<TSNodeLabelStructure> readTreebank(File inputFile, String encoding, int LL) throws Exception {
        ArrayList<TSNodeLabelStructure> result = new ArrayList<TSNodeLabelStructure>();
        Scanner scan = FileUtil.getScanner(inputFile, encoding);
        PrintProgress.start("Reading Treebank: ");
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            PrintProgress.next();
            TSNodeLabelStructure lineStructure = new TSNodeLabelStructure(line);
            if (lineStructure.lexiconLength() > LL) continue;
            result.add(lineStructure);
        }
        PrintProgress.end();
        return result;
    }

    public static void removeSemanticTagInTreebank(ArrayList<TSNodeLabelStructure> treebank) {
        for (TSNodeLabelStructure t : treebank) {
            t.structure[0].removeSemanticTags();
        }
    }

    public static void makeTreebakWithNoDoubles(File inputFile, String encoding, File outputFile) throws Exception {
        LinkedHashSet<TSNodeLabelStructure> treebank = new LinkedHashSet<TSNodeLabelStructure>();
        Scanner scan = FileUtil.getScanner(inputFile, encoding);
        PrintProgress.start("Reading Treebank: ");
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            PrintProgress.next();
            TSNodeLabelStructure lineStructure = new TSNodeLabelStructure(line);
            treebank.add(lineStructure);
        }
        PrintProgress.end();
        PrintProgress.start("Writing Treebank: ");
        PrintWriter pw = FileUtil.getPrintWriter(outputFile, encoding);
        for (TSNodeLabelStructure t : treebank) {
            PrintProgress.next();
            pw.println(t.structure[0]);
        }
        PrintProgress.end();
        pw.close();
    }

    public static void findEqualStructures(ArrayList<TSNodeLabelStructure> treebank, File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        int t1Index = -1;
        BitSet foundIndexes = new BitSet(treebank.size());
        for (TSNodeLabelStructure t1 : treebank) {
            if (foundIndexes.get(++t1Index)) continue;
            ListIterator<TSNodeLabelStructure> i2 = treebank.listIterator(t1Index + 1);
            ArrayList<Integer> equals = new ArrayList<Integer>();
            int t2Index = t1Index;
            while (i2.hasNext()) {
                ++t2Index;
                TSNodeLabelStructure t2 = i2.next();
                if (!t1.structure[0].equals(t2.structure[0])) continue;
                equals.add(t2Index);
                foundIndexes.set(t2Index);
            }
            if (equals.isEmpty()) continue;
            pw.println(String.valueOf(t1Index) + ": " + equals);
            pw.println(t1.structure[0]);
            pw.println();
        }
        pw.close();
    }

    public static int maxDepthTreebank(ArrayList<TSNodeLabelStructure> treebank) {
        int maxDepth = -1;
        for (TSNodeLabelStructure t : treebank) {
            int depth = t.structure[0].maxDepth();
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    public static void main(String[] args) throws Exception {
        File inputFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21.mrg");
        File outputFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21_noDoubles.mrg");
        TSNodeLabelStructure.makeTreebakWithNoDoubles(inputFile, FileUtil.defaultEncoding, outputFile);
    }
}

