/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.ArrayList;
import java.util.BitSet;
import tsg.ParenthesesBlockPenn;
import tsg.TSNodeLabel;

public class TSNodeLabelIndex
extends TSNodeLabel {
    public int index;

    public TSNodeLabelIndex(String s) throws Exception {
        this(s, true);
        this.setIndexRecursive(new int[1]);
    }

    public TSNodeLabelIndex(String s, boolean allTerminalsAreLeaves) throws Exception {
        this(ParenthesesBlockPenn.getParenthesesBlocks(s), allTerminalsAreLeaves);
        this.setIndexRecursive(new int[1]);
    }

    public TSNodeLabelIndex(TSNodeLabel t) throws Exception {
        this(t, new int[1]);
    }

    public TSNodeLabelIndex(TSNodeLabel t, int[] index) {
        this.label = t.label;
        this.headMarked = t.headMarked;
        this.isLexical = t.isLexical;
        int n = index[0];
        index[0] = n + 1;
        this.index = n;
        if (t.isTerminal()) {
            return;
        }
        int prole = t.prole();
        this.daughters = new TSNodeLabelIndex[prole];
        int i = 0;
        while (i < prole) {
            TSNodeLabel d = t.daughters[i];
            this.daughters[i] = new TSNodeLabelIndex(d, index);
            ++i;
        }
    }

    private TSNodeLabelIndex(ParenthesesBlockPenn p, boolean allTerminalsAreLeaves) {
        if (p.isTerminal()) {
            this.acquireTerminalLabel(p, allTerminalsAreLeaves);
        } else {
            this.acquireNonTerminalLabel(p);
            this.daughters = new TSNodeLabelIndex[p.subBlocks.size()];
            int i = 0;
            for (ParenthesesBlockPenn pd : p.subBlocks) {
                this.daughters[i] = new TSNodeLabelIndex(pd, allTerminalsAreLeaves);
                this.daughters[i].parent = this;
                ++i;
            }
        }
    }

    private void setIndexRecursive(int[] index) {
        int n = index[0];
        index[0] = n + 1;
        this.index = n;
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n2 = this.daughters.length;
        int n3 = 0;
        while (n3 < n2) {
            TSNodeLabel t = tSNodeLabelArray[n3];
            ((TSNodeLabelIndex)t).setIndexRecursive(index);
            ++n3;
        }
    }

    public TSNodeLabelIndex[] collectAllNodesInArray() {
        TSNodeLabelIndex[] result = new TSNodeLabelIndex[this.countAllNodes()];
        this.putInArrayRecursive(result);
        return result;
    }

    private void putInArrayRecursive(TSNodeLabelIndex[] array) {
        array[this.index] = this;
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            ((TSNodeLabelIndex)TN).putInArrayRecursive(array);
            ++n2;
        }
    }

    public boolean sameLabel(TSNodeLabel nodeB) {
        return this.label.equals(nodeB.label);
    }

    public boolean sameDaughtersLabel(TSNodeLabel nodeB) {
        if (this.daughters.length != nodeB.daughters.length) {
            return false;
        }
        int i = 0;
        while (i < this.daughters.length) {
            if (!this.daughters[i].sameLabel(nodeB.daughters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TSNodeLabel getSubTree(BitSet bs) {
        TSNodeLabel result = this.nonRecursiveCopy();
        if (this.isTerminal()) {
            return result;
        }
        TSNodeLabelIndex firstDaughter = (TSNodeLabelIndex)this.daughters[0];
        if (bs.get(firstDaughter.index)) {
            result.daughters = new TSNodeLabel[this.daughters.length];
            int i = 0;
            while (i < this.daughters.length) {
                TSNodeLabel d = ((TSNodeLabelIndex)this.daughters[i]).getSubTree(bs);
                d.parent = result;
                result.daughters[i] = d;
                ++i;
            }
        }
        return result;
    }

    public TSNodeLabel getSubBranch(BitSet bs) {
        TSNodeLabel result = this.nonRecursiveCopy();
        if (this.isTerminal()) {
            return result;
        }
        int selectedDaughtersNumber = 0;
        int prole = this.prole();
        ArrayList<TSNodeLabel> selectedDaughter = new ArrayList<TSNodeLabel>(prole);
        int i = 0;
        while (i < prole) {
            TSNodeLabelIndex d = (TSNodeLabelIndex)this.daughters[i];
            if (bs.get(d.index)) {
                TSNodeLabel dNew = d.getSubBranch(bs);
                dNew.parent = result;
                selectedDaughter.add(dNew);
                ++selectedDaughtersNumber;
            }
            ++i;
        }
        if (selectedDaughtersNumber > 0) {
            result.daughters = selectedDaughter.toArray(new TSNodeLabel[selectedDaughtersNumber]);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String p = "(S (NP-SBJ (NP (NNP-H Pierre) (NNP Vinken) ) (, ,) (ADJP (NP-H (CD 61) (NNS years) ) (JJ old) ) (, ,) ) (VP (MD will) (VP (VB join) (NP (DT the) (NN board) ) (PP-CLR (IN as) (NP (DT a) (JJ nonexecutive) (NN director) )) (NP-TMP (NNP Nov.) (CD 29) ))) (. .) )";
        TSNodeLabelIndex t = new TSNodeLabelIndex(p);
        System.out.println(p);
        System.out.println(t);
    }
}

