/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.Hashtable;
import java.util.Vector;

public class Label {
    protected static Hashtable<String, Integer> IDtableLabel = new Hashtable();
    protected static Vector<String> IDtableReverseLabel = new Vector();
    protected static Vector<Label> labelVector = new Vector();
    protected static int labelCounter;
    public int id;

    public static int getLabelCounter() {
        return labelCounter;
    }

    public Label(String label) {
        Integer storedId = IDtableLabel.get(label);
        if (storedId == null) {
            storedId = labelCounter++;
            IDtableLabel.put(label, storedId);
            IDtableReverseLabel.add(label);
            labelVector.add(this);
        }
        this.id = storedId;
    }

    public void relabel(String newLabel) {
        Integer storedId = IDtableLabel.get(newLabel);
        if (storedId == null) {
            storedId = labelCounter++;
            IDtableLabel.put(newLabel, storedId);
            IDtableReverseLabel.add(newLabel);
            labelVector.add(this);
        }
        this.id = storedId;
    }

    public String toString() {
        return IDtableReverseLabel.get(this.id);
    }

    public String toStringWithoutSemTags() {
        String labelString = this.toString();
        int dash_index = labelString.indexOf(45);
        if (dash_index > 0) {
            return labelString.substring(0, dash_index);
        }
        return labelString;
    }

    public Label getLabelWithoutSemTags() {
        String labelString = this.toString();
        int dashIndex = labelString.indexOf(45);
        if (dashIndex == -1) {
            return this;
        }
        return new Label(labelString.substring(0, dashIndex));
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Label) {
            Label anotherLabel = (Label)anObject;
            return this.id == anotherLabel.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Label anotherLabel) {
        return this.id == anotherLabel.id;
    }
}

