/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import settings.Parameters;
import tsg.CFSG;
import tsg.TSNode;
import tsg.TreeAnalizer;
import tsg.corpora.ConstCorpus;
import util.FileUtil;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LTSG
extends CFSG<Integer> {
    Hashtable<String, Integer> template_freq = new Hashtable();
    Hashtable<String, Integer> lexicon_freq = new Hashtable();

    public void readTreesFromFile(File templateFile) {
        this.template_freq.clear();
        this.lexicon_freq.clear();
        Scanner scan = FileUtil.getScanner(templateFile);
        while (scan.hasNextLine()) {
            Integer freq = scan.nextInt();
            String tree = scan.nextLine().trim();
            this.template_freq.put(tree, freq);
            Utility.increaseStringInteger(this.lexicon_freq, TSNode.get_unique_lexicon(tree), freq);
        }
    }

    public void readTreesFromCorpus() {
        this.readTreesFromCorpus(false);
    }

    public void readTreesFromCorpus(boolean applySpineConversion) {
        Parameters.trainingCorpus.correctHeadAnnotation();
        this.template_freq.clear();
        this.lexicon_freq.clear();
        for (TSNode TreeLine : Parameters.trainingCorpus.treeBank) {
            List<TSNode> trees = TreeLine.lexicalizedTreesFromHeadAnnotation();
            for (TSNode LT : trees) {
                if (applySpineConversion) {
                    LT.convertToSpine();
                }
                TSNode lexAnchor = LT.getAnchor();
                Utility.increaseStringInteger(this.template_freq, LT.toString(false, true), 1);
                Utility.increaseStringInteger(this.lexicon_freq, lexAnchor.label(), 1);
            }
        }
        String log = "Read trees from corups. # Trees: " + this.template_freq.size();
        FileUtil.append(log, Parameters.logFile);
    }

    public void treatTreeBank() {
        this.entropy();
        if (Parameters.delexicalize) {
            this.delexicalize();
        }
        if (Parameters.cutTopRecursion) {
            this.cutTopRecursion();
        }
    }

    public void delexicalize() {
        Hashtable new_template_freq = new Hashtable();
        Enumeration<String> e = this.template_freq.keys();
        while (e.hasMoreElements()) {
            String template = e.nextElement();
            Integer count = this.template_freq.get(template);
            TSNode TN = new TSNode(template, false);
            if (TN.isPrelexical()) {
                template = TN.toString(false, true);
                Utility.increaseStringInteger(new_template_freq, template, count);
                continue;
            }
            String[] delexTree_lexProd = TN.splitUniqueLexProduction();
            Utility.increaseStringInteger(new_template_freq, delexTree_lexProd[0], count);
            Utility.increaseStringInteger(new_template_freq, delexTree_lexProd[1], count);
        }
        this.template_freq = new_template_freq;
        FileUtil.append("Delexicalized trees", Parameters.logFile);
    }

    public void cutTopRecursion() {
        PrintWriter cutTreePW = FileUtil.getPrintWriter(new File(String.valueOf(Parameters.outputPath) + "cutTopTrees"));
        Hashtable new_template_freq = new Hashtable();
        int cutRecursionCounter = 0;
        Enumeration<String> e = this.template_freq.keys();
        while (e.hasMoreElements()) {
            String template = e.nextElement();
            Integer count = this.template_freq.get(template);
            TSNode TN = new TSNode(template, false);
            TSNode[] split = TN.cutRecursiveOld();
            if (split != null) {
                ++cutRecursionCounter;
                cutTreePW.println(TN.toString(false, true));
                TSNode[] tSNodeArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    TSNode TN_split = tSNodeArray[n2];
                    cutTreePW.println(TN_split.toString(false, true));
                    Utility.increaseStringInteger(new_template_freq, TN_split.toString(false, true), count);
                    ++n2;
                }
                cutTreePW.println();
                continue;
            }
            Utility.increaseStringInteger(new_template_freq, template, count);
        }
        cutTreePW.close();
        String log = "Cutted top recursion in trees (" + cutRecursionCounter + "trees cutted)";
        if (Parameters.cutTopRecursion) {
            FileUtil.append(log, Parameters.logFile);
        }
        this.template_freq = new_template_freq;
    }

    public void removeTrees() {
        FileUtil.append("REMOVING TREES occuring <= " + Parameters.removeTreesLimit, Parameters.logFile);
        Enumeration<String> e = this.template_freq.keys();
        while (e.hasMoreElements()) {
            String template = e.nextElement();
            String lex = TSNode.get_unique_lexicon(template);
            Integer count = this.template_freq.get(template);
            if (count > Parameters.removeTreesLimit) continue;
            this.template_freq.remove(template);
            Utility.decreaseStringInteger(this.lexicon_freq, lex, count);
        }
        String log = "# Trees after removing trees occuring <= " + Parameters.removeTreesLimit + " : " + this.template_freq.size();
        FileUtil.append(log, Parameters.logFile);
    }

    public void toPCFG() {
        this.lexRules.clear();
        this.internalRules.clear();
        int uniqueLableIndex = 1;
        Enumeration<String> e = this.template_freq.keys();
        while (e.hasMoreElements()) {
            String eTree = e.nextElement();
            Integer count = this.template_freq.get(eTree);
            TSNode TN = new TSNode(eTree, false);
            TN.toNormalForm();
            uniqueLableIndex = TN.toUniqueInternalLabels(false, uniqueLableIndex, false);
            List<TSNode> nonTerminals = TN.collectNonTerminalNodes();
            for (TSNode nonTerminal : nonTerminals) {
                Hashtable toAdd;
                String rule = nonTerminal.toCFG(false);
                Hashtable hashtable = toAdd = nonTerminal.isPrelexical() ? this.lexRules : this.internalRules;
                if (count > Parameters.removeTreesLimit) {
                    Utility.increaseStringInteger(toAdd, rule, count * Parameters.smoothingFactor);
                }
                if (!Parameters.smoothing) continue;
                rule = rule.replaceAll("@\\d+", "");
                Utility.increaseStringInteger(toAdd, rule, 1);
            }
        }
        String log = "Converted trees to PCFG (smoothing = " + Parameters.smoothing + ")" + "\n\t# Internal Rules: " + this.internalRules.size() + "\n\t# Lex Rules: " + this.lexRules.size();
        FileUtil.append(log, Parameters.logFile);
    }

    public double entropy() {
        double entropy = 0.0;
        Enumeration<String> e = this.template_freq.keys();
        while (e.hasMoreElements()) {
            String template = e.nextElement();
            entropy += LTSG.entropy(template, this.template_freq, this.lexicon_freq);
        }
        FileUtil.append("Entropy of the extracted trees:" + -entropy, Parameters.logFile);
        return -entropy;
    }

    public static double entropy(String template, Hashtable<String, Integer> template_freq, Hashtable<String, Integer> lexicon_freq) {
        String lex = TSNode.get_unique_lexicon(template);
        double tree_freq = template_freq.get(template).intValue();
        double lex_freq = lexicon_freq.get(lex).intValue();
        double prob = tree_freq / lex_freq;
        return Utility.pLogp(prob);
    }

    public static double entropy(Hashtable<String, Integer> template_freq, Hashtable<String, Integer> lexicon_freq) {
        double entropy = 0.0;
        Enumeration<String> e = template_freq.keys();
        while (e.hasMoreElements()) {
            String template = e.nextElement();
            entropy += LTSG.entropy(template, template_freq, lexicon_freq);
        }
        return -entropy;
    }

    public static double filteredEntropyGreedy(String template, Hashtable<String, Integer> template_freq) {
        Hashtable<String, Integer> filtered_template_freq = new Hashtable<String, Integer>();
        Hashtable<String, Integer> filtered_lexicon_freq = new Hashtable<String, Integer>();
        String template_root = TSNode.get_unique_root(template);
        String template_lex = TSNode.get_unique_lexicon(template);
        Enumeration<String> e = template_freq.keys();
        while (e.hasMoreElements()) {
            String tree = e.nextElement();
            String tree_root = TSNode.get_unique_root(tree);
            String tree_lex = TSNode.get_unique_lexicon(tree);
            if (!tree_root.equals(template_root) || !tree_lex.equals(template_lex)) continue;
            Integer count = template_freq.get(tree);
            filtered_template_freq.put(tree, count);
            Utility.increaseStringInteger(filtered_lexicon_freq, tree_lex, count);
        }
        return LTSG.entropy(filtered_template_freq, filtered_lexicon_freq);
    }

    public void extractAllLexTrees() {
        Parameters.trainingCorpus.removeHeadAnnotations();
        for (TSNode inputTree : Parameters.trainingCorpus.treeBank) {
            this.increaseElementaryTreeesFrom(inputTree);
        }
        String log = "Extracted all possible lexicalized trees\n\t# Trees: " + this.template_freq.size();
        FileUtil.append(log, Parameters.logFile);
    }

    public void printElementaryTreeStatistics(int[] treeIndex) {
        int[] nArray = treeIndex;
        int n = treeIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TSNode inputTree = Parameters.trainingCorpus.treeBank.get(index);
            List<TSNode> lexicon = inputTree.collectLexicalItems();
            List<ArrayList<TSNode>> eTrees = LTSG.allLexTreesForEachAnchor(inputTree, Parameters.spineConversion, lexicon);
            int terminalIndex = 0;
            for (ArrayList<TSNode> terminalTrees : eTrees) {
                String lexAnchor = lexicon.get(terminalIndex).label();
                System.out.println(String.valueOf(lexAnchor) + " : " + this.lexicon_freq.get(lexAnchor));
                for (TSNode lexTree : terminalTrees) {
                    String treeString = lexTree.toString(false, true);
                    System.out.println("\t" + treeString + " : " + this.template_freq.get(treeString));
                }
                ++terminalIndex;
            }
            ++n2;
        }
        System.out.print("\n\n");
    }

    protected void decreaseElementayTreesFrom(TSNode inputTree) {
        List<TSNode> lexicon = inputTree.collectLexicalItems();
        List<ArrayList<TSNode>> eTrees = LTSG.allLexTreesForEachAnchor(inputTree, Parameters.spineConversion, lexicon);
        int terminalIndex = 0;
        for (ArrayList<TSNode> terminalTrees : eTrees) {
            String lexAnchor = lexicon.get(terminalIndex).label();
            for (TSNode lexTree : terminalTrees) {
                Utility.decreaseStringInteger(this.template_freq, lexTree.toString(false, true), 1);
                Utility.decreaseStringInteger(this.lexicon_freq, lexAnchor, 1);
            }
            ++terminalIndex;
        }
    }

    protected void increaseElementaryTreeesFrom(TSNode inputTree) {
        List<TSNode> lexicon = inputTree.collectLexicalItems();
        List<ArrayList<TSNode>> eTrees = this.allLexTreesForEachAnchor(inputTree, lexicon);
        int terminalIndex = 0;
        for (ArrayList<TSNode> terminalTrees : eTrees) {
            String lexAnchor = lexicon.get(terminalIndex).label();
            for (TSNode lexTree : terminalTrees) {
                Utility.increaseStringInteger(this.template_freq, lexTree.toString(false, true), 1);
                Utility.increaseStringInteger(this.lexicon_freq, lexAnchor, 1);
            }
            ++terminalIndex;
        }
    }

    protected static List<ArrayList<TSNode>> allLexTreesForEachAnchor(TSNode tree, boolean spineConvertion, List<TSNode> anchors) {
        ArrayList<ArrayList<TSNode>> result = new ArrayList<ArrayList<TSNode>>(anchors.size());
        for (TSNode lex : anchors) {
            ArrayList<TSNode> result_i = new ArrayList<TSNode>();
            result.add(result_i);
            tree.markHeadPathToAnchor(lex);
            TSNode ET = new TSNode(tree);
            tree.unmarkHeadPathToAnchor(lex);
            ET.toLexicalizeFrame();
            if (spineConvertion) {
                ET.convertToSpine();
            }
            result_i.add(ET);
            do {
                ET = ET.getHeadDaughter();
                result_i.add(ET);
            } while (!ET.isPrelexical());
        }
        return result;
    }

    protected List<ArrayList<TSNode>> allLexTreesForEachAnchor(TSNode tree, List<TSNode> anchors) {
        ArrayList<ArrayList<TSNode>> result = new ArrayList<ArrayList<TSNode>>(anchors.size());
        for (TSNode lex : anchors) {
            ArrayList<TSNode> result_i = new ArrayList<TSNode>();
            result.add(result_i);
            tree.markHeadPathToAnchor(lex);
            TSNode ET = new TSNode(tree);
            tree.unmarkHeadPathToAnchor(lex);
            ET.toLexicalizeFrame();
            ET.applyAllConversions();
            result_i.add(ET);
            do {
                ET = ET.getHeadDaughter();
                result_i.add(ET);
            } while (!ET.isPrelexical());
        }
        return result;
    }

    public void evaluateTreebankOnSet(ConstCorpus evalSet, int displayPerLex) {
        File evalReport = new File(String.valueOf(Parameters.outputPath) + "EvalReport");
        TreeAnalizer analizer = new TreeAnalizer(this.template_freq);
        try {
            PrintWriter output = new PrintWriter(new BufferedWriter(new FileWriter(evalReport)));
            ListIterator<TSNode> i = evalSet.treeBank.listIterator();
            while (i.hasNext()) {
                TSNode evalTree = i.next();
                String line = String.valueOf(evalTree.toString()) + "\n";
                List<TSNode> terminals = evalTree.collectTerminals();
                List<ArrayList<TSNode>> goldTrees = LTSG.allLexTreesForEachAnchor(evalTree, false, terminals);
                int terminalIndex = 0;
                for (ArrayList<TSNode> terminalTree : goldTrees) {
                    TSNode term = terminals.get(terminalIndex);
                    String word = Utility.removeDoubleQuotes(term.label);
                    boolean unknown = this.lexicon_freq.get(word) == null;
                    line = String.valueOf(line) + word + (unknown ? " (unknown)" : "") + "\n";
                    boolean closestFound = false;
                    for (TSNode goldTemplate : terminalTree) {
                        Object[][] closestTrees = analizer.getClosestTrees(goldTemplate.toString(false, true));
                        if (closestTrees == null) continue;
                        closestFound = true;
                        line = String.valueOf(line) + "\t" + goldTemplate + "\n";
                        Hashtable lexiconCount = new Hashtable();
                        int k = 0;
                        while (k < closestTrees[0].length) {
                            String cT = (String)closestTrees[0][k];
                            String lexicalAnchor = TSNode.get_unique_lexicon(cT);
                            Integer count = (Integer)lexiconCount.get(lexicalAnchor);
                            if (count == null || count <= displayPerLex) {
                                String recall_precision = " (" + closestTrees[1][0] + "/" + closestTrees[1][1] + "," + closestTrees[1][0] + "/" + closestTrees[1][2] + ")";
                                line = String.valueOf(line) + "\t\t" + cT + recall_precision + "\n";
                                Utility.increaseStringInteger(lexiconCount, lexicalAnchor, 1);
                            }
                            ++k;
                        }
                    }
                    if (!closestFound) {
                        line = String.valueOf(line) + "\tNo closest tree found";
                    }
                    ++terminalIndex;
                }
                output.write(String.valueOf(line) + "\n");
            }
            output.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
    }

    public void printTemplatesToFile() {
        File templatesFile = new File(String.valueOf(Parameters.outputPath) + "TemplatesFile");
        FileUtil.printHashtableToFile(this.template_freq, templatesFile);
        String log = "Printed templates to file `templatesFile`";
        FileUtil.append(log, Parameters.logFile);
    }
}

