/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelFreq;
import util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertFragmentsToCFGRules {
    public Hashtable<String, ArrayList<TSNodeLabelFreq>> ruleFragmentsTable;
    public Hashtable<String, TSNodeLabelFreq[]> ruleBestFragmentFreq;
    static char lexPosSeparatorChar = (char)94;

    public ConvertFragmentsToCFGRules(File inputFile, File ruleFragmentsAmbiguity) throws Exception {
        this(inputFile, ruleFragmentsAmbiguity, new Hashtable<String, ArrayList<TSNodeLabelFreq>>(), new Hashtable<String, TSNodeLabelFreq[]>());
    }

    public ConvertFragmentsToCFGRules(File inputFile, File ruleFragmentsAmbiguity, Hashtable<String, ArrayList<TSNodeLabelFreq>> ruleFragmentsTable, Hashtable<String, TSNodeLabelFreq[]> ruleBestFragmentFreq) throws Exception {
        this.ruleFragmentsTable = ruleFragmentsTable;
        this.ruleBestFragmentFreq = ruleBestFragmentFreq;
        Scanner scan = FileUtil.getScanner(inputFile);
        while (scan.hasNextLine()) {
            String fragmentLine = scan.nextLine();
            if (fragmentLine.equals("")) continue;
            String[] lineSplit = fragmentLine.split("\t");
            int freq = Integer.parseInt(lineSplit[0]);
            String fragmentString = lineSplit[1];
            TSNodeLabel tree = new TSNodeLabel(fragmentString, false);
            String treeCFGrule = tree.compressToCFGRulePosLex(lexPosSeparatorChar);
            this.add(treeCFGrule, new TSNodeLabelFreq(tree, freq));
        }
        this.printRuleFragmentsAmbiguousToFile(ruleFragmentsAmbiguity);
    }

    public void add(String treeCFGrule, TSNodeLabelFreq treeFreq) {
        ArrayList<TSNodeLabelFreq> value = this.ruleFragmentsTable.get(treeCFGrule);
        if (value == null) {
            value = new ArrayList();
            this.ruleFragmentsTable.put(treeCFGrule, value);
            this.ruleBestFragmentFreq.put(treeCFGrule, new TSNodeLabelFreq[]{treeFreq});
        } else {
            TSNodeLabelFreq[] treeBestFreqSlot = this.ruleBestFragmentFreq.get(treeCFGrule);
            if (treeBestFreqSlot[0].freq() < treeFreq.freq()) {
                treeBestFreqSlot[0] = treeFreq;
            }
        }
        value.add(treeFreq);
    }

    public void printGrammarFile(File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        for (Map.Entry<String, TSNodeLabelFreq[]> e : this.ruleBestFragmentFreq.entrySet()) {
            pw.println(String.valueOf(e.getValue()[0].freq()) + "\t" + e.getKey());
        }
        pw.close();
    }

    public void printRuleBestFragmentMappingFile(File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        for (Map.Entry<String, TSNodeLabelFreq[]> e : this.ruleBestFragmentFreq.entrySet()) {
            pw.println(String.valueOf(e.getKey()) + "\t" + e.getValue()[0].tree().toString(false, true));
        }
        pw.close();
    }

    public Hashtable<String, TSNodeLabel> getRuleBestFragmentMappingTable() {
        Hashtable<String, TSNodeLabel> result = new Hashtable<String, TSNodeLabel>();
        for (Map.Entry<String, TSNodeLabelFreq[]> e : this.ruleBestFragmentFreq.entrySet()) {
            result.put(e.getKey(), e.getValue()[0].tree());
        }
        return result;
    }

    public static Hashtable<String, TSNodeLabel> readRuleBestFragmentMappingFile(File inputFile) throws Exception {
        Hashtable<String, TSNodeLabel> result = new Hashtable<String, TSNodeLabel>();
        Scanner scan = FileUtil.getScanner(inputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            String rule = lineSplit[0];
            TSNodeLabel fragment = new TSNodeLabel(lineSplit[1], false);
            result.put(rule, fragment);
        }
        scan.close();
        return result;
    }

    private void printRuleFragmentsAmbiguousToFile(File output) {
        PrintWriter pwLog = FileUtil.getPrintWriter(output);
        pwLog.println("List of rules mapping to multiple fragments:\n");
        for (Map.Entry<String, ArrayList<TSNodeLabelFreq>> e : this.ruleFragmentsTable.entrySet()) {
            ArrayList<TSNodeLabelFreq> value = e.getValue();
            if (value.size() == 1) continue;
            pwLog.println(e.getKey());
            for (TSNodeLabelFreq fragment : value) {
                pwLog.println("\t" + fragment.toString(false, true));
            }
            pwLog.println();
        }
        pwLog.close();
    }

    public boolean containsRule(String rule) {
        return this.ruleFragmentsTable.containsKey(rule);
    }

    public int ruleSize() {
        return this.ruleFragmentsTable.size();
    }

    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File RuleFragmentsAmbiguousFile = new File(args[2]);
        new ConvertFragmentsToCFGRules(inputFile, RuleFragmentsAmbiguousFile);
    }
}

