theory Simp_Demo
imports Main
begin

text \<open>The simplification example from the slides (with simplifier tracing):\<close>

thm add_0 add_Suc Suc_le_mono le0

lemma "0 + Suc 0 \<le> Suc 0 + x"
  using [[simp_trace]]
  by simp

section \<open>How to simplify\<close>

text \<open>No assumption:\<close>

lemma "ys @ [] = []"
  apply (simp)
  oops (* abandon proof *)

text \<open>Simplification in assumption:\<close>

lemma "\<lbrakk> xs @ zs = ys @ xs; [] @ xs = [] @ [] \<rbrakk> \<Longrightarrow> ys = zs"
  apply (simp)
  done


text \<open>Using additional rules:\<close>

lemma "(a+b)*(a-b) = a*a - b*(b::int)"
  apply (simp add: algebra_simps)
  done


text \<open>Giving a lemma the simp-attribute:\<close>

declare algebra_simps[simp]
(* Or add the simp attribute when stating and proving the lemma *)


subsection "Rewriting with definitions"

definition sq :: "nat \<Rightarrow> nat" where
  "sq n = n*n"

lemma "sq(n*n) = sq(n)*sq(n)"
  apply (simp add: sq_def) (* Definition of function f is called f_def *)
  done

subsection "Case distinctions"

text \<open>Automatic:\<close>

lemma "(A & B) = (if A then B else False)"
  apply (simp)
  done

lemma "if A then B else C"
  apply (simp)
  oops

text \<open>Manual splitting of if-expressions in assumptions:\<close>

lemma "if A then B else False \<Longrightarrow> A \<and> B"
  apply (simp split: if_split_asm)
  done

thm if_splits (* contains both if_split and if_split_asm *)

text \<open>By hand (for case):\<close>

lemma "1 \<le> (case ns of [] \<Rightarrow> 1 | n#_ \<Rightarrow> Suc n)"
  apply (simp split: list.split)
  done

text \<open>Manual case splitting in assumptions:\<close>

lemma "(case ns of [] \<Rightarrow> 1 | n#_ \<Rightarrow> Suc n) = n \<Longrightarrow> n \<ge> 1"
  apply (simp split: list.split_asm)
  done

thm list.splits (* includes both split and split_asm *)

subsection "Arithmetic"

text \<open>A bit of linear arithmetic (no multiplication) is automatic:\<close>

lemma "\<lbrakk> (x::nat) \<le> y+z;  z+x < y \<rbrakk> \<Longrightarrow> x < y"
  apply (simp)
  done

text \<open>Method ``auto'' can be modified almost like ``simp'':
 instead of ``add'' use ``simp add''.\<close>

end
