theory Single_Step_Demo
  imports Main
begin

text \<open>"thm" is a command that displays one or more named theorems:\<close>
thm conjI impI iffI notI

text \<open>Instantiation of theorems: "of"\<close>

text \<open>Positional:\<close>
thm conjI[of "A" "B"]
thm conjI[of "A"]
thm conjI[of _ "B"]

text \<open>By name:\<close>
thm conjI[where ?Q = "B"]
thm refl[where t = "a"]

text \<open>Composition of theorems: "OF"\<close>

thm refl[of "a"]
thm conjI[OF refl[of "a"] refl[of "b"]]
thm conjI[OF refl[of "a"]]
thm conjI[OF _ refl[of "b"]]

text \<open>Composition with "THEN":\<close>

thm refl[THEN conjI]
thm refl[of a, THEN conjI]
thm disjI1 disjI2
thm conjI[THEN disjI1] conjI[THEN disjI2]

text \<open>A simple backward proof:\<close>
lemma "\<lbrakk> A; B \<rbrakk> \<Longrightarrow> A \<and> B"
  apply (rule conjI)
   apply assumption
  apply assumption
  done

lemma "\<lbrakk>(a :: nat) \<le> b; b \<le> c; c \<le> d\<rbrakk> \<Longrightarrow> a \<le> d"
  thm le_trans
  sorry

lemma "A \<or> B \<Longrightarrow> B \<or> A"
  thm disjE
  sorry

lemma "\<forall>x. A x \<Longrightarrow> \<forall>x. B x \<Longrightarrow> A y \<and> B z"
  sorry

lemma "\<exists>x. A x \<Longrightarrow> \<not>(\<forall>x. \<not>A x)"
  sorry

text \<open>@{attribute rule_format} performs some normalisation on lemmas: replacing HOL universal
  quantification @{term "\<forall>x. P x"} and implication @{term "(\<longrightarrow>)"} by the corresponding Pure
  quantification @{term "\<And>x. P x"} and implication @{term "(\<Longrightarrow>)"}.  This can make it easier
  to instantiate or compose the lemma.\<close>

lemma false_imp: "\<forall>x. False \<longrightarrow> B x"
  by auto

thm false_imp[rule_format]

end
