theory Nat_Demo
  imports Overview_Demo
begin

text \<open>Another simple lemma:  Our definition of @{term add} in \<open>Overview_Demo\<close> (imported above)
  is equivalent to the builtin addition operator.}\<close>

lemma "add n m = n + m"
  by (induction n) auto

text \<open>The "by" command can be used for short one-line proofs, applying one or two proof methods.\<close>

text \<open>The induction principle for natural numbers:\<close>

thm nat.induct

text \<open>The slides contain an informal proof of lemma @{thm add_02}.
  Below is another (needlessly verbose) version of this proof that follows the structure of the
  informal proof, manually elaborated using the Isar structured proof language:

  (Don't worry, you don't need to understand the details of this proof right now, it is just meant
  as a sneak preview of structured Isar proofs.  We will learn more about Isar later.)\<close>

lemma "add m 0 = m"
proof (induction m)
  \<comment> \<open>Base case: 0\<close>
  show "add 0 0 = 0"
    by (rule add.simps(1))
next
  \<comment> \<open>Inductive step: from \<open>m\<close> to \<open>Suc m\<close>\<close>
  fix m
  assume IH: "add m 0 = m"
  have "add (Suc m) 0 = Suc (add m 0)"
    by (rule add.simps(2))
  also have "\<dots> = Suc m"
    by (simp add: IH)
  finally show "add (Suc m) 0 = Suc m" .
qed

end
