theory List_Demo
  imports Main
begin

datatype 'a list = Nil | Cons "'a" "'a list"

term "Nil"

(* In this special situation (due to name clashes with the existing list type): *)
declare [[names_short]]

fun app :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list" where
  "app Nil ys = ys"
| "app (Cons x xs) ys = Cons x (app xs ys)"

fun rev :: "'a list \<Rightarrow> 'a list" where
  "rev Nil = Nil"
| "rev (Cons x xs) = xs"

value "rev(Cons True (Cons False Nil))"

value "rev(Cons a (Cons b Nil))"

theorem rev_rev: "rev (rev xs) = xs"
  apply (induction xs)
   apply (auto)
  oops

text \<open>We need to fix the definition of \<open>rev\<close> and add some lemmas.\<close>

text \<open>The theory @{theory "HOL.List"} contains a large library of list functions and lemmas about
  them, including @{term append}, @{term List.rev}, @{term map}, @{term filter}, etc, as well as
  syntax like @{term "[0, 1, 2]"},  @{term "(@)"} for @{term append}, or
  @{term "(#)"} for @{term List.Cons}.\<close>

end
