theory Induction_Demo
  imports Main
begin

fun itrev :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list" where
  "itrev [] ys = ys"
| "itrev (x#xs) ys = itrev xs (x#ys)"

lemma "itrev xs [] = rev xs"
  apply (induction xs)
   apply (auto)
  oops


subsection "Computation Induction"

fun sep :: "'a \<Rightarrow> 'a list \<Rightarrow> 'a list" where
  "sep a [] = []"
| "sep a [x] = [x]"
| "sep a (x#y#zs) = x # a # sep a (y#zs)"

thm sep.induct

lemma "length (sep a xs) = 2 * length xs - 1"
  apply (induction a xs rule: sep.induct)
    apply auto
  done

fun div2 :: "nat \<Rightarrow> nat" where
  "div2 0 = 0"
| "div2 (Suc 0) = 0"
| "div2 (Suc (Suc n)) = Suc (div2 n)"

thm div2.induct

lemma "div2 n = n div 2"
  apply (induction n rule: div2.induct)
    apply auto
  done

end
