(** * Coq Assignment *)

(** Some questions are marked as "Advanced questions":
  you should feel free to skip them.
  Answering them is not necessary to obtain a good grade, although
  they will contribute to a distinguished grade. *)

From Coq Require Import Relations Arith Lia Bool List.
From CoqAssignment Require Import stlc.

(** ** Exercise 1 *)

(** Define a function [closedn : nat -> tm -> bool],
such that [closedn n t] tests whether all free variables of [t] are less than [n]. *)

(** Hint: you will need a test that a natural is smaller than another, which is available
in the standard library. You do not need to reimplement it yourself. *)

Fixpoint closedn (n : nat) (t : tm) : bool.
Admitted.

(** Show that well-typed terms are always closed. *)

(** Hint: you might need a lemma about [nth_error] to handle the variable case. *)

Lemma typing_closed (Γ : context) (A : ty) (t : tm) :
  (Γ |- t :: A) ->
  closedn (length Γ) t = true.
Proof.
Admitted.

(** State and show a lemma relating closedness and substitution. *)

(** Hint: you might need a lemma about renamings first.
  Hint 2: there are multiple provable statements here, but
  not all will be strong enough to solve the next question. *)

Lemma closed_subst (n : nat) (t : tm) (s : nat -> tm) :
  (* missing hypotheses! *)
  closedn n (t[s]) = true.
Proof.
Admitted.

(** Show that closedness is preserved by reduction. *)

(** Hint: take inspiration from the proof of preservation.
  You will need [closed_subst] – take care of making it powerful enough to be usable. *)

Lemma closed_red n t t' :
  closedn n t = true ->
  (t -->* t') ->
  closedn n t' = true .
Proof.
Admitted.

(** ** Exercise 2: positive product types *)

(** Extend the AST of types as follows:

  [[
  …
  | TProd (A B : ty) : ty.
  ]]

  And that of terms with

  [[
  …
  | tPair (p q : tm) : tm
  | tPLet (p t : tm) : tm.
  ]]

  The intended semantic is that [TProd] is a product type, with
  constructor pairing [tPair] and destructor [tPLet].
  [tPLet p t] binds two variables in [t], corresponding to the two
  projections of [p].

  Provide a new stlc_prod.v file, which extends stlc.v with these
  new constructs, and re-prove the theorems in the substitution section
  (up to [subst_lift_cons]).

  Hint: remember that you can use [subst_ext] and [ren_ext] to replace
  a substitution/renaming with a pointwise equal one.
*)

(** Advanced exercise: adapt the definitions of evaluation and typing,
  and show progress and preservation for this extended language.
*)

(** ** Exercise 3: boolean circuits *)

(** We define the following inductive type, representing a boolean circuit with
two inputs and one output. The [cConst] constructor represents a constant circuit
ignoring its arguments, [cInpl] and [cInpr] forward the left or right input to the output,
and [cNot] and [cAnd] represent respectively a negation and conjuction gate of two circuits. *)

Inductive circuit : Type :=
  | cConst (b : bool) : circuit
  | cInpl : circuit
  | cInpr : circuit
  | cNot (c : circuit) : circuit
  | cAnd (c c' : circuit) : circuit.

(** We want to compile our boolean circuits to the simply-typed lambda-calculus.
  That is, we want to build a function [compile_circuit : circuit -> tm] such that
  [nil |- compile_circuit c :: TArr TBool (TArr TBool TBool)].
  
  For this, we will first build a function [compile_aux : circuit -> tm] such that
  [nil,,,TBool,,,TBool |- compile_circuit_aux c :: TBool],
  which build a term of type [TBool] with two free variables,
  corresponding to the two inputs to the circuit.

  Then [compile_circuit] is obtained by abstracting over these two variables.
*)

(** We first define [compile_circuit_aux] compositionally. Fill in the definitions
  of all five building blocks. *)

Definition tConst (b : bool) : tm.
Admitted.

Definition tInpl : tm.
Admitted.

Definition tInpr : tm.
Admitted.

Definition tNot (t : tm) : tm.
Admitted.

Definition tAnd (t t' : tm) : tm.
Admitted.

Fixpoint compile_circuit_aux (c : circuit) : tm :=
  match c with
  | cConst b => tConst b
  | cInpl => tInpl
  | cInpr => tInpr
  | cNot c => tNot (compile_circuit_aux c)
  | cAnd c c' => tAnd (compile_circuit_aux c) (compile_circuit_aux c')
  end.

(** And then build [compile_circuit] by abstraction. *)

Definition compile_circuit (c : circuit) : tm := tAbs TBool (tAbs TBool (compile_circuit_aux c)).


(** Show that the compilation is well-typed. *)

Theorem compile_typed (c : circuit) :
  nil |- compile_circuit c :: TArr TBool (TArr TBool TBool).
Proof.
Admitted.

(** Show that the compilation is correct on the following example. *)

Definition circuit_example := cAnd cInpl (cNot (cConst true)).

Lemma eval_example :
  tApp (tApp (compile_circuit circuit_example) tTrue) tTrue -->* tFalse.
Proof.
Admitted.

(** Advanced question: take inspiration of the previous example to give a specification
  for your compiler, and show that it is correct. *)

Definition correctness : Prop.
Admitted.

Theorem compile_correct : correctness.
Proof.
Admitted.