(*<*)
theory Assignment1
  imports Small_Step
begin
(*>*)

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{5 marks}\<close>

text \<open>Define a function @{term [source] "vars :: aexp \<Rightarrow> vname set"} that collects all variables
  appearing in an expression, and prove that the value of an expression is unaffected by changes to
  variables not appearing in it:\<close>

(*<*)
fun vars :: "aexp \<Rightarrow> vname set" where
  "vars e = undefined"
(*>*)

lemma aval_other_var_update:
  "x \<notin> vars e \<Longrightarrow> aval e (s(x := y)) = aval e s"
  sorry

text \<open>Then show the following commutativity lemma for assignments:\<close>

lemma assign_commute:
  assumes "x \<noteq> y" and "x \<notin> vars e2" and "y \<notin> vars e1"
  shows "(x ::= e1;; y ::= e2) \<sim> (y ::= e2;; x ::= e1)"
  using assms
  sorry

text \<open>Hint: Remember lemma @{thm [source] assign_simp}.  You might want to add a corresponding
  lemma for @{term Seq}.\<close>

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{15 marks}\<close>

text \<open>Define a function @{term [source] "csimp :: com \<Rightarrow> com"} that simplifies all arithmetic and
  Boolean expressions in commands using @{const asimp} and @{const bsimp}.\<close>

(*<*)
fun csimp :: "com \<Rightarrow> com" where
  "csimp c = undefined"
(*>*)

text \<open>Show that @{const csimp} preserves the behaviour of commands:\<close>

lemma csimp_sim: "csimp c \<sim> c"
  sorry

text \<open>Hint: Remember lemma @{thm [source] sim_while_cong} for proving the WHILE case.  You might
  want to add a similar lemma that also allows changing the loop condition to an equivalent one.\<close>

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{10 marks}\<close>

text \<open>Now define a function @{term [source] "csimp_full :: com \<Rightarrow> com"} that not only simplifies
  expressions, but also does some dead code elimination in cases where Boolean expressions can be
  simplified to constants, like in the example below, and show that this function still preserves
  the behaviour of commands.\<close>

(*<*)
fun csimp_full :: "com \<Rightarrow> com" where
  "csimp_full c = undefined"
(*>*)

lemma "csimp_full (IF (Less (N 0) (N 1)) THEN x ::= N 0 ELSE x ::= N 1) = (x ::= N 0)"
  sorry

lemma csimp_full_sim: "csimp_full c \<sim> c"
  sorry

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{5 marks}\<close>

text \<open>Modify theory \<open>AExp\<close> by adding a unary negation constructor \<open>Neg\<close> to @{typ aexp}, so that
  subtraction can be expressed using @{term Plus} and \<open>Neg\<close>:\<close>

(*<*) (* FIXME: Remove after adding Neg to aexp *)
definition Neg :: "aexp \<Rightarrow> aexp" where "Neg e \<equiv> undefined"
(*>*)

abbreviation "Minus e1 e2 \<equiv> Plus e1 (Neg e2)"

text \<open>Update the definitions of @{term aval} and @{term asimp} to handle \<open>Neg\<close> and fix any broken
  proofs, then show that @{const Minus} behaves as expected:\<close>

lemma Minus_correct: "aval (Minus e1 e2) s = aval e1 s - aval e2 s"
  sorry

text \<open>Add an abbreviation \<open>Equal\<close> that checks for equality of @{typ aexp} expressions using
  existing constructors, and show that it is correct:\<close>

(*<*)
abbreviation Equal :: "aexp \<Rightarrow> aexp \<Rightarrow> bexp" where
  "Equal e1 e2 \<equiv> undefined"
(*>*)

lemma Equal_correct: "bval (Equal e1 e2) s \<longleftrightarrow> aval e1 s = aval e2 s"
  sorry

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{15 marks}\<close>

text \<open>Consider the following implementation of Euclid's algorithm for calculating the greatest
  common divisor (using the @{const Minus} and @{const Equal} expressions defined above):\<close>

abbreviation
  "imp_gcd \<equiv>
     (WHILE (Not (Equal (V ''a'') (V ''b''))) DO
        IF (Less (V ''a'') (V ''b''))
        THEN ''b'' ::= Minus (V ''b'') (V (''a''))
        ELSE ''a'' ::= Minus (V ''a'') (V (''b'')))"

text \<open>Show its (partial) correctness:\<close>

lemma imp_gcd_partial_correctness:
  assumes "(imp_gcd, s) \<Rightarrow> t" and "s ''a'' > 0" and "s ''b'' > 0"
  shows "gcd (s ''a'') (s ''b'') = t ''a''"
  using assms
  sorry

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{10 marks, advanced}\<close>

text \<open>Show that @{const imp_gcd} terminates:\<close>

lemma imp_gcd_terminates:
  assumes "s ''a'' > 0" and "s ''b'' > 0"
  shows "\<exists>t. (imp_gcd, s) \<Rightarrow> t"
  using assms
  sorry

text \<open>Hint:  You might want to prove a lemma about the termination of while loops.
  Induction rules like @{thm [source] measure_induct_rule} might be useful, which allows induction
  using a measure function @{term [source] "f :: 'a \<Rightarrow> nat"}.
  The function @{const "nat"} for converting from @{typ int} to @{typ nat} might also be useful.\<close>

text_raw \<open>\EndTask\<close>

(*-------------------------------------------------------------------------------------------*)

text_raw \<open>\BeginTask{10 marks, advanced}\<close>

text \<open>Modify theory \<open>Com\<close> by extending the type @{typ com} with a nondeterministic choice command
  @{term "CHOOSE x vs"} that sets variable @{term x} to a value chosen from a list of values that
  may depend on the state, i.e. @{term vs} has type @{typ "state \<Rightarrow> val list"}.\<close>

(*<*) (* FIXME: Remove after adding CHOOSE *)
definition CHOOSE :: "vname \<Rightarrow> (state \<Rightarrow> val list) \<Rightarrow> com" where "CHOOSE x vs \<equiv> undefined"
(*>*)

text \<open>Fix the existing proofs in theories \<open>Big_Step\<close> and \<open>Small_Step\<close>, including the equivalence
  proof between big-step and small-step semantics, but excluding the proofs that the semantics are
  deterministic and the proof about final configurations (those have been removed from the versions
  of the theories coming with this assignment).\<close>

text \<open>As an example, show that the following refinement holds:\<close>

abbreviation refines :: "com \<Rightarrow> com \<Rightarrow> bool" (infix "\<sqsubseteq>" 50) where
  "c1 \<sqsubseteq> c2 \<equiv> (\<forall>s t. (c1, s) \<Rightarrow> t \<longrightarrow> (c2, s) \<Rightarrow> t)"

lemma "(x ::= (N 2)) \<sqsubseteq> (CHOOSE x (\<lambda>_. [0, 1, 2]))"
  sorry

text \<open>Now consider the following specification for computation of the greatest common divisor:\<close>

abbreviation
  "imp_gcd_spec \<equiv>
     CHOOSE ''a'' (\<lambda>s. [gcd (s ''a'') (s ''b'')]);;
     ''b'' ::= V ''a''"

text \<open>Find a context @{term [source] "C :: com \<Rightarrow> com"} under which @{const imp_gcd} refines
  @{const imp_gcd_spec} and prove the lemma:\<close>

lemma "C imp_gcd \<sqsubseteq> C imp_gcd_spec"
  sorry

text_raw \<open>\EndTask\<close>

(*<*)
end
(*>*)
