/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import settings.Parameters;
import tesniere.Box;
import tesniere.Conversion;
import tsg.HeadLabeler;
import tsg.TSNodeLabel;
import util.FileUtil;
import viewer.TesniereTreePanel;
import viewer.TreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TesniereTreeViewer
extends TreeViewer<Box> {
    private static HeadLabeler HL;
    private static TSNodeLabel initialSentence;

    static {
        initialSentence = TesniereTreeViewer.initialSentence();
    }

    public static TSNodeLabel initialSentence() {
        try {
            return new TSNodeLabel("(S (RB Please) (, ,) (VP (VB load) (NP (NP (DT a) (NN file) (PP (IN with) (NP (JJ Penn-style) (NN structures)))) (CC or) (NP (DT a) (NN file) (PP (IN with) (NP (JJ TDS-xml) (NN structures)))) (VP (VBD located) (PP (IN in) (NP (JJ your) (NN computer)))))) (. .))");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setInitialSentence() {
        ArrayList<Box> treebank = new ArrayList<Box>();
        try {
            treebank.add(Conversion.getTesniereStructure((TSNodeLabel)initialSentence, (HeadLabeler)HL));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadTreebank(treebank);
    }

    protected void loadTreebank(File treebankFile) {
        this.corpusFile = treebankFile;
        ArrayList treebank = null;
        String firstLineFile = FileUtil.getFirstLineInFile(treebankFile);
        if (firstLineFile.startsWith("<?xml")) {
            treebank = Conversion.getTreebankFromXmlFile((File)treebankFile);
        } else {
            try {
                treebank = Conversion.getTesniereTreebank((File)treebankFile, (HeadLabeler)HL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.loadTreebank(treebank);
    }

    @Override
    protected void setCheckBoxOptions() {
        this.optionCheckBoxs = new JCheckBox[]{new JCheckBox("Skewed Lines", false), new JCheckBox("Display Categories", false)};
    }

    @Override
    protected void initializeTreePanel() {
        TesniereTreePanel tesniereTreePanel = new TesniereTreePanel();
        tesniereTreePanel.skewedLinesCheckBox = this.optionCheckBoxs[0];
        tesniereTreePanel.displayCategories = this.optionCheckBoxs[1];
        this.treePanel = tesniereTreePanel;
        this.treePanel.setBackground(Color.white);
        this.treePanel.setFocusable(false);
    }

    public static void doBeforeClosing() {
        Parameters.logPrintln("--- end of log");
        Parameters.closeLogFile();
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Tesniere Tree Viewer");
        frame.setDefaultCloseOperation(3);
        final TesniereTreeViewer treeViewer = new TesniereTreeViewer();
        Dimension area = treeViewer.treePanel.area;
        frame.setMinimumSize(new Dimension(area.width + 5, area.height + 5));
        treeViewer.setOpaque(true);
        frame.setContentPane(treeViewer);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TesniereTreeViewer.doBeforeClosing();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem openTreebank = new JMenuItem("Open Treebank");
        JMenuItem exportEps = new JMenuItem("Export to EPS");
        JMenuItem exportPdf = new JMenuItem("Export to PDF");
        JMenuItem exportAllToPdf = new JMenuItem("Export All to PDF");
        JMenuItem exportAllToXml = new JMenuItem("Export All to XML");
        JMenuItem quit = new JMenuItem("Quit");
        final JFileChooser fc = new JFileChooser();
        openTreebank.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        exportEps.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        exportPdf.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        exportAllToPdf.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        exportAllToXml.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        quit.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        openTreebank.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(treeViewer);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    treeViewer.loadTreebank(selectedFile);
                }
            }
        });
        exportEps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    selectedFile = FileUtil.changeExtention(selectedFile, "eps");
                    treeViewer.treePanel.exportToEPS(selectedFile);
                }
            }
        });
        exportPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    selectedFile = FileUtil.changeExtention(selectedFile, "pdf");
                    treeViewer.treePanel.exportToPDF(selectedFile);
                }
            }
        });
        exportAllToPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    selectedFile = FileUtil.changeExtention(selectedFile, "pdf");
                    treeViewer.treePanel.exportAllToPdf(selectedFile);
                }
            }
        });
        exportAllToXml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                if (returnVal == 0) {
                    File selectedFile = fc.getSelectedFile();
                    selectedFile = FileUtil.changeExtention(selectedFile, "xml");
                    ((TesniereTreePanel)treeViewer.treePanel).exportAllToXML(selectedFile);
                }
            }
        });
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TesniereTreeViewer.doBeforeClosing();
                System.exit(0);
            }
        });
        file.add(openTreebank);
        file.add(exportEps);
        file.add(exportPdf);
        file.add(exportAllToPdf);
        file.add(exportAllToXml);
        file.add(quit);
        openTreebank.setMnemonic('O');
        exportPdf.setMnemonic('P');
        exportAllToPdf.setMnemonic('A');
        exportAllToXml.setMnemonic('X');
        quit.setMnemonic('Q');
        menuBar.add(file);
        frame.setJMenuBar(menuBar);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        TesniereTreePanel.printOnCosoleCurrentTree = false;
        String usage = "USAGE: java [-Xmx100M] -jar TDS.jar [-log fileLog]";
        InputStream is = ClassLoader.getSystemResourceAsStream("fede.rules_12_04_10");
        HL = new HeadLabeler(is);
        File logFile = null;
        if (args.length > 1) {
            String option;
            if (args.length != 2) {
                System.err.println("Incorrect number of arguments.");
                System.err.println(usage);
                System.exit(-1);
            }
            if (!(option = args[0]).equals("-log")) {
                System.err.println("Not a valid option: " + option);
                System.err.println(usage);
                System.exit(-1);
            }
            logFile = new File(args[1]);
        }
        if (logFile != null) {
            Parameters.openLogFile(logFile);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TesniereTreeViewer.createAndShowGUI();
            }
        });
    }
}

