/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tdg.corpora.DepCorpus;
import tdg.corpora.MstSentenceUlab;
import tdg.corpora.MstSentenceUlabAdvanced;
import util.FileUtil;
import viewer.DepTreePanel;

public class DepTreeCompare
extends JPanel
implements ChangeListener,
ActionListener,
ComponentListener {
    private JPanel controlPanel;
    private JSpinner controlSentenceNumber;
    private JButton plus;
    private JButton minus;
    private DepTreePanel goldTreePanel;
    private DepTreePanel guessTreePanel;
    private JSplitPane splitPane;
    private JScrollPane goldScroller;
    private JScrollPane guessScroller;
    private JCheckBox straightLinesCheckBox;
    private JTextField uasScore;
    private JLabel sizeReport;
    private int currentSentenceNumber;
    private int size = 1;
    private ArrayList<MstSentenceUlabAdvanced> goldTreebank = new ArrayList();
    private ArrayList<MstSentenceUlabAdvanced> guessTreebank = new ArrayList();
    private static MstSentenceUlabAdvanced initialSentence;

    static {
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 1;
        initialSentence = new MstSentenceUlabAdvanced(new String[]{"Load", "gold_and_guess", "corpora"}, new String[]{"V", "J", "N"}, nArray);
    }

    public DepTreeCompare() {
        super(new BorderLayout());
        this.goldTreebank.add(initialSentence);
        this.guessTreebank.add(initialSentence);
        this.buildComponents();
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.splitPane, "Center");
        this.resetTreebanks();
        this.init();
    }

    private void loadGoldCorpus(File goldFile) {
        boolean isConnl = DepCorpus.isConnlFormat((File)goldFile);
        this.goldTreebank = isConnl ? MstSentenceUlabAdvanced.getTreebankAdvancedFromConnl((File)goldFile, (String)"UTF-8") : MstSentenceUlabAdvanced.getTreebankAdvancedFromMst((File)goldFile, (String)"UTF-8");
    }

    private void loadGuessCorpus(File guessFile) {
        boolean isConnl = DepCorpus.isConnlFormat((File)guessFile);
        this.guessTreebank = isConnl ? MstSentenceUlabAdvanced.getTreebankAdvancedFromConnl((File)guessFile, (String)"UTF-8") : MstSentenceUlabAdvanced.getTreebankAdvancedFromMst((File)guessFile, (String)"UTF-8");
    }

    private void resetTreebanks() {
        this.size = this.goldTreebank.size();
        this.goldTreePanel.loadTreebank(this.goldTreebank);
        this.guessTreePanel.loadTreebank(this.guessTreebank);
        this.currentSentenceNumber = 0;
        this.controlSentenceNumber.setValue(1);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, this.size, 1);
        this.controlSentenceNumber.setModel(spinnerModel);
        this.sizeReport.setText("of: " + this.size);
    }

    private void buildComponents() {
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, this.size, 1);
        this.controlSentenceNumber = new JSpinner(spinnerModel);
        this.controlSentenceNumber.setPreferredSize(new Dimension(100, 30));
        this.controlSentenceNumber.addChangeListener(this);
        this.controlSentenceNumber.setFocusable(true);
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setFocusable(false);
        JPanel leftControlPanel = new JPanel();
        JPanel centerControlPanel = new JPanel();
        JPanel rightControlPanel = new JPanel();
        this.controlPanel.add((Component)leftControlPanel, "West");
        this.controlPanel.add((Component)centerControlPanel, "Center");
        this.controlPanel.add((Component)rightControlPanel, "East");
        this.straightLinesCheckBox = new JCheckBox("Straight Lines:");
        this.straightLinesCheckBox.addActionListener(this);
        this.straightLinesCheckBox.setFocusable(false);
        leftControlPanel.add(this.straightLinesCheckBox);
        this.plus = new JButton("+");
        this.minus = new JButton("-");
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        this.plus.setFocusable(false);
        this.minus.setFocusable(false);
        centerControlPanel.add(new JLabel("zoom: "));
        centerControlPanel.add(this.plus);
        centerControlPanel.add(this.minus);
        JLabel uasLabel = new JLabel("UAS: ");
        this.uasScore = new JTextField(7);
        uasLabel.setFocusable(false);
        this.uasScore.setFocusable(false);
        this.uasScore.setEditable(false);
        rightControlPanel.add(uasLabel);
        rightControlPanel.add(this.uasScore);
        rightControlPanel.add(this.controlSentenceNumber);
        this.sizeReport = new JLabel();
        rightControlPanel.add(this.sizeReport);
        this.goldTreePanel = new DepTreePanel();
        this.goldTreePanel.setBackground(Color.white);
        this.goldTreePanel.setFocusable(false);
        this.guessTreePanel = new DepTreePanel();
        this.guessTreePanel.setBackground(Color.white);
        this.guessTreePanel.setFocusable(false);
        this.goldScroller = new JScrollPane(this.goldTreePanel);
        this.goldScroller.setFocusable(false);
        this.guessScroller = new JScrollPane(this.guessTreePanel);
        this.guessScroller.setFocusable(false);
        this.splitPane = new JSplitPane(0, this.goldScroller, this.guessScroller);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(300);
        this.splitPane.setFocusable(false);
        this.splitPane.setPreferredSize(new Dimension(800, 600));
        this.splitPane.addComponentListener(this);
    }

    private void init() {
        MstSentenceUlab s1 = this.goldTreePanel.getSentence(this.currentSentenceNumber);
        MstSentenceUlab s2 = this.guessTreePanel.getSentence(this.currentSentenceNumber);
        Integer[] wrongNodes = MstSentenceUlab.wrongWords((MstSentenceUlab)s1, (MstSentenceUlab)s2);
        this.goldTreePanel.init();
        this.guessTreePanel.setWrongNodes(wrongNodes);
        this.guessTreePanel.init();
        int length = s1.length;
        int uas = length - wrongNodes.length;
        this.uasScore.setText(String.valueOf(uas) + "/" + length);
    }

    public void actionPerformed(ActionEvent e) {
        throw new Error("Unresolved compilation problems: \n\tgoldTreePanel.straightLines cannot be resolved or is not a field\n\tgoldTreePanel.straightLines cannot be resolved or is not a field\n\tguessTreePanel.straightLines cannot be resolved or is not a field\n\tguessTreePanel.straightLines cannot be resolved or is not a field\n");
    }

    public void stateChanged(ChangeEvent e) {
        throw new Error("Unresolved compilation problems: \n\tgoldTreePanel.straightLines cannot be resolved or is not a field\n\tgoldTreePanel.straightLines cannot be resolved or is not a field\n\tguessTreePanel.straightLines cannot be resolved or is not a field\n\tguessTreePanel.straightLines cannot be resolved or is not a field\n");
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Dependency Tree Compare");
        frame.setDefaultCloseOperation(3);
        final DepTreeCompare contentPane = new DepTreeCompare();
        contentPane.setOpaque(true);
        frame.setContentPane(contentPane);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem loadGoldFile = new JMenuItem("Load Gold");
        JMenuItem loadGuessFile = new JMenuItem("Load Guess");
        JMenuItem displayCorpora = new JMenuItem("Display");
        JMenuItem exportEps = new JMenuItem("Export to EPS");
        JMenuItem exportPdf = new JMenuItem("Export tp PDF");
        final JFileChooser fc = new JFileChooser();
        exportEps.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        exportPdf.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        loadGoldFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(contentPane);
                File selectedFile = fc.getSelectedFile();
                if (returnVal == 0) {
                    contentPane.loadGoldCorpus(selectedFile);
                }
            }
        });
        loadGuessFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(contentPane);
                File selectedFile = fc.getSelectedFile();
                if (returnVal == 0) {
                    contentPane.loadGuessCorpus(selectedFile);
                }
            }
        });
        displayCorpora.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DepTreeCompare.this.resetTreebanks();
                DepTreeCompare.this.init();
            }
        });
        exportEps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(contentPane);
                File selectedFile = fc.getSelectedFile();
                File selectedFileGold = FileUtil.appendAndAddExtention(selectedFile, "_gold", "eps");
                File selectedFileGuess = FileUtil.appendAndAddExtention(selectedFile, "_guess", "eps");
                if (returnVal == 0) {
                    contentPane.goldTreePanel.exportToEPS(selectedFileGold);
                    contentPane.guessTreePanel.exportToEPS(selectedFileGuess);
                }
            }
        });
        exportPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(contentPane);
                File selectedFile = fc.getSelectedFile();
                File selectedFileGold = FileUtil.appendAndAddExtention(selectedFile, "_gold", "pdf");
                File selectedFileGuess = FileUtil.appendAndAddExtention(selectedFile, "_guess", "pdf");
                if (returnVal == 0) {
                    contentPane.goldTreePanel.exportToPDF(selectedFileGold);
                    contentPane.guessTreePanel.exportToPDF(selectedFileGuess);
                }
            }
        });
        file.add(loadGoldFile);
        file.add(loadGuessFile);
        file.add(displayCorpora);
        file.add(exportEps);
        file.add(exportPdf);
        file.setMnemonic('F');
        file.setMnemonic('P');
        JMenuItem quit = new JMenuItem("Quit");
        file.add(quit);
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        JMenu window = new JMenu("Window");
        menuBar.add(file);
        menuBar.add(window);
        frame.setJMenuBar(menuBar);
        frame.pack();
        frame.setVisible(true);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        Dimension newDim = this.splitPane.getSize();
        this.splitPane.setDividerLocation(newDim.height / 2);
        this.splitPane.repaint();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DepTreeCompare.createAndShowGUI();
            }
        });
    }
}

