/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tdg.corpora.DepCorpus;
import tdg.corpora.MstSentenceUlabAdvanced;
import tsg.TSNodeLabel;
import viewer.ConstTreePanel;
import viewer.DepTreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstDepTreeViewer
extends JPanel
implements ChangeListener,
ActionListener {
    private JPanel controlPanel;
    private JSpinner controlSentenceNumber;
    private JButton plus;
    private JButton minus;
    private ConstTreePanel constTreePanel;
    private DepTreePanel depTreePanel;
    private JSplitPane splitPane;
    private JScrollPane constScroller;
    private JScrollPane depScroller;
    private ArrayList<TSNodeLabel> constTreebank;
    private ArrayList<MstSentenceUlabAdvanced> depTreebank;
    private JCheckBox straightLinesCheckBox;
    private JCheckBox showHeadsCheckBox;
    private int size;

    public ConstDepTreeViewer(ArrayList<TSNodeLabel> constTreebank, ArrayList<MstSentenceUlabAdvanced> depTreebank) {
        super(new BorderLayout());
        this.size = constTreebank.size();
        this.constTreebank = constTreebank;
        this.depTreebank = depTreebank;
        this.buildComponents();
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.splitPane, "Center");
        this.constTreePanel.init();
        this.depTreePanel.init();
    }

    private void buildComponents() {
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, this.size, 1);
        this.controlSentenceNumber = new JSpinner(spinnerModel);
        this.controlSentenceNumber.setPreferredSize(new Dimension(100, 30));
        this.controlSentenceNumber.addChangeListener(this);
        this.controlSentenceNumber.setFocusable(true);
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setFocusable(false);
        JPanel leftControlPanel = new JPanel();
        JPanel centerControlPanel = new JPanel();
        JPanel rightControlPanel = new JPanel();
        this.controlPanel.add((Component)leftControlPanel, "West");
        this.controlPanel.add((Component)centerControlPanel, "Center");
        this.controlPanel.add((Component)rightControlPanel, "East");
        this.straightLinesCheckBox = new JCheckBox("Straight Lines:");
        this.straightLinesCheckBox.addActionListener(this);
        this.straightLinesCheckBox.setFocusable(false);
        leftControlPanel.add(this.straightLinesCheckBox);
        this.showHeadsCheckBox = new JCheckBox("Show heads:");
        this.showHeadsCheckBox.addActionListener(this);
        this.showHeadsCheckBox.setFocusable(false);
        leftControlPanel.add(this.showHeadsCheckBox);
        this.plus = new JButton("+");
        this.minus = new JButton("-");
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        this.plus.setFocusable(false);
        this.minus.setFocusable(false);
        centerControlPanel.add(new JLabel("zoom: "));
        centerControlPanel.add(this.plus);
        centerControlPanel.add(this.minus);
        rightControlPanel.add(this.controlSentenceNumber);
        rightControlPanel.add(new JLabel("of " + this.size));
        this.constTreePanel = new ConstTreePanel(this.constTreebank);
        this.constTreePanel.setBackground(Color.white);
        this.constTreePanel.setFocusable(false);
        this.depTreePanel = new DepTreePanel(this.depTreebank);
        this.depTreePanel.setBackground(Color.white);
        this.depTreePanel.setFocusable(false);
        this.constScroller = new JScrollPane(this.constTreePanel);
        this.constScroller.setFocusable(false);
        this.depScroller = new JScrollPane(this.depTreePanel);
        this.depScroller.setFocusable(false);
        this.splitPane = new JSplitPane(0, this.constScroller, this.depScroller);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(300);
        this.splitPane.setFocusable(false);
        this.splitPane.setPreferredSize(new Dimension(800, 600));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        throw new Error("Unresolved compilation problems: \n\tconstTreePanel.straightLines cannot be resolved or is not a field\n\tconstTreePanel.straightLines cannot be resolved or is not a field\n\tdepTreePanel.straightLines cannot be resolved or is not a field\n\tdepTreePanel.straightLines cannot be resolved or is not a field\n\tThe operator ! is undefined for the argument type(s) JCheckBox\n");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Integer s = (Integer)this.controlSentenceNumber.getValue();
        this.constTreePanel.goToSentence(s - 1);
        this.depTreePanel.goToSentence(s - 1);
        this.constTreePanel.init();
        this.depTreePanel.init();
    }

    private static void createAndShowGUI() throws Exception {
        JFrame frame = new JFrame("ConstDep Tree Viewer");
        frame.setDefaultCloseOperation(3);
        File constCorpusFile = new File("Wsj/wsj-00.mrg");
        ArrayList<TSNodeLabel> constTreebank = TSNodeLabel.getTreebank(constCorpusFile);
        File depCorpusFile = new File("Wsj/wsj-00.ulab");
        boolean isConnl = DepCorpus.isConnlFormat((File)depCorpusFile);
        ArrayList depTreebank = isConnl ? MstSentenceUlabAdvanced.getTreebankAdvancedFromConnl((File)depCorpusFile, (String)"UTF-8") : MstSentenceUlabAdvanced.getTreebankAdvancedFromMst((File)depCorpusFile, (String)"UTF-8");
        ConstDepTreeViewer newContentPane = new ConstDepTreeViewer(constTreebank, depTreebank);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ConstDepTreeViewer.createAndShowGUI();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

