/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import ccg.CCGInternalNode;
import ccg.CCGNode;
import ccg.CCGTerminalNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import javax.swing.JCheckBox;
import viewer.TreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCGTreePanel
extends TreePanel<CCGNode> {
    private static final long serialVersionUID = 1L;
    boolean showHeads;
    int sentenceLength;
    int nodesCount;
    IdentityHashMap<CCGNode, Integer> indexTable;
    CCGNode[] nodesArray;
    CCGNode[] terminalsArray;
    String[] labelArray;
    int[] XLeftArray;
    int[] YArray;
    int[] XMiddleArray;
    int[] wordLengthsArray;
    public JCheckBox skewedLinesCheckBox;

    public CCGTreePanel() {
    }

    public CCGTreePanel(ArrayList<CCGNode> treebank) {
        this.loadTreebank(treebank);
    }

    @Override
    public void loadTreebank(ArrayList<CCGNode> treebank) {
        this.treebank = treebank;
        this.lastIndex = treebank.size() - 1;
    }

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke());
        CCGNode[] cCGNodeArray = this.nodesArray;
        int n = this.nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CCGInternalNode p;
            CCGNode n3 = cCGNodeArray[n2];
            boolean isHead = this.showHeads && n3.isHead();
            int i = this.indexTable.get(n3);
            if (isHead) {
                g2.setColor(Color.BLUE);
            }
            g2.drawString(this.labelArray[i], this.XLeftArray[i], this.YArray[i]);
            if (n3.isTerminal()) {
                String word = ((CCGTerminalNode)n3).word();
                int wordLength = this.metrics.stringWidth(word);
                int wordXStart = this.XMiddleArray[i] - wordLength / 2;
                g2.drawString(word, wordXStart, this.YArray[i] + this.fontHight);
            }
            if (isHead) {
                g2.setColor(Color.black);
            }
            if ((p = n3.parent()) != null) {
                int pIndex = this.indexTable.get(p);
                this.drawLine(this.XMiddleArray[i], this.YArray[i] - this.fontSize - this.textTopMargin, this.XMiddleArray[pIndex], this.YArray[pIndex] + this.textTopMargin, g2);
            }
            ++n2;
        }
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D g2) {
        if (!this.skewedLinesCheckBox.isSelected()) {
            int yM = y1 + (y2 - y1) / 2;
            g2.drawLine(x1, y1, x1, yM);
            g2.drawLine(x1, yM, x2, yM);
            g2.drawLine(x2, yM, x2, y2);
        } else {
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.render(g2);
    }

    @Override
    public void loadSentence() {
        CCGNode t = (CCGNode)this.treebank.get(this.sentenceNumber);
        this.indexTable = new IdentityHashMap();
        this.nodesCount = t.countAllNodes();
        this.sentenceLength = t.countTerminalNodes();
        this.terminalsArray = t.collectTerminalNodes().toArray(new CCGNode[this.sentenceLength]);
        this.nodesArray = t.collectAllNodes().toArray(new CCGNode[this.nodesCount]);
        int maxDepth = t.maxDepth();
        int i = 0;
        while (i < this.nodesCount) {
            CCGNode n = this.nodesArray[i];
            this.indexTable.put(n, i);
            ++i;
        }
        this.labelArray = new String[this.nodesCount];
        this.XLeftArray = new int[this.nodesCount];
        this.XMiddleArray = new int[this.nodesCount];
        this.wordLengthsArray = new int[this.nodesCount];
        Arrays.fill(this.XLeftArray, -1);
        this.YArray = new int[this.nodesCount];
        int previousWordLength = 0;
        int previousXLeft = this.leftMargin;
        int j = 0;
        while (j < this.sentenceLength) {
            int wordLength;
            CCGNode n = this.terminalsArray[j];
            int i2 = this.indexTable.get(n);
            this.labelArray[i2] = n.category();
            int catLength = this.metrics.stringWidth(this.labelArray[i2]);
            int wordLengthColumn = this.getWordLengthColumn(n, catLength);
            if (n.isTerminal() && (wordLength = this.metrics.stringWidth(((CCGTerminalNode)n).word())) > wordLengthColumn) {
                wordLengthColumn = wordLength;
            }
            this.wordLengthsArray[i2] = wordLengthColumn;
            this.XMiddleArray[i2] = wordLengthColumn / 2 + previousXLeft + previousWordLength + this.wordSpace;
            this.XLeftArray[i2] = this.XMiddleArray[i2] - catLength / 2;
            this.YArray[i2] = this.topMargin + this.fontHight + n.hight() * this.levelSize;
            previousWordLength = wordLengthColumn;
            previousXLeft = this.XLeftArray[i2];
            ++j;
        }
        CCGNode[] cCGNodeArray = this.nodesArray;
        int n = this.nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            if (!n3.isTerminal()) {
                int i3 = this.indexTable.get(n3);
                this.updateValues((CCGInternalNode)n3, i3);
            }
            ++n2;
        }
        this.area.width = previousXLeft + previousWordLength + this.wordSpace + this.rightMargin;
        this.area.height = this.topMargin + 2 * this.fontHight + maxDepth * this.levelSize + this.bottomMargin;
    }

    private int getWordLengthColumn(CCGNode n, int wordLength) {
        while (n.parent() != null && n.isUniqueDaughter()) {
            int length = this.metrics.stringWidth((n = n.parent()).category());
            if (length <= wordLength) continue;
            wordLength = length;
        }
        return wordLength;
    }

    private void updateValues(CCGInternalNode n, int i) {
        int wordLength;
        if (this.XLeftArray[i] != -1) {
            return;
        }
        this.labelArray[i] = n.category();
        this.YArray[i] = this.topMargin + this.fontHight + n.hight() * this.levelSize;
        this.wordLengthsArray[i] = wordLength = this.metrics.stringWidth(this.labelArray[i]);
        CCGNode[] daughters = n.daughters();
        CCGNode firstDaughter = daughters[0];
        int iDF = this.indexTable.get(firstDaughter);
        if (!firstDaughter.isTerminal()) {
            this.updateValues((CCGInternalNode)firstDaughter, iDF);
        }
        if (daughters.length == 1) {
            this.XMiddleArray[i] = this.XMiddleArray[iDF];
            this.XLeftArray[i] = this.XMiddleArray[i] - wordLength / 2;
        } else {
            CCGNode lastDaughter = daughters[n.prole() - 1];
            int iDL = this.indexTable.get(lastDaughter);
            if (!lastDaughter.isTerminal()) {
                this.updateValues((CCGInternalNode)lastDaughter, iDL);
            }
            this.XMiddleArray[i] = this.XLeftArray[iDF] + (this.XLeftArray[iDL] + this.wordLengthsArray[iDL] - this.XLeftArray[iDF]) / 2;
            this.XLeftArray[i] = this.XMiddleArray[i] - wordLength / 2;
        }
    }
}

