/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.ListIterator;
import util.AllOrderedCharSubsequences;
import util.Pair;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllOrderedCharSubsequencesBF {
    Character[] a1;
    Character[] a2;

    public AllOrderedCharSubsequencesBF(Character[] a1, Character[] a2) {
        this.a1 = a1;
        this.a2 = a2;
    }

    public static Character[][] getAllSubSequences(Character[] a) {
        int resultSize = (int)Math.pow(2.0, a.length) - 1;
        Character[][] result = new Character[resultSize][];
        int i = 0;
        int l = 1;
        while (l <= a.length) {
            int[][] nairs;
            int[][] nArray = nairs = Utility.n_air(a.length, l);
            int n = nairs.length;
            int n2 = 0;
            while (n2 < n) {
                int[] comb = nArray[n2];
                Character[] result_i = new Character[l];
                int j = 0;
                while (j < l) {
                    result_i[j] = a[comb[j]];
                    ++j;
                }
                result[i] = result_i;
                ++i;
                ++n2;
            }
            ++l;
        }
        return result;
    }

    public static boolean equals(Character[] a, Character[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ArrayList<ArrayList<Pair<Character>>> getAllSubsequences() {
        ArrayList<ArrayList<Pair<Character>>> result = new ArrayList<ArrayList<Pair<Character>>>();
        Character[][] allSubSequencesA1 = AllOrderedCharSubsequencesBF.getAllSubSequences(this.a1);
        Character[][] allSubSequencesA2 = AllOrderedCharSubsequencesBF.getAllSubSequences(this.a2);
        Character[][] characterArray = allSubSequencesA1;
        int n = allSubSequencesA1.length;
        int n2 = 0;
        while (n2 < n) {
            Character[] subA1 = characterArray[n2];
            Character[][] characterArray2 = allSubSequencesA2;
            int n3 = allSubSequencesA2.length;
            int n4 = 0;
            while (n4 < n3) {
                Character[] subA2 = characterArray2[n4];
                if (AllOrderedCharSubsequencesBF.equals(subA1, subA2)) {
                    ArrayList<Pair<Character>> pairList = AllOrderedCharSubsequencesBF.buildPairList(subA1, subA2);
                    AllOrderedCharSubsequencesBF.addClosure(result, pairList);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public static void addClosure(ArrayList<ArrayList<Pair<Character>>> closureList, ArrayList<Pair<Character>> pairList) {
        ListIterator<ArrayList<Pair<Character>>> iter = closureList.listIterator();
        while (iter.hasNext()) {
            ArrayList<Pair<Character>> list = iter.next();
            if (list.size() == pairList.size()) continue;
            if (pairList.size() > list.size()) {
                if (!AllOrderedCharSubsequencesBF.isSuperSet(pairList, list)) continue;
                iter.remove();
                continue;
            }
            if (!AllOrderedCharSubsequencesBF.isSuperSet(list, pairList)) continue;
            return;
        }
        closureList.add(pairList);
    }

    public static ArrayList<Pair<Character>> buildPairList(Character[] subA1, Character[] subA2) {
        ArrayList<Pair<Character>> result = new ArrayList<Pair<Character>>(subA1.length);
        int i = 0;
        while (i < subA1.length) {
            Pair<Character> pair = new Pair<Character>(subA1[i], subA2[i]);
            result.add(pair);
            ++i;
        }
        return result;
    }

    public static boolean isSuperSet(ArrayList<Pair<Character>> bigPairList, ArrayList<Pair<Character>> smallPairList) {
        ListIterator<Pair<Character>> smallLI = smallPairList.listIterator();
        ListIterator<Pair<Character>> bigLI = bigPairList.listIterator();
        while (smallLI.hasNext()) {
            Pair<Character> p1 = smallLI.next();
            boolean found = false;
            while (bigLI.hasNext()) {
                Pair<Character> p2 = bigLI.next();
                if (p1.getFirst() != p2.getFirst() || p1.getSecond() != p2.getSecond()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualPairList(ArrayList<Pair<Character>> pairList1, ArrayList<Pair<Character>> pairList2) {
        if (pairList1.size() != pairList2.size()) {
            return false;
        }
        ListIterator<Pair<Character>> i1 = pairList1.listIterator();
        ListIterator<Pair<Character>> i2 = pairList2.listIterator();
        while (i1.hasNext()) {
            Pair<Character> p1 = i1.next();
            Pair<Character> p2 = i2.next();
            if (p1.getFirst() == p2.getFirst() && p1.getSecond() == p2.getSecond()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(ArrayList<ArrayList<Pair<Character>>> allS1, ArrayList<ArrayList<Pair<Character>>> allS2) {
        if (allS1.size() != allS2.size()) {
            return false;
        }
        BitSet indexMatched = new BitSet(allS1.size());
        int index1 = 0;
        for (ArrayList<Pair<Character>> pairList1 : allS1) {
            int index2 = 0;
            boolean found = false;
            for (ArrayList<Pair<Character>> pairList2 : allS2) {
                if (!indexMatched.get(index2) && AllOrderedCharSubsequencesBF.isEqualPairList(pairList1, pairList2)) {
                    found = true;
                    indexMatched.set(index2);
                    break;
                }
                ++index2;
            }
            if (!found) {
                return false;
            }
            ++index1;
        }
        return true;
    }

    public static int indexOf(Character c, Character[] a) {
        int i = 0;
        while (i < a.length) {
            if (c == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String toString(ArrayList<Pair<Character>> pairList, Character[] a1, Character[] a2) {
        String result = "(";
        ListIterator<Pair<Character>> iter2 = pairList.listIterator();
        while (iter2.hasNext()) {
            Pair<Character> p = iter2.next();
            Character c1 = p.getFirst();
            Character c2 = p.getSecond();
            int i1 = AllOrderedCharSubsequencesBF.indexOf(c1, a1);
            int i2 = AllOrderedCharSubsequencesBF.indexOf(c2, a2);
            result = String.valueOf(result) + "(" + c1 + i1 + "," + c2 + i2 + ")";
            if (!iter2.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public static void main1(String[] args) {
        Character[] a1 = new Character[]{new Character('A'), new Character('B'), new Character('C'), new Character('C'), new Character('A'), new Character('F'), new Character('G'), new Character('A'), new Character('A'), new Character('I'), new Character('L')};
        Character[] a2 = new Character[]{new Character('A'), new Character('B'), new Character('C'), new Character('D'), new Character('F'), new Character('A'), new Character('C'), new Character('F'), new Character('G'), new Character('H')};
        AllOrderedCharSubsequencesBF S = new AllOrderedCharSubsequencesBF(a1, a2);
        ArrayList<ArrayList<Pair<Character>>> allS = S.getAllSubsequences();
        for (ArrayList<Pair<Character>> pairList : allS) {
            System.out.println(pairList);
        }
        System.out.println(allS.size());
    }

    public static Character[] makeNewRandomCharArray(Character[] alphabet, int size) {
        int lastAlphaChar = alphabet.length - 1;
        Character[] result = new Character[size];
        int i = 0;
        while (i < size) {
            result[i] = new Character(alphabet[Utility.randomInteger(lastAlphaChar)].charValue());
            ++i;
        }
        return result;
    }

    public static Character[] makeNewCharArray(Character[] array) {
        Character[] result = new Character[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = new Character(array[i].charValue());
            ++i;
        }
        return result;
    }

    public static void main4(String[] args) {
        ArrayList<ArrayList<Pair<Character>>> allS2;
        ArrayList<ArrayList<Pair<Character>>> allS1;
        Object[] a2;
        Object[] a1;
        Character[] alphabet = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E')};
        int maxLength = 8;
        while (true) {
            int a1Size = Utility.randomInteger(maxLength);
            a1 = AllOrderedCharSubsequencesBF.makeNewRandomCharArray(alphabet, a1Size);
            int a2Size = Utility.randomInteger(maxLength);
            a2 = AllOrderedCharSubsequencesBF.makeNewRandomCharArray(alphabet, a2Size);
            AllOrderedCharSubsequencesBF S1 = new AllOrderedCharSubsequencesBF((Character[])a1, (Character[])a2);
            allS1 = S1.getAllSubsequences();
            AllOrderedCharSubsequences S2 = new AllOrderedCharSubsequences((Character[])a1, (Character[])a2);
            allS2 = S2.getAllSubsequences();
            System.out.println(Arrays.toString(a1));
            System.out.println(Arrays.toString(a2));
            boolean isEqual = AllOrderedCharSubsequencesBF.isEqual(allS1, allS2);
            if (!isEqual) break;
            System.out.println("CORRECT\n");
        }
        System.out.println("NON CORRECT:\n");
        for (ArrayList<Pair<Character>> pairList : allS1) {
            System.out.println(AllOrderedCharSubsequencesBF.toString(pairList, (Character[])a1, (Character[])a2));
        }
        System.out.println("------------");
        for (ArrayList<Pair<Character>> pairList : allS2) {
            System.out.println(AllOrderedCharSubsequencesBF.toString(pairList, (Character[])a1, (Character[])a2));
        }
    }

    public static void main(String[] args) {
        Object[] a1 = AllOrderedCharSubsequencesBF.makeNewCharArray(new Character[]{Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('B'), Character.valueOf('D')});
        Object[] a2 = AllOrderedCharSubsequencesBF.makeNewCharArray(new Character[]{Character.valueOf('B'), Character.valueOf('B'), Character.valueOf('C')});
        AllOrderedCharSubsequencesBF S1 = new AllOrderedCharSubsequencesBF((Character[])a1, (Character[])a2);
        ArrayList<ArrayList<Pair<Character>>> allS1 = S1.getAllSubsequences();
        AllOrderedCharSubsequences S2 = new AllOrderedCharSubsequences((Character[])a1, (Character[])a2);
        ArrayList<ArrayList<Pair<Character>>> allS2 = S2.getAllSubsequences();
        System.out.println(Arrays.toString(a1));
        System.out.println(Arrays.toString(a2));
        boolean isEqual = AllOrderedCharSubsequencesBF.isEqual(allS1, allS2);
        if (isEqual) {
            System.out.println("CORRECT\n");
        } else {
            System.out.println("NON CORRECT:\n");
        }
        for (ArrayList<Pair<Character>> pairList : allS1) {
            System.out.println(AllOrderedCharSubsequencesBF.toString(pairList, (Character[])a1, (Character[])a2));
        }
    }
}

