/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import settings.Parameters;
import tsg.CFSG;
import tsg.parseEval.EvalF;
import tsg.parser.CKYChart;
import tsg.parser.CacheManager;
import tsg.parser.Cell;
import tsg.parser.Grammar;
import tsg.parser.Oracle;
import tsg.parser.PostProcess;
import tsg.parser.RamCacheManager;
import tsg.parser.TestSet;
import util.FileUtil;
import util.PrintProgress;
import util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String fedePar = "fedePar";
    public static final String bitPar = "bitPar";
    Grammar grammar;
    TestSet testSet;
    CacheManager cache;
    double pruningFactor;
    public static String filePrefix = String.valueOf(Parameters.outputPath) + Parameters.parserName;
    public static File nbestParsesFile = new File(String.valueOf(filePrefix) + ".parses");
    public static File bestParseFile = new File(String.valueOf(filePrefix) + ".best");
    public static File bestParseCoveredFile = new File(String.valueOf(filePrefix) + ".best.covered");
    public static int[] coveredTotal;

    public Parser(CFSG<? extends Number> CFGgrammar) {
        Parameters.printTrainingAndTest();
        if (Parameters.parserName == bitPar) {
            this.runBitPar();
        } else if (Parameters.parserName == fedePar) {
            this.runFedePar(CFGgrammar);
        } else {
            System.err.println("No parser selected");
            return;
        }
        this.postProcess();
        this.runEvalB();
        this.runEvalF();
    }

    public void runFedePar(CFSG<? extends Number> CFGgrammar) {
        List<String> inputSentences = FileUtil.convertFileToStringList(Parameters.testFlat);
        this.grammar = new Grammar(CFGgrammar);
        this.grammar.checkRecursiveUnaryProductions();
        this.testSet = new TestSet(inputSentences, this.grammar);
        this.cache = new RamCacheManager(this.testSet);
        this.initializeStatics();
        long[] timeSentenceLength = new long[Parameters.lengthLimitTraining + 1];
        int[] countSentenceLength = new int[Parameters.lengthLimitTraining + 1];
        PrintProgress.start("EvalF is parsing sentence:");
        for (ArrayList<Integer> sentence : this.testSet.inputSentences) {
            int sentenceLength;
            Timer.timerStart();
            CKYChart chart = new CKYChart(sentence);
            String nBestDerivations = chart.outputBestNDerivation();
            FileUtil.append(nBestDerivations, nbestParsesFile);
            long ellapsed = Timer.timerStop();
            int n = sentenceLength = sentence.size();
            timeSentenceLength[n] = timeSentenceLength[n] + ellapsed;
            int n2 = sentenceLength;
            countSentenceLength[n2] = countSentenceLength[n2] + 1;
            PrintProgress.next();
        }
        PrintProgress.end();
        this.printTimeStatistics(countSentenceLength, timeSentenceLength);
        Runtime.getRuntime().gc();
    }

    private void printTimeStatistics(int[] countSentenceLength, long[] timeSentenceLength) {
        FileUtil.append("\n Parsing time statistics", this.grammar.logFile);
        FileUtil.append("Length \t AvgParsingTime", this.grammar.logFile);
        int i = 0;
        while (i < countSentenceLength.length) {
            if (countSentenceLength[i] != 0) {
                float avg = (float)timeSentenceLength[i] / (float)(countSentenceLength[i] * 1000);
                FileUtil.append(i + "\t" + avg, this.grammar.logFile);
            }
            ++i;
        }
    }

    public void initializeStatics() {
        CKYChart.grammar = this.grammar;
        CKYChart.cache = this.cache;
        Cell.grammar = this.grammar;
    }

    public void postProcess() {
        PostProcess.processFile(nbestParsesFile, bestParseFile, false);
        if (Parameters.markHeadsInPostprocessing) {
            PostProcess.processFile(nbestParsesFile, new File(bestParseFile + ".heads"), true);
        }
        if (Parameters.makeCoveredStatistics) {
            coveredTotal = PostProcess.keepCovered(Parameters.testGold, Parameters.testGoldCovered, bestParseFile, bestParseCoveredFile);
        }
    }

    private void runBitPar() {
        try {
            String bitparApp = "/home/fsangati/SOFTWARE/BitPar_Last/bitpar";
            String bitparArgs = "-s TOP -b " + Parameters.nBest + " -vp ";
            Process p = Runtime.getRuntime().exec(String.valueOf(bitparApp) + " " + bitparArgs + " grammar lexicon " + Parameters.testExtrWords, null, new File(Parameters.outputPath));
            Parser.redirectOutput(p, nbestParsesFile, true);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    private void runEvalB() {
        try {
            String evalbApp = "/home/fsangati/SOFTWARE/EVALB/evalb";
            String paramFolder = "/home/fsangati/SOFTWARE/EVALB/param/";
            String evalbArgs = "-p " + paramFolder + "collins" + Parameters.lengthLimitTest + ".prm";
            String evalbArgsUL = "-p " + paramFolder + "collins" + Parameters.lengthLimitTest + ".UL.prm";
            File parserScoresFile = new File(String.valueOf(Parameters.outputPath) + "EvalB" + ".scores");
            File parserScoresULFile = new File(String.valueOf(Parameters.outputPath) + "EvalB" + ".scores.UL");
            File parserScoresCoveredFile = new File(String.valueOf(Parameters.outputPath) + "EvalB" + ".covered.scores");
            File parserScoresCoveredULFile = new File(String.valueOf(Parameters.outputPath) + "EvalB" + ".covered.scores.UL");
            Process p = Runtime.getRuntime().exec(String.valueOf(evalbApp) + " " + evalbArgs + " " + Parameters.testGold + " " + bestParseFile);
            Parser.redirectOutput(p, parserScoresFile, false);
            p = Runtime.getRuntime().exec(String.valueOf(evalbApp) + " " + evalbArgsUL + " " + Parameters.testGold + " " + bestParseFile);
            Parser.redirectOutput(p, parserScoresULFile, false);
            if (Parameters.makeCoveredStatistics) {
                p = Runtime.getRuntime().exec(String.valueOf(evalbApp) + " " + Parameters.testGoldCovered + " " + bestParseCoveredFile + " " + evalbArgs, null, new File(Parameters.outputPath));
                Parser.redirectOutput(p, parserScoresCoveredFile, false);
                p = Runtime.getRuntime().exec(String.valueOf(evalbApp) + " " + Parameters.testGoldCovered + " " + bestParseCoveredFile + " " + evalbArgsUL, null, new File(Parameters.outputPath));
                Parser.redirectOutput(p, parserScoresCoveredULFile, false);
            }
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    private void runEvalF() {
        File parserScoresFile = new File(String.valueOf(Parameters.outputPath) + "EvalF" + ".scores");
        File evalFLog = new File(String.valueOf(Parameters.outputPath) + "EvalF" + ".log");
        File parserScoresULFile = new File(String.valueOf(Parameters.outputPath) + "EvalF" + ".scores.UL");
        File parserScoresCoveredFile = new File(String.valueOf(Parameters.outputPath) + "EvalF" + ".covered.scores");
        File evalFLogCovered = new File(String.valueOf(Parameters.outputPath) + "EvalF" + ".covered.log");
        File parserScoresCoveredULFile = new File(String.valueOf(Parameters.outputPath) + "EvalF" + ".covered.scores.UL");
        File resultFile = new File(String.valueOf(Parameters.outputPath) + "Results.EvalF.txt");
        EvalF.MAX_SENTENCE_LENGTH = Parameters.lengthLimitTest;
        float[] results = EvalF.staticEvalF(Parameters.testGold, bestParseFile, parserScoresFile, evalFLog, true);
        float[] resultsUL = EvalF.staticEvalF(Parameters.testGold, bestParseFile, parserScoresULFile, false);
        if (Parameters.makeCoveredStatistics) {
            new EvalF(Parameters.testGoldCovered, bestParseCoveredFile, parserScoresCoveredFile, evalFLogCovered, true);
            new EvalF(Parameters.testGoldCovered, bestParseCoveredFile, parserScoresCoveredULFile, false);
        }
        String resultReport = String.valueOf(Arrays.toString(results)) + "\n" + Arrays.toString(resultsUL);
        FileUtil.append(resultReport, resultFile);
        if (Parameters.makeOracleStatistics) {
            File oracleFile = new File(String.valueOf(Parameters.outputPath) + "oracle.best");
            File oracleScore = new File(String.valueOf(Parameters.outputPath) + "EvalF" + ".oracle.scores");
            Oracle.processFile(nbestParsesFile, Parameters.testGold, oracleFile);
            new EvalF(Parameters.testGold, oracleFile, oracleScore, true);
        }
    }

    private static void redirectOutput(Process p, File outFile, boolean printProgress) {
        try {
            String s = null;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            PrintWriter pw = FileUtil.getPrintWriter(outFile);
            int sentenceIndex = 1;
            if (printProgress) {
                PrintProgress.start("Running bitpar, outputted lines:");
            }
            while ((s = stdInput.readLine()) != null) {
                pw.println(s);
                if (!printProgress || s.length() == 0 || s.startsWith("vitprob")) continue;
                PrintProgress.next();
                ++sentenceIndex;
            }
            if (printProgress) {
                PrintProgress.end();
            }
            p.getInputStream().close();
            p.getOutputStream().close();
            p.getErrorStream().close();
            pw.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
    }

    private static void printResults(int[] coveredTotal, File score, File scoreUL, File scoreCovered, File scoreCoveredUL, String resultFile) {
        String prefix = "Bracketing FMeasure";
        String scoreValue = FileUtil.getLineInFileStartingWith(score, prefix).split("=")[1].trim();
        String scoreULValue = FileUtil.getLineInFileStartingWith(scoreUL, prefix).split("=")[1].trim();
        String scoreCoveredValue = FileUtil.getLineInFileStartingWith(scoreCovered, prefix).split("=")[1].trim();
        String scoreCoveredULValue = FileUtil.getLineInFileStartingWith(scoreCoveredUL, prefix).split("=")[1].trim();
        File resultCompressed = new File(String.valueOf(Parameters.outputPath) + resultFile);
        if (resultCompressed.length() == 0L) {
            String firstLine = "covered\ttotal\tscore\tscoreUL\tscoreCovered\tscoreCoveredUL\n";
            FileUtil.append(firstLine, resultCompressed);
        }
        String results = String.valueOf(coveredTotal[0]) + "\t" + coveredTotal[1] + "\t" + scoreValue + "\t" + scoreULValue + "\t" + scoreCoveredValue + "\t" + scoreCoveredULValue;
        FileUtil.append(results, resultCompressed);
    }
}

