/*
 * Decompiled with CFR 0.152.
 */
package tsg.parseEval;

import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import tsg.Constituency;
import tsg.IndexConstituency;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelConstituency;
import util.FileUtil;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvalF {
    public static boolean LABELED = true;
    public static boolean REMOVE_SEMANTIC_TAGS = true;
    public static int MAX_SENTENCE_LENGTH = 40;
    public static boolean COUNT_YIELD = false;
    String defaultEncoding = "UTF-8";
    public static String[] EXCLUDE_CAT = new String[]{"TOP"};
    public static String[] EXCLUDE_POS = new String[0];
    public static String[] DELETE_POS = new String[]{"-NONE-"};
    public static String[][] EQUAL_LABELS = new String[][]{{"PRT", "ADVP"}};
    public static NumberFormat formatter = new DecimalFormat("0.00");
    PrintWriter out;
    PrintWriter log;
    int sentences;
    int totalMatchBrackets;
    int totalGoldBrackets;
    int totalTestBrackets;
    int totalCrossBracket;
    int totalWords;
    int totalCorrectTags;
    int totalExactMatch;
    int noCrossing;
    int twoOrLessCrossing;
    float totalRecallPercentage;
    float totalPrecisionPercentage;
    float taggingAccuracyPercentage;
    Hashtable<String, Integer> crossingBracketsCatTable;
    Hashtable<String, int[]> categoryStatistics;
    Hashtable<String, Integer> wrongCatStatistics;
    int totalCategoryGold;
    int sentencesMSL;
    int totalMatchBracketsMSL;
    int totalGoldBracketsMSL;
    int totalTestBracketsMSL;
    int totalCrossBracketMSL;
    int totalWordsMSL;
    int totalCorrectTagsMSL;
    int totalExactMatchMSL;
    int noCrossingMSL;
    int twoOrLessCrossingMSL;
    float totalRecallPercentageMSL;
    float totalPrecisionPercentageMSL;
    float taggingAccuracyPercentageMSL;
    HashSet<Integer> skipSentences;

    public EvalF() {
    }

    public EvalF(File goldFile, File testFile, File outputFile, File logFile, Boolean labeled) {
        this.makeEval(goldFile, testFile, outputFile, logFile, labeled);
    }

    public EvalF(File goldFile, File testFile, File outputFile, Boolean labeled) {
        this(goldFile, testFile, outputFile, null, labeled);
    }

    public EvalF(File goldFile, File testFile, File outputFile) {
        this(goldFile, testFile, outputFile, null);
    }

    public static float[] staticEvalF(File goldFile, File testFile, File outputFile, File logFile, Boolean labeled) {
        EvalF EF = new EvalF();
        return EF.makeEval(goldFile, testFile, outputFile, logFile, labeled);
    }

    public static float[] staticEvalF(File goldFile, File testFile, File outputFile, Boolean labeled) {
        EvalF EF = new EvalF();
        return EF.makeEval(goldFile, testFile, outputFile, null, labeled);
    }

    public float[] makeEval(File goldFile, File testFile, File outputFile, File logFile, Boolean labeled) {
        this.skipSentences = new HashSet();
        if (labeled != null) {
            LABELED = labeled;
        }
        Arrays.sort(EXCLUDE_CAT);
        Arrays.sort(EXCLUDE_POS);
        Arrays.sort(DELETE_POS);
        ArrayList<TSNodeLabel> goldCorpus = null;
        ArrayList<TSNodeLabel> testCorpus = null;
        try {
            goldCorpus = TSNodeLabel.getTreebank(goldFile, this.defaultEncoding, Integer.MAX_VALUE);
            testCorpus = TSNodeLabel.getTreebank(testFile, this.defaultEncoding, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.out = FileUtil.getPrintWriter(outputFile);
        PrintWriter printWriter = this.log = logFile == null ? null : FileUtil.getPrintWriter(logFile);
        if (REMOVE_SEMANTIC_TAGS) {
            TSNodeLabel.removeSemanticTags(testCorpus);
            TSNodeLabel.removeSemanticTags(goldCorpus);
        }
        if (EQUAL_LABELS != null) {
            String[][] stringArray = EQUAL_LABELS;
            int n = EQUAL_LABELS.length;
            int n2 = 0;
            while (n2 < n) {
                String[] equalPairs = stringArray[n2];
                TSNodeLabel.replaceLabelTreebank(testCorpus, equalPairs[0], equalPairs[1]);
                TSNodeLabel.replaceLabelTreebank(goldCorpus, equalPairs[0], equalPairs[1]);
                ++n2;
            }
        }
        if (!this.areComparable(testCorpus, goldCorpus)) {
            return null;
        }
        if (LABELED) {
            this.categoryStatistics = new Hashtable();
            this.wrongCatStatistics = new Hashtable();
            if (!COUNT_YIELD) {
                this.crossingBracketsCatTable = new Hashtable();
            }
        }
        this.printHeader();
        int i = 0;
        while (i < goldCorpus.size()) {
            TSNodeLabel TNgold = goldCorpus.get(i);
            TSNodeLabel TNtest = testCorpus.get(i);
            this.updateStatistics(i + 1, TNgold, TNtest);
            ++i;
        }
        this.printFinalStatistics();
        if (LABELED) {
            this.printCategoryStatistics();
            this.printWrongCatStatistics();
        }
        float[] results = this.printSummaryStatistics();
        this.out.close();
        if (this.log != null) {
            this.log.close();
        }
        return results;
    }

    public void writeLog(String logString) {
        if (this.log != null) {
            this.log.println(logString);
        }
    }

    private boolean areComparable(ArrayList<TSNodeLabel> testCorpus, ArrayList<TSNodeLabel> goldCorpus) {
        if (testCorpus.size() != goldCorpus.size()) {
            String report = "Sentences in testFile and goldFile don't match in number (" + testCorpus.size() + "|" + goldCorpus.size() + ")";
            System.err.println(report);
            this.writeLog(report);
            return false;
        }
        int i = 0;
        while (i < testCorpus.size()) {
            TSNodeLabel testTree = testCorpus.get(i);
            TSNodeLabel goldTree = goldCorpus.get(i);
            if (DELETE_POS.length > 0) {
                testTree.pruneSubTrees(DELETE_POS);
                goldTree.pruneSubTrees(DELETE_POS);
            }
            ArrayList<TSNodeLabel> testLexicon = testTree.collectLexicalItems();
            ArrayList<TSNodeLabel> goldLexicon = goldTree.collectLexicalItems();
            if (testLexicon.size() != goldLexicon.size()) {
                String report = i + 1 + " : " + "Length test|gold unmatch (" + testLexicon.size() + "|" + goldLexicon.size() + ")";
                System.err.println(report);
                this.writeLog(report);
                this.skipSentences.add(new Integer(i));
            } else {
                int j = 0;
                while (j < testLexicon.size()) {
                    String goldWord;
                    String testWord = ((TSNodeLabel)testLexicon.get(j)).label();
                    if (!testWord.equals(goldWord = ((TSNodeLabel)goldLexicon.get(j)).label())) {
                        String report = i + 1 + " : " + "Words test|gold unmatch (" + testWord + "|" + goldWord + ")";
                        System.err.println(report);
                        this.writeLog(report);
                        this.skipSentences.add(new Integer(i));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public void updateStatistics(int index, TSNodeLabel TNgold, TSNodeLabel TNtest) {
        boolean compatible;
        boolean bl = compatible = !this.skipSentences.contains(new Integer(index - 1));
        if (!compatible && !COUNT_YIELD) {
            this.out.println(String.valueOf(Utility.fsb(4, Integer.toString(index))) + ' ' + Utility.fca(73, " SKIPPED SENTENCE ", '-'));
            return;
        }
        if (DELETE_POS.length > 0) {
            TNgold.pruneSubTrees(DELETE_POS);
            TNtest.pruneSubTrees(DELETE_POS);
        }
        int length = TNgold.countLexicalNodes();
        List<Constituency> goldConst = TNgold.collectConsituencies(LABELED, EXCLUDE_CAT, COUNT_YIELD);
        ArrayList<Constituency> goldConstCopy = new ArrayList<Constituency>(goldConst);
        List<Constituency> testConst = TNtest.collectConsituencies(LABELED, EXCLUDE_CAT, COUNT_YIELD);
        ArrayList<Constituency> testConstCopy = new ArrayList<Constituency>(testConst);
        int goldBrackets = goldConst.size();
        int testBrackets = testConst.size();
        ArrayList<Constituency> matchedConst = new ArrayList<Constituency>();
        for (Constituency c : testConst) {
            if (!goldConstCopy.contains(c)) continue;
            matchedConst.add(c);
            goldConstCopy.remove(c);
            testConstCopy.remove(c);
        }
        if (this.log != null) {
            List<Constituency> unmatchedGold = goldConstCopy;
            List<Constituency> unmatchedTest = testConstCopy;
            if (!COUNT_YIELD) {
                unmatchedGold = IndexConstituency.toYieldConstituency(unmatchedGold, TNgold);
                unmatchedTest = IndexConstituency.toYieldConstituency(unmatchedTest, TNtest);
            }
            this.log.println("Sentence: " + index + "\n" + "\tGold: " + TNgold + "\n" + "\tTest: " + TNtest + "\n" + "\tUnmatched Gold: " + unmatchedGold + "\n" + "\tUnmatched Test: " + unmatchedTest + "\n\n");
        }
        if (LABELED) {
            this.updateCategoryStatistics(testConst, goldConst, matchedConst);
            this.updateWrongCatStatistics(testConstCopy, goldConstCopy);
        }
        int words = TNtest.countLexicalNodesExcludingLexLabels(EXCLUDE_POS);
        int matchBrackets = matchedConst.size();
        float recallPercentage = (float)matchBrackets * 100.0f / (float)goldBrackets;
        float precisionPercentage = (float)matchBrackets * 100.0f / (float)testBrackets;
        int correctTags = -1;
        float tagAccuracyPercentage = -1.0f;
        if (compatible) {
            correctTags = TNtest.countCorrectPOS(TNgold, EXCLUDE_POS);
            tagAccuracyPercentage = (float)correctTags * 100.0f / (float)words;
        }
        boolean exactMatch = matchBrackets == testBrackets && matchBrackets == goldBrackets;
        int crossBracket = -1;
        if (!COUNT_YIELD) {
            crossBracket = IndexConstituency.updateCrossingBrackets(testConst, goldConst, this.crossingBracketsCatTable);
        }
        DecimalFormat formatter = new DecimalFormat("0.00");
        this.out.println(String.valueOf(Utility.fsb(4, Integer.toString(index))) + (compatible ? (char)' ' : '*') + Utility.fsb(6, Integer.toString(length)) + ' ' + Utility.fsb(7, formatter.format(recallPercentage)) + ' ' + Utility.fsb(7, formatter.format(precisionPercentage)) + ' ' + Utility.fsb(7, Integer.toString(matchBrackets)) + ' ' + Utility.fsb(6, Integer.toString(goldBrackets)) + ' ' + Utility.fsb(6, Integer.toString(testBrackets)) + ' ' + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, Integer.toString(crossBracket))) + ' ' + Utility.fsb(6, Integer.toString(words)) + ' ' + (compatible ? Utility.fsb(5, Integer.toString(correctTags)) : Utility.fsb(5, "-")) + ' ' + (compatible ? Utility.fsb(7, formatter.format(tagAccuracyPercentage)) : Utility.fsb(7, "-")));
        ++this.sentences;
        this.totalMatchBrackets += matchBrackets;
        this.totalGoldBrackets += goldBrackets;
        this.totalTestBrackets += testBrackets;
        this.totalWords += words;
        this.totalCorrectTags += correctTags;
        if (exactMatch) {
            ++this.totalExactMatch;
        }
        if (!COUNT_YIELD) {
            this.totalCrossBracket += crossBracket;
            if (crossBracket == 0) {
                ++this.noCrossing;
            }
            if (crossBracket <= 2) {
                ++this.twoOrLessCrossing;
            }
        }
        if (length <= MAX_SENTENCE_LENGTH) {
            ++this.sentencesMSL;
            this.totalMatchBracketsMSL += matchBrackets;
            this.totalGoldBracketsMSL += goldBrackets;
            this.totalTestBracketsMSL += testBrackets;
            this.totalWordsMSL += words;
            this.totalCorrectTagsMSL += correctTags;
            if (exactMatch) {
                ++this.totalExactMatchMSL;
            }
            if (!COUNT_YIELD) {
                this.totalCrossBracketMSL += crossBracket;
                if (crossBracket == 0) {
                    ++this.noCrossingMSL;
                }
                if (crossBracket <= 2) {
                    ++this.twoOrLessCrossingMSL;
                }
            }
        }
    }

    public static float getScore(TSNodeLabel TNgold, TSNodeLabel TNtest) {
        if (REMOVE_SEMANTIC_TAGS) {
            TNgold.removeSemanticTags();
            TNtest.removeSemanticTags();
        }
        List<Constituency> goldConst = TNgold.collectConsituencies(LABELED, EXCLUDE_CAT, COUNT_YIELD);
        ArrayList<Constituency> goldConstCopy = new ArrayList<Constituency>(goldConst);
        List<Constituency> testConst = TNtest.collectConsituencies(LABELED, EXCLUDE_CAT, COUNT_YIELD);
        ArrayList<Constituency> testConstCopy = new ArrayList<Constituency>(testConst);
        int goldBrackets = goldConst.size();
        int testBrackets = testConst.size();
        ArrayList<Constituency> matchedConst = new ArrayList<Constituency>();
        for (Constituency c : testConst) {
            if (!goldConstCopy.contains(c)) continue;
            matchedConst.add(c);
            goldConstCopy.remove(c);
            testConstCopy.remove(c);
        }
        int matchBrackets = matchedConst.size();
        return EvalF.fscore(matchBrackets, goldBrackets, testBrackets);
    }

    public static float fscore(int[] scores) {
        return EvalF.fscore(scores[0], scores[1], scores[2]);
    }

    public static float fscore(int matchBrackets, int goldBrackets, int parsedBrackets) {
        float recall = (float)matchBrackets / (float)goldBrackets;
        float precision = (float)matchBrackets / (float)parsedBrackets;
        return recall == 0.0f && precision == 0.0f ? 0.0f : 2.0f * recall * precision / (recall + precision);
    }

    public static int[] getScores(TSNodeLabel TNgold, TSNodeLabel TNtest) {
        if (REMOVE_SEMANTIC_TAGS) {
            TNgold.removeSemanticTags();
            TNtest.removeSemanticTags();
        }
        List<Constituency> goldConst = TNgold.collectConsituencies(LABELED, EXCLUDE_CAT, COUNT_YIELD);
        ArrayList<Constituency> goldConstCopy = new ArrayList<Constituency>(goldConst);
        List<Constituency> parsedConst = TNtest.collectConsituencies(LABELED, EXCLUDE_CAT, COUNT_YIELD);
        ArrayList<Constituency> testConstCopy = new ArrayList<Constituency>(parsedConst);
        int goldBrackets = goldConst.size();
        int parsedBrackets = parsedConst.size();
        ArrayList<Constituency> matchedConst = new ArrayList<Constituency>();
        for (Constituency c : parsedConst) {
            if (!goldConstCopy.contains(c)) continue;
            matchedConst.add(c);
            goldConstCopy.remove(c);
            testConstCopy.remove(c);
        }
        int matchBrackets = matchedConst.size();
        return new int[]{matchBrackets, goldBrackets, parsedBrackets};
    }

    public static ArrayList<TSNodeLabel>[] getDiff(TSNodeLabel TNgold, TSNodeLabel TNtest) {
        List<TSNodeLabelConstituency> goldConst = TNgold.collectConsituencies();
        ArrayList<TSNodeLabelConstituency> goldConstDiff = new ArrayList<TSNodeLabelConstituency>(goldConst);
        List<TSNodeLabelConstituency> testConst = TNtest.collectConsituencies();
        ArrayList<TSNodeLabelConstituency> testConstDiff = new ArrayList<TSNodeLabelConstituency>(testConst);
        for (TSNodeLabelConstituency c : testConst) {
            goldConstDiff.remove(c);
        }
        for (TSNodeLabelConstituency c : goldConst) {
            testConstDiff.remove(c);
        }
        ArrayList<TSNodeLabel> goldConstDiffArray = new ArrayList<TSNodeLabel>();
        ArrayList<TSNodeLabel> testConstDiffArray = new ArrayList<TSNodeLabel>();
        for (TSNodeLabelConstituency c : goldConstDiff) {
            goldConstDiffArray.add(c.getOriginalNode());
        }
        for (TSNodeLabelConstituency c : testConstDiff) {
            testConstDiffArray.add(c.getOriginalNode());
        }
        ArrayList[] diffGoldGuess = new ArrayList[]{goldConstDiffArray, testConstDiffArray};
        return diffGoldGuess;
    }

    public void updateCategoryStatistics(List<Constituency> goldConst, List<Constituency> testConst, List<Constituency> matchedConst) {
        this.totalCategoryGold += goldConst.size();
        for (Constituency c : goldConst) {
            Utility.increaseStringIntArray(this.categoryStatistics, 3, c.label(), 0, 1);
        }
        for (Constituency c : testConst) {
            Utility.increaseStringIntArray(this.categoryStatistics, 3, c.label(), 1, 1);
        }
        for (Constituency c : matchedConst) {
            Utility.increaseStringIntArray(this.categoryStatistics, 3, c.label(), 2, 1);
        }
    }

    public void updateWrongCatStatistics(List<Constituency> wrongTestConst, List<Constituency> wrongGoldConst) {
        ArrayList<Constituency> ULwrongTestConst = new ArrayList<Constituency>();
        for (Constituency C : wrongTestConst) {
            ULwrongTestConst.add(C.unlabeledCopy());
        }
        ArrayList<Constituency> ULwrongGoldConst = new ArrayList<Constituency>();
        for (Constituency C : wrongGoldConst) {
            ULwrongGoldConst.add(C.unlabeledCopy());
        }
        int indexGold = -1;
        for (Constituency C : ULwrongGoldConst) {
            ++indexGold;
            int indexTest = ULwrongTestConst.indexOf(C);
            if (indexTest <= -1) continue;
            Constituency labelTest = wrongTestConst.get(indexTest);
            Constituency labelGold = wrongGoldConst.get(indexGold);
            String key = String.valueOf(labelTest.label()) + "/" + labelGold.label();
            Utility.increaseStringInteger(this.wrongCatStatistics, key, 1);
        }
    }

    public void printHeader() {
        this.out.println(String.valueOf(Utility.fsb(11, "Sentence")) + ' ' + Utility.fsb(15, "") + ' ' + Utility.fsb(7, "Matched") + ' ' + Utility.fca(13, "Brackets", ' ') + ' ' + Utility.fsb(7, "Cross") + ' ' + Utility.fsb(6, "") + ' ' + Utility.fsb(5, "Corr") + ' ' + Utility.fsb(7, "Tag"));
        this.out.println(String.valueOf(Utility.fsb(4, "ID")) + ' ' + Utility.fsb(6, "Length") + ' ' + Utility.fsb(7, "Recall") + ' ' + Utility.fsb(7, "Precis") + ' ' + Utility.fsb(7, "Bracket") + ' ' + Utility.fsb(6, "gold") + ' ' + Utility.fsb(6, "test") + ' ' + Utility.fsb(7, "Bracket") + ' ' + Utility.fsb(6, "Words") + ' ' + Utility.fsb(5, "Tags") + ' ' + Utility.fsb(7, "Accracy"));
        this.out.println(Utility.fillChar(78, '_'));
    }

    private void calculateFinalResults() {
        this.totalRecallPercentage = (float)this.totalMatchBrackets * 100.0f / (float)this.totalGoldBrackets;
        this.totalPrecisionPercentage = (float)this.totalMatchBrackets * 100.0f / (float)this.totalTestBrackets;
        this.taggingAccuracyPercentage = (float)this.totalCorrectTags * 100.0f / (float)this.totalWords;
        this.totalRecallPercentageMSL = (float)this.totalMatchBracketsMSL * 100.0f / (float)this.totalGoldBracketsMSL;
        this.totalPrecisionPercentageMSL = (float)this.totalMatchBracketsMSL * 100.0f / (float)this.totalTestBracketsMSL;
        this.taggingAccuracyPercentageMSL = (float)this.totalCorrectTagsMSL * 100.0f / (float)this.totalWordsMSL;
    }

    public void printFinalStatistics() {
        this.calculateFinalResults();
        this.out.println(Utility.fillChar(78, '_'));
        this.out.println(String.valueOf(Utility.fsb(4, "")) + ' ' + Utility.fsb(6, "") + ' ' + Utility.fsb(7, formatter.format(this.totalRecallPercentage)) + ' ' + Utility.fsb(7, formatter.format(this.totalPrecisionPercentage)) + ' ' + Utility.fsb(7, Integer.toString(this.totalMatchBrackets)) + ' ' + Utility.fsb(6, Integer.toString(this.totalGoldBrackets)) + ' ' + Utility.fsb(6, Integer.toString(this.totalTestBrackets)) + ' ' + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, Integer.toString(this.totalCrossBracket))) + ' ' + Utility.fsb(6, Integer.toString(this.totalWords)) + ' ' + Utility.fsb(5, Integer.toString(this.totalCorrectTags)) + ' ' + Utility.fsb(7, formatter.format(this.taggingAccuracyPercentage)));
    }

    public void printCategoryStatistics() {
        this.out.println();
        this.out.println(Utility.fca(58, " Category Statistics ", '_'));
        this.out.println();
        this.out.println(String.valueOf(Utility.fsb(10, "label")) + Utility.fsb(12, "% gold") + Utility.fsb(12, "catRecall") + Utility.fsb(12, "catPrecis") + Utility.fsb(12, "catFScore"));
        this.out.println(Utility.fillChar(58, '_'));
        IdentityHashMap<Float, String> orderedCategory = new IdentityHashMap<Float, String>();
        for (String label : this.categoryStatistics.keySet()) {
            int[] values = this.categoryStatistics.get(label);
            float percentageGold = (float)values[1] * 100.0f / (float)this.totalCategoryGold;
            float catRecall = (float)values[2] * 100.0f / (float)values[0];
            float catPrecision = (float)values[2] * 100.0f / (float)values[1];
            float catFScore = 2.0f * catRecall * catPrecision / (catRecall + catPrecision);
            String line = String.valueOf(Utility.fsb(10, label)) + Utility.fsb(12, formatter.format(percentageGold)) + Utility.fsb(12, formatter.format(catRecall)) + Utility.fsb(12, formatter.format(catPrecision)) + Utility.fsb(12, formatter.format(catFScore));
            orderedCategory.put(Float.valueOf(percentageGold), line);
        }
        Object[] percentageSorted = orderedCategory.keySet().toArray(new Float[0]);
        Arrays.sort(percentageSorted);
        int i = percentageSorted.length - 1;
        while (i >= 0) {
            String line = (String)orderedCategory.get(percentageSorted[i]);
            this.out.println(line);
            --i;
        }
        this.out.println();
        if (!COUNT_YIELD) {
            this.out.println(Utility.fsb(20, "Crossing brackets"));
            this.out.println(String.valueOf(Utility.fsb(12, "test/gold")) + Utility.fsb(8, "count"));
            this.out.println(Utility.fillChar(20, '_'));
            IdentityHashMap<Integer, String> reversedTable = Utility.reverseStringIntegerTable(this.crossingBracketsCatTable);
            Object[] countSorted = reversedTable.keySet().toArray(new Integer[0]);
            Arrays.sort(countSorted);
            int i2 = countSorted.length - 1;
            while (i2 >= 0) {
                Object count = countSorted[i2];
                String pair = reversedTable.get(count);
                this.out.println(String.valueOf(Utility.fsb(12, pair)) + Utility.fsb(8, ((Integer)count).toString()));
                --i2;
            }
            this.out.println();
        }
    }

    public void printWrongCatStatistics() {
        this.out.println(Utility.fsb(20, "Wrong Category Statistics"));
        this.out.println(String.valueOf(Utility.fsb(12, "test/gold")) + Utility.fsb(8, "count"));
        this.out.println(Utility.fillChar(20, '_'));
        IdentityHashMap<Integer, String> reversedTable = Utility.reverseStringIntegerTable(this.wrongCatStatistics);
        Object[] countSorted = reversedTable.keySet().toArray(new Integer[0]);
        Arrays.sort(countSorted);
        int i = countSorted.length - 1;
        while (i >= 0) {
            Object count = countSorted[i];
            String pair = reversedTable.get(count);
            this.out.println(String.valueOf(Utility.fsb(12, pair)) + Utility.fsb(8, ((Integer)count).toString()));
            --i;
        }
        this.out.println();
    }

    public float[] printSummaryStatistics() {
        float totalFMeasurePercentage = 2.0f * this.totalRecallPercentage * this.totalPrecisionPercentage / (this.totalRecallPercentage + this.totalPrecisionPercentage);
        float averageCrossing = COUNT_YIELD ? 0.0f : (float)this.totalCrossBracket / (float)this.sentences;
        float completeMatchPercentage = (float)this.totalExactMatch * 100.0f / (float)this.sentences;
        float noCrossingPercentage = COUNT_YIELD ? 0.0f : (float)this.noCrossing * 100.0f / (float)this.sentences;
        float twoOrLessCrossingPercentage = COUNT_YIELD ? 0.0f : (float)this.twoOrLessCrossing * 100.0f / (float)this.sentences;
        float totalFMeasurePercentageMSL = 2.0f * this.totalRecallPercentageMSL * this.totalPrecisionPercentageMSL / (this.totalRecallPercentageMSL + this.totalPrecisionPercentageMSL);
        float averageCrossingMSL = COUNT_YIELD ? 0.0f : (float)this.totalCrossBracketMSL / (float)this.sentencesMSL;
        float completeMatchPercentageMSL = (float)this.totalExactMatchMSL * 100.0f / (float)this.sentencesMSL;
        float noCrossingPercentageMSL = COUNT_YIELD ? 0.0f : (float)this.noCrossingMSL * 100.0f / (float)this.sentencesMSL;
        float twoOrLessCrossingPercentageMSL = COUNT_YIELD ? 0.0f : (float)this.twoOrLessCrossingMSL * 100.0f / (float)this.sentencesMSL;
        this.out.println();
        this.out.println(Utility.fca(34, " Summary ", '_'));
        this.out.println();
        this.out.println(Utility.fca(34, " All ", '_'));
        this.out.println("Number of sentence        =" + Utility.fsb(7, Integer.toString(this.sentences)) + "\n" + "Bracketing Recall         =" + Utility.fsb(7, formatter.format(this.totalRecallPercentage)) + "\n" + "Bracketing Precision      =" + Utility.fsb(7, formatter.format(this.totalPrecisionPercentage)) + "\n" + "Bracketing FMeasure       =" + Utility.fsb(7, formatter.format(totalFMeasurePercentage)) + "\n" + "Complete match            =" + Utility.fsb(7, formatter.format(completeMatchPercentage)) + "\n" + "Average crossing          =" + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, formatter.format(averageCrossing))) + "\n" + "No crossing               =" + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, formatter.format(noCrossingPercentage))) + "\n" + "2 or less crossing        =" + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, formatter.format(twoOrLessCrossingPercentage))) + "\n" + "Tagging accuracy          =" + Utility.fsb(7, formatter.format(this.taggingAccuracyPercentage)));
        this.out.println();
        this.out.println(Utility.fca(34, " len<=" + MAX_SENTENCE_LENGTH + " ", '_'));
        this.out.println("Number of sentence        =" + Utility.fsb(7, Integer.toString(this.sentencesMSL)) + "\n" + "Bracketing Recall         =" + Utility.fsb(7, formatter.format(this.totalRecallPercentageMSL)) + "\n" + "Bracketing Precision      =" + Utility.fsb(7, formatter.format(this.totalPrecisionPercentageMSL)) + "\n" + "Bracketing FMeasure       =" + Utility.fsb(7, formatter.format(totalFMeasurePercentageMSL)) + "\n" + "Complete match            =" + Utility.fsb(7, formatter.format(completeMatchPercentageMSL)) + "\n" + "Average crossing          =" + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, formatter.format(averageCrossingMSL))) + "\n" + "No crossing               =" + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, formatter.format(noCrossingPercentageMSL))) + "\n" + "2 or less crossing        =" + (COUNT_YIELD ? Utility.fsb(7, "-") : Utility.fsb(7, formatter.format(twoOrLessCrossingPercentageMSL))) + "\n" + "Tagging accuracy          =" + Utility.fsb(7, formatter.format(this.taggingAccuracyPercentageMSL)));
        return new float[]{this.totalRecallPercentage, this.totalPrecisionPercentage, totalFMeasurePercentage};
    }

    public static void main1() {
        String basePath = "/scratch/fsangati/RESULTS/TSG/DOP_SD_Reranker/";
        File gold = new File(String.valueOf(basePath) + "wsj-22_gold.mrg");
        File test = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.mrg");
        File evalF = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.evalF");
        float[] rerankedFScore = EvalF.staticEvalF(gold, test, evalF, true);
        System.out.println("Reranked Recall Precision FScore: " + Arrays.toString(rerankedFScore));
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Error. Correct usage: EvalF goldFile testFile ouputFile");
            return;
        }
        File gold = new File(args[0]);
        File test = new File(args[1]);
        File evalF = new File(args[2]);
        float[] rerankedFScore = EvalF.staticEvalF(gold, test, evalF, true);
        System.out.println("Reranked Recall Precision FScore: " + Arrays.toString(rerankedFScore));
    }
}

