# This will be the common prelude to all of our DoctorWho queries. 

import sys     # talk to the operating system 
import os.path # manipulate paths to files, directories 
import pickle  # read/write pickled python dictionaries 
import pprint  # pretty print JSON

data_dir = sys.argv[1] # first command-line argument -- the directory of data 

# use os.path.join so that path works on both Windows and Unix 
doctorwho_path = os.path.join(data_dir, 'imdb_doctorwho_database_v3.pickled')


# open data dictionary file and un-pickle it
doctorwhoFile = open(doctorwho_path, mode= "rb")
doctorwho     = pickle.load(doctorwhoFile)


def display_ans(line_limit, ans):
    ans = sorted(ans) # Sort into ascending order
    ans = ans[0:line_limit]  # Limit number of entries
    for item in ans:
        print(f'{item}')
    print(f'Returned {len(ans)} records')


#####################################
# write your query code here ... 

#arg2    = sys.argv[2] # second command-line argument
#arg3    = sys.argv[3] # third command-line argument

# ...  
