#ifndef REVWORDS_H
#define REVWORDS_H 0 

/* reverse_substring(s, start, end) function takes a string s, and two
   integer indices start and end identifying the start and end of a
   substring of s.

   The function may assume that start and end are both valid indices 
   into the string. 
*/

extern void reverse_substring(char str[], int start, int end);

/* find_word_start(s, len, i) takes a string s of length len, and 
   an index i (which must be strictly less than len). 

   It then returns the index k which is the starting position of
   the next word beginning at position i or later. 

   If no such index exists, then it should return -1. 

*/

extern int find_next_start(char str[], int len, int i);

/* find_word_end(s, len, i) takes a string s of length len, and 
   an index i (which must be strictly less than len). 

   It returns the first index k past the end of the word starting
   at i. 
*/

extern int find_next_end(char str[], int len, int i);

/* reverse_words(s) takes a string s, and reverses all of the
   words in it. 

   Here, a "word" is defined as a contiguous sequence of alphabetic
   characters.
*/

extern void reverse_words(char s[]);

#endif /* REVWORDS_H */
