//megafunction wizard: %Altera SOPC Builder%
//GENERATION: STANDARD
//VERSION: WM1.0


//Legal Notice: (C)2005 Altera Corporation. All rights reserved.  Your
//use of Altera Corporation's design tools, logic functions and other
//software and tools, and its AMPP partner logic functions, and any
//output files any of the foregoing (including device programming or
//simulation files), and any associated documentation or information are
//expressly subject to the terms and conditions of the Altera Program
//License Subscription Agreement or other applicable license agreement,
//including, without limitation, that your use is for the sole purpose
//of programming logic devices manufactured by Altera and sold by Altera
//or its authorized distributors.  Please refer to the applicable
//agreement for further details.

// synthesis translate_off
`timescale 1ns / 100ps
// synthesis translate_on
module keyboard_avalonS_arbitrator (
                                     // inputs:
                                      address_from_the_subsystemMMU_to_slave,
                                      clk,
                                      keyboard_avalonS_dataavailable,
                                      keyboard_avalonS_irq,
                                      keyboard_avalonS_readdata,
                                      read_n_from_the_subsystemMMU,
                                      reset_n,
                                      write_n_from_the_subsystemMMU,

                                     // outputs:
                                      d1_keyboard_avalonS_end_xfer,
                                      keyboard_avalonS_chipselect,
                                      keyboard_avalonS_dataavailable_from_sa,
                                      keyboard_avalonS_irq_from_sa,
                                      keyboard_avalonS_readdata_from_sa,
                                      keyboard_avalonS_reset,
                                      subsystemMMU_avalonM_granted_keyboard_avalonS,
                                      subsystemMMU_avalonM_qualified_request_keyboard_avalonS,
                                      subsystemMMU_avalonM_read_data_valid_keyboard_avalonS,
                                      subsystemMMU_avalonM_requests_keyboard_avalonS
                                   )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           d1_keyboard_avalonS_end_xfer;
  output           keyboard_avalonS_chipselect;
  output           keyboard_avalonS_dataavailable_from_sa;
  output           keyboard_avalonS_irq_from_sa;
  output  [ 15: 0] keyboard_avalonS_readdata_from_sa;
  output           keyboard_avalonS_reset;
  output           subsystemMMU_avalonM_granted_keyboard_avalonS;
  output           subsystemMMU_avalonM_qualified_request_keyboard_avalonS;
  output           subsystemMMU_avalonM_read_data_valid_keyboard_avalonS;
  output           subsystemMMU_avalonM_requests_keyboard_avalonS;
  input   [ 31: 0] address_from_the_subsystemMMU_to_slave;
  input            clk;
  input            keyboard_avalonS_dataavailable;
  input            keyboard_avalonS_irq;
  input   [ 15: 0] keyboard_avalonS_readdata;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input            write_n_from_the_subsystemMMU;

  reg              d1_keyboard_avalonS_end_xfer;
  reg              d1_reasons_to_wait;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             keyboard_avalonS_address_for_slave_wo_address;
  wire             keyboard_avalonS_allgrants;
  wire             keyboard_avalonS_allow_new_arb_cycle;
  wire             keyboard_avalonS_any_continuerequest;
  wire             keyboard_avalonS_arb_counter_enable;
  reg              keyboard_avalonS_arb_share_counter;
  wire             keyboard_avalonS_arb_share_counter_next_value;
  wire             keyboard_avalonS_arb_share_set_values;
  wire             keyboard_avalonS_beginbursttransfer_internal;
  wire             keyboard_avalonS_begins_xfer;
  wire             keyboard_avalonS_chipselect;
  wire             keyboard_avalonS_dataavailable_from_sa;
  wire             keyboard_avalonS_end_xfer;
  wire             keyboard_avalonS_firsttransfer;
  wire             keyboard_avalonS_grant_vector;
  wire             keyboard_avalonS_in_a_read_cycle;
  wire             keyboard_avalonS_in_a_write_cycle;
  wire             keyboard_avalonS_irq_from_sa;
  wire             keyboard_avalonS_master_qreq_vector;
  wire    [ 15: 0] keyboard_avalonS_readdata_from_sa;
  wire             keyboard_avalonS_reset;
  reg              keyboard_avalonS_slavearbiterlockenable;
  wire             keyboard_avalonS_waits_for_read;
  wire             keyboard_avalonS_waits_for_write;
  wire             subsystemMMU_avalonM_arbiterlock;
  wire             subsystemMMU_avalonM_continuerequest;
  wire             subsystemMMU_avalonM_granted_keyboard_avalonS;
  wire             subsystemMMU_avalonM_qualified_request_keyboard_avalonS;
  wire             subsystemMMU_avalonM_read_data_valid_keyboard_avalonS;
  wire             subsystemMMU_avalonM_requests_keyboard_avalonS;
  wire             subsystemMMU_avalonM_saved_grant_keyboard_avalonS;
  wire             wait_for_keyboard_avalonS_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~keyboard_avalonS_end_xfer;
    end


  assign keyboard_avalonS_begins_xfer = ~d1_reasons_to_wait & ((subsystemMMU_avalonM_qualified_request_keyboard_avalonS));
  //assign keyboard_avalonS_readdata_from_sa = keyboard_avalonS_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign keyboard_avalonS_readdata_from_sa = keyboard_avalonS_readdata;

  assign subsystemMMU_avalonM_requests_keyboard_avalonS = (({address_from_the_subsystemMMU_to_slave[31 : 1] , 1'b0} == 32'h20001000) & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)) & ~read_n_from_the_subsystemMMU;
  //assign keyboard_avalonS_dataavailable_from_sa = keyboard_avalonS_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign keyboard_avalonS_dataavailable_from_sa = keyboard_avalonS_dataavailable;

  //keyboard_avalonS_arb_share_counter set values, which is an e_mux
  assign keyboard_avalonS_arb_share_set_values = 1;

  //keyboard_avalonS_arb_share_counter_next_value assignment, which is an e_assign
  assign keyboard_avalonS_arb_share_counter_next_value = keyboard_avalonS_firsttransfer ? (keyboard_avalonS_arb_share_set_values - 1) : |keyboard_avalonS_arb_share_counter ? (keyboard_avalonS_arb_share_counter - 1) : 0;

  //keyboard_avalonS_allgrants all slave grants, which is an e_mux
  assign keyboard_avalonS_allgrants = |keyboard_avalonS_grant_vector;

  //keyboard_avalonS_end_xfer assignment, which is an e_assign
  assign keyboard_avalonS_end_xfer = ~(keyboard_avalonS_waits_for_read | keyboard_avalonS_waits_for_write);

  //keyboard_avalonS_arb_share_counter arbitration counter enable, which is an e_assign
  assign keyboard_avalonS_arb_counter_enable = keyboard_avalonS_end_xfer & keyboard_avalonS_allgrants;

  //keyboard_avalonS_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keyboard_avalonS_arb_share_counter <= 0;
      else if (keyboard_avalonS_arb_counter_enable)
          keyboard_avalonS_arb_share_counter <= keyboard_avalonS_arb_share_counter_next_value;
    end


  //keyboard_avalonS_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keyboard_avalonS_slavearbiterlockenable <= 0;
      else if (|keyboard_avalonS_master_qreq_vector & keyboard_avalonS_end_xfer)
          keyboard_avalonS_slavearbiterlockenable <= |keyboard_avalonS_arb_share_counter_next_value;
    end


  //subsystemMMU/avalonM keyboard/avalonS arbiterlock, which is an e_assign
  assign subsystemMMU_avalonM_arbiterlock = keyboard_avalonS_slavearbiterlockenable & subsystemMMU_avalonM_continuerequest;

  //keyboard_avalonS_any_continuerequest at least one master continues requesting, which is an e_assign
  assign keyboard_avalonS_any_continuerequest = 1;

  //subsystemMMU_avalonM_continuerequest continued request, which is an e_assign
  assign subsystemMMU_avalonM_continuerequest = 1;

  assign subsystemMMU_avalonM_qualified_request_keyboard_avalonS = subsystemMMU_avalonM_requests_keyboard_avalonS;
  //master is always granted when requested
  assign subsystemMMU_avalonM_granted_keyboard_avalonS = subsystemMMU_avalonM_qualified_request_keyboard_avalonS;

  //subsystemMMU/avalonM saved-grant keyboard/avalonS, which is an e_assign
  assign subsystemMMU_avalonM_saved_grant_keyboard_avalonS = subsystemMMU_avalonM_requests_keyboard_avalonS;

  //allow new arb cycle for keyboard/avalonS, which is an e_assign
  assign keyboard_avalonS_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign keyboard_avalonS_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign keyboard_avalonS_master_qreq_vector = 1;

  //~keyboard_avalonS_reset assignment, which is an e_assign
  assign keyboard_avalonS_reset = ~reset_n;

  assign keyboard_avalonS_chipselect = subsystemMMU_avalonM_granted_keyboard_avalonS;
  //keyboard_avalonS_firsttransfer first transaction, which is an e_assign
  assign keyboard_avalonS_firsttransfer = ~(keyboard_avalonS_slavearbiterlockenable & keyboard_avalonS_any_continuerequest);

  //keyboard_avalonS_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign keyboard_avalonS_beginbursttransfer_internal = keyboard_avalonS_begins_xfer & keyboard_avalonS_firsttransfer;

  //keyboard_avalonS_address_for_slave_wo_address mux, which is an e_mux
  assign keyboard_avalonS_address_for_slave_wo_address = address_from_the_subsystemMMU_to_slave >> 1;

  //d1_keyboard_avalonS_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_keyboard_avalonS_end_xfer <= 1;
      else if (1)
          d1_keyboard_avalonS_end_xfer <= keyboard_avalonS_end_xfer;
    end


  //keyboard_avalonS_waits_for_read in a cycle, which is an e_mux
  assign keyboard_avalonS_waits_for_read = keyboard_avalonS_in_a_read_cycle & keyboard_avalonS_begins_xfer;

  //keyboard_avalonS_in_a_read_cycle assignment, which is an e_assign
  assign keyboard_avalonS_in_a_read_cycle = subsystemMMU_avalonM_granted_keyboard_avalonS & ~read_n_from_the_subsystemMMU;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = keyboard_avalonS_in_a_read_cycle;

  //keyboard_avalonS_waits_for_write in a cycle, which is an e_mux
  assign keyboard_avalonS_waits_for_write = keyboard_avalonS_in_a_write_cycle & keyboard_avalonS_begins_xfer;

  //keyboard_avalonS_in_a_write_cycle assignment, which is an e_assign
  assign keyboard_avalonS_in_a_write_cycle = subsystemMMU_avalonM_granted_keyboard_avalonS & ~write_n_from_the_subsystemMMU;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = keyboard_avalonS_in_a_write_cycle;

  assign wait_for_keyboard_avalonS_counter = 0;
  //assign keyboard_avalonS_irq_from_sa = keyboard_avalonS_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign keyboard_avalonS_irq_from_sa = keyboard_avalonS_irq;


endmodule


module scarab_avalonM_arbitrator (
                                   // inputs:
                                    ava_address_from_the_scarab,
                                    ava_byteenable_from_the_scarab,
                                    ava_read_from_the_scarab,
                                    ava_write_from_the_scarab,
                                    ava_writedata_from_the_scarab,
                                    clk,
                                    d1_subsystemSDRAM_s1_end_xfer,
                                    reset_n,
                                    scarab_avalonM_granted_subsystemSDRAM_s1,
                                    scarab_avalonM_qualified_request_subsystemSDRAM_s1,
                                    scarab_avalonM_read_data_valid_subsystemSDRAM_s1,
                                    scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register,
                                    scarab_avalonM_requests_subsystemSDRAM_s1,
                                    subsystemSDRAM_s1_readdata_from_sa,
                                    subsystemSDRAM_s1_waitrequest_from_sa,

                                   // outputs:
                                    ava_address_from_the_scarab_to_slave,
                                    ava_readdata_to_the_scarab,
                                    ava_waitrequest_to_the_scarab
                                 )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [ 22: 0] ava_address_from_the_scarab_to_slave;
  output  [ 15: 0] ava_readdata_to_the_scarab;
  output           ava_waitrequest_to_the_scarab;
  input   [ 22: 0] ava_address_from_the_scarab;
  input   [  1: 0] ava_byteenable_from_the_scarab;
  input            ava_read_from_the_scarab;
  input            ava_write_from_the_scarab;
  input   [ 15: 0] ava_writedata_from_the_scarab;
  input            clk;
  input            d1_subsystemSDRAM_s1_end_xfer;
  input            reset_n;
  input            scarab_avalonM_granted_subsystemSDRAM_s1;
  input            scarab_avalonM_qualified_request_subsystemSDRAM_s1;
  input            scarab_avalonM_read_data_valid_subsystemSDRAM_s1;
  input            scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register;
  input            scarab_avalonM_requests_subsystemSDRAM_s1;
  input   [ 15: 0] subsystemSDRAM_s1_readdata_from_sa;
  input            subsystemSDRAM_s1_waitrequest_from_sa;

  reg              active_and_waiting_last_time;
  reg     [ 22: 0] ava_address_from_the_scarab_last_time;
  wire    [ 22: 0] ava_address_from_the_scarab_to_slave;
  reg              ava_read_from_the_scarab_last_time;
  wire    [ 15: 0] ava_readdata_to_the_scarab;
  wire             ava_waitrequest_to_the_scarab;
  reg              ava_write_from_the_scarab_last_time;
  reg     [ 15: 0] ava_writedata_from_the_scarab_last_time;
  wire             r_0;
  wire             scarab_avalonM_run;
  //r_0 master_run cascaded wait assignment, which is an e_assign
  assign r_0 = 1 & (scarab_avalonM_qualified_request_subsystemSDRAM_s1 | scarab_avalonM_read_data_valid_subsystemSDRAM_s1 | ~scarab_avalonM_requests_subsystemSDRAM_s1) & ((~scarab_avalonM_qualified_request_subsystemSDRAM_s1 | ~ava_read_from_the_scarab | (scarab_avalonM_read_data_valid_subsystemSDRAM_s1 & ava_read_from_the_scarab))) & ((~scarab_avalonM_qualified_request_subsystemSDRAM_s1 | ~(ava_read_from_the_scarab | ava_write_from_the_scarab) | (1 & ~subsystemSDRAM_s1_waitrequest_from_sa & (ava_read_from_the_scarab | ava_write_from_the_scarab))));

  //cascaded wait assignment, which is an e_assign
  assign scarab_avalonM_run = r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign ava_address_from_the_scarab_to_slave = ava_address_from_the_scarab[22 : 0];

  //scarab/avalonM readdata mux, which is an e_mux
  assign ava_readdata_to_the_scarab = subsystemSDRAM_s1_readdata_from_sa;

  //actual waitrequest port, which is an e_assign
  assign ava_waitrequest_to_the_scarab = ~scarab_avalonM_run;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //ava_address_from_the_scarab check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          ava_address_from_the_scarab_last_time <= 0;
      else if (1)
          ava_address_from_the_scarab_last_time <= ava_address_from_the_scarab;
    end


  //scarab/avalonM waited last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          active_and_waiting_last_time <= 0;
      else if (1)
          active_and_waiting_last_time <= ava_waitrequest_to_the_scarab & (ava_read_from_the_scarab | ava_write_from_the_scarab);
    end


  //ava_address_from_the_scarab matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or ava_address_from_the_scarab or ava_address_from_the_scarab_last_time)
    begin
      if (active_and_waiting_last_time & (ava_address_from_the_scarab != ava_address_from_the_scarab_last_time))
        begin
          $write("%0d ns: ava_address_from_the_scarab did not heed wait!!!", $time);
          $stop;
        end
    end


  //ava_read_from_the_scarab check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          ava_read_from_the_scarab_last_time <= 0;
      else if (1)
          ava_read_from_the_scarab_last_time <= ava_read_from_the_scarab;
    end


  //ava_read_from_the_scarab matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or ava_read_from_the_scarab or ava_read_from_the_scarab_last_time)
    begin
      if (active_and_waiting_last_time & (ava_read_from_the_scarab != ava_read_from_the_scarab_last_time))
        begin
          $write("%0d ns: ava_read_from_the_scarab did not heed wait!!!", $time);
          $stop;
        end
    end


  //ava_write_from_the_scarab check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          ava_write_from_the_scarab_last_time <= 0;
      else if (1)
          ava_write_from_the_scarab_last_time <= ava_write_from_the_scarab;
    end


  //ava_write_from_the_scarab matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or ava_write_from_the_scarab or ava_write_from_the_scarab_last_time)
    begin
      if (active_and_waiting_last_time & (ava_write_from_the_scarab != ava_write_from_the_scarab_last_time))
        begin
          $write("%0d ns: ava_write_from_the_scarab did not heed wait!!!", $time);
          $stop;
        end
    end


  //ava_writedata_from_the_scarab check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          ava_writedata_from_the_scarab_last_time <= 0;
      else if (1)
          ava_writedata_from_the_scarab_last_time <= ava_writedata_from_the_scarab;
    end


  //ava_writedata_from_the_scarab matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or ava_write_from_the_scarab or ava_writedata_from_the_scarab or ava_writedata_from_the_scarab_last_time)
    begin
      if (active_and_waiting_last_time & (ava_writedata_from_the_scarab != ava_writedata_from_the_scarab_last_time) & ava_write_from_the_scarab)
        begin
          $write("%0d ns: ava_writedata_from_the_scarab did not heed wait!!!", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


module subsystemAudio_avalonS_arbitrator (
                                           // inputs:
                                            address_from_the_subsystemMMU_to_slave,
                                            clk,
                                            read_n_from_the_subsystemMMU,
                                            reset_n,
                                            subsystemAudio_avalonS_irq,
                                            subsystemAudio_avalonS_waitrequest,
                                            write_n_from_the_subsystemMMU,
                                            writedata_from_the_subsystemMMU,

                                           // outputs:
                                            d1_subsystemAudio_avalonS_end_xfer,
                                            subsystemAudio_avalonS_chipselect,
                                            subsystemAudio_avalonS_irq_from_sa,
                                            subsystemAudio_avalonS_reset_n,
                                            subsystemAudio_avalonS_waitrequest_from_sa,
                                            subsystemAudio_avalonS_write_n,
                                            subsystemAudio_avalonS_writedata,
                                            subsystemMMU_avalonM_granted_subsystemAudio_avalonS,
                                            subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS,
                                            subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS,
                                            subsystemMMU_avalonM_requests_subsystemAudio_avalonS
                                         )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           d1_subsystemAudio_avalonS_end_xfer;
  output           subsystemAudio_avalonS_chipselect;
  output           subsystemAudio_avalonS_irq_from_sa;
  output           subsystemAudio_avalonS_reset_n;
  output           subsystemAudio_avalonS_waitrequest_from_sa;
  output           subsystemAudio_avalonS_write_n;
  output  [ 15: 0] subsystemAudio_avalonS_writedata;
  output           subsystemMMU_avalonM_granted_subsystemAudio_avalonS;
  output           subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS;
  output           subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS;
  output           subsystemMMU_avalonM_requests_subsystemAudio_avalonS;
  input   [ 31: 0] address_from_the_subsystemMMU_to_slave;
  input            clk;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input            subsystemAudio_avalonS_irq;
  input            subsystemAudio_avalonS_waitrequest;
  input            write_n_from_the_subsystemMMU;
  input   [ 15: 0] writedata_from_the_subsystemMMU;

  reg              d1_reasons_to_wait;
  reg              d1_subsystemAudio_avalonS_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             subsystemAudio_avalonS_address_for_slave_wo_address;
  wire             subsystemAudio_avalonS_allgrants;
  wire             subsystemAudio_avalonS_allow_new_arb_cycle;
  wire             subsystemAudio_avalonS_any_continuerequest;
  wire             subsystemAudio_avalonS_arb_counter_enable;
  reg              subsystemAudio_avalonS_arb_share_counter;
  wire             subsystemAudio_avalonS_arb_share_counter_next_value;
  wire             subsystemAudio_avalonS_arb_share_set_values;
  wire             subsystemAudio_avalonS_beginbursttransfer_internal;
  wire             subsystemAudio_avalonS_begins_xfer;
  wire             subsystemAudio_avalonS_chipselect;
  wire             subsystemAudio_avalonS_end_xfer;
  wire             subsystemAudio_avalonS_firsttransfer;
  wire             subsystemAudio_avalonS_grant_vector;
  wire             subsystemAudio_avalonS_in_a_read_cycle;
  wire             subsystemAudio_avalonS_in_a_write_cycle;
  wire             subsystemAudio_avalonS_irq_from_sa;
  wire             subsystemAudio_avalonS_master_qreq_vector;
  wire             subsystemAudio_avalonS_reset_n;
  reg              subsystemAudio_avalonS_slavearbiterlockenable;
  wire             subsystemAudio_avalonS_waitrequest_from_sa;
  wire             subsystemAudio_avalonS_waits_for_read;
  wire             subsystemAudio_avalonS_waits_for_write;
  wire             subsystemAudio_avalonS_write_n;
  wire    [ 15: 0] subsystemAudio_avalonS_writedata;
  wire             subsystemMMU_avalonM_arbiterlock;
  wire             subsystemMMU_avalonM_continuerequest;
  wire             subsystemMMU_avalonM_granted_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_requests_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_saved_grant_subsystemAudio_avalonS;
  wire             wait_for_subsystemAudio_avalonS_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~subsystemAudio_avalonS_end_xfer;
    end


  assign subsystemAudio_avalonS_begins_xfer = ~d1_reasons_to_wait & ((subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS));
  assign subsystemMMU_avalonM_requests_subsystemAudio_avalonS = (({address_from_the_subsystemMMU_to_slave[31 : 1] , 1'b0} == 32'h20002000) & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)) & ~write_n_from_the_subsystemMMU;
  //assign subsystemAudio_avalonS_waitrequest_from_sa = subsystemAudio_avalonS_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemAudio_avalonS_waitrequest_from_sa = subsystemAudio_avalonS_waitrequest;

  //subsystemAudio_avalonS_arb_share_counter set values, which is an e_mux
  assign subsystemAudio_avalonS_arb_share_set_values = 1;

  //subsystemAudio_avalonS_arb_share_counter_next_value assignment, which is an e_assign
  assign subsystemAudio_avalonS_arb_share_counter_next_value = subsystemAudio_avalonS_firsttransfer ? (subsystemAudio_avalonS_arb_share_set_values - 1) : |subsystemAudio_avalonS_arb_share_counter ? (subsystemAudio_avalonS_arb_share_counter - 1) : 0;

  //subsystemAudio_avalonS_allgrants all slave grants, which is an e_mux
  assign subsystemAudio_avalonS_allgrants = |subsystemAudio_avalonS_grant_vector;

  //subsystemAudio_avalonS_end_xfer assignment, which is an e_assign
  assign subsystemAudio_avalonS_end_xfer = ~(subsystemAudio_avalonS_waits_for_read | subsystemAudio_avalonS_waits_for_write);

  //subsystemAudio_avalonS_arb_share_counter arbitration counter enable, which is an e_assign
  assign subsystemAudio_avalonS_arb_counter_enable = subsystemAudio_avalonS_end_xfer & subsystemAudio_avalonS_allgrants;

  //subsystemAudio_avalonS_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemAudio_avalonS_arb_share_counter <= 0;
      else if (subsystemAudio_avalonS_arb_counter_enable)
          subsystemAudio_avalonS_arb_share_counter <= subsystemAudio_avalonS_arb_share_counter_next_value;
    end


  //subsystemAudio_avalonS_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemAudio_avalonS_slavearbiterlockenable <= 0;
      else if (|subsystemAudio_avalonS_master_qreq_vector & subsystemAudio_avalonS_end_xfer)
          subsystemAudio_avalonS_slavearbiterlockenable <= |subsystemAudio_avalonS_arb_share_counter_next_value;
    end


  //subsystemMMU/avalonM subsystemAudio/avalonS arbiterlock, which is an e_assign
  assign subsystemMMU_avalonM_arbiterlock = subsystemAudio_avalonS_slavearbiterlockenable & subsystemMMU_avalonM_continuerequest;

  //subsystemAudio_avalonS_any_continuerequest at least one master continues requesting, which is an e_assign
  assign subsystemAudio_avalonS_any_continuerequest = 1;

  //subsystemMMU_avalonM_continuerequest continued request, which is an e_assign
  assign subsystemMMU_avalonM_continuerequest = 1;

  assign subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS = subsystemMMU_avalonM_requests_subsystemAudio_avalonS;
  //subsystemAudio_avalonS_writedata mux, which is an e_mux
  assign subsystemAudio_avalonS_writedata = writedata_from_the_subsystemMMU;

  //master is always granted when requested
  assign subsystemMMU_avalonM_granted_subsystemAudio_avalonS = subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS;

  //subsystemMMU/avalonM saved-grant subsystemAudio/avalonS, which is an e_assign
  assign subsystemMMU_avalonM_saved_grant_subsystemAudio_avalonS = subsystemMMU_avalonM_requests_subsystemAudio_avalonS;

  //allow new arb cycle for subsystemAudio/avalonS, which is an e_assign
  assign subsystemAudio_avalonS_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign subsystemAudio_avalonS_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign subsystemAudio_avalonS_master_qreq_vector = 1;

  //subsystemAudio_avalonS_reset_n assignment, which is an e_assign
  assign subsystemAudio_avalonS_reset_n = reset_n;

  assign subsystemAudio_avalonS_chipselect = subsystemMMU_avalonM_granted_subsystemAudio_avalonS;
  //subsystemAudio_avalonS_firsttransfer first transaction, which is an e_assign
  assign subsystemAudio_avalonS_firsttransfer = ~(subsystemAudio_avalonS_slavearbiterlockenable & subsystemAudio_avalonS_any_continuerequest);

  //subsystemAudio_avalonS_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign subsystemAudio_avalonS_beginbursttransfer_internal = subsystemAudio_avalonS_begins_xfer & subsystemAudio_avalonS_firsttransfer;

  //~subsystemAudio_avalonS_write_n assignment, which is an e_mux
  assign subsystemAudio_avalonS_write_n = ~(subsystemMMU_avalonM_granted_subsystemAudio_avalonS & ~write_n_from_the_subsystemMMU);

  //subsystemAudio_avalonS_address_for_slave_wo_address mux, which is an e_mux
  assign subsystemAudio_avalonS_address_for_slave_wo_address = address_from_the_subsystemMMU_to_slave >> 1;

  //d1_subsystemAudio_avalonS_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_subsystemAudio_avalonS_end_xfer <= 1;
      else if (1)
          d1_subsystemAudio_avalonS_end_xfer <= subsystemAudio_avalonS_end_xfer;
    end


  //subsystemAudio_avalonS_waits_for_read in a cycle, which is an e_mux
  assign subsystemAudio_avalonS_waits_for_read = subsystemAudio_avalonS_in_a_read_cycle & subsystemAudio_avalonS_waitrequest_from_sa;

  //subsystemAudio_avalonS_in_a_read_cycle assignment, which is an e_assign
  assign subsystemAudio_avalonS_in_a_read_cycle = subsystemMMU_avalonM_granted_subsystemAudio_avalonS & ~read_n_from_the_subsystemMMU;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = subsystemAudio_avalonS_in_a_read_cycle;

  //subsystemAudio_avalonS_waits_for_write in a cycle, which is an e_mux
  assign subsystemAudio_avalonS_waits_for_write = subsystemAudio_avalonS_in_a_write_cycle & subsystemAudio_avalonS_waitrequest_from_sa;

  //subsystemAudio_avalonS_in_a_write_cycle assignment, which is an e_assign
  assign subsystemAudio_avalonS_in_a_write_cycle = subsystemMMU_avalonM_granted_subsystemAudio_avalonS & ~write_n_from_the_subsystemMMU;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = subsystemAudio_avalonS_in_a_write_cycle;

  assign wait_for_subsystemAudio_avalonS_counter = 0;
  //assign subsystemAudio_avalonS_irq_from_sa = subsystemAudio_avalonS_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemAudio_avalonS_irq_from_sa = subsystemAudio_avalonS_irq;


endmodule


module subsystemI2C_avalonS_arbitrator (
                                         // inputs:
                                          address_from_the_subsystemMMU_to_slave,
                                          byteenable_from_the_subsystemMMU,
                                          clk,
                                          read_n_from_the_subsystemMMU,
                                          reset_n,
                                          subsystemI2C_avalonS_readdata,
                                          subsystemI2C_avalonS_waitrequest_n,
                                          write_n_from_the_subsystemMMU,
                                          writedata_from_the_subsystemMMU,

                                         // outputs:
                                          d1_subsystemI2C_avalonS_end_xfer,
                                          subsystemI2C_avalonS_address,
                                          subsystemI2C_avalonS_always0,
                                          subsystemI2C_avalonS_chipselect,
                                          subsystemI2C_avalonS_readdata_from_sa,
                                          subsystemI2C_avalonS_reset_n,
                                          subsystemI2C_avalonS_waitrequest_n_from_sa,
                                          subsystemI2C_avalonS_write,
                                          subsystemI2C_avalonS_writedata,
                                          subsystemMMU_avalonM_granted_subsystemI2C_avalonS,
                                          subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS,
                                          subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS,
                                          subsystemMMU_avalonM_requests_subsystemI2C_avalonS
                                       )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           d1_subsystemI2C_avalonS_end_xfer;
  output  [  2: 0] subsystemI2C_avalonS_address;
  output           subsystemI2C_avalonS_always0;
  output           subsystemI2C_avalonS_chipselect;
  output  [  7: 0] subsystemI2C_avalonS_readdata_from_sa;
  output           subsystemI2C_avalonS_reset_n;
  output           subsystemI2C_avalonS_waitrequest_n_from_sa;
  output           subsystemI2C_avalonS_write;
  output  [  7: 0] subsystemI2C_avalonS_writedata;
  output           subsystemMMU_avalonM_granted_subsystemI2C_avalonS;
  output           subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS;
  output           subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS;
  output           subsystemMMU_avalonM_requests_subsystemI2C_avalonS;
  input   [ 31: 0] address_from_the_subsystemMMU_to_slave;
  input   [  1: 0] byteenable_from_the_subsystemMMU;
  input            clk;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input   [  7: 0] subsystemI2C_avalonS_readdata;
  input            subsystemI2C_avalonS_waitrequest_n;
  input            write_n_from_the_subsystemMMU;
  input   [ 15: 0] writedata_from_the_subsystemMMU;

  reg              d1_reasons_to_wait;
  reg              d1_subsystemI2C_avalonS_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  2: 0] subsystemI2C_avalonS_address;
  wire             subsystemI2C_avalonS_allgrants;
  wire             subsystemI2C_avalonS_allow_new_arb_cycle;
  wire             subsystemI2C_avalonS_always0;
  wire             subsystemI2C_avalonS_any_continuerequest;
  wire             subsystemI2C_avalonS_arb_counter_enable;
  reg              subsystemI2C_avalonS_arb_share_counter;
  wire             subsystemI2C_avalonS_arb_share_counter_next_value;
  wire             subsystemI2C_avalonS_arb_share_set_values;
  wire             subsystemI2C_avalonS_beginbursttransfer_internal;
  wire             subsystemI2C_avalonS_begins_xfer;
  wire             subsystemI2C_avalonS_chipselect;
  wire             subsystemI2C_avalonS_end_xfer;
  wire             subsystemI2C_avalonS_firsttransfer;
  wire             subsystemI2C_avalonS_grant_vector;
  wire             subsystemI2C_avalonS_in_a_read_cycle;
  wire             subsystemI2C_avalonS_in_a_write_cycle;
  wire             subsystemI2C_avalonS_master_qreq_vector;
  wire             subsystemI2C_avalonS_pretend_byte_enable;
  wire    [  7: 0] subsystemI2C_avalonS_readdata_from_sa;
  wire             subsystemI2C_avalonS_reset_n;
  reg              subsystemI2C_avalonS_slavearbiterlockenable;
  wire             subsystemI2C_avalonS_waitrequest_n_from_sa;
  wire             subsystemI2C_avalonS_waits_for_read;
  wire             subsystemI2C_avalonS_waits_for_write;
  wire             subsystemI2C_avalonS_write;
  wire    [  7: 0] subsystemI2C_avalonS_writedata;
  wire             subsystemMMU_avalonM_arbiterlock;
  wire             subsystemMMU_avalonM_continuerequest;
  wire             subsystemMMU_avalonM_granted_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_requests_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_saved_grant_subsystemI2C_avalonS;
  wire             wait_for_subsystemI2C_avalonS_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~subsystemI2C_avalonS_end_xfer;
    end


  assign subsystemI2C_avalonS_begins_xfer = ~d1_reasons_to_wait & ((subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS));
  //assign subsystemI2C_avalonS_readdata_from_sa = subsystemI2C_avalonS_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemI2C_avalonS_readdata_from_sa = subsystemI2C_avalonS_readdata;

  assign subsystemMMU_avalonM_requests_subsystemI2C_avalonS = ({address_from_the_subsystemMMU_to_slave[31 : 4] , 4'b0} == 32'h20004000) & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU);
  //assign subsystemI2C_avalonS_waitrequest_n_from_sa = subsystemI2C_avalonS_waitrequest_n so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemI2C_avalonS_waitrequest_n_from_sa = subsystemI2C_avalonS_waitrequest_n;

  //subsystemI2C_avalonS_arb_share_counter set values, which is an e_mux
  assign subsystemI2C_avalonS_arb_share_set_values = 1;

  //subsystemI2C_avalonS_arb_share_counter_next_value assignment, which is an e_assign
  assign subsystemI2C_avalonS_arb_share_counter_next_value = subsystemI2C_avalonS_firsttransfer ? (subsystemI2C_avalonS_arb_share_set_values - 1) : |subsystemI2C_avalonS_arb_share_counter ? (subsystemI2C_avalonS_arb_share_counter - 1) : 0;

  //subsystemI2C_avalonS_allgrants all slave grants, which is an e_mux
  assign subsystemI2C_avalonS_allgrants = |subsystemI2C_avalonS_grant_vector;

  //subsystemI2C_avalonS_end_xfer assignment, which is an e_assign
  assign subsystemI2C_avalonS_end_xfer = ~(subsystemI2C_avalonS_waits_for_read | subsystemI2C_avalonS_waits_for_write);

  //subsystemI2C_avalonS_arb_share_counter arbitration counter enable, which is an e_assign
  assign subsystemI2C_avalonS_arb_counter_enable = subsystemI2C_avalonS_end_xfer & subsystemI2C_avalonS_allgrants;

  //subsystemI2C_avalonS_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemI2C_avalonS_arb_share_counter <= 0;
      else if (subsystemI2C_avalonS_arb_counter_enable)
          subsystemI2C_avalonS_arb_share_counter <= subsystemI2C_avalonS_arb_share_counter_next_value;
    end


  //subsystemI2C_avalonS_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemI2C_avalonS_slavearbiterlockenable <= 0;
      else if (|subsystemI2C_avalonS_master_qreq_vector & subsystemI2C_avalonS_end_xfer)
          subsystemI2C_avalonS_slavearbiterlockenable <= |subsystemI2C_avalonS_arb_share_counter_next_value;
    end


  //subsystemMMU/avalonM subsystemI2C/avalonS arbiterlock, which is an e_assign
  assign subsystemMMU_avalonM_arbiterlock = subsystemI2C_avalonS_slavearbiterlockenable & subsystemMMU_avalonM_continuerequest;

  //subsystemI2C_avalonS_any_continuerequest at least one master continues requesting, which is an e_assign
  assign subsystemI2C_avalonS_any_continuerequest = 1;

  //subsystemMMU_avalonM_continuerequest continued request, which is an e_assign
  assign subsystemMMU_avalonM_continuerequest = 1;

  assign subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS = subsystemMMU_avalonM_requests_subsystemI2C_avalonS;
  //subsystemI2C_avalonS_writedata mux, which is an e_mux
  assign subsystemI2C_avalonS_writedata = writedata_from_the_subsystemMMU;

  //master is always granted when requested
  assign subsystemMMU_avalonM_granted_subsystemI2C_avalonS = subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS;

  //subsystemMMU/avalonM saved-grant subsystemI2C/avalonS, which is an e_assign
  assign subsystemMMU_avalonM_saved_grant_subsystemI2C_avalonS = subsystemMMU_avalonM_requests_subsystemI2C_avalonS;

  //allow new arb cycle for subsystemI2C/avalonS, which is an e_assign
  assign subsystemI2C_avalonS_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign subsystemI2C_avalonS_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign subsystemI2C_avalonS_master_qreq_vector = 1;

  //subsystemI2C_avalonS_reset_n assignment, which is an e_assign
  assign subsystemI2C_avalonS_reset_n = reset_n;

  assign subsystemI2C_avalonS_chipselect = subsystemMMU_avalonM_granted_subsystemI2C_avalonS;
  //subsystemI2C_avalonS_firsttransfer first transaction, which is an e_assign
  assign subsystemI2C_avalonS_firsttransfer = ~(subsystemI2C_avalonS_slavearbiterlockenable & subsystemI2C_avalonS_any_continuerequest);

  //subsystemI2C_avalonS_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign subsystemI2C_avalonS_beginbursttransfer_internal = subsystemI2C_avalonS_begins_xfer & subsystemI2C_avalonS_firsttransfer;

  //subsystemI2C_avalonS_write assignment, which is an e_mux
  assign subsystemI2C_avalonS_write = ((subsystemMMU_avalonM_granted_subsystemI2C_avalonS & ~write_n_from_the_subsystemMMU)) & subsystemI2C_avalonS_pretend_byte_enable;

  //subsystemI2C_avalonS_address mux, which is an e_mux
  assign subsystemI2C_avalonS_address = address_from_the_subsystemMMU_to_slave >> 1;

  //d1_subsystemI2C_avalonS_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_subsystemI2C_avalonS_end_xfer <= 1;
      else if (1)
          d1_subsystemI2C_avalonS_end_xfer <= subsystemI2C_avalonS_end_xfer;
    end


  //subsystemI2C_avalonS_waits_for_read in a cycle, which is an e_mux
  assign subsystemI2C_avalonS_waits_for_read = subsystemI2C_avalonS_in_a_read_cycle & ~subsystemI2C_avalonS_waitrequest_n_from_sa;

  //subsystemI2C_avalonS_in_a_read_cycle assignment, which is an e_assign
  assign subsystemI2C_avalonS_in_a_read_cycle = subsystemMMU_avalonM_granted_subsystemI2C_avalonS & ~read_n_from_the_subsystemMMU;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = subsystemI2C_avalonS_in_a_read_cycle;

  //subsystemI2C_avalonS_waits_for_write in a cycle, which is an e_mux
  assign subsystemI2C_avalonS_waits_for_write = subsystemI2C_avalonS_in_a_write_cycle & ~subsystemI2C_avalonS_waitrequest_n_from_sa;

  //subsystemI2C_avalonS_in_a_write_cycle assignment, which is an e_assign
  assign subsystemI2C_avalonS_in_a_write_cycle = subsystemMMU_avalonM_granted_subsystemI2C_avalonS & ~write_n_from_the_subsystemMMU;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = subsystemI2C_avalonS_in_a_write_cycle;

  assign wait_for_subsystemI2C_avalonS_counter = 0;
  //subsystemI2C_avalonS_pretend_byte_enable byte enable port mux, which is an e_mux
  assign subsystemI2C_avalonS_pretend_byte_enable = (subsystemMMU_avalonM_granted_subsystemI2C_avalonS)? byteenable_from_the_subsystemMMU :
    -1;

  //subsystemI2C_avalonS_always0 always signal, which is an e_assign
  assign subsystemI2C_avalonS_always0 = 0;


endmodule


module subsystemJTAG_avalon_jtag_slave_arbitrator (
                                                    // inputs:
                                                     address_from_the_subsystemMMU_to_slave,
                                                     clk,
                                                     read_n_from_the_subsystemMMU,
                                                     reset_n,
                                                     subsystemJTAG_avalon_jtag_slave_dataavailable,
                                                     subsystemJTAG_avalon_jtag_slave_irq,
                                                     subsystemJTAG_avalon_jtag_slave_readdata,
                                                     subsystemJTAG_avalon_jtag_slave_readyfordata,
                                                     subsystemJTAG_avalon_jtag_slave_waitrequest,
                                                     write_n_from_the_subsystemMMU,
                                                     writedata_from_the_subsystemMMU,

                                                    // outputs:
                                                     d1_subsystemJTAG_avalon_jtag_slave_end_xfer,
                                                     subsystemJTAG_avalon_jtag_slave_address,
                                                     subsystemJTAG_avalon_jtag_slave_chipselect,
                                                     subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa,
                                                     subsystemJTAG_avalon_jtag_slave_irq_from_sa,
                                                     subsystemJTAG_avalon_jtag_slave_read_n,
                                                     subsystemJTAG_avalon_jtag_slave_readdata_from_sa,
                                                     subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa,
                                                     subsystemJTAG_avalon_jtag_slave_reset_n,
                                                     subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa,
                                                     subsystemJTAG_avalon_jtag_slave_write_n,
                                                     subsystemJTAG_avalon_jtag_slave_writedata,
                                                     subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave,
                                                     subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave,
                                                     subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave,
                                                     subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave
                                                  )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           d1_subsystemJTAG_avalon_jtag_slave_end_xfer;
  output           subsystemJTAG_avalon_jtag_slave_address;
  output           subsystemJTAG_avalon_jtag_slave_chipselect;
  output           subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa;
  output           subsystemJTAG_avalon_jtag_slave_irq_from_sa;
  output           subsystemJTAG_avalon_jtag_slave_read_n;
  output  [ 31: 0] subsystemJTAG_avalon_jtag_slave_readdata_from_sa;
  output           subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa;
  output           subsystemJTAG_avalon_jtag_slave_reset_n;
  output           subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa;
  output           subsystemJTAG_avalon_jtag_slave_write_n;
  output  [ 31: 0] subsystemJTAG_avalon_jtag_slave_writedata;
  output           subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave;
  output           subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave;
  output           subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave;
  output           subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave;
  input   [ 31: 0] address_from_the_subsystemMMU_to_slave;
  input            clk;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input            subsystemJTAG_avalon_jtag_slave_dataavailable;
  input            subsystemJTAG_avalon_jtag_slave_irq;
  input   [ 31: 0] subsystemJTAG_avalon_jtag_slave_readdata;
  input            subsystemJTAG_avalon_jtag_slave_readyfordata;
  input            subsystemJTAG_avalon_jtag_slave_waitrequest;
  input            write_n_from_the_subsystemMMU;
  input   [ 15: 0] writedata_from_the_subsystemMMU;

  reg              d1_reasons_to_wait;
  reg              d1_subsystemJTAG_avalon_jtag_slave_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             subsystemJTAG_avalon_jtag_slave_address;
  wire             subsystemJTAG_avalon_jtag_slave_allgrants;
  wire             subsystemJTAG_avalon_jtag_slave_allow_new_arb_cycle;
  wire             subsystemJTAG_avalon_jtag_slave_any_continuerequest;
  wire             subsystemJTAG_avalon_jtag_slave_arb_counter_enable;
  reg              subsystemJTAG_avalon_jtag_slave_arb_share_counter;
  wire             subsystemJTAG_avalon_jtag_slave_arb_share_counter_next_value;
  wire             subsystemJTAG_avalon_jtag_slave_arb_share_set_values;
  wire             subsystemJTAG_avalon_jtag_slave_beginbursttransfer_internal;
  wire             subsystemJTAG_avalon_jtag_slave_begins_xfer;
  wire             subsystemJTAG_avalon_jtag_slave_chipselect;
  wire             subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_end_xfer;
  wire             subsystemJTAG_avalon_jtag_slave_firsttransfer;
  wire             subsystemJTAG_avalon_jtag_slave_grant_vector;
  wire             subsystemJTAG_avalon_jtag_slave_in_a_read_cycle;
  wire             subsystemJTAG_avalon_jtag_slave_in_a_write_cycle;
  wire             subsystemJTAG_avalon_jtag_slave_irq_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_master_qreq_vector;
  wire             subsystemJTAG_avalon_jtag_slave_read_n;
  wire    [ 31: 0] subsystemJTAG_avalon_jtag_slave_readdata_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_reset_n;
  reg              subsystemJTAG_avalon_jtag_slave_slavearbiterlockenable;
  wire             subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_waits_for_read;
  wire             subsystemJTAG_avalon_jtag_slave_waits_for_write;
  wire             subsystemJTAG_avalon_jtag_slave_write_n;
  wire    [ 31: 0] subsystemJTAG_avalon_jtag_slave_writedata;
  wire             subsystemMMU_avalonM_arbiterlock;
  wire             subsystemMMU_avalonM_continuerequest;
  wire             subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_saved_grant_subsystemJTAG_avalon_jtag_slave;
  wire             wait_for_subsystemJTAG_avalon_jtag_slave_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~subsystemJTAG_avalon_jtag_slave_end_xfer;
    end


  assign subsystemJTAG_avalon_jtag_slave_begins_xfer = ~d1_reasons_to_wait & ((subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave));
  //assign subsystemJTAG_avalon_jtag_slave_readdata_from_sa = subsystemJTAG_avalon_jtag_slave_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_readdata_from_sa = subsystemJTAG_avalon_jtag_slave_readdata;

  assign subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave = ({address_from_the_subsystemMMU_to_slave[31 : 2] , 2'b0} == 32'h10000000) & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU);
  //assign subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa = subsystemJTAG_avalon_jtag_slave_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa = subsystemJTAG_avalon_jtag_slave_dataavailable;

  //assign subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa = subsystemJTAG_avalon_jtag_slave_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa = subsystemJTAG_avalon_jtag_slave_readyfordata;

  //assign subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa = subsystemJTAG_avalon_jtag_slave_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa = subsystemJTAG_avalon_jtag_slave_waitrequest;

  //subsystemJTAG_avalon_jtag_slave_arb_share_counter set values, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_arb_share_set_values = 1;

  //subsystemJTAG_avalon_jtag_slave_arb_share_counter_next_value assignment, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_arb_share_counter_next_value = subsystemJTAG_avalon_jtag_slave_firsttransfer ? (subsystemJTAG_avalon_jtag_slave_arb_share_set_values - 1) : |subsystemJTAG_avalon_jtag_slave_arb_share_counter ? (subsystemJTAG_avalon_jtag_slave_arb_share_counter - 1) : 0;

  //subsystemJTAG_avalon_jtag_slave_allgrants all slave grants, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_allgrants = |subsystemJTAG_avalon_jtag_slave_grant_vector;

  //subsystemJTAG_avalon_jtag_slave_end_xfer assignment, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_end_xfer = ~(subsystemJTAG_avalon_jtag_slave_waits_for_read | subsystemJTAG_avalon_jtag_slave_waits_for_write);

  //subsystemJTAG_avalon_jtag_slave_arb_share_counter arbitration counter enable, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_arb_counter_enable = subsystemJTAG_avalon_jtag_slave_end_xfer & subsystemJTAG_avalon_jtag_slave_allgrants;

  //subsystemJTAG_avalon_jtag_slave_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemJTAG_avalon_jtag_slave_arb_share_counter <= 0;
      else if (subsystemJTAG_avalon_jtag_slave_arb_counter_enable)
          subsystemJTAG_avalon_jtag_slave_arb_share_counter <= subsystemJTAG_avalon_jtag_slave_arb_share_counter_next_value;
    end


  //subsystemJTAG_avalon_jtag_slave_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemJTAG_avalon_jtag_slave_slavearbiterlockenable <= 0;
      else if (|subsystemJTAG_avalon_jtag_slave_master_qreq_vector & subsystemJTAG_avalon_jtag_slave_end_xfer)
          subsystemJTAG_avalon_jtag_slave_slavearbiterlockenable <= |subsystemJTAG_avalon_jtag_slave_arb_share_counter_next_value;
    end


  //subsystemMMU/avalonM subsystemJTAG/avalon_jtag_slave arbiterlock, which is an e_assign
  assign subsystemMMU_avalonM_arbiterlock = subsystemJTAG_avalon_jtag_slave_slavearbiterlockenable & subsystemMMU_avalonM_continuerequest;

  //subsystemJTAG_avalon_jtag_slave_any_continuerequest at least one master continues requesting, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_any_continuerequest = 1;

  //subsystemMMU_avalonM_continuerequest continued request, which is an e_assign
  assign subsystemMMU_avalonM_continuerequest = 1;

  assign subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave = subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave;
  //subsystemJTAG_avalon_jtag_slave_writedata mux, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_writedata = writedata_from_the_subsystemMMU;

  //master is always granted when requested
  assign subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave = subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave;

  //subsystemMMU/avalonM saved-grant subsystemJTAG/avalon_jtag_slave, which is an e_assign
  assign subsystemMMU_avalonM_saved_grant_subsystemJTAG_avalon_jtag_slave = subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave;

  //allow new arb cycle for subsystemJTAG/avalon_jtag_slave, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign subsystemJTAG_avalon_jtag_slave_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign subsystemJTAG_avalon_jtag_slave_master_qreq_vector = 1;

  //subsystemJTAG_avalon_jtag_slave_reset_n assignment, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_reset_n = reset_n;

  assign subsystemJTAG_avalon_jtag_slave_chipselect = subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave;
  //subsystemJTAG_avalon_jtag_slave_firsttransfer first transaction, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_firsttransfer = ~(subsystemJTAG_avalon_jtag_slave_slavearbiterlockenable & subsystemJTAG_avalon_jtag_slave_any_continuerequest);

  //subsystemJTAG_avalon_jtag_slave_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_beginbursttransfer_internal = subsystemJTAG_avalon_jtag_slave_begins_xfer & subsystemJTAG_avalon_jtag_slave_firsttransfer;

  //~subsystemJTAG_avalon_jtag_slave_read_n assignment, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_read_n = ~(subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave & ~read_n_from_the_subsystemMMU);

  //~subsystemJTAG_avalon_jtag_slave_write_n assignment, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_write_n = ~(subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave & ~write_n_from_the_subsystemMMU);

  //subsystemJTAG_avalon_jtag_slave_address mux, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_address = address_from_the_subsystemMMU_to_slave >> 1;

  //d1_subsystemJTAG_avalon_jtag_slave_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_subsystemJTAG_avalon_jtag_slave_end_xfer <= 1;
      else if (1)
          d1_subsystemJTAG_avalon_jtag_slave_end_xfer <= subsystemJTAG_avalon_jtag_slave_end_xfer;
    end


  //subsystemJTAG_avalon_jtag_slave_waits_for_read in a cycle, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_waits_for_read = subsystemJTAG_avalon_jtag_slave_in_a_read_cycle & subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa;

  //subsystemJTAG_avalon_jtag_slave_in_a_read_cycle assignment, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_in_a_read_cycle = subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave & ~read_n_from_the_subsystemMMU;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = subsystemJTAG_avalon_jtag_slave_in_a_read_cycle;

  //subsystemJTAG_avalon_jtag_slave_waits_for_write in a cycle, which is an e_mux
  assign subsystemJTAG_avalon_jtag_slave_waits_for_write = subsystemJTAG_avalon_jtag_slave_in_a_write_cycle & subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa;

  //subsystemJTAG_avalon_jtag_slave_in_a_write_cycle assignment, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_in_a_write_cycle = subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave & ~write_n_from_the_subsystemMMU;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = subsystemJTAG_avalon_jtag_slave_in_a_write_cycle;

  assign wait_for_subsystemJTAG_avalon_jtag_slave_counter = 0;
  //assign subsystemJTAG_avalon_jtag_slave_irq_from_sa = subsystemJTAG_avalon_jtag_slave_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemJTAG_avalon_jtag_slave_irq_from_sa = subsystemJTAG_avalon_jtag_slave_irq;


endmodule


module subsystemMMU_avalonM_arbitrator (
                                         // inputs:
                                          address_from_the_subsystemMMU,
                                          byteenable_from_the_subsystemMMU,
                                          clk,
                                          d1_keyboard_avalonS_end_xfer,
                                          d1_subsystemAudio_avalonS_end_xfer,
                                          d1_subsystemI2C_avalonS_end_xfer,
                                          d1_subsystemJTAG_avalon_jtag_slave_end_xfer,
                                          d1_subsystemSerialPort_s1_end_xfer,
                                          d1_subsystemTimer_s1_end_xfer,
                                          keyboard_avalonS_irq_from_sa,
                                          keyboard_avalonS_readdata_from_sa,
                                          read_n_from_the_subsystemMMU,
                                          reset_n,
                                          subsystemAudio_avalonS_irq_from_sa,
                                          subsystemAudio_avalonS_waitrequest_from_sa,
                                          subsystemI2C_avalonS_readdata_from_sa,
                                          subsystemI2C_avalonS_waitrequest_n_from_sa,
                                          subsystemJTAG_avalon_jtag_slave_irq_from_sa,
                                          subsystemJTAG_avalon_jtag_slave_readdata_from_sa,
                                          subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa,
                                          subsystemMMU_avalonM_granted_keyboard_avalonS,
                                          subsystemMMU_avalonM_granted_subsystemAudio_avalonS,
                                          subsystemMMU_avalonM_granted_subsystemI2C_avalonS,
                                          subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave,
                                          subsystemMMU_avalonM_granted_subsystemSerialPort_s1,
                                          subsystemMMU_avalonM_granted_subsystemTimer_s1,
                                          subsystemMMU_avalonM_qualified_request_keyboard_avalonS,
                                          subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS,
                                          subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS,
                                          subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave,
                                          subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1,
                                          subsystemMMU_avalonM_qualified_request_subsystemTimer_s1,
                                          subsystemMMU_avalonM_read_data_valid_keyboard_avalonS,
                                          subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS,
                                          subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS,
                                          subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave,
                                          subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1,
                                          subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1,
                                          subsystemMMU_avalonM_requests_keyboard_avalonS,
                                          subsystemMMU_avalonM_requests_subsystemAudio_avalonS,
                                          subsystemMMU_avalonM_requests_subsystemI2C_avalonS,
                                          subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave,
                                          subsystemMMU_avalonM_requests_subsystemSerialPort_s1,
                                          subsystemMMU_avalonM_requests_subsystemTimer_s1,
                                          subsystemSerialPort_s1_readdata_from_sa,
                                          subsystemTimer_s1_irq_from_sa,
                                          subsystemTimer_s1_readdata_from_sa,
                                          write_n_from_the_subsystemMMU,
                                          writedata_from_the_subsystemMMU,

                                         // outputs:
                                          address_from_the_subsystemMMU_to_slave,
                                          irq_to_the_subsystemMMU,
                                          irqnumber_to_the_subsystemMMU,
                                          readdata_to_the_subsystemMMU,
                                          reset_n_to_the_subsystemMMU,
                                          waitrequest_to_the_subsystemMMU
                                       )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output  [ 31: 0] address_from_the_subsystemMMU_to_slave;
  output           irq_to_the_subsystemMMU;
  output  [  5: 0] irqnumber_to_the_subsystemMMU;
  output  [ 15: 0] readdata_to_the_subsystemMMU;
  output           reset_n_to_the_subsystemMMU;
  output           waitrequest_to_the_subsystemMMU;
  input   [ 31: 0] address_from_the_subsystemMMU;
  input   [  1: 0] byteenable_from_the_subsystemMMU;
  input            clk;
  input            d1_keyboard_avalonS_end_xfer;
  input            d1_subsystemAudio_avalonS_end_xfer;
  input            d1_subsystemI2C_avalonS_end_xfer;
  input            d1_subsystemJTAG_avalon_jtag_slave_end_xfer;
  input            d1_subsystemSerialPort_s1_end_xfer;
  input            d1_subsystemTimer_s1_end_xfer;
  input            keyboard_avalonS_irq_from_sa;
  input   [ 15: 0] keyboard_avalonS_readdata_from_sa;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input            subsystemAudio_avalonS_irq_from_sa;
  input            subsystemAudio_avalonS_waitrequest_from_sa;
  input   [  7: 0] subsystemI2C_avalonS_readdata_from_sa;
  input            subsystemI2C_avalonS_waitrequest_n_from_sa;
  input            subsystemJTAG_avalon_jtag_slave_irq_from_sa;
  input   [ 31: 0] subsystemJTAG_avalon_jtag_slave_readdata_from_sa;
  input            subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa;
  input            subsystemMMU_avalonM_granted_keyboard_avalonS;
  input            subsystemMMU_avalonM_granted_subsystemAudio_avalonS;
  input            subsystemMMU_avalonM_granted_subsystemI2C_avalonS;
  input            subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave;
  input            subsystemMMU_avalonM_granted_subsystemSerialPort_s1;
  input            subsystemMMU_avalonM_granted_subsystemTimer_s1;
  input            subsystemMMU_avalonM_qualified_request_keyboard_avalonS;
  input            subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS;
  input            subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS;
  input            subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave;
  input            subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1;
  input            subsystemMMU_avalonM_qualified_request_subsystemTimer_s1;
  input            subsystemMMU_avalonM_read_data_valid_keyboard_avalonS;
  input            subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS;
  input            subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS;
  input            subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave;
  input            subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1;
  input            subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1;
  input            subsystemMMU_avalonM_requests_keyboard_avalonS;
  input            subsystemMMU_avalonM_requests_subsystemAudio_avalonS;
  input            subsystemMMU_avalonM_requests_subsystemI2C_avalonS;
  input            subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave;
  input            subsystemMMU_avalonM_requests_subsystemSerialPort_s1;
  input            subsystemMMU_avalonM_requests_subsystemTimer_s1;
  input   [ 15: 0] subsystemSerialPort_s1_readdata_from_sa;
  input            subsystemTimer_s1_irq_from_sa;
  input   [ 15: 0] subsystemTimer_s1_readdata_from_sa;
  input            write_n_from_the_subsystemMMU;
  input   [ 15: 0] writedata_from_the_subsystemMMU;

  reg              active_and_waiting_last_time;
  reg     [ 31: 0] address_from_the_subsystemMMU_last_time;
  wire    [ 31: 0] address_from_the_subsystemMMU_to_slave;
  wire             irq_to_the_subsystemMMU;
  wire    [  5: 0] irqnumber_to_the_subsystemMMU;
  wire             r_0;
  reg              read_n_from_the_subsystemMMU_last_time;
  wire    [ 15: 0] readdata_to_the_subsystemMMU;
  wire             reset_n_to_the_subsystemMMU;
  wire             subsystemMMU_avalonM_run;
  wire             waitrequest_to_the_subsystemMMU;
  reg              write_n_from_the_subsystemMMU_last_time;
  reg     [ 15: 0] writedata_from_the_subsystemMMU_last_time;
  //r_0 master_run cascaded wait assignment, which is an e_assign
  assign r_0 = 1 & ((~subsystemMMU_avalonM_qualified_request_keyboard_avalonS | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~d1_keyboard_avalonS_end_xfer & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & ((~subsystemMMU_avalonM_qualified_request_keyboard_avalonS | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~d1_keyboard_avalonS_end_xfer & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & 1 & ((~subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~subsystemAudio_avalonS_waitrequest_from_sa & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & ((~subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~subsystemAudio_avalonS_waitrequest_from_sa & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & 1 & ((~subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & subsystemI2C_avalonS_waitrequest_n_from_sa & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & ((~subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & subsystemI2C_avalonS_waitrequest_n_from_sa & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & 1 & ((~subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & ((~subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & 1 & ((~subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1 | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~d1_subsystemSerialPort_s1_end_xfer & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & ((~subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1 | ~(~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU) | (1 & ~d1_subsystemSerialPort_s1_end_xfer & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU)))) & 1 & ((~subsystemMMU_avalonM_qualified_request_subsystemTimer_s1 | read_n_from_the_subsystemMMU | (1 & ~d1_subsystemTimer_s1_end_xfer & ~read_n_from_the_subsystemMMU))) & ((~subsystemMMU_avalonM_qualified_request_subsystemTimer_s1 | write_n_from_the_subsystemMMU | (1 & ~write_n_from_the_subsystemMMU)));

  //cascaded wait assignment, which is an e_assign
  assign subsystemMMU_avalonM_run = r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign address_from_the_subsystemMMU_to_slave = {2'b0,
    address_from_the_subsystemMMU[29 : 28],
    13'b0,
    address_from_the_subsystemMMU[14 : 12],
    8'b0,
    address_from_the_subsystemMMU[3 : 0]};

  //subsystemMMU/avalonM readdata mux, which is an e_mux
  assign readdata_to_the_subsystemMMU = ({16 {~subsystemMMU_avalonM_requests_keyboard_avalonS}} | keyboard_avalonS_readdata_from_sa) &
    ({16 {~subsystemMMU_avalonM_requests_subsystemI2C_avalonS}} | subsystemI2C_avalonS_readdata_from_sa) &
    ({16 {~subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave}} | subsystemJTAG_avalon_jtag_slave_readdata_from_sa) &
    ({16 {~subsystemMMU_avalonM_requests_subsystemSerialPort_s1}} | subsystemSerialPort_s1_readdata_from_sa) &
    ({16 {~subsystemMMU_avalonM_requests_subsystemTimer_s1}} | subsystemTimer_s1_readdata_from_sa);

  //actual waitrequest port, which is an e_assign
  assign waitrequest_to_the_subsystemMMU = ~subsystemMMU_avalonM_run;

  //reset_n_to_the_subsystemMMU assignment, which is an e_assign
  assign reset_n_to_the_subsystemMMU = reset_n;

  //irq mux, which is an e_mux
  assign irq_to_the_subsystemMMU = keyboard_avalonS_irq_from_sa |
    subsystemAudio_avalonS_irq_from_sa |
    subsystemJTAG_avalon_jtag_slave_irq_from_sa |
    subsystemTimer_s1_irq_from_sa;

  //mux subsystemMMU/avalonM irqnumber, which is an e_mux
  assign irqnumber_to_the_subsystemMMU = (subsystemJTAG_avalon_jtag_slave_irq_from_sa)? 2 :
    (subsystemTimer_s1_irq_from_sa)? 3 :
    (keyboard_avalonS_irq_from_sa)? 4 :
    6;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //address_from_the_subsystemMMU check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          address_from_the_subsystemMMU_last_time <= 0;
      else if (1)
          address_from_the_subsystemMMU_last_time <= address_from_the_subsystemMMU;
    end


  //subsystemMMU/avalonM waited last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          active_and_waiting_last_time <= 0;
      else if (1)
          active_and_waiting_last_time <= waitrequest_to_the_subsystemMMU & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU);
    end


  //address_from_the_subsystemMMU matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or address_from_the_subsystemMMU or address_from_the_subsystemMMU_last_time)
    begin
      if (active_and_waiting_last_time & (address_from_the_subsystemMMU != address_from_the_subsystemMMU_last_time))
        begin
          $write("%0d ns: address_from_the_subsystemMMU did not heed wait!!!", $time);
          $stop;
        end
    end


  //~read_n_from_the_subsystemMMU check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          read_n_from_the_subsystemMMU_last_time <= ~0;
      else if (1)
          read_n_from_the_subsystemMMU_last_time <= read_n_from_the_subsystemMMU;
    end


  //~read_n_from_the_subsystemMMU matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or read_n_from_the_subsystemMMU or read_n_from_the_subsystemMMU_last_time)
    begin
      if (active_and_waiting_last_time & (~read_n_from_the_subsystemMMU != ~read_n_from_the_subsystemMMU_last_time))
        begin
          $write("%0d ns: ~read_n_from_the_subsystemMMU did not heed wait!!!", $time);
          $stop;
        end
    end


  //~write_n_from_the_subsystemMMU check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          write_n_from_the_subsystemMMU_last_time <= ~0;
      else if (1)
          write_n_from_the_subsystemMMU_last_time <= write_n_from_the_subsystemMMU;
    end


  //~write_n_from_the_subsystemMMU matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or write_n_from_the_subsystemMMU or write_n_from_the_subsystemMMU_last_time)
    begin
      if (active_and_waiting_last_time & (~write_n_from_the_subsystemMMU != ~write_n_from_the_subsystemMMU_last_time))
        begin
          $write("%0d ns: ~write_n_from_the_subsystemMMU did not heed wait!!!", $time);
          $stop;
        end
    end


  //writedata_from_the_subsystemMMU check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          writedata_from_the_subsystemMMU_last_time <= 0;
      else if (1)
          writedata_from_the_subsystemMMU_last_time <= writedata_from_the_subsystemMMU;
    end


  //writedata_from_the_subsystemMMU matches last port_name, which is an e_process
  always @(active_and_waiting_last_time or write_n_from_the_subsystemMMU or writedata_from_the_subsystemMMU or writedata_from_the_subsystemMMU_last_time)
    begin
      if (active_and_waiting_last_time & (writedata_from_the_subsystemMMU != writedata_from_the_subsystemMMU_last_time) & ~write_n_from_the_subsystemMMU)
        begin
          $write("%0d ns: writedata_from_the_subsystemMMU did not heed wait!!!", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


module rdv_fifo_for_scarab_avalonM_to_subsystemSDRAM_s1_module (
                                                                 // inputs:
                                                                  clear_fifo,
                                                                  clk,
                                                                  data_in,
                                                                  read,
                                                                  reset_n,
                                                                  sync_reset,
                                                                  write,

                                                                 // outputs:
                                                                  data_out,
                                                                  empty,
                                                                  fifo_contains_ones_n,
                                                                  full
                                                               )
;

  output           data_out;
  output           empty;
  output           fifo_contains_ones_n;
  output           full;
  input            clear_fifo;
  input            clk;
  input            data_in;
  input            read;
  input            reset_n;
  input            sync_reset;
  input            write;

  wire             data_out;
  wire             empty;
  reg              fifo_contains_ones_n;
  wire             full;
  reg              full_0;
  reg              full_1;
  reg              full_2;
  reg              full_3;
  reg              full_4;
  reg              full_5;
  reg              full_6;
  wire             full_7;
  reg     [  3: 0] how_many_ones;
  wire    [  3: 0] one_count_minus_one;
  wire    [  3: 0] one_count_plus_one;
  wire             p0_full_0;
  wire             p0_stage_0;
  wire             p1_full_1;
  wire             p1_stage_1;
  wire             p2_full_2;
  wire             p2_stage_2;
  wire             p3_full_3;
  wire             p3_stage_3;
  wire             p4_full_4;
  wire             p4_stage_4;
  wire             p5_full_5;
  wire             p5_stage_5;
  wire             p6_full_6;
  wire             p6_stage_6;
  reg              stage_0;
  reg              stage_1;
  reg              stage_2;
  reg              stage_3;
  reg              stage_4;
  reg              stage_5;
  reg              stage_6;
  wire    [  3: 0] updated_one_count;
  assign data_out = stage_0;
  assign full = full_6;
  assign empty = !full_0;
  assign full_7 = 0;
  //data_6, which is an e_mux
  assign p6_stage_6 = ((full_7 & ~clear_fifo) == 0)? data_in :
    data_in;

  //data_reg_6, which is an e_register
  always @(posedge clk)
    begin
      if (clear_fifo | sync_reset | read | (write & !full_6))
          if (sync_reset & full_6 & !((full_7 == 0) & read & write))
              stage_6 <= 0;
          else 
            stage_6 <= p6_stage_6;
    end


  //control_6, which is an e_mux
  assign p6_full_6 = ((read & !write) == 0)? full_5 :
    0;

  //control_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_6 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_6 <= 0;
          else 
            full_6 <= p6_full_6;
    end


  //data_5, which is an e_mux
  assign p5_stage_5 = ((full_6 & ~clear_fifo) == 0)? data_in :
    stage_6;

  //data_reg_5, which is an e_register
  always @(posedge clk)
    begin
      if (clear_fifo | sync_reset | read | (write & !full_5))
          if (sync_reset & full_5 & !((full_6 == 0) & read & write))
              stage_5 <= 0;
          else 
            stage_5 <= p5_stage_5;
    end


  //control_5, which is an e_mux
  assign p5_full_5 = ((read & !write) == 0)? full_4 :
    full_6;

  //control_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_5 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_5 <= 0;
          else 
            full_5 <= p5_full_5;
    end


  //data_4, which is an e_mux
  assign p4_stage_4 = ((full_5 & ~clear_fifo) == 0)? data_in :
    stage_5;

  //data_reg_4, which is an e_register
  always @(posedge clk)
    begin
      if (clear_fifo | sync_reset | read | (write & !full_4))
          if (sync_reset & full_4 & !((full_5 == 0) & read & write))
              stage_4 <= 0;
          else 
            stage_4 <= p4_stage_4;
    end


  //control_4, which is an e_mux
  assign p4_full_4 = ((read & !write) == 0)? full_3 :
    full_5;

  //control_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_4 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_4 <= 0;
          else 
            full_4 <= p4_full_4;
    end


  //data_3, which is an e_mux
  assign p3_stage_3 = ((full_4 & ~clear_fifo) == 0)? data_in :
    stage_4;

  //data_reg_3, which is an e_register
  always @(posedge clk)
    begin
      if (clear_fifo | sync_reset | read | (write & !full_3))
          if (sync_reset & full_3 & !((full_4 == 0) & read & write))
              stage_3 <= 0;
          else 
            stage_3 <= p3_stage_3;
    end


  //control_3, which is an e_mux
  assign p3_full_3 = ((read & !write) == 0)? full_2 :
    full_4;

  //control_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_3 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_3 <= 0;
          else 
            full_3 <= p3_full_3;
    end


  //data_2, which is an e_mux
  assign p2_stage_2 = ((full_3 & ~clear_fifo) == 0)? data_in :
    stage_3;

  //data_reg_2, which is an e_register
  always @(posedge clk)
    begin
      if (clear_fifo | sync_reset | read | (write & !full_2))
          if (sync_reset & full_2 & !((full_3 == 0) & read & write))
              stage_2 <= 0;
          else 
            stage_2 <= p2_stage_2;
    end


  //control_2, which is an e_mux
  assign p2_full_2 = ((read & !write) == 0)? full_1 :
    full_3;

  //control_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_2 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_2 <= 0;
          else 
            full_2 <= p2_full_2;
    end


  //data_1, which is an e_mux
  assign p1_stage_1 = ((full_2 & ~clear_fifo) == 0)? data_in :
    stage_2;

  //data_reg_1, which is an e_register
  always @(posedge clk)
    begin
      if (clear_fifo | sync_reset | read | (write & !full_1))
          if (sync_reset & full_1 & !((full_2 == 0) & read & write))
              stage_1 <= 0;
          else 
            stage_1 <= p1_stage_1;
    end


  //control_1, which is an e_mux
  assign p1_full_1 = ((read & !write) == 0)? full_0 :
    full_2;

  //control_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_1 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_1 <= 0;
          else 
            full_1 <= p1_full_1;
    end


  //data_0, which is an e_mux
  assign p0_stage_0 = ((full_1 & ~clear_fifo) == 0)? data_in :
    stage_1;

  //data_reg_0, which is an e_register
  always @(posedge clk)
    begin
      if (clear_fifo | sync_reset | read | (write & !full_0))
          if (sync_reset & full_0 & !((full_1 == 0) & read & write))
              stage_0 <= 0;
          else 
            stage_0 <= p0_stage_0;
    end


  //control_0, which is an e_mux
  assign p0_full_0 = ((read & !write) == 0)? 1 :
    full_1;

  //control_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_0 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo & ~write)
              full_0 <= 0;
          else 
            full_0 <= p0_full_0;
    end


  assign one_count_plus_one = how_many_ones + 1;
  assign one_count_minus_one = how_many_ones - 1;
  //updated_one_count, which is an e_mux
  assign updated_one_count = ((((clear_fifo | sync_reset) & !write)))? 0 :
    ((((clear_fifo | sync_reset) & write)))? |data_in :
    ((read & (|data_in) & write & (|stage_0)))? how_many_ones :
    ((write & (|data_in)))? one_count_plus_one :
    ((read & (|stage_0)))? one_count_minus_one :
    how_many_ones;

  //counts how many ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          how_many_ones <= 0;
      else if (clear_fifo | sync_reset | read | write)
          how_many_ones <= updated_one_count;
    end


  //this fifo contains ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          fifo_contains_ones_n <= 1;
      else if (clear_fifo | sync_reset | read | write)
          fifo_contains_ones_n <= ~(|updated_one_count);
    end



endmodule


module subsystemSDRAM_s1_arbitrator (
                                      // inputs:
                                       ava_address_from_the_scarab_to_slave,
                                       ava_byteenable_from_the_scarab,
                                       ava_read_from_the_scarab,
                                       ava_write_from_the_scarab,
                                       ava_writedata_from_the_scarab,
                                       clk,
                                       reset_n,
                                       subsystemSDRAM_s1_readdata,
                                       subsystemSDRAM_s1_readdatavalid,
                                       subsystemSDRAM_s1_waitrequest,

                                      // outputs:
                                       d1_subsystemSDRAM_s1_end_xfer,
                                       scarab_avalonM_granted_subsystemSDRAM_s1,
                                       scarab_avalonM_qualified_request_subsystemSDRAM_s1,
                                       scarab_avalonM_read_data_valid_subsystemSDRAM_s1,
                                       scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register,
                                       scarab_avalonM_requests_subsystemSDRAM_s1,
                                       subsystemSDRAM_s1_address,
                                       subsystemSDRAM_s1_byteenable_n,
                                       subsystemSDRAM_s1_chipselect,
                                       subsystemSDRAM_s1_read_n,
                                       subsystemSDRAM_s1_readdata_from_sa,
                                       subsystemSDRAM_s1_reset_n,
                                       subsystemSDRAM_s1_waitrequest_from_sa,
                                       subsystemSDRAM_s1_write_n,
                                       subsystemSDRAM_s1_writedata
                                    )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           d1_subsystemSDRAM_s1_end_xfer;
  output           scarab_avalonM_granted_subsystemSDRAM_s1;
  output           scarab_avalonM_qualified_request_subsystemSDRAM_s1;
  output           scarab_avalonM_read_data_valid_subsystemSDRAM_s1;
  output           scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register;
  output           scarab_avalonM_requests_subsystemSDRAM_s1;
  output  [ 21: 0] subsystemSDRAM_s1_address;
  output  [  1: 0] subsystemSDRAM_s1_byteenable_n;
  output           subsystemSDRAM_s1_chipselect;
  output           subsystemSDRAM_s1_read_n;
  output  [ 15: 0] subsystemSDRAM_s1_readdata_from_sa;
  output           subsystemSDRAM_s1_reset_n;
  output           subsystemSDRAM_s1_waitrequest_from_sa;
  output           subsystemSDRAM_s1_write_n;
  output  [ 15: 0] subsystemSDRAM_s1_writedata;
  input   [ 22: 0] ava_address_from_the_scarab_to_slave;
  input   [  1: 0] ava_byteenable_from_the_scarab;
  input            ava_read_from_the_scarab;
  input            ava_write_from_the_scarab;
  input   [ 15: 0] ava_writedata_from_the_scarab;
  input            clk;
  input            reset_n;
  input   [ 15: 0] subsystemSDRAM_s1_readdata;
  input            subsystemSDRAM_s1_readdatavalid;
  input            subsystemSDRAM_s1_waitrequest;

  reg              d1_reasons_to_wait;
  reg              d1_subsystemSDRAM_s1_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             scarab_avalonM_arbiterlock;
  wire             scarab_avalonM_continuerequest;
  wire             scarab_avalonM_granted_subsystemSDRAM_s1;
  wire             scarab_avalonM_qualified_request_subsystemSDRAM_s1;
  wire             scarab_avalonM_rdv_fifo_empty_subsystemSDRAM_s1;
  wire             scarab_avalonM_rdv_fifo_output_from_subsystemSDRAM_s1;
  wire             scarab_avalonM_read_data_valid_subsystemSDRAM_s1;
  wire             scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register;
  wire             scarab_avalonM_requests_subsystemSDRAM_s1;
  wire             scarab_avalonM_saved_grant_subsystemSDRAM_s1;
  wire    [ 21: 0] subsystemSDRAM_s1_address;
  wire             subsystemSDRAM_s1_allgrants;
  wire             subsystemSDRAM_s1_allow_new_arb_cycle;
  wire             subsystemSDRAM_s1_any_continuerequest;
  wire             subsystemSDRAM_s1_arb_counter_enable;
  reg              subsystemSDRAM_s1_arb_share_counter;
  wire             subsystemSDRAM_s1_arb_share_counter_next_value;
  wire             subsystemSDRAM_s1_arb_share_set_values;
  wire             subsystemSDRAM_s1_beginbursttransfer_internal;
  wire             subsystemSDRAM_s1_begins_xfer;
  wire    [  1: 0] subsystemSDRAM_s1_byteenable_n;
  wire             subsystemSDRAM_s1_chipselect;
  wire             subsystemSDRAM_s1_end_xfer;
  wire             subsystemSDRAM_s1_firsttransfer;
  wire             subsystemSDRAM_s1_grant_vector;
  wire             subsystemSDRAM_s1_in_a_read_cycle;
  wire             subsystemSDRAM_s1_in_a_write_cycle;
  wire             subsystemSDRAM_s1_master_qreq_vector;
  wire             subsystemSDRAM_s1_move_on_to_next_transaction;
  wire             subsystemSDRAM_s1_read_n;
  wire    [ 15: 0] subsystemSDRAM_s1_readdata_from_sa;
  wire             subsystemSDRAM_s1_readdatavalid_from_sa;
  wire             subsystemSDRAM_s1_reset_n;
  reg              subsystemSDRAM_s1_slavearbiterlockenable;
  wire             subsystemSDRAM_s1_waitrequest_from_sa;
  wire             subsystemSDRAM_s1_waits_for_read;
  wire             subsystemSDRAM_s1_waits_for_write;
  wire             subsystemSDRAM_s1_write_n;
  wire    [ 15: 0] subsystemSDRAM_s1_writedata;
  wire             wait_for_subsystemSDRAM_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~subsystemSDRAM_s1_end_xfer;
    end


  assign subsystemSDRAM_s1_begins_xfer = ~d1_reasons_to_wait & ((scarab_avalonM_qualified_request_subsystemSDRAM_s1));
  //assign subsystemSDRAM_s1_readdata_from_sa = subsystemSDRAM_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemSDRAM_s1_readdata_from_sa = subsystemSDRAM_s1_readdata;

  assign scarab_avalonM_requests_subsystemSDRAM_s1 = (1) & (ava_read_from_the_scarab | ava_write_from_the_scarab);
  //assign subsystemSDRAM_s1_waitrequest_from_sa = subsystemSDRAM_s1_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemSDRAM_s1_waitrequest_from_sa = subsystemSDRAM_s1_waitrequest;

  //assign subsystemSDRAM_s1_readdatavalid_from_sa = subsystemSDRAM_s1_readdatavalid so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemSDRAM_s1_readdatavalid_from_sa = subsystemSDRAM_s1_readdatavalid;

  //subsystemSDRAM_s1_arb_share_counter set values, which is an e_mux
  assign subsystemSDRAM_s1_arb_share_set_values = 1;

  //subsystemSDRAM_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign subsystemSDRAM_s1_arb_share_counter_next_value = subsystemSDRAM_s1_firsttransfer ? (subsystemSDRAM_s1_arb_share_set_values - 1) : |subsystemSDRAM_s1_arb_share_counter ? (subsystemSDRAM_s1_arb_share_counter - 1) : 0;

  //subsystemSDRAM_s1_allgrants all slave grants, which is an e_mux
  assign subsystemSDRAM_s1_allgrants = |subsystemSDRAM_s1_grant_vector;

  //subsystemSDRAM_s1_end_xfer assignment, which is an e_assign
  assign subsystemSDRAM_s1_end_xfer = ~(subsystemSDRAM_s1_waits_for_read | subsystemSDRAM_s1_waits_for_write);

  //subsystemSDRAM_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign subsystemSDRAM_s1_arb_counter_enable = subsystemSDRAM_s1_end_xfer & subsystemSDRAM_s1_allgrants;

  //subsystemSDRAM_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemSDRAM_s1_arb_share_counter <= 0;
      else if (subsystemSDRAM_s1_arb_counter_enable)
          subsystemSDRAM_s1_arb_share_counter <= subsystemSDRAM_s1_arb_share_counter_next_value;
    end


  //subsystemSDRAM_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemSDRAM_s1_slavearbiterlockenable <= 0;
      else if (|subsystemSDRAM_s1_master_qreq_vector & subsystemSDRAM_s1_end_xfer)
          subsystemSDRAM_s1_slavearbiterlockenable <= |subsystemSDRAM_s1_arb_share_counter_next_value;
    end


  //scarab/avalonM subsystemSDRAM/s1 arbiterlock, which is an e_assign
  assign scarab_avalonM_arbiterlock = subsystemSDRAM_s1_slavearbiterlockenable & scarab_avalonM_continuerequest;

  //subsystemSDRAM_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign subsystemSDRAM_s1_any_continuerequest = 1;

  //scarab_avalonM_continuerequest continued request, which is an e_assign
  assign scarab_avalonM_continuerequest = 1;

  assign scarab_avalonM_qualified_request_subsystemSDRAM_s1 = scarab_avalonM_requests_subsystemSDRAM_s1 & ~((ava_read_from_the_scarab & ((|scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register))));
  //unique name for subsystemSDRAM_s1_move_on_to_next_transaction, which is an e_assign
  assign subsystemSDRAM_s1_move_on_to_next_transaction = subsystemSDRAM_s1_readdatavalid_from_sa;

  //rdv_fifo_for_scarab_avalonM_to_subsystemSDRAM_s1, which is an e_fifo_with_registered_outputs
  rdv_fifo_for_scarab_avalonM_to_subsystemSDRAM_s1_module rdv_fifo_for_scarab_avalonM_to_subsystemSDRAM_s1
    (
      .clear_fifo           (1'b0),
      .clk                  (clk),
      .data_in              (scarab_avalonM_granted_subsystemSDRAM_s1),
      .data_out             (scarab_avalonM_rdv_fifo_output_from_subsystemSDRAM_s1),
      .empty                (),
      .fifo_contains_ones_n (scarab_avalonM_rdv_fifo_empty_subsystemSDRAM_s1),
      .full                 (),
      .read                 (subsystemSDRAM_s1_move_on_to_next_transaction),
      .reset_n              (reset_n),
      .sync_reset           (1'b0),
      .write                (in_a_read_cycle & ~subsystemSDRAM_s1_waits_for_read)
    );

  assign scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register = ~scarab_avalonM_rdv_fifo_empty_subsystemSDRAM_s1;
  //local readdatavalid scarab_avalonM_read_data_valid_subsystemSDRAM_s1, which is an e_mux
  assign scarab_avalonM_read_data_valid_subsystemSDRAM_s1 = subsystemSDRAM_s1_readdatavalid_from_sa;

  //subsystemSDRAM_s1_writedata mux, which is an e_mux
  assign subsystemSDRAM_s1_writedata = ava_writedata_from_the_scarab;

  //master is always granted when requested
  assign scarab_avalonM_granted_subsystemSDRAM_s1 = scarab_avalonM_qualified_request_subsystemSDRAM_s1;

  //scarab/avalonM saved-grant subsystemSDRAM/s1, which is an e_assign
  assign scarab_avalonM_saved_grant_subsystemSDRAM_s1 = scarab_avalonM_requests_subsystemSDRAM_s1;

  //allow new arb cycle for subsystemSDRAM/s1, which is an e_assign
  assign subsystemSDRAM_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign subsystemSDRAM_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign subsystemSDRAM_s1_master_qreq_vector = 1;

  //subsystemSDRAM_s1_reset_n assignment, which is an e_assign
  assign subsystemSDRAM_s1_reset_n = reset_n;

  assign subsystemSDRAM_s1_chipselect = scarab_avalonM_granted_subsystemSDRAM_s1;
  //subsystemSDRAM_s1_firsttransfer first transaction, which is an e_assign
  assign subsystemSDRAM_s1_firsttransfer = ~(subsystemSDRAM_s1_slavearbiterlockenable & subsystemSDRAM_s1_any_continuerequest);

  //subsystemSDRAM_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign subsystemSDRAM_s1_beginbursttransfer_internal = subsystemSDRAM_s1_begins_xfer & subsystemSDRAM_s1_firsttransfer;

  //~subsystemSDRAM_s1_read_n assignment, which is an e_mux
  assign subsystemSDRAM_s1_read_n = ~(scarab_avalonM_granted_subsystemSDRAM_s1 & ava_read_from_the_scarab);

  //~subsystemSDRAM_s1_write_n assignment, which is an e_mux
  assign subsystemSDRAM_s1_write_n = ~(scarab_avalonM_granted_subsystemSDRAM_s1 & ava_write_from_the_scarab);

  //subsystemSDRAM_s1_address mux, which is an e_mux
  assign subsystemSDRAM_s1_address = ava_address_from_the_scarab_to_slave >> 1;

  //d1_subsystemSDRAM_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_subsystemSDRAM_s1_end_xfer <= 1;
      else if (1)
          d1_subsystemSDRAM_s1_end_xfer <= subsystemSDRAM_s1_end_xfer;
    end


  //subsystemSDRAM_s1_waits_for_read in a cycle, which is an e_mux
  assign subsystemSDRAM_s1_waits_for_read = subsystemSDRAM_s1_in_a_read_cycle & subsystemSDRAM_s1_waitrequest_from_sa;

  //subsystemSDRAM_s1_in_a_read_cycle assignment, which is an e_assign
  assign subsystemSDRAM_s1_in_a_read_cycle = scarab_avalonM_granted_subsystemSDRAM_s1 & ava_read_from_the_scarab;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = subsystemSDRAM_s1_in_a_read_cycle;

  //subsystemSDRAM_s1_waits_for_write in a cycle, which is an e_mux
  assign subsystemSDRAM_s1_waits_for_write = subsystemSDRAM_s1_in_a_write_cycle & subsystemSDRAM_s1_waitrequest_from_sa;

  //subsystemSDRAM_s1_in_a_write_cycle assignment, which is an e_assign
  assign subsystemSDRAM_s1_in_a_write_cycle = scarab_avalonM_granted_subsystemSDRAM_s1 & ava_write_from_the_scarab;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = subsystemSDRAM_s1_in_a_write_cycle;

  assign wait_for_subsystemSDRAM_s1_counter = 0;
  //~subsystemSDRAM_s1_byteenable_n byte enable port mux, which is an e_mux
  assign subsystemSDRAM_s1_byteenable_n = ~((scarab_avalonM_granted_subsystemSDRAM_s1)? ava_byteenable_from_the_scarab :
    -1);


endmodule


module subsystemSerialPort_s1_arbitrator (
                                           // inputs:
                                            address_from_the_subsystemMMU_to_slave,
                                            clk,
                                            read_n_from_the_subsystemMMU,
                                            reset_n,
                                            subsystemSerialPort_s1_dataavailable,
                                            subsystemSerialPort_s1_readdata,
                                            subsystemSerialPort_s1_readyfordata,
                                            write_n_from_the_subsystemMMU,
                                            writedata_from_the_subsystemMMU,

                                           // outputs:
                                            d1_subsystemSerialPort_s1_end_xfer,
                                            subsystemMMU_avalonM_granted_subsystemSerialPort_s1,
                                            subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1,
                                            subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1,
                                            subsystemMMU_avalonM_requests_subsystemSerialPort_s1,
                                            subsystemSerialPort_s1_address,
                                            subsystemSerialPort_s1_begintransfer,
                                            subsystemSerialPort_s1_chipselect,
                                            subsystemSerialPort_s1_dataavailable_from_sa,
                                            subsystemSerialPort_s1_read_n,
                                            subsystemSerialPort_s1_readdata_from_sa,
                                            subsystemSerialPort_s1_readyfordata_from_sa,
                                            subsystemSerialPort_s1_reset_n,
                                            subsystemSerialPort_s1_write_n,
                                            subsystemSerialPort_s1_writedata
                                         )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           d1_subsystemSerialPort_s1_end_xfer;
  output           subsystemMMU_avalonM_granted_subsystemSerialPort_s1;
  output           subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1;
  output           subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1;
  output           subsystemMMU_avalonM_requests_subsystemSerialPort_s1;
  output  [  2: 0] subsystemSerialPort_s1_address;
  output           subsystemSerialPort_s1_begintransfer;
  output           subsystemSerialPort_s1_chipselect;
  output           subsystemSerialPort_s1_dataavailable_from_sa;
  output           subsystemSerialPort_s1_read_n;
  output  [ 15: 0] subsystemSerialPort_s1_readdata_from_sa;
  output           subsystemSerialPort_s1_readyfordata_from_sa;
  output           subsystemSerialPort_s1_reset_n;
  output           subsystemSerialPort_s1_write_n;
  output  [ 15: 0] subsystemSerialPort_s1_writedata;
  input   [ 31: 0] address_from_the_subsystemMMU_to_slave;
  input            clk;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input            subsystemSerialPort_s1_dataavailable;
  input   [ 15: 0] subsystemSerialPort_s1_readdata;
  input            subsystemSerialPort_s1_readyfordata;
  input            write_n_from_the_subsystemMMU;
  input   [ 15: 0] writedata_from_the_subsystemMMU;

  reg              d1_reasons_to_wait;
  reg              d1_subsystemSerialPort_s1_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             subsystemMMU_avalonM_arbiterlock;
  wire             subsystemMMU_avalonM_continuerequest;
  wire             subsystemMMU_avalonM_granted_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_requests_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_saved_grant_subsystemSerialPort_s1;
  wire    [  2: 0] subsystemSerialPort_s1_address;
  wire             subsystemSerialPort_s1_allgrants;
  wire             subsystemSerialPort_s1_allow_new_arb_cycle;
  wire             subsystemSerialPort_s1_any_continuerequest;
  wire             subsystemSerialPort_s1_arb_counter_enable;
  reg              subsystemSerialPort_s1_arb_share_counter;
  wire             subsystemSerialPort_s1_arb_share_counter_next_value;
  wire             subsystemSerialPort_s1_arb_share_set_values;
  wire             subsystemSerialPort_s1_beginbursttransfer_internal;
  wire             subsystemSerialPort_s1_begins_xfer;
  wire             subsystemSerialPort_s1_begintransfer;
  wire             subsystemSerialPort_s1_chipselect;
  wire             subsystemSerialPort_s1_dataavailable_from_sa;
  wire             subsystemSerialPort_s1_end_xfer;
  wire             subsystemSerialPort_s1_firsttransfer;
  wire             subsystemSerialPort_s1_grant_vector;
  wire             subsystemSerialPort_s1_in_a_read_cycle;
  wire             subsystemSerialPort_s1_in_a_write_cycle;
  wire             subsystemSerialPort_s1_master_qreq_vector;
  wire             subsystemSerialPort_s1_read_n;
  wire    [ 15: 0] subsystemSerialPort_s1_readdata_from_sa;
  wire             subsystemSerialPort_s1_readyfordata_from_sa;
  wire             subsystemSerialPort_s1_reset_n;
  reg              subsystemSerialPort_s1_slavearbiterlockenable;
  wire             subsystemSerialPort_s1_waits_for_read;
  wire             subsystemSerialPort_s1_waits_for_write;
  wire             subsystemSerialPort_s1_write_n;
  wire    [ 15: 0] subsystemSerialPort_s1_writedata;
  wire             wait_for_subsystemSerialPort_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~subsystemSerialPort_s1_end_xfer;
    end


  assign subsystemSerialPort_s1_begins_xfer = ~d1_reasons_to_wait & ((subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1));
  //assign subsystemSerialPort_s1_readdata_from_sa = subsystemSerialPort_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemSerialPort_s1_readdata_from_sa = subsystemSerialPort_s1_readdata;

  assign subsystemMMU_avalonM_requests_subsystemSerialPort_s1 = ({address_from_the_subsystemMMU_to_slave[31 : 4] , 4'b0} == 32'h20000000) & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU);
  //assign subsystemSerialPort_s1_dataavailable_from_sa = subsystemSerialPort_s1_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemSerialPort_s1_dataavailable_from_sa = subsystemSerialPort_s1_dataavailable;

  //assign subsystemSerialPort_s1_readyfordata_from_sa = subsystemSerialPort_s1_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemSerialPort_s1_readyfordata_from_sa = subsystemSerialPort_s1_readyfordata;

  //subsystemSerialPort_s1_arb_share_counter set values, which is an e_mux
  assign subsystemSerialPort_s1_arb_share_set_values = 1;

  //subsystemSerialPort_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign subsystemSerialPort_s1_arb_share_counter_next_value = subsystemSerialPort_s1_firsttransfer ? (subsystemSerialPort_s1_arb_share_set_values - 1) : |subsystemSerialPort_s1_arb_share_counter ? (subsystemSerialPort_s1_arb_share_counter - 1) : 0;

  //subsystemSerialPort_s1_allgrants all slave grants, which is an e_mux
  assign subsystemSerialPort_s1_allgrants = |subsystemSerialPort_s1_grant_vector;

  //subsystemSerialPort_s1_end_xfer assignment, which is an e_assign
  assign subsystemSerialPort_s1_end_xfer = ~(subsystemSerialPort_s1_waits_for_read | subsystemSerialPort_s1_waits_for_write);

  //subsystemSerialPort_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign subsystemSerialPort_s1_arb_counter_enable = subsystemSerialPort_s1_end_xfer & subsystemSerialPort_s1_allgrants;

  //subsystemSerialPort_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemSerialPort_s1_arb_share_counter <= 0;
      else if (subsystemSerialPort_s1_arb_counter_enable)
          subsystemSerialPort_s1_arb_share_counter <= subsystemSerialPort_s1_arb_share_counter_next_value;
    end


  //subsystemSerialPort_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemSerialPort_s1_slavearbiterlockenable <= 0;
      else if (|subsystemSerialPort_s1_master_qreq_vector & subsystemSerialPort_s1_end_xfer)
          subsystemSerialPort_s1_slavearbiterlockenable <= |subsystemSerialPort_s1_arb_share_counter_next_value;
    end


  //subsystemMMU/avalonM subsystemSerialPort/s1 arbiterlock, which is an e_assign
  assign subsystemMMU_avalonM_arbiterlock = subsystemSerialPort_s1_slavearbiterlockenable & subsystemMMU_avalonM_continuerequest;

  //subsystemSerialPort_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign subsystemSerialPort_s1_any_continuerequest = 1;

  //subsystemMMU_avalonM_continuerequest continued request, which is an e_assign
  assign subsystemMMU_avalonM_continuerequest = 1;

  assign subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1 = subsystemMMU_avalonM_requests_subsystemSerialPort_s1;
  //subsystemSerialPort_s1_writedata mux, which is an e_mux
  assign subsystemSerialPort_s1_writedata = writedata_from_the_subsystemMMU;

  //master is always granted when requested
  assign subsystemMMU_avalonM_granted_subsystemSerialPort_s1 = subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1;

  //subsystemMMU/avalonM saved-grant subsystemSerialPort/s1, which is an e_assign
  assign subsystemMMU_avalonM_saved_grant_subsystemSerialPort_s1 = subsystemMMU_avalonM_requests_subsystemSerialPort_s1;

  //allow new arb cycle for subsystemSerialPort/s1, which is an e_assign
  assign subsystemSerialPort_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign subsystemSerialPort_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign subsystemSerialPort_s1_master_qreq_vector = 1;

  assign subsystemSerialPort_s1_begintransfer = subsystemSerialPort_s1_begins_xfer;
  //subsystemSerialPort_s1_reset_n assignment, which is an e_assign
  assign subsystemSerialPort_s1_reset_n = reset_n;

  assign subsystemSerialPort_s1_chipselect = subsystemMMU_avalonM_granted_subsystemSerialPort_s1;
  //subsystemSerialPort_s1_firsttransfer first transaction, which is an e_assign
  assign subsystemSerialPort_s1_firsttransfer = ~(subsystemSerialPort_s1_slavearbiterlockenable & subsystemSerialPort_s1_any_continuerequest);

  //subsystemSerialPort_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign subsystemSerialPort_s1_beginbursttransfer_internal = subsystemSerialPort_s1_begins_xfer & subsystemSerialPort_s1_firsttransfer;

  //~subsystemSerialPort_s1_read_n assignment, which is an e_mux
  assign subsystemSerialPort_s1_read_n = ~(subsystemMMU_avalonM_granted_subsystemSerialPort_s1 & ~read_n_from_the_subsystemMMU);

  //~subsystemSerialPort_s1_write_n assignment, which is an e_mux
  assign subsystemSerialPort_s1_write_n = ~(subsystemMMU_avalonM_granted_subsystemSerialPort_s1 & ~write_n_from_the_subsystemMMU);

  //subsystemSerialPort_s1_address mux, which is an e_mux
  assign subsystemSerialPort_s1_address = address_from_the_subsystemMMU_to_slave >> 1;

  //d1_subsystemSerialPort_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_subsystemSerialPort_s1_end_xfer <= 1;
      else if (1)
          d1_subsystemSerialPort_s1_end_xfer <= subsystemSerialPort_s1_end_xfer;
    end


  //subsystemSerialPort_s1_waits_for_read in a cycle, which is an e_mux
  assign subsystemSerialPort_s1_waits_for_read = subsystemSerialPort_s1_in_a_read_cycle & subsystemSerialPort_s1_begins_xfer;

  //subsystemSerialPort_s1_in_a_read_cycle assignment, which is an e_assign
  assign subsystemSerialPort_s1_in_a_read_cycle = subsystemMMU_avalonM_granted_subsystemSerialPort_s1 & ~read_n_from_the_subsystemMMU;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = subsystemSerialPort_s1_in_a_read_cycle;

  //subsystemSerialPort_s1_waits_for_write in a cycle, which is an e_mux
  assign subsystemSerialPort_s1_waits_for_write = subsystemSerialPort_s1_in_a_write_cycle & subsystemSerialPort_s1_begins_xfer;

  //subsystemSerialPort_s1_in_a_write_cycle assignment, which is an e_assign
  assign subsystemSerialPort_s1_in_a_write_cycle = subsystemMMU_avalonM_granted_subsystemSerialPort_s1 & ~write_n_from_the_subsystemMMU;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = subsystemSerialPort_s1_in_a_write_cycle;

  assign wait_for_subsystemSerialPort_s1_counter = 0;

endmodule


module subsystemTimer_s1_arbitrator (
                                      // inputs:
                                       address_from_the_subsystemMMU_to_slave,
                                       clk,
                                       read_n_from_the_subsystemMMU,
                                       reset_n,
                                       subsystemTimer_s1_irq,
                                       subsystemTimer_s1_readdata,
                                       write_n_from_the_subsystemMMU,
                                       writedata_from_the_subsystemMMU,

                                      // outputs:
                                       d1_subsystemTimer_s1_end_xfer,
                                       subsystemMMU_avalonM_granted_subsystemTimer_s1,
                                       subsystemMMU_avalonM_qualified_request_subsystemTimer_s1,
                                       subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1,
                                       subsystemMMU_avalonM_requests_subsystemTimer_s1,
                                       subsystemTimer_s1_address,
                                       subsystemTimer_s1_chipselect,
                                       subsystemTimer_s1_irq_from_sa,
                                       subsystemTimer_s1_readdata_from_sa,
                                       subsystemTimer_s1_reset_n,
                                       subsystemTimer_s1_write_n,
                                       subsystemTimer_s1_writedata
                                    )
  /* synthesis auto_dissolve = "FALSE" */ ;

  output           d1_subsystemTimer_s1_end_xfer;
  output           subsystemMMU_avalonM_granted_subsystemTimer_s1;
  output           subsystemMMU_avalonM_qualified_request_subsystemTimer_s1;
  output           subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1;
  output           subsystemMMU_avalonM_requests_subsystemTimer_s1;
  output  [  2: 0] subsystemTimer_s1_address;
  output           subsystemTimer_s1_chipselect;
  output           subsystemTimer_s1_irq_from_sa;
  output  [ 15: 0] subsystemTimer_s1_readdata_from_sa;
  output           subsystemTimer_s1_reset_n;
  output           subsystemTimer_s1_write_n;
  output  [ 15: 0] subsystemTimer_s1_writedata;
  input   [ 31: 0] address_from_the_subsystemMMU_to_slave;
  input            clk;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input            subsystemTimer_s1_irq;
  input   [ 15: 0] subsystemTimer_s1_readdata;
  input            write_n_from_the_subsystemMMU;
  input   [ 15: 0] writedata_from_the_subsystemMMU;

  reg              d1_reasons_to_wait;
  reg              d1_subsystemTimer_s1_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             subsystemMMU_avalonM_arbiterlock;
  wire             subsystemMMU_avalonM_continuerequest;
  wire             subsystemMMU_avalonM_granted_subsystemTimer_s1;
  wire             subsystemMMU_avalonM_qualified_request_subsystemTimer_s1;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1;
  wire             subsystemMMU_avalonM_requests_subsystemTimer_s1;
  wire             subsystemMMU_avalonM_saved_grant_subsystemTimer_s1;
  wire    [  2: 0] subsystemTimer_s1_address;
  wire             subsystemTimer_s1_allgrants;
  wire             subsystemTimer_s1_allow_new_arb_cycle;
  wire             subsystemTimer_s1_any_continuerequest;
  wire             subsystemTimer_s1_arb_counter_enable;
  reg              subsystemTimer_s1_arb_share_counter;
  wire             subsystemTimer_s1_arb_share_counter_next_value;
  wire             subsystemTimer_s1_arb_share_set_values;
  wire             subsystemTimer_s1_beginbursttransfer_internal;
  wire             subsystemTimer_s1_begins_xfer;
  wire             subsystemTimer_s1_chipselect;
  wire             subsystemTimer_s1_end_xfer;
  wire             subsystemTimer_s1_firsttransfer;
  wire             subsystemTimer_s1_grant_vector;
  wire             subsystemTimer_s1_in_a_read_cycle;
  wire             subsystemTimer_s1_in_a_write_cycle;
  wire             subsystemTimer_s1_irq_from_sa;
  wire             subsystemTimer_s1_master_qreq_vector;
  wire    [ 15: 0] subsystemTimer_s1_readdata_from_sa;
  wire             subsystemTimer_s1_reset_n;
  reg              subsystemTimer_s1_slavearbiterlockenable;
  wire             subsystemTimer_s1_waits_for_read;
  wire             subsystemTimer_s1_waits_for_write;
  wire             subsystemTimer_s1_write_n;
  wire    [ 15: 0] subsystemTimer_s1_writedata;
  wire             wait_for_subsystemTimer_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~subsystemTimer_s1_end_xfer;
    end


  assign subsystemTimer_s1_begins_xfer = ~d1_reasons_to_wait & ((subsystemMMU_avalonM_qualified_request_subsystemTimer_s1));
  //assign subsystemTimer_s1_readdata_from_sa = subsystemTimer_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemTimer_s1_readdata_from_sa = subsystemTimer_s1_readdata;

  assign subsystemMMU_avalonM_requests_subsystemTimer_s1 = ({address_from_the_subsystemMMU_to_slave[31 : 4] , 4'b0} == 32'h20005000) & (~read_n_from_the_subsystemMMU | ~write_n_from_the_subsystemMMU);
  //subsystemTimer_s1_arb_share_counter set values, which is an e_mux
  assign subsystemTimer_s1_arb_share_set_values = 1;

  //subsystemTimer_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign subsystemTimer_s1_arb_share_counter_next_value = subsystemTimer_s1_firsttransfer ? (subsystemTimer_s1_arb_share_set_values - 1) : |subsystemTimer_s1_arb_share_counter ? (subsystemTimer_s1_arb_share_counter - 1) : 0;

  //subsystemTimer_s1_allgrants all slave grants, which is an e_mux
  assign subsystemTimer_s1_allgrants = |subsystemTimer_s1_grant_vector;

  //subsystemTimer_s1_end_xfer assignment, which is an e_assign
  assign subsystemTimer_s1_end_xfer = ~(subsystemTimer_s1_waits_for_read | subsystemTimer_s1_waits_for_write);

  //subsystemTimer_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign subsystemTimer_s1_arb_counter_enable = subsystemTimer_s1_end_xfer & subsystemTimer_s1_allgrants;

  //subsystemTimer_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemTimer_s1_arb_share_counter <= 0;
      else if (subsystemTimer_s1_arb_counter_enable)
          subsystemTimer_s1_arb_share_counter <= subsystemTimer_s1_arb_share_counter_next_value;
    end


  //subsystemTimer_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          subsystemTimer_s1_slavearbiterlockenable <= 0;
      else if (|subsystemTimer_s1_master_qreq_vector & subsystemTimer_s1_end_xfer)
          subsystemTimer_s1_slavearbiterlockenable <= |subsystemTimer_s1_arb_share_counter_next_value;
    end


  //subsystemMMU/avalonM subsystemTimer/s1 arbiterlock, which is an e_assign
  assign subsystemMMU_avalonM_arbiterlock = subsystemTimer_s1_slavearbiterlockenable & subsystemMMU_avalonM_continuerequest;

  //subsystemTimer_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign subsystemTimer_s1_any_continuerequest = 1;

  //subsystemMMU_avalonM_continuerequest continued request, which is an e_assign
  assign subsystemMMU_avalonM_continuerequest = 1;

  assign subsystemMMU_avalonM_qualified_request_subsystemTimer_s1 = subsystemMMU_avalonM_requests_subsystemTimer_s1;
  //subsystemTimer_s1_writedata mux, which is an e_mux
  assign subsystemTimer_s1_writedata = writedata_from_the_subsystemMMU;

  //master is always granted when requested
  assign subsystemMMU_avalonM_granted_subsystemTimer_s1 = subsystemMMU_avalonM_qualified_request_subsystemTimer_s1;

  //subsystemMMU/avalonM saved-grant subsystemTimer/s1, which is an e_assign
  assign subsystemMMU_avalonM_saved_grant_subsystemTimer_s1 = subsystemMMU_avalonM_requests_subsystemTimer_s1;

  //allow new arb cycle for subsystemTimer/s1, which is an e_assign
  assign subsystemTimer_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign subsystemTimer_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign subsystemTimer_s1_master_qreq_vector = 1;

  //subsystemTimer_s1_reset_n assignment, which is an e_assign
  assign subsystemTimer_s1_reset_n = reset_n;

  assign subsystemTimer_s1_chipselect = subsystemMMU_avalonM_granted_subsystemTimer_s1;
  //subsystemTimer_s1_firsttransfer first transaction, which is an e_assign
  assign subsystemTimer_s1_firsttransfer = ~(subsystemTimer_s1_slavearbiterlockenable & subsystemTimer_s1_any_continuerequest);

  //subsystemTimer_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign subsystemTimer_s1_beginbursttransfer_internal = subsystemTimer_s1_begins_xfer & subsystemTimer_s1_firsttransfer;

  //~subsystemTimer_s1_write_n assignment, which is an e_mux
  assign subsystemTimer_s1_write_n = ~(subsystemMMU_avalonM_granted_subsystemTimer_s1 & ~write_n_from_the_subsystemMMU);

  //subsystemTimer_s1_address mux, which is an e_mux
  assign subsystemTimer_s1_address = address_from_the_subsystemMMU_to_slave >> 1;

  //d1_subsystemTimer_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_subsystemTimer_s1_end_xfer <= 1;
      else if (1)
          d1_subsystemTimer_s1_end_xfer <= subsystemTimer_s1_end_xfer;
    end


  //subsystemTimer_s1_waits_for_read in a cycle, which is an e_mux
  assign subsystemTimer_s1_waits_for_read = subsystemTimer_s1_in_a_read_cycle & subsystemTimer_s1_begins_xfer;

  //subsystemTimer_s1_in_a_read_cycle assignment, which is an e_assign
  assign subsystemTimer_s1_in_a_read_cycle = subsystemMMU_avalonM_granted_subsystemTimer_s1 & ~read_n_from_the_subsystemMMU;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = subsystemTimer_s1_in_a_read_cycle;

  //subsystemTimer_s1_waits_for_write in a cycle, which is an e_mux
  assign subsystemTimer_s1_waits_for_write = subsystemTimer_s1_in_a_write_cycle & 0;

  //subsystemTimer_s1_in_a_write_cycle assignment, which is an e_assign
  assign subsystemTimer_s1_in_a_write_cycle = subsystemMMU_avalonM_granted_subsystemTimer_s1 & ~write_n_from_the_subsystemMMU;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = subsystemTimer_s1_in_a_write_cycle;

  assign wait_for_subsystemTimer_s1_counter = 0;
  //assign subsystemTimer_s1_irq_from_sa = subsystemTimer_s1_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign subsystemTimer_s1_irq_from_sa = subsystemTimer_s1_irq;


endmodule


module systemAvalon_reset_clk_domain_synch_module (
                                                    // inputs:
                                                     clk,
                                                     data_in,
                                                     reset_n,

                                                    // outputs:
                                                     data_out
                                                  )
;

  output           data_out;
  input            clk;
  input            data_in;
  input            reset_n;

  reg              data_in_d1 /* synthesis ALTERA_ATTRIBUTE =  "MAX_DELAY=\"100ns\" ; PRESERVE_REGISTER=ON" */;
  reg              data_out /* synthesis ALTERA_ATTRIBUTE =  "PRESERVE_REGISTER=ON" */;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_in_d1 <= 0;
      else if (1)
          data_in_d1 <= data_in;
    end


  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_out <= 0;
      else if (1)
          data_out <= data_in_d1;
    end



endmodule


module systemAvalon (
                      // 1) global signals:
                       clk,
                       reset_n,

                      // the_keyboard
                       PS2_CLK_to_and_from_the_keyboard,
                       PS2_DAT_to_and_from_the_keyboard,

                      // the_scarab_avalonM
                       ava_address_from_the_scarab,
                       ava_byteenable_from_the_scarab,
                       ava_read_from_the_scarab,
                       ava_readdata_to_the_scarab,
                       ava_waitrequest_to_the_scarab,
                       ava_write_from_the_scarab,
                       ava_writedata_from_the_scarab,

                      // the_subsystemAudio
                       iCLK_18_4_to_the_subsystemAudio,
                       oAUD_BCK_from_the_subsystemAudio,
                       oAUD_DATA_from_the_subsystemAudio,
                       oAUD_LRCK_from_the_subsystemAudio,

                      // the_subsystemI2C
                       scl_pad_i_to_the_subsystemI2C,
                       scl_pad_o_from_the_subsystemI2C,
                       scl_padoen_o_from_the_subsystemI2C,
                       sda_pad_i_to_the_subsystemI2C,
                       sda_pad_o_from_the_subsystemI2C,
                       sda_padoen_o_from_the_subsystemI2C,

                      // the_subsystemMMU_avalonM
                       address_from_the_subsystemMMU,
                       byteenable_from_the_subsystemMMU,
                       irq_to_the_subsystemMMU,
                       irqnumber_to_the_subsystemMMU,
                       read_n_from_the_subsystemMMU,
                       readdata_to_the_subsystemMMU,
                       reset_n_to_the_subsystemMMU,
                       waitrequest_to_the_subsystemMMU,
                       write_n_from_the_subsystemMMU,
                       writedata_from_the_subsystemMMU,

                      // the_subsystemSDRAM
                       zs_addr_from_the_subsystemSDRAM,
                       zs_ba_from_the_subsystemSDRAM,
                       zs_cas_n_from_the_subsystemSDRAM,
                       zs_cke_from_the_subsystemSDRAM,
                       zs_cs_n_from_the_subsystemSDRAM,
                       zs_dq_to_and_from_the_subsystemSDRAM,
                       zs_dqm_from_the_subsystemSDRAM,
                       zs_ras_n_from_the_subsystemSDRAM,
                       zs_we_n_from_the_subsystemSDRAM,

                      // the_subsystemSerialPort
                       rxd_to_the_subsystemSerialPort,
                       txd_from_the_subsystemSerialPort
                    )
;

  inout            PS2_CLK_to_and_from_the_keyboard;
  inout            PS2_DAT_to_and_from_the_keyboard;
  output  [ 15: 0] ava_readdata_to_the_scarab;
  output           ava_waitrequest_to_the_scarab;
  output           irq_to_the_subsystemMMU;
  output  [  5: 0] irqnumber_to_the_subsystemMMU;
  output           oAUD_BCK_from_the_subsystemAudio;
  output           oAUD_DATA_from_the_subsystemAudio;
  output           oAUD_LRCK_from_the_subsystemAudio;
  output  [ 15: 0] readdata_to_the_subsystemMMU;
  output           reset_n_to_the_subsystemMMU;
  output           scl_pad_o_from_the_subsystemI2C;
  output           scl_padoen_o_from_the_subsystemI2C;
  output           sda_pad_o_from_the_subsystemI2C;
  output           sda_padoen_o_from_the_subsystemI2C;
  output           txd_from_the_subsystemSerialPort;
  output           waitrequest_to_the_subsystemMMU;
  output  [ 11: 0] zs_addr_from_the_subsystemSDRAM;
  output  [  1: 0] zs_ba_from_the_subsystemSDRAM;
  output           zs_cas_n_from_the_subsystemSDRAM;
  output           zs_cke_from_the_subsystemSDRAM;
  output           zs_cs_n_from_the_subsystemSDRAM;
  inout   [ 15: 0] zs_dq_to_and_from_the_subsystemSDRAM;
  output  [  1: 0] zs_dqm_from_the_subsystemSDRAM;
  output           zs_ras_n_from_the_subsystemSDRAM;
  output           zs_we_n_from_the_subsystemSDRAM;
  input   [ 31: 0] address_from_the_subsystemMMU;
  input   [ 22: 0] ava_address_from_the_scarab;
  input   [  1: 0] ava_byteenable_from_the_scarab;
  input            ava_read_from_the_scarab;
  input            ava_write_from_the_scarab;
  input   [ 15: 0] ava_writedata_from_the_scarab;
  input   [  1: 0] byteenable_from_the_subsystemMMU;
  input            clk;
  input            iCLK_18_4_to_the_subsystemAudio;
  input            read_n_from_the_subsystemMMU;
  input            reset_n;
  input            rxd_to_the_subsystemSerialPort;
  input            scl_pad_i_to_the_subsystemI2C;
  input            sda_pad_i_to_the_subsystemI2C;
  input            write_n_from_the_subsystemMMU;
  input   [ 15: 0] writedata_from_the_subsystemMMU;

  wire             PS2_CLK_to_and_from_the_keyboard;
  wire             PS2_DAT_to_and_from_the_keyboard;
  wire    [ 31: 0] address_from_the_subsystemMMU_to_slave;
  wire    [ 22: 0] ava_address_from_the_scarab_to_slave;
  wire    [ 15: 0] ava_readdata_to_the_scarab;
  wire             ava_waitrequest_to_the_scarab;
  wire             clk_reset_n;
  wire             d1_keyboard_avalonS_end_xfer;
  wire             d1_subsystemAudio_avalonS_end_xfer;
  wire             d1_subsystemI2C_avalonS_end_xfer;
  wire             d1_subsystemJTAG_avalon_jtag_slave_end_xfer;
  wire             d1_subsystemSDRAM_s1_end_xfer;
  wire             d1_subsystemSerialPort_s1_end_xfer;
  wire             d1_subsystemTimer_s1_end_xfer;
  wire             irq_to_the_subsystemMMU;
  wire    [  5: 0] irqnumber_to_the_subsystemMMU;
  wire             keyboard_avalonS_chipselect;
  wire             keyboard_avalonS_dataavailable;
  wire             keyboard_avalonS_dataavailable_from_sa;
  wire             keyboard_avalonS_irq;
  wire             keyboard_avalonS_irq_from_sa;
  wire    [ 15: 0] keyboard_avalonS_readdata;
  wire    [ 15: 0] keyboard_avalonS_readdata_from_sa;
  wire             keyboard_avalonS_reset;
  wire             oAUD_BCK_from_the_subsystemAudio;
  wire             oAUD_DATA_from_the_subsystemAudio;
  wire             oAUD_LRCK_from_the_subsystemAudio;
  wire    [ 15: 0] readdata_to_the_subsystemMMU;
  wire             reset_n_sources;
  wire             reset_n_to_the_subsystemMMU;
  wire             scarab_avalonM_granted_subsystemSDRAM_s1;
  wire             scarab_avalonM_qualified_request_subsystemSDRAM_s1;
  wire             scarab_avalonM_read_data_valid_subsystemSDRAM_s1;
  wire             scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register;
  wire             scarab_avalonM_requests_subsystemSDRAM_s1;
  wire             scl_pad_o_from_the_subsystemI2C;
  wire             scl_padoen_o_from_the_subsystemI2C;
  wire             sda_pad_o_from_the_subsystemI2C;
  wire             sda_padoen_o_from_the_subsystemI2C;
  wire             subsystemAudio_avalonS_chipselect;
  wire             subsystemAudio_avalonS_irq;
  wire             subsystemAudio_avalonS_irq_from_sa;
  wire             subsystemAudio_avalonS_reset_n;
  wire             subsystemAudio_avalonS_waitrequest;
  wire             subsystemAudio_avalonS_waitrequest_from_sa;
  wire             subsystemAudio_avalonS_write_n;
  wire    [ 15: 0] subsystemAudio_avalonS_writedata;
  wire    [  2: 0] subsystemI2C_avalonS_address;
  wire             subsystemI2C_avalonS_always0;
  wire             subsystemI2C_avalonS_chipselect;
  wire             subsystemI2C_avalonS_irq;
  wire    [  7: 0] subsystemI2C_avalonS_readdata;
  wire    [  7: 0] subsystemI2C_avalonS_readdata_from_sa;
  wire             subsystemI2C_avalonS_reset_n;
  wire             subsystemI2C_avalonS_waitrequest_n;
  wire             subsystemI2C_avalonS_waitrequest_n_from_sa;
  wire             subsystemI2C_avalonS_write;
  wire    [  7: 0] subsystemI2C_avalonS_writedata;
  wire             subsystemJTAG_avalon_jtag_slave_address;
  wire             subsystemJTAG_avalon_jtag_slave_chipselect;
  wire             subsystemJTAG_avalon_jtag_slave_dataavailable;
  wire             subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_irq;
  wire             subsystemJTAG_avalon_jtag_slave_irq_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_read_n;
  wire    [ 31: 0] subsystemJTAG_avalon_jtag_slave_readdata;
  wire    [ 31: 0] subsystemJTAG_avalon_jtag_slave_readdata_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_readyfordata;
  wire             subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_reset_n;
  wire             subsystemJTAG_avalon_jtag_slave_waitrequest;
  wire             subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_write_n;
  wire    [ 31: 0] subsystemJTAG_avalon_jtag_slave_writedata;
  wire             subsystemMMU_avalonM_granted_keyboard_avalonS;
  wire             subsystemMMU_avalonM_granted_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_granted_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_granted_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_granted_subsystemTimer_s1;
  wire             subsystemMMU_avalonM_qualified_request_keyboard_avalonS;
  wire             subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_qualified_request_subsystemTimer_s1;
  wire             subsystemMMU_avalonM_read_data_valid_keyboard_avalonS;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1;
  wire             subsystemMMU_avalonM_requests_keyboard_avalonS;
  wire             subsystemMMU_avalonM_requests_subsystemAudio_avalonS;
  wire             subsystemMMU_avalonM_requests_subsystemI2C_avalonS;
  wire             subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave;
  wire             subsystemMMU_avalonM_requests_subsystemSerialPort_s1;
  wire             subsystemMMU_avalonM_requests_subsystemTimer_s1;
  wire    [ 21: 0] subsystemSDRAM_s1_address;
  wire    [  1: 0] subsystemSDRAM_s1_byteenable_n;
  wire             subsystemSDRAM_s1_chipselect;
  wire             subsystemSDRAM_s1_read_n;
  wire    [ 15: 0] subsystemSDRAM_s1_readdata;
  wire    [ 15: 0] subsystemSDRAM_s1_readdata_from_sa;
  wire             subsystemSDRAM_s1_readdatavalid;
  wire             subsystemSDRAM_s1_reset_n;
  wire             subsystemSDRAM_s1_waitrequest;
  wire             subsystemSDRAM_s1_waitrequest_from_sa;
  wire             subsystemSDRAM_s1_write_n;
  wire    [ 15: 0] subsystemSDRAM_s1_writedata;
  wire    [  2: 0] subsystemSerialPort_s1_address;
  wire             subsystemSerialPort_s1_begintransfer;
  wire             subsystemSerialPort_s1_chipselect;
  wire             subsystemSerialPort_s1_dataavailable;
  wire             subsystemSerialPort_s1_dataavailable_from_sa;
  wire             subsystemSerialPort_s1_irq;
  wire             subsystemSerialPort_s1_read_n;
  wire    [ 15: 0] subsystemSerialPort_s1_readdata;
  wire    [ 15: 0] subsystemSerialPort_s1_readdata_from_sa;
  wire             subsystemSerialPort_s1_readyfordata;
  wire             subsystemSerialPort_s1_readyfordata_from_sa;
  wire             subsystemSerialPort_s1_reset_n;
  wire             subsystemSerialPort_s1_write_n;
  wire    [ 15: 0] subsystemSerialPort_s1_writedata;
  wire    [  2: 0] subsystemTimer_s1_address;
  wire             subsystemTimer_s1_chipselect;
  wire             subsystemTimer_s1_irq;
  wire             subsystemTimer_s1_irq_from_sa;
  wire    [ 15: 0] subsystemTimer_s1_readdata;
  wire    [ 15: 0] subsystemTimer_s1_readdata_from_sa;
  wire             subsystemTimer_s1_reset_n;
  wire             subsystemTimer_s1_write_n;
  wire    [ 15: 0] subsystemTimer_s1_writedata;
  wire             txd_from_the_subsystemSerialPort;
  wire             waitrequest_to_the_subsystemMMU;
  wire    [ 11: 0] zs_addr_from_the_subsystemSDRAM;
  wire    [  1: 0] zs_ba_from_the_subsystemSDRAM;
  wire             zs_cas_n_from_the_subsystemSDRAM;
  wire             zs_cke_from_the_subsystemSDRAM;
  wire             zs_cs_n_from_the_subsystemSDRAM;
  wire    [ 15: 0] zs_dq_to_and_from_the_subsystemSDRAM;
  wire    [  1: 0] zs_dqm_from_the_subsystemSDRAM;
  wire             zs_ras_n_from_the_subsystemSDRAM;
  wire             zs_we_n_from_the_subsystemSDRAM;
  keyboard_avalonS_arbitrator the_keyboard_avalonS
    (
      .address_from_the_subsystemMMU_to_slave                  (address_from_the_subsystemMMU_to_slave),
      .clk                                                     (clk),
      .d1_keyboard_avalonS_end_xfer                            (d1_keyboard_avalonS_end_xfer),
      .keyboard_avalonS_chipselect                             (keyboard_avalonS_chipselect),
      .keyboard_avalonS_dataavailable                          (keyboard_avalonS_dataavailable),
      .keyboard_avalonS_dataavailable_from_sa                  (keyboard_avalonS_dataavailable_from_sa),
      .keyboard_avalonS_irq                                    (keyboard_avalonS_irq),
      .keyboard_avalonS_irq_from_sa                            (keyboard_avalonS_irq_from_sa),
      .keyboard_avalonS_readdata                               (keyboard_avalonS_readdata),
      .keyboard_avalonS_readdata_from_sa                       (keyboard_avalonS_readdata_from_sa),
      .keyboard_avalonS_reset                                  (keyboard_avalonS_reset),
      .read_n_from_the_subsystemMMU                            (read_n_from_the_subsystemMMU),
      .reset_n                                                 (clk_reset_n),
      .subsystemMMU_avalonM_granted_keyboard_avalonS           (subsystemMMU_avalonM_granted_keyboard_avalonS),
      .subsystemMMU_avalonM_qualified_request_keyboard_avalonS (subsystemMMU_avalonM_qualified_request_keyboard_avalonS),
      .subsystemMMU_avalonM_read_data_valid_keyboard_avalonS   (subsystemMMU_avalonM_read_data_valid_keyboard_avalonS),
      .subsystemMMU_avalonM_requests_keyboard_avalonS          (subsystemMMU_avalonM_requests_keyboard_avalonS),
      .write_n_from_the_subsystemMMU                           (write_n_from_the_subsystemMMU)
    );

  keyboard the_keyboard
    (
      .CLK           (clk),
      .PS2_CLK       (PS2_CLK_to_and_from_the_keyboard),
      .PS2_DAT       (PS2_DAT_to_and_from_the_keyboard),
      .dataavailable (keyboard_avalonS_dataavailable),
      .irq           (keyboard_avalonS_irq),
      .read          (keyboard_avalonS_chipselect),
      .readdata      (keyboard_avalonS_readdata),
      .reset         (keyboard_avalonS_reset)
    );

  scarab_avalonM_arbitrator the_scarab_avalonM
    (
      .ava_address_from_the_scarab                                     (ava_address_from_the_scarab),
      .ava_address_from_the_scarab_to_slave                            (ava_address_from_the_scarab_to_slave),
      .ava_byteenable_from_the_scarab                                  (ava_byteenable_from_the_scarab),
      .ava_read_from_the_scarab                                        (ava_read_from_the_scarab),
      .ava_readdata_to_the_scarab                                      (ava_readdata_to_the_scarab),
      .ava_waitrequest_to_the_scarab                                   (ava_waitrequest_to_the_scarab),
      .ava_write_from_the_scarab                                       (ava_write_from_the_scarab),
      .ava_writedata_from_the_scarab                                   (ava_writedata_from_the_scarab),
      .clk                                                             (clk),
      .d1_subsystemSDRAM_s1_end_xfer                                   (d1_subsystemSDRAM_s1_end_xfer),
      .reset_n                                                         (clk_reset_n),
      .scarab_avalonM_granted_subsystemSDRAM_s1                        (scarab_avalonM_granted_subsystemSDRAM_s1),
      .scarab_avalonM_qualified_request_subsystemSDRAM_s1              (scarab_avalonM_qualified_request_subsystemSDRAM_s1),
      .scarab_avalonM_read_data_valid_subsystemSDRAM_s1                (scarab_avalonM_read_data_valid_subsystemSDRAM_s1),
      .scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register (scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register),
      .scarab_avalonM_requests_subsystemSDRAM_s1                       (scarab_avalonM_requests_subsystemSDRAM_s1),
      .subsystemSDRAM_s1_readdata_from_sa                              (subsystemSDRAM_s1_readdata_from_sa),
      .subsystemSDRAM_s1_waitrequest_from_sa                           (subsystemSDRAM_s1_waitrequest_from_sa)
    );

  subsystemAudio_avalonS_arbitrator the_subsystemAudio_avalonS
    (
      .address_from_the_subsystemMMU_to_slave                        (address_from_the_subsystemMMU_to_slave),
      .clk                                                           (clk),
      .d1_subsystemAudio_avalonS_end_xfer                            (d1_subsystemAudio_avalonS_end_xfer),
      .read_n_from_the_subsystemMMU                                  (read_n_from_the_subsystemMMU),
      .reset_n                                                       (clk_reset_n),
      .subsystemAudio_avalonS_chipselect                             (subsystemAudio_avalonS_chipselect),
      .subsystemAudio_avalonS_irq                                    (subsystemAudio_avalonS_irq),
      .subsystemAudio_avalonS_irq_from_sa                            (subsystemAudio_avalonS_irq_from_sa),
      .subsystemAudio_avalonS_reset_n                                (subsystemAudio_avalonS_reset_n),
      .subsystemAudio_avalonS_waitrequest                            (subsystemAudio_avalonS_waitrequest),
      .subsystemAudio_avalonS_waitrequest_from_sa                    (subsystemAudio_avalonS_waitrequest_from_sa),
      .subsystemAudio_avalonS_write_n                                (subsystemAudio_avalonS_write_n),
      .subsystemAudio_avalonS_writedata                              (subsystemAudio_avalonS_writedata),
      .subsystemMMU_avalonM_granted_subsystemAudio_avalonS           (subsystemMMU_avalonM_granted_subsystemAudio_avalonS),
      .subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS (subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS),
      .subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS   (subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS),
      .subsystemMMU_avalonM_requests_subsystemAudio_avalonS          (subsystemMMU_avalonM_requests_subsystemAudio_avalonS),
      .write_n_from_the_subsystemMMU                                 (write_n_from_the_subsystemMMU),
      .writedata_from_the_subsystemMMU                               (writedata_from_the_subsystemMMU)
    );

  subsystemAudio the_subsystemAudio
    (
      .chipselect  (subsystemAudio_avalonS_chipselect),
      .clk         (clk),
      .iCLK_18_4   (iCLK_18_4_to_the_subsystemAudio),
      .irq         (subsystemAudio_avalonS_irq),
      .oAUD_BCK    (oAUD_BCK_from_the_subsystemAudio),
      .oAUD_DATA   (oAUD_DATA_from_the_subsystemAudio),
      .oAUD_LRCK   (oAUD_LRCK_from_the_subsystemAudio),
      .reset_n     (subsystemAudio_avalonS_reset_n),
      .waitrequest (subsystemAudio_avalonS_waitrequest),
      .write_n     (subsystemAudio_avalonS_write_n),
      .writedata   (subsystemAudio_avalonS_writedata)
    );

  subsystemI2C_avalonS_arbitrator the_subsystemI2C_avalonS
    (
      .address_from_the_subsystemMMU_to_slave                      (address_from_the_subsystemMMU_to_slave),
      .byteenable_from_the_subsystemMMU                            (byteenable_from_the_subsystemMMU),
      .clk                                                         (clk),
      .d1_subsystemI2C_avalonS_end_xfer                            (d1_subsystemI2C_avalonS_end_xfer),
      .read_n_from_the_subsystemMMU                                (read_n_from_the_subsystemMMU),
      .reset_n                                                     (clk_reset_n),
      .subsystemI2C_avalonS_address                                (subsystemI2C_avalonS_address),
      .subsystemI2C_avalonS_always0                                (subsystemI2C_avalonS_always0),
      .subsystemI2C_avalonS_chipselect                             (subsystemI2C_avalonS_chipselect),
      .subsystemI2C_avalonS_readdata                               (subsystemI2C_avalonS_readdata),
      .subsystemI2C_avalonS_readdata_from_sa                       (subsystemI2C_avalonS_readdata_from_sa),
      .subsystemI2C_avalonS_reset_n                                (subsystemI2C_avalonS_reset_n),
      .subsystemI2C_avalonS_waitrequest_n                          (subsystemI2C_avalonS_waitrequest_n),
      .subsystemI2C_avalonS_waitrequest_n_from_sa                  (subsystemI2C_avalonS_waitrequest_n_from_sa),
      .subsystemI2C_avalonS_write                                  (subsystemI2C_avalonS_write),
      .subsystemI2C_avalonS_writedata                              (subsystemI2C_avalonS_writedata),
      .subsystemMMU_avalonM_granted_subsystemI2C_avalonS           (subsystemMMU_avalonM_granted_subsystemI2C_avalonS),
      .subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS (subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS),
      .subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS   (subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS),
      .subsystemMMU_avalonM_requests_subsystemI2C_avalonS          (subsystemMMU_avalonM_requests_subsystemI2C_avalonS),
      .write_n_from_the_subsystemMMU                               (write_n_from_the_subsystemMMU),
      .writedata_from_the_subsystemMMU                             (writedata_from_the_subsystemMMU)
    );

  subsystemI2C the_subsystemI2C
    (
      .arst_i       (subsystemI2C_avalonS_reset_n),
      .scl_pad_i    (scl_pad_i_to_the_subsystemI2C),
      .scl_pad_o    (scl_pad_o_from_the_subsystemI2C),
      .scl_padoen_o (scl_padoen_o_from_the_subsystemI2C),
      .sda_pad_i    (sda_pad_i_to_the_subsystemI2C),
      .sda_pad_o    (sda_pad_o_from_the_subsystemI2C),
      .sda_padoen_o (sda_padoen_o_from_the_subsystemI2C),
      .wb_ack_o     (subsystemI2C_avalonS_waitrequest_n),
      .wb_adr_i     (subsystemI2C_avalonS_address),
      .wb_clk_i     (clk),
      .wb_cyc_i     (subsystemI2C_avalonS_chipselect),
      .wb_dat_i     (subsystemI2C_avalonS_writedata),
      .wb_dat_o     (subsystemI2C_avalonS_readdata),
      .wb_inta_o    (subsystemI2C_avalonS_irq),
      .wb_rst_i     (subsystemI2C_avalonS_always0),
      .wb_stb_i     (subsystemI2C_avalonS_chipselect),
      .wb_we_i      (subsystemI2C_avalonS_write)
    );

  subsystemJTAG_avalon_jtag_slave_arbitrator the_subsystemJTAG_avalon_jtag_slave
    (
      .address_from_the_subsystemMMU_to_slave                                 (address_from_the_subsystemMMU_to_slave),
      .clk                                                                    (clk),
      .d1_subsystemJTAG_avalon_jtag_slave_end_xfer                            (d1_subsystemJTAG_avalon_jtag_slave_end_xfer),
      .read_n_from_the_subsystemMMU                                           (read_n_from_the_subsystemMMU),
      .reset_n                                                                (clk_reset_n),
      .subsystemJTAG_avalon_jtag_slave_address                                (subsystemJTAG_avalon_jtag_slave_address),
      .subsystemJTAG_avalon_jtag_slave_chipselect                             (subsystemJTAG_avalon_jtag_slave_chipselect),
      .subsystemJTAG_avalon_jtag_slave_dataavailable                          (subsystemJTAG_avalon_jtag_slave_dataavailable),
      .subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa                  (subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa),
      .subsystemJTAG_avalon_jtag_slave_irq                                    (subsystemJTAG_avalon_jtag_slave_irq),
      .subsystemJTAG_avalon_jtag_slave_irq_from_sa                            (subsystemJTAG_avalon_jtag_slave_irq_from_sa),
      .subsystemJTAG_avalon_jtag_slave_read_n                                 (subsystemJTAG_avalon_jtag_slave_read_n),
      .subsystemJTAG_avalon_jtag_slave_readdata                               (subsystemJTAG_avalon_jtag_slave_readdata),
      .subsystemJTAG_avalon_jtag_slave_readdata_from_sa                       (subsystemJTAG_avalon_jtag_slave_readdata_from_sa),
      .subsystemJTAG_avalon_jtag_slave_readyfordata                           (subsystemJTAG_avalon_jtag_slave_readyfordata),
      .subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa                   (subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa),
      .subsystemJTAG_avalon_jtag_slave_reset_n                                (subsystemJTAG_avalon_jtag_slave_reset_n),
      .subsystemJTAG_avalon_jtag_slave_waitrequest                            (subsystemJTAG_avalon_jtag_slave_waitrequest),
      .subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa                    (subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa),
      .subsystemJTAG_avalon_jtag_slave_write_n                                (subsystemJTAG_avalon_jtag_slave_write_n),
      .subsystemJTAG_avalon_jtag_slave_writedata                              (subsystemJTAG_avalon_jtag_slave_writedata),
      .subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave           (subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave),
      .subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave (subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave),
      .subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave   (subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave),
      .subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave          (subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave),
      .write_n_from_the_subsystemMMU                                          (write_n_from_the_subsystemMMU),
      .writedata_from_the_subsystemMMU                                        (writedata_from_the_subsystemMMU)
    );

  subsystemJTAG the_subsystemJTAG
    (
      .av_address     (subsystemJTAG_avalon_jtag_slave_address),
      .av_chipselect  (subsystemJTAG_avalon_jtag_slave_chipselect),
      .av_irq         (subsystemJTAG_avalon_jtag_slave_irq),
      .av_read_n      (subsystemJTAG_avalon_jtag_slave_read_n),
      .av_readdata    (subsystemJTAG_avalon_jtag_slave_readdata),
      .av_waitrequest (subsystemJTAG_avalon_jtag_slave_waitrequest),
      .av_write_n     (subsystemJTAG_avalon_jtag_slave_write_n),
      .av_writedata   (subsystemJTAG_avalon_jtag_slave_writedata),
      .clk            (clk),
      .dataavailable  (subsystemJTAG_avalon_jtag_slave_dataavailable),
      .readyfordata   (subsystemJTAG_avalon_jtag_slave_readyfordata),
      .rst_n          (subsystemJTAG_avalon_jtag_slave_reset_n)
    );

  subsystemMMU_avalonM_arbitrator the_subsystemMMU_avalonM
    (
      .address_from_the_subsystemMMU                                          (address_from_the_subsystemMMU),
      .address_from_the_subsystemMMU_to_slave                                 (address_from_the_subsystemMMU_to_slave),
      .byteenable_from_the_subsystemMMU                                       (byteenable_from_the_subsystemMMU),
      .clk                                                                    (clk),
      .d1_keyboard_avalonS_end_xfer                                           (d1_keyboard_avalonS_end_xfer),
      .d1_subsystemAudio_avalonS_end_xfer                                     (d1_subsystemAudio_avalonS_end_xfer),
      .d1_subsystemI2C_avalonS_end_xfer                                       (d1_subsystemI2C_avalonS_end_xfer),
      .d1_subsystemJTAG_avalon_jtag_slave_end_xfer                            (d1_subsystemJTAG_avalon_jtag_slave_end_xfer),
      .d1_subsystemSerialPort_s1_end_xfer                                     (d1_subsystemSerialPort_s1_end_xfer),
      .d1_subsystemTimer_s1_end_xfer                                          (d1_subsystemTimer_s1_end_xfer),
      .irq_to_the_subsystemMMU                                                (irq_to_the_subsystemMMU),
      .irqnumber_to_the_subsystemMMU                                          (irqnumber_to_the_subsystemMMU),
      .keyboard_avalonS_irq_from_sa                                           (keyboard_avalonS_irq_from_sa),
      .keyboard_avalonS_readdata_from_sa                                      (keyboard_avalonS_readdata_from_sa),
      .read_n_from_the_subsystemMMU                                           (read_n_from_the_subsystemMMU),
      .readdata_to_the_subsystemMMU                                           (readdata_to_the_subsystemMMU),
      .reset_n                                                                (clk_reset_n),
      .reset_n_to_the_subsystemMMU                                            (reset_n_to_the_subsystemMMU),
      .subsystemAudio_avalonS_irq_from_sa                                     (subsystemAudio_avalonS_irq_from_sa),
      .subsystemAudio_avalonS_waitrequest_from_sa                             (subsystemAudio_avalonS_waitrequest_from_sa),
      .subsystemI2C_avalonS_readdata_from_sa                                  (subsystemI2C_avalonS_readdata_from_sa),
      .subsystemI2C_avalonS_waitrequest_n_from_sa                             (subsystemI2C_avalonS_waitrequest_n_from_sa),
      .subsystemJTAG_avalon_jtag_slave_irq_from_sa                            (subsystemJTAG_avalon_jtag_slave_irq_from_sa),
      .subsystemJTAG_avalon_jtag_slave_readdata_from_sa                       (subsystemJTAG_avalon_jtag_slave_readdata_from_sa),
      .subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa                    (subsystemJTAG_avalon_jtag_slave_waitrequest_from_sa),
      .subsystemMMU_avalonM_granted_keyboard_avalonS                          (subsystemMMU_avalonM_granted_keyboard_avalonS),
      .subsystemMMU_avalonM_granted_subsystemAudio_avalonS                    (subsystemMMU_avalonM_granted_subsystemAudio_avalonS),
      .subsystemMMU_avalonM_granted_subsystemI2C_avalonS                      (subsystemMMU_avalonM_granted_subsystemI2C_avalonS),
      .subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave           (subsystemMMU_avalonM_granted_subsystemJTAG_avalon_jtag_slave),
      .subsystemMMU_avalonM_granted_subsystemSerialPort_s1                    (subsystemMMU_avalonM_granted_subsystemSerialPort_s1),
      .subsystemMMU_avalonM_granted_subsystemTimer_s1                         (subsystemMMU_avalonM_granted_subsystemTimer_s1),
      .subsystemMMU_avalonM_qualified_request_keyboard_avalonS                (subsystemMMU_avalonM_qualified_request_keyboard_avalonS),
      .subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS          (subsystemMMU_avalonM_qualified_request_subsystemAudio_avalonS),
      .subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS            (subsystemMMU_avalonM_qualified_request_subsystemI2C_avalonS),
      .subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave (subsystemMMU_avalonM_qualified_request_subsystemJTAG_avalon_jtag_slave),
      .subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1          (subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1),
      .subsystemMMU_avalonM_qualified_request_subsystemTimer_s1               (subsystemMMU_avalonM_qualified_request_subsystemTimer_s1),
      .subsystemMMU_avalonM_read_data_valid_keyboard_avalonS                  (subsystemMMU_avalonM_read_data_valid_keyboard_avalonS),
      .subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS            (subsystemMMU_avalonM_read_data_valid_subsystemAudio_avalonS),
      .subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS              (subsystemMMU_avalonM_read_data_valid_subsystemI2C_avalonS),
      .subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave   (subsystemMMU_avalonM_read_data_valid_subsystemJTAG_avalon_jtag_slave),
      .subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1            (subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1),
      .subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1                 (subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1),
      .subsystemMMU_avalonM_requests_keyboard_avalonS                         (subsystemMMU_avalonM_requests_keyboard_avalonS),
      .subsystemMMU_avalonM_requests_subsystemAudio_avalonS                   (subsystemMMU_avalonM_requests_subsystemAudio_avalonS),
      .subsystemMMU_avalonM_requests_subsystemI2C_avalonS                     (subsystemMMU_avalonM_requests_subsystemI2C_avalonS),
      .subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave          (subsystemMMU_avalonM_requests_subsystemJTAG_avalon_jtag_slave),
      .subsystemMMU_avalonM_requests_subsystemSerialPort_s1                   (subsystemMMU_avalonM_requests_subsystemSerialPort_s1),
      .subsystemMMU_avalonM_requests_subsystemTimer_s1                        (subsystemMMU_avalonM_requests_subsystemTimer_s1),
      .subsystemSerialPort_s1_readdata_from_sa                                (subsystemSerialPort_s1_readdata_from_sa),
      .subsystemTimer_s1_irq_from_sa                                          (subsystemTimer_s1_irq_from_sa),
      .subsystemTimer_s1_readdata_from_sa                                     (subsystemTimer_s1_readdata_from_sa),
      .waitrequest_to_the_subsystemMMU                                        (waitrequest_to_the_subsystemMMU),
      .write_n_from_the_subsystemMMU                                          (write_n_from_the_subsystemMMU),
      .writedata_from_the_subsystemMMU                                        (writedata_from_the_subsystemMMU)
    );

  subsystemSDRAM_s1_arbitrator the_subsystemSDRAM_s1
    (
      .ava_address_from_the_scarab_to_slave                            (ava_address_from_the_scarab_to_slave),
      .ava_byteenable_from_the_scarab                                  (ava_byteenable_from_the_scarab),
      .ava_read_from_the_scarab                                        (ava_read_from_the_scarab),
      .ava_write_from_the_scarab                                       (ava_write_from_the_scarab),
      .ava_writedata_from_the_scarab                                   (ava_writedata_from_the_scarab),
      .clk                                                             (clk),
      .d1_subsystemSDRAM_s1_end_xfer                                   (d1_subsystemSDRAM_s1_end_xfer),
      .reset_n                                                         (clk_reset_n),
      .scarab_avalonM_granted_subsystemSDRAM_s1                        (scarab_avalonM_granted_subsystemSDRAM_s1),
      .scarab_avalonM_qualified_request_subsystemSDRAM_s1              (scarab_avalonM_qualified_request_subsystemSDRAM_s1),
      .scarab_avalonM_read_data_valid_subsystemSDRAM_s1                (scarab_avalonM_read_data_valid_subsystemSDRAM_s1),
      .scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register (scarab_avalonM_read_data_valid_subsystemSDRAM_s1_shift_register),
      .scarab_avalonM_requests_subsystemSDRAM_s1                       (scarab_avalonM_requests_subsystemSDRAM_s1),
      .subsystemSDRAM_s1_address                                       (subsystemSDRAM_s1_address),
      .subsystemSDRAM_s1_byteenable_n                                  (subsystemSDRAM_s1_byteenable_n),
      .subsystemSDRAM_s1_chipselect                                    (subsystemSDRAM_s1_chipselect),
      .subsystemSDRAM_s1_read_n                                        (subsystemSDRAM_s1_read_n),
      .subsystemSDRAM_s1_readdata                                      (subsystemSDRAM_s1_readdata),
      .subsystemSDRAM_s1_readdata_from_sa                              (subsystemSDRAM_s1_readdata_from_sa),
      .subsystemSDRAM_s1_readdatavalid                                 (subsystemSDRAM_s1_readdatavalid),
      .subsystemSDRAM_s1_reset_n                                       (subsystemSDRAM_s1_reset_n),
      .subsystemSDRAM_s1_waitrequest                                   (subsystemSDRAM_s1_waitrequest),
      .subsystemSDRAM_s1_waitrequest_from_sa                           (subsystemSDRAM_s1_waitrequest_from_sa),
      .subsystemSDRAM_s1_write_n                                       (subsystemSDRAM_s1_write_n),
      .subsystemSDRAM_s1_writedata                                     (subsystemSDRAM_s1_writedata)
    );

  subsystemSDRAM the_subsystemSDRAM
    (
      .az_addr        (subsystemSDRAM_s1_address),
      .az_be_n        (subsystemSDRAM_s1_byteenable_n),
      .az_cs          (subsystemSDRAM_s1_chipselect),
      .az_data        (subsystemSDRAM_s1_writedata),
      .az_rd_n        (subsystemSDRAM_s1_read_n),
      .az_wr_n        (subsystemSDRAM_s1_write_n),
      .clk            (clk),
      .reset_n        (subsystemSDRAM_s1_reset_n),
      .za_data        (subsystemSDRAM_s1_readdata),
      .za_valid       (subsystemSDRAM_s1_readdatavalid),
      .za_waitrequest (subsystemSDRAM_s1_waitrequest),
      .zs_addr        (zs_addr_from_the_subsystemSDRAM),
      .zs_ba          (zs_ba_from_the_subsystemSDRAM),
      .zs_cas_n       (zs_cas_n_from_the_subsystemSDRAM),
      .zs_cke         (zs_cke_from_the_subsystemSDRAM),
      .zs_cs_n        (zs_cs_n_from_the_subsystemSDRAM),
      .zs_dq          (zs_dq_to_and_from_the_subsystemSDRAM),
      .zs_dqm         (zs_dqm_from_the_subsystemSDRAM),
      .zs_ras_n       (zs_ras_n_from_the_subsystemSDRAM),
      .zs_we_n        (zs_we_n_from_the_subsystemSDRAM)
    );

  subsystemSerialPort_s1_arbitrator the_subsystemSerialPort_s1
    (
      .address_from_the_subsystemMMU_to_slave                        (address_from_the_subsystemMMU_to_slave),
      .clk                                                           (clk),
      .d1_subsystemSerialPort_s1_end_xfer                            (d1_subsystemSerialPort_s1_end_xfer),
      .read_n_from_the_subsystemMMU                                  (read_n_from_the_subsystemMMU),
      .reset_n                                                       (clk_reset_n),
      .subsystemMMU_avalonM_granted_subsystemSerialPort_s1           (subsystemMMU_avalonM_granted_subsystemSerialPort_s1),
      .subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1 (subsystemMMU_avalonM_qualified_request_subsystemSerialPort_s1),
      .subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1   (subsystemMMU_avalonM_read_data_valid_subsystemSerialPort_s1),
      .subsystemMMU_avalonM_requests_subsystemSerialPort_s1          (subsystemMMU_avalonM_requests_subsystemSerialPort_s1),
      .subsystemSerialPort_s1_address                                (subsystemSerialPort_s1_address),
      .subsystemSerialPort_s1_begintransfer                          (subsystemSerialPort_s1_begintransfer),
      .subsystemSerialPort_s1_chipselect                             (subsystemSerialPort_s1_chipselect),
      .subsystemSerialPort_s1_dataavailable                          (subsystemSerialPort_s1_dataavailable),
      .subsystemSerialPort_s1_dataavailable_from_sa                  (subsystemSerialPort_s1_dataavailable_from_sa),
      .subsystemSerialPort_s1_read_n                                 (subsystemSerialPort_s1_read_n),
      .subsystemSerialPort_s1_readdata                               (subsystemSerialPort_s1_readdata),
      .subsystemSerialPort_s1_readdata_from_sa                       (subsystemSerialPort_s1_readdata_from_sa),
      .subsystemSerialPort_s1_readyfordata                           (subsystemSerialPort_s1_readyfordata),
      .subsystemSerialPort_s1_readyfordata_from_sa                   (subsystemSerialPort_s1_readyfordata_from_sa),
      .subsystemSerialPort_s1_reset_n                                (subsystemSerialPort_s1_reset_n),
      .subsystemSerialPort_s1_write_n                                (subsystemSerialPort_s1_write_n),
      .subsystemSerialPort_s1_writedata                              (subsystemSerialPort_s1_writedata),
      .write_n_from_the_subsystemMMU                                 (write_n_from_the_subsystemMMU),
      .writedata_from_the_subsystemMMU                               (writedata_from_the_subsystemMMU)
    );

  subsystemSerialPort the_subsystemSerialPort
    (
      .address       (subsystemSerialPort_s1_address),
      .begintransfer (subsystemSerialPort_s1_begintransfer),
      .chipselect    (subsystemSerialPort_s1_chipselect),
      .clk           (clk),
      .dataavailable (subsystemSerialPort_s1_dataavailable),
      .irq           (subsystemSerialPort_s1_irq),
      .read_n        (subsystemSerialPort_s1_read_n),
      .readdata      (subsystemSerialPort_s1_readdata),
      .readyfordata  (subsystemSerialPort_s1_readyfordata),
      .reset_n       (subsystemSerialPort_s1_reset_n),
      .rxd           (rxd_to_the_subsystemSerialPort),
      .txd           (txd_from_the_subsystemSerialPort),
      .write_n       (subsystemSerialPort_s1_write_n),
      .writedata     (subsystemSerialPort_s1_writedata)
    );

  subsystemTimer_s1_arbitrator the_subsystemTimer_s1
    (
      .address_from_the_subsystemMMU_to_slave                   (address_from_the_subsystemMMU_to_slave),
      .clk                                                      (clk),
      .d1_subsystemTimer_s1_end_xfer                            (d1_subsystemTimer_s1_end_xfer),
      .read_n_from_the_subsystemMMU                             (read_n_from_the_subsystemMMU),
      .reset_n                                                  (clk_reset_n),
      .subsystemMMU_avalonM_granted_subsystemTimer_s1           (subsystemMMU_avalonM_granted_subsystemTimer_s1),
      .subsystemMMU_avalonM_qualified_request_subsystemTimer_s1 (subsystemMMU_avalonM_qualified_request_subsystemTimer_s1),
      .subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1   (subsystemMMU_avalonM_read_data_valid_subsystemTimer_s1),
      .subsystemMMU_avalonM_requests_subsystemTimer_s1          (subsystemMMU_avalonM_requests_subsystemTimer_s1),
      .subsystemTimer_s1_address                                (subsystemTimer_s1_address),
      .subsystemTimer_s1_chipselect                             (subsystemTimer_s1_chipselect),
      .subsystemTimer_s1_irq                                    (subsystemTimer_s1_irq),
      .subsystemTimer_s1_irq_from_sa                            (subsystemTimer_s1_irq_from_sa),
      .subsystemTimer_s1_readdata                               (subsystemTimer_s1_readdata),
      .subsystemTimer_s1_readdata_from_sa                       (subsystemTimer_s1_readdata_from_sa),
      .subsystemTimer_s1_reset_n                                (subsystemTimer_s1_reset_n),
      .subsystemTimer_s1_write_n                                (subsystemTimer_s1_write_n),
      .subsystemTimer_s1_writedata                              (subsystemTimer_s1_writedata),
      .write_n_from_the_subsystemMMU                            (write_n_from_the_subsystemMMU),
      .writedata_from_the_subsystemMMU                          (writedata_from_the_subsystemMMU)
    );

  subsystemTimer the_subsystemTimer
    (
      .address    (subsystemTimer_s1_address),
      .chipselect (subsystemTimer_s1_chipselect),
      .clk        (clk),
      .irq        (subsystemTimer_s1_irq),
      .readdata   (subsystemTimer_s1_readdata),
      .reset_n    (subsystemTimer_s1_reset_n),
      .write_n    (subsystemTimer_s1_write_n),
      .writedata  (subsystemTimer_s1_writedata)
    );

  //reset is asserted asynchronously and deasserted synchronously
  systemAvalon_reset_clk_domain_synch_module systemAvalon_reset_clk_domain_synch
    (
      .clk      (clk),
      .data_in  (1'b1),
      .data_out (clk_reset_n),
      .reset_n  (reset_n_sources)
    );

  //reset sources mux, which is an e_mux
  assign reset_n_sources = ~(~reset_n |
    0);


endmodule


//synthesis translate_off



// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE

// AND HERE WILL BE PRESERVED </ALTERA_NOTE>


// If user logic components use Altsync_Ram with convert_hex2ver.dll,
// set USE_convert_hex2ver in the user comments section above

`ifdef USE_convert_hex2ver
`else
`define NO_PLI 1
`endif

`include "c:/altera/quartus51/eda/sim_lib/altera_mf.v"
`include "c:/altera/quartus51/eda/sim_lib/220model.v"
`include "c:/altera/quartus51/eda/sim_lib/sgate.v"
`include "subsystemJTAG.v"
`include "i2c_master_bit_ctrl.v"
`include "i2c_master_byte_ctrl.v"
`include "i2c_master_defines.v"
`include "i2c_master_top.v"
`include "subsystemI2C.v"
`include "subsystemTimer.v"
`include "subsystemSerialPort.v"
`include "subsystemSDRAM.v"
`include "./ps2keyboard.v"
`include "./kbfifo.v"
`include "keyboard.v"
`include "./subsystemAudioBuffer.v"
`include "subsystemAudio.v"

`timescale 1ns / 100ps

module test_bench 
;


  wire             PS2_CLK_to_and_from_the_keyboard;
  wire             PS2_DAT_to_and_from_the_keyboard;
  wire    [ 31: 0] address_from_the_subsystemMMU;
  wire    [ 22: 0] ava_address_from_the_scarab;
  wire    [  1: 0] ava_byteenable_from_the_scarab;
  wire             ava_read_from_the_scarab;
  wire    [ 15: 0] ava_readdata_to_the_scarab;
  wire             ava_waitrequest_to_the_scarab;
  wire             ava_write_from_the_scarab;
  wire    [ 15: 0] ava_writedata_from_the_scarab;
  wire    [  1: 0] byteenable_from_the_subsystemMMU;
  reg              clk;
  wire             iCLK_18_4_to_the_subsystemAudio;
  wire             irq_to_the_subsystemMMU;
  wire    [  5: 0] irqnumber_to_the_subsystemMMU;
  wire             keyboard_avalonS_dataavailable_from_sa;
  wire             oAUD_BCK_from_the_subsystemAudio;
  wire             oAUD_DATA_from_the_subsystemAudio;
  wire             oAUD_LRCK_from_the_subsystemAudio;
  wire             read_n_from_the_subsystemMMU;
  wire    [ 15: 0] readdata_to_the_subsystemMMU;
  reg              reset_n;
  wire             reset_n_to_the_subsystemMMU;
  wire             rxd_to_the_subsystemSerialPort;
  wire             scl_pad_i_to_the_subsystemI2C;
  wire             scl_pad_o_from_the_subsystemI2C;
  wire             scl_padoen_o_from_the_subsystemI2C;
  wire             sda_pad_i_to_the_subsystemI2C;
  wire             sda_pad_o_from_the_subsystemI2C;
  wire             sda_padoen_o_from_the_subsystemI2C;
  wire             subsystemI2C_avalonS_irq;
  wire             subsystemJTAG_avalon_jtag_slave_dataavailable_from_sa;
  wire             subsystemJTAG_avalon_jtag_slave_readyfordata_from_sa;
  wire             subsystemSerialPort_s1_dataavailable_from_sa;
  wire             subsystemSerialPort_s1_irq;
  wire             subsystemSerialPort_s1_readyfordata_from_sa;
  wire             txd_from_the_subsystemSerialPort;
  wire             waitrequest_to_the_subsystemMMU;
  wire             write_n_from_the_subsystemMMU;
  wire    [ 15: 0] writedata_from_the_subsystemMMU;
  wire    [ 11: 0] zs_addr_from_the_subsystemSDRAM;
  wire    [  1: 0] zs_ba_from_the_subsystemSDRAM;
  wire             zs_cas_n_from_the_subsystemSDRAM;
  wire             zs_cke_from_the_subsystemSDRAM;
  wire             zs_cs_n_from_the_subsystemSDRAM;
  wire    [ 15: 0] zs_dq_to_and_from_the_subsystemSDRAM;
  wire    [  1: 0] zs_dqm_from_the_subsystemSDRAM;
  wire             zs_ras_n_from_the_subsystemSDRAM;
  wire             zs_we_n_from_the_subsystemSDRAM;


// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
//  add your signals and additional architecture here
// AND HERE WILL BE PRESERVED </ALTERA_NOTE>

  //Set us up the Dut
  systemAvalon DUT
    (
      .PS2_CLK_to_and_from_the_keyboard     (PS2_CLK_to_and_from_the_keyboard),
      .PS2_DAT_to_and_from_the_keyboard     (PS2_DAT_to_and_from_the_keyboard),
      .address_from_the_subsystemMMU        (address_from_the_subsystemMMU),
      .ava_address_from_the_scarab          (ava_address_from_the_scarab),
      .ava_byteenable_from_the_scarab       (ava_byteenable_from_the_scarab),
      .ava_read_from_the_scarab             (ava_read_from_the_scarab),
      .ava_readdata_to_the_scarab           (ava_readdata_to_the_scarab),
      .ava_waitrequest_to_the_scarab        (ava_waitrequest_to_the_scarab),
      .ava_write_from_the_scarab            (ava_write_from_the_scarab),
      .ava_writedata_from_the_scarab        (ava_writedata_from_the_scarab),
      .byteenable_from_the_subsystemMMU     (byteenable_from_the_subsystemMMU),
      .clk                                  (clk),
      .iCLK_18_4_to_the_subsystemAudio      (iCLK_18_4_to_the_subsystemAudio),
      .irq_to_the_subsystemMMU              (irq_to_the_subsystemMMU),
      .irqnumber_to_the_subsystemMMU        (irqnumber_to_the_subsystemMMU),
      .oAUD_BCK_from_the_subsystemAudio     (oAUD_BCK_from_the_subsystemAudio),
      .oAUD_DATA_from_the_subsystemAudio    (oAUD_DATA_from_the_subsystemAudio),
      .oAUD_LRCK_from_the_subsystemAudio    (oAUD_LRCK_from_the_subsystemAudio),
      .read_n_from_the_subsystemMMU         (read_n_from_the_subsystemMMU),
      .readdata_to_the_subsystemMMU         (readdata_to_the_subsystemMMU),
      .reset_n                              (reset_n),
      .reset_n_to_the_subsystemMMU          (reset_n_to_the_subsystemMMU),
      .rxd_to_the_subsystemSerialPort       (rxd_to_the_subsystemSerialPort),
      .scl_pad_i_to_the_subsystemI2C        (scl_pad_i_to_the_subsystemI2C),
      .scl_pad_o_from_the_subsystemI2C      (scl_pad_o_from_the_subsystemI2C),
      .scl_padoen_o_from_the_subsystemI2C   (scl_padoen_o_from_the_subsystemI2C),
      .sda_pad_i_to_the_subsystemI2C        (sda_pad_i_to_the_subsystemI2C),
      .sda_pad_o_from_the_subsystemI2C      (sda_pad_o_from_the_subsystemI2C),
      .sda_padoen_o_from_the_subsystemI2C   (sda_padoen_o_from_the_subsystemI2C),
      .txd_from_the_subsystemSerialPort     (txd_from_the_subsystemSerialPort),
      .waitrequest_to_the_subsystemMMU      (waitrequest_to_the_subsystemMMU),
      .write_n_from_the_subsystemMMU        (write_n_from_the_subsystemMMU),
      .writedata_from_the_subsystemMMU      (writedata_from_the_subsystemMMU),
      .zs_addr_from_the_subsystemSDRAM      (zs_addr_from_the_subsystemSDRAM),
      .zs_ba_from_the_subsystemSDRAM        (zs_ba_from_the_subsystemSDRAM),
      .zs_cas_n_from_the_subsystemSDRAM     (zs_cas_n_from_the_subsystemSDRAM),
      .zs_cke_from_the_subsystemSDRAM       (zs_cke_from_the_subsystemSDRAM),
      .zs_cs_n_from_the_subsystemSDRAM      (zs_cs_n_from_the_subsystemSDRAM),
      .zs_dq_to_and_from_the_subsystemSDRAM (zs_dq_to_and_from_the_subsystemSDRAM),
      .zs_dqm_from_the_subsystemSDRAM       (zs_dqm_from_the_subsystemSDRAM),
      .zs_ras_n_from_the_subsystemSDRAM     (zs_ras_n_from_the_subsystemSDRAM),
      .zs_we_n_from_the_subsystemSDRAM      (zs_we_n_from_the_subsystemSDRAM)
    );

  initial
    clk = 1'b0;
  always
    #28 clk <= ~clk;
  
  initial 
    begin
      reset_n <= 0;
      #560 reset_n <= 1;
    end

endmodule


//synthesis translate_on