`define CHARACTER_SET_588x441x15	0
`define CHARACTER_SET_ISO-8859-1	1




module VGA_CONTROLLER(
	input			CLOCK_25175,
	input			RST,
	
	input			CHARACTER_SET,
	
	input 	[39:0]	FIFO_READ_DATA,
	output reg			FIFO_READ_ACK,
	input			FIFO_READ_EMPTY,
	
	output reg	[11:0]	VGA_TB_READ_ADDR,
	input	[14:0]	VGA_TB_READ_DATA,
	output reg	[11:0]	VGA_CHARMAP_READ_ADDR,
	input	[7:0]	VGA_CHARMAP_READ_DATA,
	
	output reg	[9:0]	VGA_R,		//	VGA Red[9:0]
	output reg	[9:0]	VGA_G,		//	VGA Green[9:0]
	output reg	[9:0]	VGA_B,		//	VGA Blue[9:0]
	output			VGA_BLANK,		//	VGA BLANK
	output reg			VGA_HS,		//	VGA H_SYNC
	output reg			VGA_VS,		//	VGA V_SYNC
	output			VGA_SYNC		//	VGA SYNC
	);


assign VGA_BLANK = VGA_HS & VGA_VS;
assign VGA_SYNC = 0;


//	VGA_HS & VGA_VS Generator, Ref. 25.175 MHz Clock
reg		[9:0]	H_Cont;
reg		[9:0]	V_Cont;
reg		[6:0]	T_Colour;
reg		[5:0]	T_Blink;

always@(negedge CLOCK_25175 or negedge RST)
begin
	FIFO_READ_ACK <= 0;	// we don't want to read from the FIFO by default

	if(!RST)
	begin
		H_Cont		<=	0;
		VGA_HS		<=	0;
		
		V_Cont		<=	0;
		VGA_VS		<=	0;
	end
	else
	begin
		//	H_Sync Counter
		if( H_Cont < 799 )
			H_Cont	<=	H_Cont+1;
		else
			H_Cont	<=	0;
		
		//	H_Sync Generator
		if( H_Cont < 96 )
			VGA_HS	<=	0;
		else
			VGA_HS	<=	1;
		
		if( H_Cont == 0 )
		begin
			//	V_Sync Counter
			if( V_Cont < 524 )
				V_Cont	<=	V_Cont+1;
			else
				V_Cont	<=	0;
			
			//	H_Sync Generator
			if( V_Cont < 2 )
				VGA_VS	<=	0;
			else
				VGA_VS	<=	1;
		end
		
		if( CHARACTER_SET > 0 )
		begin	// text mode
			if( H_Cont == 799
				&&
				V_Cont == 524 )
				T_Blink <= T_Blink + 1;
			
			if( H_Cont >= 136 && H_Cont <= 775
				&&
				V_Cont >= 35 && V_Cont <= 514
				&&
				H_Cont % 8 == 4 )
			begin
				// we need to update VGA_TB_READ_ADDR so that
				// next clock cycle VGA_TB_READ_DATA will be
				// valid for the if statement below
				
				VGA_TB_READ_ADDR <= ((V_Cont - 35) / 16) * 80 + (H_Cont - 140) / 8;
			end
			
			if( H_Cont >= 136 && H_Cont <= 775
				&&
				V_Cont >= 35 && V_Cont <= 514
				&&
				H_Cont % 8 == 6 )
			begin
				// we need to update VGA_CHARMAP_READ_ADDR so that
				// next clock cycle VGA_CHARMAP_READ_DATA will be
				// valid for the 8-pixel block that begins then
				
				VGA_CHARMAP_READ_ADDR <= VGA_TB_READ_DATA[7:0] * 16
											+ (VGA_TB_READ_DATA[7] ? (CHARACTER_SET - 1) * 128 : 0)
											+ (V_Cont - 35) % 16;
			end
			
			if( H_Cont >= 136 && H_Cont <= 775
				&&
				V_Cont >= 35 && V_Cont <= 514
				&&
				H_Cont % 8 == 7 )
			begin
				T_Colour <= VGA_TB_READ_DATA[14:8];
			end
		end
		
		// Pixel generator
		if( H_Cont >= 144 && H_Cont <= 783
			&&
			V_Cont >= 35 && V_Cont <= 514 )
		begin
			if( CHARACTER_SET > 0 )
			begin	// text mode
				VGA_R <= VGA_CHARMAP_READ_DATA[7 - (H_Cont - 144) % 8]
							&& (!T_Colour[6] || T_Blink[5])				? (T_Colour[2] ? 1023 : 0)
																		: (T_Colour[5] ? 1023 : 0);
				VGA_G <= VGA_CHARMAP_READ_DATA[7 - (H_Cont - 144) % 8]
							&& (!T_Colour[6] || T_Blink[5])				? (T_Colour[1] ? 1023 : 0)
																		: (T_Colour[4] ? 1023 : 0);
				VGA_B <= VGA_CHARMAP_READ_DATA[7 - (H_Cont - 144) % 8]
							&& (!T_Colour[6] || T_Blink[5])				? (T_Colour[0] ? 1023 : 0)
																		: (T_Colour[3] ? 1023 : 0);
			end
			else if( H_Cont >= 170 && H_Cont <= 757
				&&
				V_Cont >= 54 && V_Cont <= 494 )
			begin
				if( FIFO_READ_EMPTY )
				begin	// shit. the fifo is empty (believed to never happen ;)
					VGA_R <= 1023;
					VGA_G <= 0;
					VGA_B <= 0;
				end
				else
				begin
					if( FIFO_READ_DATA[39:22] == (V_Cont - 54) * 588 + (H_Cont - 170) )
					begin	// perfect
						VGA_R <= {FIFO_READ_DATA[14:10], 5'b00000};
						VGA_G <= {FIFO_READ_DATA[9:5], 5'b00000};
						VGA_B <= {FIFO_READ_DATA[4:0], 5'b00000};
						
						FIFO_READ_ACK <= 1;
					end
					else
					begin	// shit. the fifo doesn't contain what it should (believed to never happen ;)
						VGA_R <= 1023;
						VGA_G <= 512;
						VGA_B <= 256;
					end
				end
			end
			else
			begin	// not on the 588x441 area
				VGA_R <= 876;
				VGA_G <= 744;
				VGA_B <= 468;
			end
		end
		else
		begin	// not on the 640x480 area
			VGA_R <= 0;
			VGA_G <= 0;
			VGA_B <= 0;
		end
	end
end


endmodule




module SRAM_CONTROLLER(
	input			CLOCK_111,
	input			RST,
	
	input 	[39:0]	FIFO_READ_DATA,
	output reg			FIFO_READ_ACK,
	input			FIFO_READ_EMPTY,
	
	output reg	[17:0]	SRAM_ADDR,
	inout reg 	[15:0]	SRAM_DQ,
	output reg			SRAM_WE_N,
	output			SRAM_OE_N,
	output			SRAM_UB_N,
	output			SRAM_LB_N,
	output			SRAM_CE_N,
	
	output reg	[39:0]	FIFO_WRITE_DATA,
	output reg			FIFO_WRITE_REQ,
	input			FIFO_WRITE_FULL
	);


assign SRAM_OE_N = 0;
assign SRAM_UB_N = 0;
assign SRAM_LB_N = 0;
assign SRAM_CE_N = 0;


reg		[1:0]	State;
reg		[17:0]	Read_Address;

always@(posedge CLOCK_111 or negedge RST)
begin
	FIFO_READ_ACK <= 0;		// we don't want to read from the FIFO by default
	FIFO_WRITE_REQ <= 0;	// we don't want to write to the FIFO by default

	if(!RST)
	begin
		SRAM_ADDR <= 0;
		SRAM_WE_N <= 1;
		
		State <= 0;
		Read_Address <= 0;
	end
	else
	begin
		if( State < 2 )
			State	<=	State+1;
		else
			State	<=	0;
		
		if( State == 0 )
		begin
			// setup read
			SRAM_ADDR <= Read_Address;
			SRAM_DQ <= 16'bzzzzzzzzzzzzzzzz;
			SRAM_WE_N <= 1;
		end
		else if( State == 2 )
		begin
			// perform read
			if( !FIFO_WRITE_FULL )
			begin
				FIFO_WRITE_DATA <= {Read_Address, 6'b000000, SRAM_DQ};
				
				FIFO_WRITE_REQ <= 1;
				if( Read_Address < 259307 )
					Read_Address	<=	Read_Address+1;
				else
					Read_Address	<=	0;
			end
			
			// setup write
			if( !FIFO_READ_EMPTY )
			begin
				SRAM_ADDR <= FIFO_READ_DATA[39:22];
				SRAM_DQ <= FIFO_READ_DATA[15:0];
				SRAM_WE_N <= 0;
				
				FIFO_READ_ACK <= 1;
			end
		end
	end
end


endmodule
