module subsystemAudioBuffer (
	input chipselect,
	input clk,
	input iCLK_18_4,
	output irq,
	output oAUD_BCK,
	output oAUD_DATA,
	output oAUD_LRCK,
	input reset_n,
	output waitrequest,
	input write_n,
	input [15:0] writedata
);

	wire iwaitrequest;
	assign waitrequest = chipselect && !write_n && iwaitrequest;

	reg rdack;
	wire empty;
	wire [15:0] q;
	AUDIO_FIFO fifo (
		.aclr(!reset_n),
		.clock(clk),
		.data(writedata),
		.rdreq(rdack),
		.wrreq(chipselect && !write_n && !iwaitrequest),
		.almost_empty(irq),
		.empty(empty),
		.full(iwaitrequest),
		.q(q)
	);

	reg [15:0] data;
	reg wrreq;
	wire full;
	AUDIO_DAC_FIFO audioOut (
		.iDATA(data),
		.iWR(wrreq),
		.iWR_CLK(clk),
		.oWR_FULL(full),
		.oAUD_BCK(oAUD_BCK),
		.oAUD_DATA(oAUD_DATA),
		.oAUD_LRCK(oAUD_LRCK),
		.iCLK_18_4(iCLK_18_4),
		.iRST_N(reset_n)
	);

	reg waiter;
	reg [3:0] repeater;
	always @(posedge clk or negedge reset_n)
	begin
		if( !reset_n )
		begin
			rdack <= 0;
			wrreq <= 0;
			waiter <= 0;
			repeater <= 0;
		end
		else
		begin
			rdack <= 0;
			wrreq <= 0;
			waiter <= waiter + 1'd1;
			
			if( !full && !empty && waiter )
			begin
				rdack <= repeater == 11;
				repeater <= repeater == 11 ? 4'd0 : repeater + 4'd1;
				
				data <= q;
				wrreq <= 1;
			end
		end
	end

endmodule
