`include "malwa_defines.v"

module malwa_writeback(
	input clk,
	input reset,
	input clear,
	
	input [31:0] instr,
	input [`CONTROL_WIDTH] control,
	input [31:0] branchout,
	input [31:0] executeout,
	input [1:0] bottomaddress,

	output reg [31:0] instrMWB,
	output reg [`CONTROL_WIDTH] controlMWB,
	output reg [31:0] executeoutMWB,
	output reg [1:0] bottomaddressMWB,
	
	output writeregenMduring,
	output writeregen,
	output [`REGNUM_WIDTH] writeregnum,
	output [31:0] writeregdata
);

	assign writeregenMduring = control[`CONTROL_MEMREAD] && control[`CONTROL_REGWRITE];
	assign writeregen = !control[`CONTROL_MEMREAD] && control[`CONTROL_REGWRITE];
	assign writeregnum = control[`CONTROL_WRITEREGNUM];
	assign writeregdata = control[`CONTROL_LINK] ? branchout : executeout;

	always @(posedge clk)
	begin
		if( reset || clear )
		begin
			instrMWB <= 0;
			controlMWB <= 0;
			executeoutMWB <= 0;
			bottomaddressMWB <= 0;
		end
		else
		begin
			instrMWB <= instr;
			controlMWB <= control;
			executeoutMWB <= executeout;
			bottomaddressMWB <= bottomaddress;
		end
	end	
endmodule