`include "malwa_defines.v"

module malwa_memwriteback(
	input clk,
	
	input [31:0] instr,
	input [`CONTROL_WIDTH] control,
	input [31:0] executeout,
	input [1:0] bottomaddress,
	input [31:0] memreaddata,
	
	output writeregen,
	output [`REGNUM_WIDTH] writeregnum,
	output [31:0] writeregdata
);

	assign writeregen = control[`CONTROL_MEMREAD] && control[`CONTROL_REGWRITE];
	assign writeregnum = control[`CONTROL_WRITEREGNUM];
	assign writeregdata =
		control[`CONTROL_MEML] ?
			 bottomaddress==2'd0 ?	memreaddata
			:bottomaddress==2'd1 ?	{memreaddata[23:0],executeout[7:0]}
			:bottomaddress==2'd2 ?	{memreaddata[15:0],executeout[15:0]}
			:bottomaddress==2'd3 ?	{memreaddata[7:0],executeout[23:0]}
			:						32'hXXXX_XXXX
		:control[`CONTROL_MEMR] ?
			 bottomaddress==2'd0 ?	{executeout[31:8],memreaddata[31:24]}
			:bottomaddress==2'd1 ?	{executeout[31:16],memreaddata[31:16]}
			:bottomaddress==2'd2 ?	{executeout[31:24],memreaddata[31:8]}
			:bottomaddress==2'd3 ?	memreaddata
			:						32'hXXXX_XXXX
		:memreaddata;
endmodule