`include "malwa_defines.v"

module malwa_malwa(
	input clk,
	input reset,
	input i_stall,
	input d_stall,
	
	input irq,
	
	output [31:0] pc,
	input [31:0] instrF,

	output memwrite,memread,mem16,mem8,memzerofill,
	output [31:0] memaddress,memwritedata,
	input [31:0] memreaddata
);
	wire de_stall,ex_stall;

	wire clearpipelineF;
	
	wire [31:0] instrDE;

	wire [31:0] instrE;
	wire [`CONTROL_WIDTH] controlE;
	wire [31:0] branchoutE;
	wire [31:0] rsE;
	wire [31:0] rtE;
	wire writeregenduring;
	wire [`REGNUM_WIDTH] writeregnumduring;

	wire [31:0] instrWB;
	wire [`CONTROL_WIDTH] controlWB;
	wire [31:0] executeoutWB;
	wire [31:0] branchoutWB;
	wire [1:0] bottomaddressWB;
	wire writeregenMduring;
	wire writeregen;
	wire [`REGNUM_WIDTH] writeregnum;
	wire [31:0] writeregdata;

	wire [31:0] instrMWB;
	wire [`CONTROL_WIDTH] controlMWB;
	wire [31:0] executeoutMWB;
	wire [1:0] bottomaddressMWB;
	wire writeregenM;
	wire [`REGNUM_WIDTH] writeregnumM;
	wire [31:0] writeregdataM;
	
	malwa_fetch fe(
		.clk(clk),
		.reset(reset),
		.stall(i_stall || de_stall || ex_stall || d_stall),
		.clear(clearpipelineF),
		
		.instr(instrF),

		.instrDE(instrDE)
	);

	malwa_decode de(
		.clk(clk),
		.reset(reset),
		.stall(ex_stall || d_stall),
		.clear(i_stall || de_stall),

		.irq(irq),

		.instr(instrDE),
		
		.writeregenduring(writeregenduring),
		.writeregnumduring(writeregnumduring),
		.writeregenMduring(writeregenMduring),
		.writeregen(writeregen),
		.writeregnum(writeregnum),
		.writeregdata(writeregdata),
		.writeregenM(writeregenM),
		.writeregnumM(writeregnumM),
		.writeregdataM(writeregdataM),
		
		.stallreq(de_stall),

		.instrE(instrE),
		.controlE(controlE),
		.rsE(rsE),
		.rtE(rtE),
		
		.branchoutE(branchoutE),

		.nextpc(pc),
		.clearpipelineF(clearpipelineF)
	);
	
	wire [31:0]rsEFF;
	malwa_ff ff_for_rs(
		.regnum(instrE[25:21]),
		.writereg1(writeregnum),
		.writereg2(writeregnumM),
		.writeregen1(writeregen),
		.writeregen2(writeregenM),
		.regdata(rsE),
		.writeregdata1(writeregdata),
		.writeregdata2(writeregdataM),
		.out(rsEFF)
	);
	
	wire [31:0]rtEFF;
	malwa_ff ff_for_rt(
		.regnum(instrE[20:16]),
		.writereg1(writeregnum),
		.writereg2(writeregnumM),
		.writeregen1(writeregen),
		.writeregen2(writeregenM),
		.regdata(rtE),
		.writeregdata1(writeregdata),
		.writeregdata2(writeregdataM),
		.out(rtEFF)
	);
	
	malwa_execute ex(
		.clk(clk),
		.reset(reset),
		.stall(d_stall),
		.clear(ex_stall),
		
		.instr(instrE),
		.control(controlE),
		.rs(rsEFF),//instrE[25:21]==5'b0 ? 32'b0 : instrE[25:21]==writeregnum && writeregen ? writeregdata : instrE[25:21]==writeregnumM && writeregenM ? writeregdataM : rsE),
		.rt(rtEFF),//instrE[20:16]==5'b0 ? 32'b0 : instrE[20:16]==writeregnum && writeregen ? writeregdata : instrE[20:16]==writeregnumM && writeregenM ? writeregdataM : rtE),
		.branchout(branchoutE),

		.writeregenMduring(writeregenMduring),
		.writeregnum(writeregnum),
		
		.writeregenduring(writeregenduring),
		.writeregnumduring(writeregnumduring),
		
		.instrWB(instrWB),
		.controlWB(controlWB),
		.executeoutWB(executeoutWB),
		.branchoutWB(branchoutWB),
		.bottomaddressWB(bottomaddressWB),
		
		.stallreq(ex_stall),
		
		.memread(memread),
		.mem16(mem16),
		.mem8(mem8),
		.memzerofill(memzerofill),
		.memwrite(memwrite),
		.memaddress(memaddress),
		.memwritedata(memwritedata)
	);

	malwa_writeback wb(
		.clk(clk),
		.reset(reset),
		.clear(d_stall),
		
		.instr(instrWB),
		.control(controlWB),
		.branchout(branchoutWB),
		.executeout(executeoutWB),
		.bottomaddress(bottomaddressWB),
		
		.instrMWB(instrMWB),
		.controlMWB(controlMWB),
		.executeoutMWB(executeoutMWB),
		.bottomaddressMWB(bottomaddressMWB),
		
		.writeregenMduring(writeregenMduring),		
		.writeregen(writeregen),
		.writeregnum(writeregnum),
		.writeregdata(writeregdata)
	);
	
	malwa_memwriteback mwb(
		.clk(clk),
		
		.instr(instrMWB),
		.control(controlMWB),
		.executeout(executeoutMWB),
		.bottomaddress(bottomaddressMWB),
		.memreaddata(memreaddata),
	
		.writeregen(writeregenM),
		.writeregnum(writeregnumM),
		.writeregdata(writeregdataM)
	);
endmodule