`define REGNUM_WIDTH	4:0

`define CONTROL_WIDTH	26:0
`define CONTROL_ALUCONTROL	12:8
`define CONTROL_BRANCHTYPE	7:5
`define CONTROL_WRITEREGNUM	4:0


`define BR_NONE			3'd0
`define BR_LTZ			3'd1
`define BR_GEZ			3'd2
`define BR_EQ			3'd3
`define BR_NE			3'd4
`define BR_LEZ			3'd5
`define BR_GTZ			3'd6


`define CONTROL_ALUCONTROL_UNSIGNED	8
`define CONTROL_ALUCONTROL_RIGHT	9
`define CONTROL_ALUCONTROL_VARIABLE	10
`define CONTROL_ALUCONTROL_SHIFT	12:11
`define ALU_UNSIGNED	5'b0000_1

`define	ALU_NONE		5'b0000_0	// unsigned version needed
`define ALU_MFHI		5'b0001_0
`define ALU_MTHI		5'b0001_1
`define ALU_MFLO		5'b0010_0
`define ALU_MTLO		5'b0010_1
`define ALU_MULT		5'b0011_0	// unsigned version needed
`define ALU_DIV			5'b0100_0	// unsigned version needed
`define ALU_ADD			5'b0101_0	// unsigned version needed
`define ALU_SUB			5'b0110_0	// unsigned version needed
`define ALU_AND			5'b0111_0
`define ALU_OR			5'b0111_1
`define ALU_XOR			5'b1000_0
`define ALU_NOR			5'b1000_1
`define ALU_SLT			5'b1001_0	// unsigned version needed
`define ALU_LUI			5'b1010_0
// 1010_1 is unused
`define ALU_MUL			5'b1011_0	// unsigned version needed
`define ALU_SL			5'b1100_0	// unsigned version needed
`define ALU_SR			5'b1101_0	// unsigned version needed
`define ALU_SLV			5'b1110_0	// unsigned version needed
`define ALU_SRV			5'b1111_0	// unsigned version needed


`define CONTROL_IRQRETURN	13
`define CONTROL_MEMR		14
`define CONTROL_MEML		15
`define CONTROL_MEM8		16
`define CONTROL_MEM16		17
`define CONTROL_LINK		18
`define CONTROL_ZEROFILL	19
`define CONTROL_REGJUMP		20
`define CONTROL_JUMP		21
`define CONTROL_MEMREAD		22
`define CONTROL_MEMWRITE	23
`define CONTROL_BRANCH		24
`define CONTROL_USEIMM		25
`define CONTROL_REGWRITE	26
