`include "malwa_defines.v"

module malwa_branch(
	input clk,
	input reset,
	input stall,

	input irq,
	
	input [31:0] instr,
	input [`CONTROL_WIDTH] control,
	input [31:0] rs,
	input [31:0] rt,
	
	output reg [31:0] branchout,
	
	output [31:0] nextpc,
	output clearpipelineF
);

	wire irqtake = irq && (!inirqhandler || control[`CONTROL_IRQRETURN]);
	wire irqreturn = inirqhandler && control[`CONTROL_IRQRETURN];
	wire [2:0] branchtype = control[`CONTROL_BRANCHTYPE];
	wire takebranch =  control[`CONTROL_BRANCH]
					&&
					(  (branchtype == `BR_LTZ && rs[31])
					|| (branchtype == `BR_GEZ && !rs[31])
					|| (branchtype == `BR_EQ && rs == rt)
					|| (branchtype == `BR_NE && rs != rt)
					|| (branchtype == `BR_LEZ && rs[31])
					|| (branchtype == `BR_LEZ && rs == 0)
					|| (branchtype == `BR_GTZ && !rs[31] && rs != 0)
					);
	wire [31:0] signimmsh = {{14{instr[15]}}, instr[15:0], 2'b00};
	wire [31:0] pcplus4 = currentpc + 4;
	
	assign nextpc	=	reset							?	32'h0000_0400
					:	stall							?	currentpc
					:	takebranch						?	currentpc + signimmsh
					:	control[`CONTROL_JUMP]			?	{currentpc[31:28], instr[25:0], 2'b00}
					:	control[`CONTROL_REGJUMP]		?	rs
					:	irqtake							?	32'h0000_0000
					:	irqreturn						?	irqreturnpc
					:										pcplus4;
	assign clearpipelineF = (irqtake || irqreturn)
							&& (!takebranch && !control[`CONTROL_JUMP] && !control[`CONTROL_REGJUMP]);
	
	reg [31:0] currentpc, irqreturnpc;
	reg inirqhandler;
	always @(posedge clk)
	begin
		currentpc <= nextpc;
		
		if( reset )
		begin
			inirqhandler <= 0;
		end
		else if( !stall )
		begin
			if( irqtake && !takebranch && !control[`CONTROL_JUMP] && !control[`CONTROL_REGJUMP] )
			begin
				inirqhandler <= 1;
				
				if( !inirqhandler )
					irqreturnpc <= currentpc;
			end
			else if( irqreturn )
				inirqhandler <= 0;
			
			branchout <= pcplus4;
		end
	end
endmodule
