`include "malwa_defines.v"

module malwa_alu(
	input signed [31:0]	srca, srcb,
	input  [4:0]		alucontrol,
	output [31:0]	    aluout
);

	wire unsigned [31:0] srcau = srca;
	wire unsigned [31:0] srcbu = srcb;
	
	assign aluout	=	alucontrol == `ALU_ADD || alucontrol == (`ALU_ADD | `ALU_UNSIGNED)	?	srca + srcb
					:	alucontrol == `ALU_SUB || alucontrol == (`ALU_SUB | `ALU_UNSIGNED)	?	srca - srcb
					:	alucontrol == `ALU_AND												?	srca & srcb
					:	alucontrol == `ALU_OR												?	srca | srcb
					:	alucontrol == `ALU_XOR												?	srca ^ srcb
					:	alucontrol == `ALU_NOR												?	~(srca | srcb)
					:	alucontrol == `ALU_SLT												?	srca < srcb
					:	alucontrol == (`ALU_SLT | `ALU_UNSIGNED)							?	srcau < srcbu
					:	alucontrol == `ALU_LUI												?	{srcb[15:0], 16'b0}
					:																			32'hXXXX_XXXX;
	
endmodule