`define WIDTH_TAG	10:0
`define WIDTH_VALID	3:0

module cache_tagstore(
	input				clk,

	input [`WIDTH_TAG]	i_tag,
	input [7:0]			i_index,
	input [3:0]			i_tagwrite,
	
	output [3:0]		i_match,
	output				i_anymatch,
	output [1:0]		i_set,
	output [`WIDTH_TAG] i_tagdata3,i_tagdata2,i_tagdata1,i_tagdata0,

	input [`WIDTH_TAG]	d_tag,
	input [7:0]			d_index,
	input [3:0]			d_tagwrite,
	
	output [3:0]		d_match,
	output				d_anymatch,
	output [1:0]		d_set,
	
	input [1:0]			f_set,
	output [`WIDTH_TAG]	f_tag
);
	wire [43:0] i_tagdata;
	wire [43:0] d_tagdata;

	assign {i_tagdata3,i_tagdata2,i_tagdata1,i_tagdata0}=i_tagdata;

	wire [`WIDTH_TAG] d_tagdata3,d_tagdata2,d_tagdata1,d_tagdata0;
	assign {d_tagdata3,d_tagdata2,d_tagdata1,d_tagdata0}=d_tagdata;

	cache_tag t[3:0](
		.address_a(i_index),
		.address_b(d_index),
		.clock_a(clk),
		.clock_b(clk),
		.data_a(i_tag),
		.data_b(d_tag),
		.wren_a(i_tagwrite),
		.wren_b(d_tagwrite),
		.q_a(i_tagdata),
		.q_b(d_tagdata)
	);
	
	assign i_match={
		!i_match[0] && !i_match[1] && !i_match[2] && i_tagdata3==i_tag,
		!i_match[0] && !i_match[1] && i_tagdata2==i_tag,
		!i_match[0] && i_tagdata1==i_tag,
		i_tagdata0==i_tag
	};
	
	assign i_anymatch=|(i_match);

	assign i_set=i_match[0] ?	2'd0
				:i_match[1] ?	2'd1
				:i_match[2] ?	2'd2
				:i_match[3] ?	2'd3
				:				2'bXX;

	assign d_match={
		!d_match[0] && !d_match[1] && !d_match[2] && d_tagdata3==d_tag,
		!d_match[0] && !d_match[1] && d_tagdata2==d_tag,
		!d_match[0] && d_tagdata1==d_tag,
		d_tagdata0==d_tag
	};
	
	assign d_anymatch=|(d_match);

	assign d_set=d_match[0] ?	2'd0
				:d_match[1] ?	2'd1
				:d_match[2] ?	2'd2
				:d_match[3] ?	2'd3
				:				2'bXX;
	
	assign f_tag=f_set==2'd0 ?	d_tagdata0
				:f_set==2'd1 ?	d_tagdata1
				:f_set==2'd2 ?	d_tagdata2
				:f_set==2'd3 ?	d_tagdata3
				:				11'bXXXX_XXXX_XXX;
endmodule