
/******************************************************************************
**                                                                           **
**      Copyright (C) 2006 Robin Message and David Simner                    **
**      {rhm31, djs203}@cam.ac.uk                                            **
**                                                                           **
******************************************************************************/


volatile unsigned short *const vgaBase = (volatile unsigned short*) 0x90000000;
unsigned short vgaColour = 0;

void vgaInit();
void setColour(unsigned int r, unsigned int g, unsigned int b);
void fillScreen();
void fillRectangle();
void fill3x3RectangleFast();


asm(".text");
asm(".align	2");
asm(".globl	vgaInit");
asm(".ent	vgaInit");
asm("vgaInit:");

asm("addiu $sp,$sp,-4");
asm("sw $31,0($sp)");
asm("addiu $4,$0,27		# $4 = 27");
asm("addiu $5,$0,23		# $5 = 23");
asm("addiu $6,$0,14		# $6 = 14");
asm("jal setColour");
asm("jal fillScreen");
asm("lw $31,0($sp)");
asm("addiu $sp,$sp,4");
asm("j $31");

asm(".end	vgaInit");
asm(".size	vgaInit, .-vgaInit");


asm(".align	2");
asm(".globl	setColour");
asm(".ent	setColour");
asm("setColour:");

asm("andi $8,$4,31		#  $8 = $4 & 31");
asm("andi $9,$5,31		#  $9 = $5 & 31");
asm("andi $10,$6,31		# $10 = $6 & 31");
asm("sll $11,$9,5		# $11 = $9 << 5");
asm("or $10,$10,$11		# $10 |= $11");
asm("sll $11,$8,10		# $11 = $8 << 10");
asm("or $10,$10,$11		# $10 |= $11");
asm("sh $10,vgaColour		# colour = $10");
asm("j $31");

asm(".end	setColour");
asm(".size	setColour, .-setColour");


asm(".align	2");
asm(".globl	fillScreen");
asm(".ent	fillScreen");
asm("fillScreen:");

asm("li $8,0x90000000		# $8 = 0x90000000");
asm("li $9,0x9007e9d8		# $9 = 0x9007e9d8");
asm("lhu $10,vgaColour		# $10 = colour");
asm("__djs203__fillScreen__while:sh $10,0($8)");
asm("sh $10,2($8)");
asm("sh $10,4($8)");
asm("sh $10,6($8)");
asm("sh $10,8($8)");
asm("sh $10,10($8)");
asm("sh $10,12($8)");
asm("sh $10,14($8)");
asm("sh $10,16($8)");
asm("sh $10,18($8)");
asm("sh $10,20($8)");
asm("sh $10,22($8)");
asm("sh $10,24($8)");
asm("sh $10,26($8)");
asm("sh $10,28($8)");
asm("sh $10,30($8)");
asm("sh $10,32($8)");
asm("sh $10,34($8)");
asm("sh $10,36($8)");
asm("sh $10,38($8)");
asm("sh $10,40($8)");
asm("sh $10,42($8)");
asm("sh $10,44($8)");
asm("sh $10,46($8)");
asm("sh $10,48($8)");
asm("sh $10,50($8)");
asm("sh $10,52($8)");
asm("sh $10,54($8)");
asm("sh $10,56($8)");
asm("sh $10,58($8)");
asm("sh $10,60($8)");
asm("sh $10,62($8)");
asm("sh $10,64($8)");
asm("sh $10,66($8)");
asm("sh $10,68($8)");
asm("sh $10,70($8)");
asm("addiu $8,$8,72		# $8 += 72");
asm("bne $8,$9,__djs203__fillScreen__while");
asm("j $31");

asm(".end	fillScreen");
asm(".size	fillScreen, .-fillScreen");


asm(".align	2");
asm(".globl	fillRectangle");
asm(".ent	fillRectangle");
asm("fillRectangle:");

asm("li $8,0x90000000		# $8 = 0x90000000");
asm("li $9,1176			# $9 = 1176");
asm("mul $9,$9,$5		# $9 *= $5");
asm("addu $8,$8,$9		# $8 += $9");
asm("sll $9,$4,1		# $9 = $4 << 1");
asm("addu $8,$8,$9		# $8 += $9");
asm("sll $9,$6,1		# $9 = $6 << 1");
asm("subu $9,$0,$9		# $9 = 0 - $9");
asm("addiu $9,$9,1176		# $9 += 1176");
asm("lhu $10,vgaColour		# $10 = colour");
asm("");
asm("xor $11,$7,$0		# $11 = $7");
asm("j __djs203__fillRectangle__endy");
asm("__djs203__fillRectangle__starty:xor $12,$6,$0	# $12 = $6");
asm("");
asm("j __djs203__fillRectangle__endx");
asm("__djs203__fillRectangle__startx:sh $10,0($8)	# pixel = $10");
asm("addiu $8,$8,2			# $8 += 2");
asm("addiu $12,$12,-1			# $12 -= 1");
asm("__djs203__fillRectangle__endx:bne $12,$0,__djs203__fillRectangle__startx");
asm("");
asm("addu $8,$8,$9			# $8 += $9");
asm("addiu $11,$11,-1			# $11 -= 1");
asm("__djs203__fillRectangle__endy:bne $11,$0,__djs203__fillRectangle__starty");
asm("j $31");

asm(".end	fillRectangle");
asm(".size	fillRectangle, .-fillRectangle");


asm(".align	2");
asm(".globl	fill3x3RectangleFast");
asm(".ent	fill3x3RectangleFast");
asm("fill3x3RectangleFast:");

asm("sh $5,0($4)");
asm("sh $5,2($4)");
asm("sh $5,4($4)");
asm("sh $5,1176($4)");
asm("sh $5,1178($4)");
asm("sh $5,1180($4)");
asm("sh $5,2352($4)");
asm("sh $5,2354($4)");
asm("sh $5,2356($4)");
asm("j $31");

asm(".end	fill3x3RectangleFast");
asm(".size	fill3x3RectangleFast, .-fill3x3RectangleFast");
