
/******************************************************************************
**                                                                           **
**      MIPS Exception Handler                                               **
**      Copyright (C) 2006 Robin Message and David Simner                    **
**      {rhm31, djs203}@cam.ac.uk                                            **
**                                                                           **
******************************************************************************/


/*
**
**      MAINTAINERS: Any changes to this file *must* be accompanied by changes
**                   to the number of NOP instructions at the end, so that the
**                   code is always exactly 256 assembly instructions long.
**
*/


// unsigned short _system_interrupted		996
// unsigned int _system_timer				1000
// unsigned short _system_keyboard_write		1004
// unsigned short _system_keyboard_read		1006
// unsigned short[8] _system_keyboard_buffer	1008


asm(".text");
asm(".align	2");
asm(".globl	__exception");
asm(".ent	__exception");
asm("__exception:");

asm(".set	noreorder");
asm(".set	nomacro");

// instruction 0, the beginning
asm("addiu $sp,$sp,-8");
asm("sw $8,0($sp)");
asm("sw $9,4($sp)");
asm("lui $8,0xf000");
asm("lw $8,0x0000($8)					# Read interrupt number");
asm("ori $9,$0,1");
asm("sll $8,$8,5");
asm("jr $8");
asm("sh $9,996($0)					# Set _system_interrupted");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");

// instruction 16, interrupt #2, the boot loader
asm("j __bootloader");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");

// instruction 24, interrupt #3, the timer
asm("lw $8,1000($0)					# Read _system_timer");
asm("lui $9,0x2000");
asm("addiu $8,$8,1");
asm("sw $8,1000($0)					# Increment _system_timer");
asm("j __exception.end");
asm("sh $0,0x5000($9)					# Clear interrupt");
asm("nop");
asm("nop");

// instruction 32, interrupt #4, the keyboard
asm("lh $8,1004($0)					# Read _system_keyboard_write");
asm("lui $9,0x2000");
asm("lh $9,0x1000($9)					# Load data from keyboard");
asm("sh $9,1008($8)					# Write _system_keyboard_buffer[$8]");
asm("addiu $8,$8,2					# Increment write position");
asm("lh $9,1006($0)					# Read _system_keyboard_read");
asm("andi $8,$8,0x0f					#   modulo 16");
asm("bne $8,$9,__exception.end");
asm("sh $8,1004($0)					# Write _system_keyboard_write");
asm("addiu $9,$9,2					# Increment read position");
asm("andi $9,$9,0x0f					#   modulo 16");
asm("j __exception.end");
asm("sh $9,1006($0)					# Write _system_keyboard_read");
asm("nop");
asm("nop");
asm("nop");

// instruction 48, interrupt #6, the sound
asm("addiu $sp,$sp,-60");
asm("sw $2,0($sp)");
asm("sw $3,4($sp)");
asm("sw $4,8($sp)");
asm("sw $5,12($sp)");
asm("sw $6,16($sp)");
asm("sw $7,20($sp)");
asm("sw $10,24($sp)");
asm("sw $11,28($sp)");
asm("sw $12,32($sp)");
asm("sw $13,36($sp)");
asm("sw $14,40($sp)");
asm("sw $15,44($sp)");
asm("sw $16,48($sp)");
asm("sw $17,52($sp)");
asm("sw $18,56($sp)");
asm("");
asm("lui $2,0x0078");
asm("lui $3,0x2000");
asm("lw $4,0x00($2)");
asm("lw $5,0x0c($2)");
asm("lw $6,0x08($2)");
asm("lw $7,0x10($2)");
asm("lw $8,0x1c($2)");
asm("lw $9,0x18($2)");
asm("lw $10,0x20($2)");
asm("lw $11,0x2c($2)");
asm("lw $12,0x28($2)");
asm("lw $13,0x30($2)");
asm("lw $14,0x3c($2)");
asm("lw $15,0x38($2)");
asm("xori $16,$0,256");
asm("__exception.sound.start:bne $5,$6,__exception.sound.endif1");
asm("nop");
asm("lw $5,0x04($2)");
asm("__exception.sound.endif1:bne $8,$9,__exception.sound.endif2");
asm("nop");
asm("lw $8,0x14($2)");
asm("__exception.sound.endif2:bne $11,$12,__exception.sound.endif3");
asm("nop");
asm("lw $11,0x24($2)");
asm("__exception.sound.endif3:bne $14,$15,__exception.sound.endif4");
asm("nop");
asm("lw $14,0x34($2)");
asm("__exception.sound.endif4:xori $17,$0,0");
asm("beq $4,$0,__exception.sound.endif5");
asm("nop");
asm("lb $18,0($5)");
asm("mul $18,$18,$4");
asm("addu $17,$17,$18");
asm("__exception.sound.endif5:beq $7,$0,__exception.sound.endif6");
asm("nop");
asm("lb $18,0($8)");
asm("mul $18,$18,$7");
asm("addu $17,$17,$18");
asm("__exception.sound.endif6:beq $10,$0,__exception.sound.endif7");
asm("nop");
asm("lb $18,0($11)");
asm("mul $18,$18,$10");
asm("addu $17,$17,$18");
asm("__exception.sound.endif7:beq $13,$0,__exception.sound.endif8");
asm("nop");
asm("lb $18,0($14)");
asm("mul $18,$18,$13");
asm("addu $17,$17,$18");
asm("__exception.sound.endif8:sra $17,$17,16");
asm("sh $17,0x2000($3)");
asm("addiu $5,$5,1");
asm("addiu $8,$8,1");
asm("addiu $11,$11,1");
asm("addiu $14,$14,1");
asm("addiu $16,$16,-1");
asm("bne $16,$0,__exception.sound.start");
asm("nop");
asm("sw $5,0x0c($2)");
asm("sw $8,0x1c($2)");
asm("sw $11,0x2c($2)");
asm("sw $14,0x3c($2)");
asm("");
asm("lw $2,0($sp)");
asm("lw $3,4($sp)");
asm("lw $4,8($sp)");
asm("lw $5,12($sp)");
asm("lw $6,16($sp)");
asm("lw $7,20($sp)");
asm("lw $10,24($sp)");
asm("lw $11,28($sp)");
asm("lw $12,32($sp)");
asm("lw $13,36($sp)");
asm("lw $14,40($sp)");
asm("lw $15,44($sp)");
asm("lw $16,48($sp)");
asm("lw $17,52($sp)");
asm("lw $18,56($sp)");
asm("addiu $sp,$sp,60");
asm("j __exception.end");
asm("nop");
asm("nop");

// instruction 144, the end
asm("__exception.end:lw $8,0($sp)");
asm("lw $9,4($sp)");
asm("addiu $sp,$sp,8");
asm("eret");

// nop sled
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");

asm(".set	macro");
asm(".set	reorder");

asm(".end	__exception");
asm(".size	__exception, .-__exception");
