
import java_cup.runtime.Symbol;
import java.math.BigInteger;
import reducer.*;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 *
 *   Note that CUP and Jlex have their own (liberal) copyrights: see their
 *   documentation.
 */


%%
%cup
%state SLASHSTARCOMMENT
%state SLASHSLASHCOMMENT
%state ATEOF
%eofval{
                        return new Symbol(sym.EOF);
%eofval}
%%


<YYINITIAL>  "+"      { return new Symbol(sym.PLUS, new PlusCombinator()); }
<YYINITIAL>  "-"      { return new Symbol(sym.MINUS, new DifferenceCombinator()); }
<YYINITIAL>  "*"      { return new Symbol(sym.TIMES, new TimesCombinator()); }
<YYINITIAL>  "/"      { return new Symbol(sym.DIVIDE, new QuotientCombinator()); }
<YYINITIAL>  "%"      { return new Symbol(sym.REMAINDER, new RemainderCombinator()); }
<YYINITIAL>  "<"      { return new Symbol(sym.LESS, new LtCombinator()); }
<YYINITIAL>  ">"      { return new Symbol(sym.GREATER, new GtCombinator()); }
<YYINITIAL>  ">="     { return new Symbol(sym.GREATEREQ, new GeCombinator()); }
<YYINITIAL>  "<="     { return new Symbol(sym.LESSEQ, new LeCombinator()); }
<YYINITIAL>  "="      { return new Symbol(sym.EQUAL, new EqCombinator()); }
<YYINITIAL>  "!="     { return new Symbol(sym.NOTEQUAL, new NeCombinator()); }
<YYINITIAL>  "orelse" { return new Symbol(sym.ORELSE, new OrElseCombinator()); }
<YYINITIAL>  "andalso" { return new Symbol(sym.ANDALSO, new AndAlsoCombinator()); }
<YYINITIAL>  "::"     { return new Symbol(sym.CONS, new PCombinator()); }


<YYINITIAL>  ";"      { return new Symbol(sym.SEMICOLON); }
<YYINITIAL>  "op"     { return new Symbol(sym.OP); }
<YYINITIAL>  "("      { return new Symbol(sym.LPAR); }
<YYINITIAL>  ")"      { return new Symbol(sym.RPAR); }
<YYINITIAL>  "["      { return new Symbol(sym.LBRACKET); }
<YYINITIAL>  "]"      { return new Symbol(sym.RBRACKET); }
<YYINITIAL>  ","      { return new Symbol(sym.COMMA); }
<YYINITIAL>  ":"      { return new Symbol(sym.COLON); }
<YYINITIAL>  "~"      { return new Symbol(sym.NEGATE); }
<YYINITIAL>  "->"     { return new Symbol(sym.ARROW); }
<YYINITIAL>  "=>"     { return new Symbol(sym.BIGARROW); }
<YYINITIAL>  "|"      { return new Symbol(sym.VBAR); }
<YYINITIAL>  "_"      { return new Symbol(sym.UNDERSCORE); }
<YYINITIAL>  "nil"    { return new Symbol(sym.NIL); }
<YYINITIAL>  "unit"   { return new Symbol(sym.UNIT); }
<YYINITIAL>  "not"    { return new Symbol(sym.NOT); }
<YYINITIAL>  "true"   { return new Symbol(sym.TRUE); }
<YYINITIAL>  "false"  { return new Symbol(sym.FALSE); }
<YYINITIAL>  "if"     { return new Symbol(sym.IF); }
<YYINITIAL>  "then"   { return new Symbol(sym.THEN); }
<YYINITIAL>  "else"   { return new Symbol(sym.ELSE); }
<YYINITIAL>  "as"     { return new Symbol(sym.AS); }
<YYINITIAL>  "and"    { return new Symbol(sym.AND); }
<YYINITIAL>  "fn"     { return new Symbol(sym.FN); }
<YYINITIAL>  "let"    { return new Symbol(sym.LET); }
<YYINITIAL>  "in"     { return new Symbol(sym.IN); }
<YYINITIAL>  "end"    { return new Symbol(sym.END); }
<YYINITIAL>  "fun"    { return new Symbol(sym.FUN); }
<YYINITIAL>  "val"    { return new Symbol(sym.VAL); }
<YYINITIAL>  "local"  { return new Symbol(sym.LOCAL); }
<YYINITIAL>  "rec"    { return new Symbol(sym.REC); }

<YYINITIAL>  "/*"     { yybegin(SLASHSTARCOMMENT); }
<YYINITIAL>  "//"     { yybegin(SLASHSLASHCOMMENT); }

<YYINITIAL>  [A-Za-z][A-Za-z0-9_]* 
                      { return new Symbol(sym.NAME, new String(yytext())); }
<YYINITIAL>  [_][A-Za-z][A-Za-z0-9_]* 
                      { return new Symbol(sym.NAME, new String(yytext())); }
<YYINITIAL>  [']+[A-Za-z_][A-Za-z0-9_]* 
                      { return new Symbol(sym.NAME, new String(yytext())); }

<YYINITIAL>  [0-9]+   { return new Symbol(sym.NUMBER, new BigInteger(yytext())); }

<YYINITIAL>  [ \t\r\n\f] 
                      { /* ignore white space. */ }
<YYINITIAL>  [\^d\^z] { yybegin(ATEOF);
                        /* I have some pain over EOF, which this does not
			   totally fix... */
                        return new Symbol(sym.EOF);
	              }

<YYINITIAL>  .        { System.err.println("Illegal character: "+yytext()); }


<SLASHSTARCOMMENT>  "*/"     { yybegin(YYINITIAL); }
<SLASHSTARCOMMENT>  %eofval  { System.err.println("End of File within comment"); 
                               return new Symbol(sym.EOF); }
<SLASHSTARCOMMENT>  [\r\n\f] {}
<SLASHSTARCOMMENT>  .        {}


<SLASHSLASHCOMMENT> [\r\n\f] { yybegin(YYINITIAL); }
<SLASHSLASHCOMMENT> %eofval  { System.err.println("End of File within comment"); 
                               return new Symbol(sym.EOF); }
<SLASHSLASHCOMMENT> .        {}

<ATEOF> [\r\n\f]             { return new Symbol(sym.EOF); }
<ATEOF> .                    { return new Symbol(sym.EOF); }






