
package reducer;

public class Val extends Definition
{

public Pattern p;
public Graph x;

Type type;

public Val(Pattern p, Graph x)
{
    this.p = p;
    this.x = x;
    type = null;
}

public void print() throws TooManySteps
{
    Graph.text("VAL ");
    p.print();
    Graph.text(" = ");
    x.print();
}

public void instate()
{
    if (p instanceof NamePattern)
    {   String name = ((NamePattern)p).name;
        Graph.values.put(name, x.substitute());
        if (type != null) Graph.types.put(name, type);
        else Graph.types.remove(name);
        return;
    }
    Graph.text("pattern ");
    p.print(64);
    Graph.text(" not supported with VAL yet");
    Graph.newline();
}

public Environment typeCheckDef(Environment e) throws NoType
{
    if (!(p instanceof NamePattern)) return null;
    String n = ((NamePattern)p).name;
    type = x.typeCheck(e);
    return new Environment(n, type, null);
}

}


