package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class UCombinator extends Combinator
{

public UCombinator()
{
    name = "U";
}

boolean makeHeadNormal() throws TooManySteps
{
    if (trail == null) return false;
    Application trail1 = (Application)trail.function;
    if (trail1 == null) return false;
    Application trail2 = (Application)trail1.function;
    if (trail2 == null) return false;
    // Now we know we have 3 arguments
    trail1.function = trail;
    trail.function = current; // repair ((U f) g)
    Graph a = Graph.makeHeadNormal(trail2.argument);
    if (a instanceof Pair)
    {   Pair p = (Pair)a;
        trail = new Application(trail2, p.car);
        trail2.argument = p.cdr;
        current = trail1.argument;           
    }
    else
    {   trail2.argument = a;
        current = trail.argument;
        trail = trail2;
    }
    return true;
}

}



