package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class Tuple extends Graph
{

Graph car;
Tuple cdr;

public Tuple(Graph car, Tuple cdr)
{
    this.car = car;
    this.cdr = cdr;
}

public void print() throws TooManySteps
{
    if (lengthLeft < 0) throw new TooManySteps();
    Tuple w = this;
    String prefix = "(";
    while (w != null)
    {   text(prefix);
        prefix = ",";
        w.car.print();
        w = w.cdr;
    }
    text(")");
}

public void reduceAndPrint() throws TooManySteps
{
    if (lengthLeft < 0) throw new TooManySteps();
    Tuple w = this;
    String prefix = "(";
    while (w != null)
    {   text(prefix);
        prefix = ",";
        w.car.reduceAndPrint();
        w = w.cdr;
    }
    text(")");
}

boolean makeHeadNormal()
{
    return false;
}

public Graph substitute()
{
    Tuple d = cdr;
    if (d != null) d = (Tuple)d.substitute();
    return new Tuple(car.substitute(), d);
}


}



